* GNU
*
          PROGRAM SL_LNS4
*         ***************
          parameter (maxc=21,maxc1=22)
          IMPLICIT REAL*8(A-H,O-Z)
          Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12
          Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     *    OUTNAM
          Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
          Common/ZAEFF/Zeff,Aeff
          Common/ZAINI/Zini,Aini
          Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED0(MAXC),NK
          COMMON/ED1/ED
          DIMENSION TARRAY(1499)
          EXTERNAL F,FTRN, CS
          REAL*8 NAIGUS
          COMMON/NRT1/ATRN,BTRN,GTRN
          COMMON/NRT2/COEFF
          Common/PARAM01/TLIM,IDSDT
          Common/AUX1/rlambdaft12,rmft12,qft12
          Open(33,file='check.sl4')    
          CALL READ_INPUT_SL_LNS
          CALL PRECALCULATION
          CALL T0_DEFINITION(TARRAY,NTAR)  
          ACCUR=0.01
          MAXN=15
          NK1=NK+1
          Do 2000 IK=1,NK1
          If(IK.eq.1) then
                      Z1=Zini
                      A1=Aini
                      endif
          If(IK.ne.1) then
                      Z1=ZT(IK-1)
                      A1=AT(IK-1)
          If(  dabs(Z1-Zini).lt.0.001d0 
     *   .and. dabs(A1-Aini).lt.0.001d0) goto 2000 
                      endif
          Do MK=1,NK 
                      Z2=ZT(MK)
                      A2=AT(MK)
          CALL NRT_COEFF(Z2,Zeff,A2,Aeff,ATRN,BTRN,GTRN)  
          ED=ED0(MK)
          PI=3.1415926
          EL=4.8E-10        
          A0=0.52918E-08    
          DA=(1./RN0)**0.33333333  
          AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )
     *         /SQRT(Z1**0.6666666+Z2**0.6666666)
          If(IDSDT.ne.0) 
     *    AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )
     *         /(   ( SQRT(Z1)+SQRT(Z2) )**0.666666666   )
          E0=Z1*Z2*(EL**2)*(A1+A2)/(AA*A2)
            E0=E0/1.6E-06    
          ALPHA2=4.*A1*A2/((A1+A2)**2)
          PIA2=Pi*(AA**2)            
          open(34,file=INPNAM_XS(IK,MK))
          Write(34,111)Z1,A1,Z2,A2,Zeff,Aeff
 111      Format(2f6.1,5x,2f6.1,'    Z1, A1 + Z2,A2  for Zeff,Aeff=',
     *    2f6.1,'      (7 lines:comments)')
          Write(34,222)
 222      Format(' 1 col: energy'/
     *' 2 col: N0 * ( Int[Ed to Tmax] nu(T)sig(T)dt )  (units: 1/cm)'/
     *' 3 col: N0 * ( Int[ 0 to Tmax]   T* sig(T)dt )  (units: MeV/cm)'/
     *' 4 col: N0 * ( Int[ 0 to Ed  ]   T* sig(T)dt )  (units: MeV/cm)'/
     *' 5 col: N0 * ( Int[Ed to Tmax]   T* sig(T)dt )  (units: MeV/cm)'/
     *' 6 col:      ( Int[Ed to Tmax]   sig(T)dt    )  (units: barn  )')
         If(IDSDT.eq.0) Write(34,223)rlambdaft12,rmft12,qft12
         If(IDSDT.ne.0) Write(34,224)
223      Format(' LNS  F(t1/2) FUNCTION IS USED.    Lambda=',f6.3,
     *  '  m=',f6.3,'  q=',f6.3)
224      Format(' BURENKOV ET AL F(t1/2) FUNCTION IS USED  ')
          Print *,' '
          If(IDSDT.eq.0) Print *,'            LNS F(t1/2) function'
          If(IDSDT.ne.0) Print *,'            Burenkov F(t1/2) function'
          Print *,' '
          Print 333,Z1,A1,Z2,A2
333       Format(' INTERACTION  ',2f6.1,' +',2f6.1,'    energies:')
                                                     i2i2=0
          DO 9000 III=1,NTAR
          T0=TARRAY(III)
          If(T0.gt.Tlim) goto 9001
          If(T0.gt.0.1) then
          if(i2i2.eq.0) then
                        print *,' '
                        print *,'low energies were treated.'
                        endif
          i2i2=1
          Print 444,T0
444       Format(1pg10.2)
          endif
          EPS= T0/E0
          Tmax=ALPHA2*T0
          COEFF=ALPHA2*E0/EPS
            XminNRT= DSQRT( EPS*ED /(ALPHA2*E0) )
            XminT  = DSQRT( 0.0d0 /(ALPHA2*E0) )
            Xmax= DSQRT( EPS*Tmax/(ALPHA2*E0) )
                                DSDX=0.0
         If(XminNRT.lt.Xmax) then
           RES = NAIGUS(XminNRT,Xmax,FTRN,ACCUR,MAXN,IER)
           DSDX=RES*RN0 * PIA2* COEFF
         endif
                                DEDX_nuc_total=0.0
         If(XminT.lt.Xmax) then
           RES = NAIGUS(XminT,Xmax,F,ACCUR,MAXN,IER)
           DEDX_nuc_total=RES*RN0 * PIA2* COEFF
         endif
                                DEDX_nuc_0_Ed=0.0
         If(0.0d+0.lt.XminNRT) then
           X10=0.0d+0
           X20=DMIN1( XminNRT, Xmax)
           RES = NAIGUS(X10,X20,F,ACCUR,MAXN,IER)
           DEDX_nuc_0_Ed=RES*RN0 * PIA2* COEFF
         endif
                                DEDX_nuc_Ed_Tmax=0.0
         If(XminNRT.lt.Xmax) then
           RES = NAIGUS(XminNRT,Xmax,F,ACCUR,MAXN,IER)
           DEDX_nuc_Ed_Tmax=RES*RN0 * PIA2* COEFF
         endif
                                CS_Ed_Tmax=0.0
         If(XminNRT.lt.Xmax) then
           RES = NAIGUS(XminNRT,Xmax,CS,ACCUR,MAXN,IER)
           CS_Ed_Tmax=RES* PIA2* COEFF *1.E+24  
         endif
          Write(34,'(6g12.5)')T0,DSDX,DEDX_nuc_total,
     *    DEDX_nuc_0_Ed, DEDX_nuc_Ed_Tmax,  CS_Ed_Tmax
9000     Continue 
9001     Close (34)
         Enddo  
2000     Continue  
         End
C
         REAL*8 FUNCTION FTRN(X) 
         IMPLICIT REAL*8(A-H,O-Z)
         COMMON/NRT1/ATRN,BTRN,GTRN
         COMMON/NRT2/COEFF
         COMMON/ED1/ED
         Common/PARAM01/TLIM,IDSDT
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
         If(IDSDT.eq.0) then
         F=ALP1*(X**BET1)*(   ( 1.+( ALP2*(X**BET2) )**BET3)**BET4  )
         goto 1
                        else
         F=FBUR(X)
                        endif
  1          TT=1000.*COEFF*(X**2)     
             TT1=TT
         IF(TT.le.2.*ED*1000.) TT=2.*ED*1000.
         CF=(0.8/(2.*ED*1000.))*TT/
     *   (1.+ATRN*TT+BTRN*(TT**0.75)+GTRN*(TT**0.1666666666))     
         FTRN=F*CF/(TT1/1000.)
         Return
         End
C
         REAL*8 FUNCTION F(X) 
         IMPLICIT REAL*8(A-H,O-Z)
         Common/PARAM01/TLIM,IDSDT
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
         If(IDSDT.eq.0) then
         F=ALP1*(X**BET1)*(   ( 1.+( ALP2*(X**BET2) )**BET3)**BET4  )
         return
                        else
         F=FBUR(X)
                        endif
         return
         End
C
         REAL*8 FUNCTION CS(X) 
         IMPLICIT REAL*8(A-H,O-Z)
         COMMON/NRT1/ATRN,BTRN,GTRN
         COMMON/NRT2/COEFF
         COMMON/ED1/ED
         Common/PARAM01/TLIM,IDSDT
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
         If(IDSDT.eq.0) then
         F=ALP1*(X**BET1)*(   ( 1.+( ALP2*(X**BET2) )**BET3)**BET4  )
         goto 1
                        else
         F=FBUR(X)
                        endif
   1         TT=COEFF*(X**2)     
         CS=F/TT
         Return
         End
C
      FUNCTION  NAIGUS(A,B,F,EPS,MAX,IER)
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION          Z(8),C(8)
      DOUBLE PRECISION  Z,C,H,ARG,HAG,SUM,IN,IN1,X,S1,Q
      REAL*8 NAIGUS
      DATA              Z(1)/0.01985507D0/
      DATA              Z(2)/0.10166676D0/
      DATA              Z(3)/0.23723379D0/
      DATA              Z(4)/0.40828268D0/
      DATA              Z(5)/0.59171732D0/
      DATA              Z(6)/0.76276621D0/
      DATA              Z(7)/0.89833324D0/
      DATA              Z(8)/0.98014493D0/
      DATA              C(1)/0.05061427D0/
      DATA              C(2)/0.11119052D0/
      DATA              C(3)/0.15685332D0/
      DATA              C(4)/0.18134139D0/
      DATA              C(5)/0.18134139D0/
      DATA              C(6)/0.15685332D0/
      DATA              C(7)/0.11119052D0/
      DATA              C(8)/0.05061427D0/
      IER = 0
      SUM = 0.0
      IN = 0.0
      IN1 = 0.0
      H = B -A
      ARG = A
      N = 1
      N2 = 1
      HAG = H
    5 DO 20 K = 1,N2
        DO 10 I = 1,8
          X = ARG + HAG*Z(I)
          S1 =C(I)*F(X)
          SUM = SUM+S1
   10   CONTINUE
        ARG = ARG+HAG
   20 CONTINUE
      IN1 = HAG*SUM
      Q = ABS(IN1-IN)
      IF (Q .LT. EPS) GO TO 40
      IF (N .GT. MAX) GO TO 30
      N = N+1
      N2 = N2*2
      HAG = HAG/2
      ARG = A
      IN = IN1
      SUM = 0.0
      GO TO 5
   30 IER = 1
   40 NAIGUS =IN1
      RETURN
      END
C
          Subroutine NRT_COEFF(Z1,Z2,A1,A2,ANRT,BNRT,GNRT)  
          IMPLICIT REAL*8(A-H,O-Z)
          PI=3.1415926
          A0=0.52918E-08    
          EL=4.8E-10        
          RK0=0.0793*(Z1**0.6666666)*SQRT(Z2)*((A1+A2)**1.5)/         (
     *    (A1**1.5)*SQRT(A2)*((Z1**0.666666666+Z2**0.66666666)**0.75) )
          AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )/
     *          SQRT(Z1**0.6666666+Z2**0.6666666)
          E0=Z1*Z2*(EL**2)*(A1+A2)/(AA*A2)
            E0=E0/1.6E-06   
            E0=1000.*E0     
            EE=1./E0
         ANRT=RK0*EE         
         BNRT=0.40244*RK0*(EE**0.75)                                          
         GNRT=3.4008*RK0*(EE**0.1666666666)                                   
         RETURN
         END
C         
          Subroutine T0_DEFINITION(TARRAY,N)  
          IMPLICIT REAL*8(A-H,O-Z)
          DIMENSION TARRAY(1499), TBAS(591)
          TB=1.0d0 - 0.1d0
          Do iii=1,11111111
          TB=TB+0.1d0
          if(TB.ge.9.9999d0) goto 1 
          imax=iii
                   If(iii.gt.591) then
                   Print *,' Dimension of TBAS is not sufficient !'
                   stop
                   endif  
          TBAS(iii)=TB
          Enddo
  1       j=0          
          RM=1.D-07
          Do irm=1,11
          RM=RM*10.d+0          
          Do i=1,imax
          j=j+1
                   If(j.gt.1499) then
                   Print *,' Dimension of TARRAY is not sufficient !'
                   stop
                   endif  
          TARRAY(j)=TBAS(i)*RM            
          Enddo
          Enddo
          N=j
          return
          end
C
        Subroutine READ_INPUT_SL_LNS
        IMPLICIT REAL*8(A-H,O-Z)
        parameter (maxc=21,maxc1=22)
        Character CTASK_NAME*80
        Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12
        Character NF(MAXC)*12, C80*80
        Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     *  OUTNAM
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/ZAINI/Zini,Aini
        Common/PARAM01/TLIM,IDSDT
        Common/EARTH/CTASK_NAME
        open(1,file='input')
        call star(1)
        read(1,'(a80)')CTASK_NAME
        call star(1)
        read(1,*)iiii,jjjj,Tlim,IDSDT
        If(Tlim.gt.5200.)then
        Print *,'           E R R O R  in INPUT file       '
        Print *,'Maximal energy should be below 5.2 GeV  !'
        Print *,'               press any key...'
        pause
        stop
        endif
        If(Tlim.le.0.0) Tlim=5000.
        Call FT12CHOICE(IDSDT)
        If(IDSDT.ne.0.and.IDSDT.ne.1) then
        Print *,'           E R R O R  in INPUT file       '
        Print *,'  IDSDT parameter is incorrect'
        Print *,'                          press any key...'
        pause
        stop
        endif
        call star(1)
        read(1,'(a80)')C80
        if(findp(C80,'B').ne.0. .or. findp(C80,'M').ne.0. .or. 
     *     findp(C80,'b').ne.0. .or. findp(C80,'m').ne.0. ) then
        call star(1)
        read(1,*,err=9919) XXX 
                                                            else
        backspace 1
                                                            endif
        call star(1)
        read(1,*)Zini, Aini
        call star(1)
        read(1,*)RO, NK
                 backspace 1
                 istop=0
                 read(1,'(a80)')C80
        if(findp(C80,'Z').ne.0.0.or.findp(C80,'z').ne.0.0  
     *  .or.findp(C80,'I').ne.0.0.or.findp(C80,'i').ne.0.0) istop=-1  
        if(findp(C80,'A').ne.0.0.or.findp(C80,'a').ne.0.0)  istop=+1  
        If(istop.eq.0) then 
        Print *,' '
        Print *,' Model to obtain dE/dx is not identified !!'
        print *,'                                press any key...'
        pause
        stop
        endif
        If(NK.gt.MAXC) then 
        Print *,'Number of components > ',MAXC,' !'
        print *,'                       press any key...'
        stop
        endif
        If(RO.le.0. .and. NK.ne.1) then
        Print *,' '
        Print *,
     *  '      NO  default density for compounds !!!'
        print *,'                           press any key...'
        pause
        stop
        endif
        call star(1)
        Call GET_FILE_NAMES(1,NK,NF)
        Do MK=1,NK
        INPNAM_XS(1,MK)=NF(MK)
        Enddo
        if(istop.eq.-1) then 
        call star(1)
        Call GET_FILE_NAMES(1,1,NF)
        INPNAM_DEDX(1)=NF(1)
                        endif    
        Do IK=1,NK
        call star(1)
        read(1,*,err=90000)ZZ,AA, FR0, ED0
                             If(ED0.le.0.0) ED0=40.0  
        ZT(IK)=ZZ
        AT(IK)=AA
        FR(IK)=FR0
        ED(IK)=ED0 *1.e-06   
        call star(1)
        Call GET_FILE_NAMES(1,NK,NF)
        Do MK=1,NK
        INPNAM_XS(IK+1,MK)=NF(MK)
        Enddo
        if(istop.eq.-1) then
        call star(1)
        Call GET_FILE_NAMES(1,1,NF)
        INPNAM_DEDX(IK+1)=NF(1)
                        endif 
        Enddo
        Return
9919    Print *,' ERROR:   MD efficiency'
        print *,'                        press any key...'
        pause
        stop
90000   print 90001
90001   Format(/'  E R R O R  in input file INPUT !!!'
     *  /'  Possible reason:  dE/dx model chosen is inconsistent ',
     *  /'                    with the file names introduced in INPUT'  
     *  /'  Note:   SPAR option - names should be omitted'
     *  /'          SRIM option - names should be given')
        print *,'                              press any key...'
        pause
        stop
        End
C
       Subroutine star(k)
       IMPLICIT REAL*8(A-H,O-Z)
       character c1*1
1      read(1,'(a1)',end=1000)c1
       if(c1.eq.'*'.or.c1.eq.'c'.or.c1.eq.'C'.or.c1.eq.'!') goto 1
       backspace 1
       return
1000   if(k.eq.0) return 
       Print *,' U N E X P E C T E D   E N D   O F   I N P U T '
       print *,'                        press any key...'
       pause
       stop
       end 
C
        Subroutine PRECALCULATION
        IMPLICIT REAL*8(A-H,O-Z)
        parameter (maxc=21)
        Character CTASK_NAME*80
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/ZAEFF/Zeff,Aeff
        Common/ZAINI/Zini,Aini
        Common/DATATAB1/WTAB(101),ROTAB(101),RITAB(101),IATAB(101)
        Common/EARTH/CTASK_NAME
        AVO=6.022E+23     
          IZ1=idint(Zini+0.001)
        Call DATATAB
        If(Aini.le.0.0) then 
                      Aini=WTAB(IZ1)
                      endif
                      If(Aini.le.0.0) goto 90000
        do i=1,nk
        If(AT(i).le.0.0) then 
                      IZT=idint(ZT(i)+0.001)              
                      AT(i)=WTAB(IZT)
                      endif
                      If(AT(i).le.0.0) goto 90001
        enddo
        if(RO.le.0.0) then
                      IZT=idint(ZT(NK)+0.001)  
                      RO=ROTAB(IZT) 
                      endif
                      If(RO.le.0.0) goto 90002
           sum=0.0
           do i=1,nk
           sum=sum+FR(i)
           enddo
           Do i=1,nk
           FR(I)=FR(I)/SUM
           Enddo
           Zeff=0.0
           Aeff=0.0
        Do i=1,nk
        Zeff=Zeff+FR(I)*ZT(I)
        Aeff=Aeff+FR(I)*AT(I)
        Enddo
           AW=Aeff
        RN0=AVO*RO/AW     
        write(33,*)'                              SL_LNS4  CODE'
        write(33,*)' TASK NAME FOR "IOTA" CODE IS:'
        write(33,'(a80)')CTASK_NAME
        write(33,*)' '
        write(33,1000)IZ1,Aini
 1000   Format(1x,'Primary particle (Z,A)',i3,f8.2) 
        write(33,1001)
 1001   Format(' Material      at %    Ed (eV)')
             Do IK=1,NK
             IZ=idint(ZT(IK)+0.0001)
             FR0=FR(IK)*100.
             write(33,1002)IZ,AT(ik),FR0,ED(IK)*1.e+06
 1002        Format(i3,f8.2,f9.2,f9.1)
             Enddo
          write(33,1003)RO,RN0
 1003     Format(/' Density =',f8.4,' g/cm3    n0=',1pe12.5,' 1/cm3')
          write(33,1004)Zeff,Aeff
 1004     Format(' Z(eff) =',f6.2,'    A(eff)=',f7.2)
          Return
90000     Print *,' E R R O R :   Aini is not defined !'
          print *,'                           press any key...'
          pause
          stop
90001     Print *,' E R R O R :   A  for materilal  with  Z=',IZT,
     *    ' is not defined !'
          print *,'                           press any key...'
          pause
          stop
90002     Print *,' E R R O R :   Density is not defined !'
          print *,'                           press any key...'
          pause
          stop
          End 
C
        Subroutine GET_FILE_NAMES(IU,NK,NF)
        IMPLICIT REAL*8(A-H,O-Z)
        Character C80*80, NF*12, NFTMP*12
        Dimension NF(NK)
 400    Read(IU,'(a80)') C80    
        if(C80(1:1).eq.'*') goto 400
          MK=0
 1      Do J=1,80
        i=J
        If(C80(j:j).ne.' ') goto 2
        Enddo
        If(MK.gt.NK)  goto 90000
        If(MK.eq.NK)  return
 500    Read(IU,'(a80)') C80    
        if(C80(1:1).eq.'*') goto 500
        goto 1
 2      MK=MK+1        
        If(MK.gt.NK)  goto 90000
        NFTMP='            '
           L=0 
           Do M=i,80
           If(C80(m:m).eq.' ') goto 3
           L=L+1 
           If(L.gt.12) goto 91000
           NFTMP(L:L)=C80(M:M)
           C80(M:M)=' '
           Enddo
 3      NF(MK)=NFTMP
        If(MK.eq.NK) Return
        goto 1
90000   Print *,'***** Subr.GET_FILE_NAMES'
        Print *,' Number of files MK exceeds NK(input) !'
        print *,'                         press any key...'
        pause
        stop
91000   Print *,'***** Subr.GET_FILE_NAMES'
        Print *,' One of the file name exceeds 12 characters !'
        Print *,'               CHANGE INPUT   '
        print *,'                         press any key...'
        pause
        stop
        END
C
         REAL*8 FUNCTION FBUR(X) 
         IMPLICIT REAL*8(A-H,O-Z)
         If(X.le.0.04) then
           RJ=1.
           A1=0.088
           A2=1.
           A3=0.2
           goto 1
           endif
         If(0.04.lt.X  .and.  X.le.1.0) then
           RJ=1.
           A1=0.23
           A2=1.3
           A3=0.4
           goto 1
           endif
         If(1.0.lt.X  .and.  X.le.40.) then
           RJ=0.0
           A1=0.4563
           A2=0.0
           A3=0.3
           goto 1
           endif
         If(X.gt.40.) then
           RJ=0.0
           A1=0.5
           A2=0.0
           A3=0.0
           endif
1        FBUR=A1*(X**(RJ/2.))*(X+A2)/(  (X+A3)**2 )
         Return
         End
C
         Subroutine FT12CHOICE(idsdt)
         IMPLICIT REAL*8(A-H,O-Z)
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
         Common/AUX1/rlambda,rm,q
         if(idsdt.eq.1) return   
         if(idsdt.eq.0) goto 10   
         goto(888,888,888,888,888,888,888,888,888,10,
     *        11,12,13,14,15), idsdt
         goto 888
10       rlambda=1.309
         rm=1./3.
         q=2./3.
         goto 777
11       rlambda=1.7
         rm=0.311
         q=0.588
         goto 777
12       rlambda=2.37
         rm=0.103
         q=0.570
         goto 777
13       rlambda=2.92
         rm=0.191
         q=0.512
         goto 777
14       rlambda=3.07
         rm=0.216
         q=0.530
         goto 777
15       rlambda=3.35
         rm=0.2328
         q=0.4445
777      alp1=rlambda
         bet1=1.-2.*rm
         alp2=2.*rlambda
         bet2=2.*(1.-rm)
         bet3=q
         bet4=-1./q
         idsdt=0
         Return 
  888    Print 999,idsdt
  999    Format(' ERROR:    Parameters of f(t^1/2) are not known !'/
     *   '           idsdt=',i5,' is not correct.')      
         Print *,'                     press any key...'
         pause
         stop
         End
C
         REAL*8 Function FINDP(S80,C10)
         Character S80*80, C10*1
         NS=80
         NC=1
                            N=0         
         Do 2000 I=1,NS
               i1=I
               i2=I+NC-1
               if(i2.gt.NS) goto 2000
         if(s80(I1:I2).eq.C10) goto 3000
2000     continue      
         findp=dfloat(N)  
         return
3000     continue
         N=i2 
         findp=dfloat(N)
         return
         end
C
      Subroutine DATATAB
      IMPLICIT REAL*8(A-H,O-Z)
      Common/DATATAB1/WTAB1(101),ROTAB1(101),RITAB1(101),IATAB1(101)
      Dimension IATAB(92), WTAB(92), ROTAB(92), RITAB(92)
      Data IATAB( 1),  WTAB( 1),  ROTAB( 1),  RITAB( 1)
     & /        1   ,    1.0079,   0.071486,    19.60/
      Data IATAB( 2),  WTAB( 2),  ROTAB( 2),  RITAB( 2)
     & /        4   ,    4.0026,   0.125880,    39.00/
      Data IATAB( 3),  WTAB( 3),  ROTAB( 3),  RITAB( 3)
     & /        7   ,    6.9410,   0.534000,    42.20/
      Data IATAB( 4),  WTAB( 4),  ROTAB( 4),  RITAB( 4)
     & /        9   ,    9.0122,   1.848000,    63.70/
      Data IATAB( 5),  WTAB( 5),  ROTAB( 5),  RITAB( 5)
     & /       11   ,   10.8110,   2.350200,    76.00/
      Data IATAB( 6),  WTAB( 6),  ROTAB( 6),  RITAB( 6)
     & /       12   ,   12.0110,   2.253000,    79.10/
      Data IATAB( 7),  WTAB( 7),  ROTAB( 7),  RITAB( 7)
     & /       14   ,   14.0070,   1.026000,    84.20/
      Data IATAB( 8),  WTAB( 8),  ROTAB( 8),  RITAB( 8)
     & /       16   ,   15.9990,   1.426000,    96.00/
      Data IATAB( 9),  WTAB( 9),  ROTAB( 9),  RITAB( 9)
     & /       19   ,   18.9980,   1.111100,   107.00/
      Data IATAB(10),  WTAB(10),  ROTAB(10),  RITAB(10)
     & /       20   ,   20.1797,   1.204000,   133.00/
      Data IATAB(11),  WTAB(11),  ROTAB(11),  RITAB(11)
     & /       23   ,   22.9898,   0.970000,   149.00/
      Data IATAB(12),  WTAB(12),  ROTAB(12),  RITAB(12)
     & /       24   ,   24.3050,   1.736600,   156.00/
      Data IATAB(13),  WTAB(13),  ROTAB(13),  RITAB(13)
     & /       27   ,   26.9815,   2.702000,   170.00/
      Data IATAB(14),  WTAB(14),  ROTAB(14),  RITAB(14)
     & /       28   ,   28.0860,   2.321200,   171.00/
      Data IATAB(15),  WTAB(15),  ROTAB(15),  RITAB(15)
     & /       31   ,   30.9737,   1.821900,   173.00/
      Data IATAB(16),  WTAB(16),  ROTAB(16),  RITAB(16)
     & /       32   ,   32.0660,   2.068600,   184.00/
      Data IATAB(17),  WTAB(17),  ROTAB(17),  RITAB(17)
     & /       35   ,   35.4530,   1.895600,   178.00/
      Data IATAB(18),  WTAB(18),  ROTAB(18),  RITAB(18)
     & /       40   ,   39.9480,   1.650400,   190.00/
      Data IATAB(19),  WTAB(19),  ROTAB(19),  RITAB(19)
     & /       39   ,   39.0983,   0.863180,   190.00/
      Data IATAB(20),  WTAB(20),  ROTAB(20),  RITAB(20)
     & /       40   ,   40.0800,   1.540000,   198.00/
      Data IATAB(21),  WTAB(21),  ROTAB(21),  RITAB(21)
     & /       45   ,   44.9560,   2.989000,   225.00/
      Data IATAB(22),  WTAB(22),  ROTAB(22),  RITAB(22)
     & /       48   ,   47.9000,   4.518900,   231.00/
      Data IATAB(23),  WTAB(23),  ROTAB(23),  RITAB(23)
     & /       51   ,   50.9420,   5.960000,   249.00/
      Data IATAB(24),  WTAB(24),  ROTAB(24),  RITAB(24)
     & /       52   ,   51.9960,   7.200000,   265.00/
      Data IATAB(25),  WTAB(25),  ROTAB(25),  RITAB(25)
     & /       55   ,   54.9380,   7.434100,   275.00/
      Data IATAB(26),  WTAB(26),  ROTAB(26),  RITAB(26)
     & /       56   ,   55.8470,   7.865800,   286.00/
      Data IATAB(27),  WTAB(27),  ROTAB(27),  RITAB(27)
     & /       59   ,   58.9330,   8.900000,   306.00/
      Data IATAB(28),  WTAB(28),  ROTAB(28),  RITAB(28)
     & /       58   ,   58.6900,   8.895500,   321.00/
      Data IATAB(29),  WTAB(29),  ROTAB(29),  RITAB(29)
     & /       63   ,   63.5460,   8.920000,   332.00/
      Data IATAB(30),  WTAB(30),  ROTAB(30),  RITAB(30)
     & /       64   ,   65.3900,   7.140000,   330.00/
      Data IATAB(31),  WTAB(31),  ROTAB(31),  RITAB(31)
     & /       69   ,   69.7200,   5.904000,   334.00/
      Data IATAB(32),  WTAB(32),  ROTAB(32),  RITAB(32)
     & /       74   ,   72.6100,   5.350000,   335.00/
      Data IATAB(33),  WTAB(33),  ROTAB(33),  RITAB(33)
     & /       75   ,   74.9220,   5.727000,   353.00/
      Data IATAB(34),  WTAB(34),  ROTAB(34),  RITAB(34)
     & /       80   ,   78.9600,   4.810000,   351.00/
      Data IATAB(35),  WTAB(35),  ROTAB(35),  RITAB(35)
     & /       79   ,   79.9040,   3.199000,   317.00/
      Data IATAB(36),  WTAB(36),  ROTAB(36),  RITAB(36)
     & /       84   ,   83.8000,   2.602100,   348.00/
      Data IATAB(37),  WTAB(37),  ROTAB(37),  RITAB(37)
     & /       85   ,   85.4700,   1.532000,   364.00/
      Data IATAB(38),  WTAB(38),  ROTAB(38),  RITAB(38)
     & /       88   ,   87.6200,   2.600000,   366.00/
      Data IATAB(39),  WTAB(39),  ROTAB(39),  RITAB(39)
     & /       89   ,   88.9050,   4.469000,   375.00/
      Data IATAB(40),  WTAB(40),  ROTAB(40),  RITAB(40)
     & /       90   ,   91.2200,   6.490000,   389.00/
      Data IATAB(41),  WTAB(41),  ROTAB(41),  RITAB(41)
     & /       93   ,   92.9060,   8.570000,   417.00/
      Data IATAB(42),  WTAB(42),  ROTAB(42),  RITAB(42)
     & /       98   ,   95.9400,  10.206000,   423.00/
      Data IATAB(43),  WTAB(43),  ROTAB(43),  RITAB(43)
     & /       97   ,   97.0000,  11.500000,   428.00/
      Data IATAB(44),  WTAB(44),  ROTAB(44),  RITAB(44)
     & /      102   ,  101.0700,  12.300000,   441.00/
      Data IATAB(45),  WTAB(45),  ROTAB(45),  RITAB(45)
     & /      103   ,  102.9100,  12.399000,   468.00/
      Data IATAB(46),  WTAB(46),  ROTAB(46),  RITAB(46)
     & /      106   ,  106.4000,  12.020000,   476.00/
      Data IATAB(47),  WTAB(47),  ROTAB(47),  RITAB(47)
     & /      107   ,  107.8700,  10.473000,   488.00/
      Data IATAB(48),  WTAB(48),  ROTAB(48),  RITAB(48)
     & /      114   ,  112.4000,   8.642000,   441.00/
      Data IATAB(49),  WTAB(49),  ROTAB(49),  RITAB(49)
     & /      115   ,  114.8200,   7.300000,   481.00/
      Data IATAB(50),  WTAB(50),  ROTAB(50),  RITAB(50)
     & /      120   ,  118.7100,   7.281600,   478.00/
      Data IATAB(51),  WTAB(51),  ROTAB(51),  RITAB(51)
     & /      121   ,  121.7500,   6.684000,   472.00/
      Data IATAB(52),  WTAB(52),  ROTAB(52),  RITAB(52)
     & /      130   ,  127.6000,   6.250000,   485.00/
      Data IATAB(53),  WTAB(53),  ROTAB(53),  RITAB(53)
     & /      127   ,  126.9000,   4.937300,   455.00/
      Data IATAB(54),  WTAB(54),  ROTAB(54),  RITAB(54)
     & /      132   ,  131.3000,   3.058900,   440.00/
      Data IATAB(55),  WTAB(55),  ROTAB(55),  RITAB(55)
     & /      133   ,  132.9100,   1.878500,   488.00/
      Data IATAB(56),  WTAB(56),  ROTAB(56),  RITAB(56)
     & /      138   ,  137.3270,   3.510000,   491.00/
      Data IATAB(57),  WTAB(57),  ROTAB(57),  RITAB(57)
     & /      139   ,  138.9100,   6.173800,   472.00/
      Data IATAB(58),  WTAB(58),  ROTAB(58),  RITAB(58)
     & /      140   ,  140.1200,   6.672400,   501.00/
      Data IATAB(59),  WTAB(59),  ROTAB(59),  RITAB(59)
     & /      141   ,  140.9100,   6.773000,   513.00/
      Data IATAB(60),  WTAB(60),  ROTAB(60),  RITAB(60)
     & /      142   ,  144.2400,   7.008000,   546.00/
      Data IATAB(61),  WTAB(61),  ROTAB(61),  RITAB(61)
     & /      148   ,  148.0000,   6.475000,   560.00/
      Data IATAB(62),  WTAB(62),  ROTAB(62),  RITAB(62)
     & /      152   ,  150.3600,   7.520000,   566.00/
      Data IATAB(63),  WTAB(63),  ROTAB(63),  RITAB(63)
     & /      153   ,  151.9700,   5.244000,   580.00/
      Data IATAB(64),  WTAB(64),  ROTAB(64),  RITAB(64)
     & /      158   ,  157.2500,   7.901000,   586.00/
      Data IATAB(65),  WTAB(65),  ROTAB(65),  RITAB(65)
     & /      159   ,  158.9300,   8.230000,   614.00/
      Data IATAB(66),  WTAB(66),  ROTAB(66),  RITAB(66)
     & /      164   ,  162.5000,   8.551000,   603.00/
      Data IATAB(67),  WTAB(67),  ROTAB(67),  RITAB(67)
     & /      165   ,  164.9300,   8.795000,   641.00/
      Data IATAB(68),  WTAB(68),  ROTAB(68),  RITAB(68)
     & /      166   ,  167.2600,   9.066000,   661.00/
      Data IATAB(69),  WTAB(69),  ROTAB(69),  RITAB(69)
     & /      169   ,  168.9300,   9.321000,   683.00/
      Data IATAB(70),  WTAB(70),  ROTAB(70),  RITAB(70)
     & /      174   ,  173.0400,   6.960000,   684.00/
      Data IATAB(71),  WTAB(71),  ROTAB(71),  RITAB(71)
     & /      175   ,  174.9700,   9.841000,   694.00/
      Data IATAB(72),  WTAB(72),  ROTAB(72),  RITAB(72)
     & /      180   ,  178.4900,  13.310000,   675.00/
      Data IATAB(73),  WTAB(73),  ROTAB(73),  RITAB(73)
     & /      181   ,  180.9500,  16.601000,   729.00/
      Data IATAB(74),  WTAB(74),  ROTAB(74),  RITAB(74)
     & /      184   ,  183.8500,  19.350000,   735.00/
      Data IATAB(75),  WTAB(75),  ROTAB(75),  RITAB(75)
     & /      187   ,  186.2000,  20.530001,   749.00/
      Data IATAB(76),  WTAB(76),  ROTAB(76),  RITAB(76)
     & /      192   ,  190.2000,  22.480000,   746.00/
      Data IATAB(77),  WTAB(77),  ROTAB(77),  RITAB(77)
     & /      193   ,  192.2000,  22.421000,   757.00/
      Data IATAB(78),  WTAB(78),  ROTAB(78),  RITAB(78)
     & /      195   ,  195.0800,  21.450001,   792.00/
      Data IATAB(79),  WTAB(79),  ROTAB(79),  RITAB(79)
     & /      197   ,  196.9700,  19.311001,   789.00/
      Data IATAB(80),  WTAB(80),  ROTAB(80),  RITAB(80)
     & /      202   ,  200.5900,  13.546200,   800.00/
      Data IATAB(81),  WTAB(81),  ROTAB(81),  RITAB(81)
     & /      205   ,  204.3800,  11.850000,   810.00/
      Data IATAB(82),  WTAB(82),  ROTAB(82),  RITAB(82)
     & /      208   ,  207.1900,  11.343700,   787.00/
      Data IATAB(83),  WTAB(83),  ROTAB(83),  RITAB(83)
     & /      209   ,  208.9800,   9.800000,   819.00/
      Data IATAB(84),  WTAB(84),  ROTAB(84),  RITAB(84)
     & /      209   ,  210.0000,   9.251100,   830.00/
      Data IATAB(85),  WTAB(85),  ROTAB(85),  RITAB(85)
     & /      210   ,  210.0000,  10.000000,   756.95/
      Data IATAB(86),  WTAB(86),  ROTAB(86),  RITAB(86)
     & /      222   ,  222.0000,   9.910000,   736.54/
      Data IATAB(87),  WTAB(87),  ROTAB(87),  RITAB(87)
     & /      223   ,  223.0000,  10.000000,   827.00/
      Data IATAB(88),  WTAB(88),  ROTAB(88),  RITAB(88)
     & /      226   ,  226.0000,   5.022200,   826.00/
      Data IATAB(89),  WTAB(89),  ROTAB(89),  RITAB(89)
     & /      227   ,  227.0000,  10.000000,   841.00/
      Data IATAB(90),  WTAB(90),  ROTAB(90),  RITAB(90)
     & /      232   ,  232.0000,  11.658000,   847.00/
      Data IATAB(91),  WTAB(91),  ROTAB(91),  RITAB(91)
     & /      231   ,  231.0000,  15.370000,   878.00/
      Data IATAB(92),  WTAB(92),  ROTAB(92),  RITAB(92)
     & /      238   ,  238.0300,  19.042999,   842.00/
      Do i=1,92
      IATAB1(i)=IATAB(i)
      WTAB1(i) =WTAB(i) 
      ROTAB1(i)=ROTAB(i)
      RITAB1(i)=RITAB(i)
      enddo
          Do i=93,101
          IATAB1(i)=0
          WTAB1(i) =0.0
          ROTAB1(i)=0.0
          RITAB1(i)=0.0
          enddo
      Return
      End   
