**************************************************************************
*
* IOTA code
* ---------
*
*
* Maximal number of the material component is 21. To increase this 
* value change parameter(maxc= to N desirable value in all routines
* and maxc1= to N+1
*
* Maximal energy = 5 GeV
*  
*
c
c 
c GNU random number generator is used now. To use other generator
c change function RANDOM
c
*
* Last changes 09/01/2004     
*
c
       PROGRAM IOTA
       parameter (maxe=50001)
       Common/EIN/EIN(MAXE),NH(MAXE),KEIN
       COMMON/RECSTORE/TKIN(50003),ZZ(50003),NKO(50003),INDIC(50003),
     #                 NREC
       Common/MERCURY/CMD(5),Ecrit,MD
c          
c======================================================================
c
c
c
*
* read input data file
         CALL READ_INPUT
*
* prepare basic data for calculations
         CALL PRECALCULATION
*
* read cross-sections and dE/dx
         CALL READ_DATA
*
* make interpolation between data points
         CALL INCREASE_DATA_ARRAY
*
* calculate dE/dx by SPAR routine
         CALL DEDX_SPAR
*
*
c
c========================================================================
c
* Cycle for energies
* ------------------
        Do IE=1,KEIN
        T0=EIN(IE)
        NHIST=NH(IE)
c
            If(T0.gt.5000.) then
            Print *,' T0 exceeds the allowable maximum. Change the code'
            Call Error('    ',5000)
            Endif
*
*
        Call INITIALIZE_AND_ZEROIZE(T0)
*       
* Cycle for events
* ----------------
        Do 7 IH=1,Nhist         
        Print 1000,IH,T0
 1000   Format('*************  history =',I10,'     E=',g12.5)
*
        Call DISPERS(1)
* 
* Primary ion movement
*                    IDE corresponds to the energy of the primary
*                        particle which attenuates in material 
        Z=0.0
        IK=1        
        IDE=-1
        Call MODEL(IK,T0,Z,IDE) 
        if(NREC.le.0) goto 6
* 
* Secondary recoils movement
   2    Call STORE_OUT(MK,T1,Z,IDE)
*
                                         if(nrec.lt.0.and.md.eq.0) then
                                         print *,'strange error'
                                         stop
                                         endif
        if(NREC.le.0) goto 6
        IK=MK+1
        Call MODEL(IK,T1,Z,IDE) 
        goto 2
*
*
*
   6    Call DISPERS(2)
   7    Continue  
c
*
* Integration of nu(T)dS/dT along the trajectory
        Call  LindInt(T0) 
        Print *,'*****  Finished !'
*
        Call Print(T0,Nhist)
c            
        Enddo !   Do IE=1,KEIN
*
        Call end_of_calculation
        Stop                   
        End
*
************************************************************************
*
        Subroutine ARRAYINT(KEY, E,CS,N,T,INTS0,RES)
*       --------------------------------------------
* REAL*4
*
*  To get RES value for arrays E(N),CS(N) at point T depending
*  ----------------------------------------------------------
*  from INTS int scheme 
*  -------------------
*
* KEY defines how to treat situation when T is not covered by E array
* ---
* KEY = 0   :  stop when T < E(1)  or T > E(N)
*     = 1   :  assign RES=0.0 if T < E(1) and RES=CS(N) if T > E(N)
* 
* INT has the usual meaning as in ENDF/B format
*
* Attention (!)
* ---------
* Input arrays E(N) and CS(N) should be in increased order
*
*
       Dimension E(N), CS(N)
       if(KEY.lt.0.or.KEY.gt.1) then
       Print *,'                        E R R O R         '
       Print *,'Subroutine  ARRAYINT:  KEY=',KEY,' is not acceptable !'
       print *,'                            press any key...'
       pause
       stop
       endif
       INTS=INTS0
*
       If(T.lt.E(1)) goto 8000
       If(T.gt.E(N)) goto 9000
*
       Do i=1,N
       i1=i
       If( T.le.E(i) ) goto 1000
       Enddo
            goto 9500
1000   if(i1.eq.1) then  ! means that T=E(1)
       RES=CS(1)
       Return
       Endif       
          X1=E(i1-1)
          X2=E(i1)
          Y1=CS(i1-1)
          Y2=CS(i1)
          WL=T
       CALL INTERMEDIATE(X1,X2,Y1,Y2,WL,INTS,RESINT)
       RES=RESINT
       Return
* 
* 
* T < E(1)
* --------
8000   if(key.eq.0) then
       Write(6,*)'                        E R R O R        '
       Write(6,8001) T,E(1),key
8001   Format(1x,'Subroutine  ARRAYINT:'/1x,
     # ' Requested energy T=',e12.5,' is less than minimal array '
     # ,'E(1) value=',e12.5
     #  //1x,'              CHANGE THE DATA or KEY number !!'/1x,
     # ' now  KEY is equal to', i5)
       print *,'                            press any key...'
       pause
       stop
       endif
c         
       RES=0.0
       Print 8002,T,RES
8002   Format(1x,'ARRAYINT(N): for T =',e12.5,' result ',
     # 'is set to',e12.5,' (min)')
       Return
* 
* T > E(N)
* --------
9000   if(key.eq.0) then
       Write(6,*)'                        E R R O R        '
       Write(6,9001) T,E(N),key
9001   Format(1x,'Subroutine  ARRAYINT:'/1x,
     # ' Requested energy T=',e12.5,' is more than MAXIMAL array '
     # ,'E(N) value=',e12.5
     #  //1x,'              CHANGE THE DATA or KEY number !!'/1x,
     # ' now  KEY is equal to', i5)
       print *,'                            press any key...'
       pause
       stop
       endif
c         
       RES=CS(N)
       Print 9002,T,RES
9002   Format(1x,'ARRAYINT(X): for T =',e12.5,' result ',
     # 'is set to',e12.5,' (MAX)')
       Return
*
9500   Write(6,9501)
9501   Format(1x,'Subroutine  ARRAYINT:  Strange E R R O R')
       print *,'                            press any key...'
       pause
       stop
       End
*
************************************************************************
*  
       Function CF(IK,MK,TREC)
*      -----------------------
       parameter (maxc=21,maxc1=22)
       COMMON/NRT1/ANRT(MAXC1),BNRT(MAXC1),GNRT(MAXC1)
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       EDkeV=ED(MK)*1000.
* NRT 
       TT=TREC*1000.
*
       If(TT.lt.EDkeV) then
                       CF=0.0
                       Return
                       Endif
*
       If(TT.lt.2.*EDkeV) TT=2.*EDkeV
*
*                                                       
       CF=(0.8/(2.*EDkeV))*TT/
     # (1.+ANRT(IK)*TT+BNRT(IK)*(TT**0.75)+GNRT(IK)*(TT**0.16666666666))     
        RETURN
        END
*
************************************************************************
*  
       FUNCTION CF1(ED,ATRN,BTRN,GTRN,TREC)
*      ------------------------------------
* As CF, but for special purpose
       TT=TREC*1000.                                                       
       CF1=(0.8/(2.*ED*1000.))*TT/
     # (1.+ATRN*TT+BTRN*(TT**0.75)+GTRN*(TT**0.16666666666))     
        RETURN
        END
*
************************************************************************
*  
* Special function to incorporate MD result
*
       Function CF2(IK,MK,TREC)
*      ------------------------
       parameter (maxc=21,maxc1=22)
       COMMON/NRT1/ANRT(MAXC1),BNRT(MAXC1),GNRT(MAXC1)
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       Common/MERCURY/CMD(5),Ecrit,MD
       EDkeV=ED(MK)*1000.
* mod NRT 
       TT=TREC*1000.   ! MeV --> keV
*
       If(TT.lt.EDkeV) then
                       CF2=0.0
                       Return
                       Endif
*
       If(TT.lt.2.*EDkeV) TT=2.*EDkeV
*
*                                                       
       eMD= TT/
     # (1.+ANRT(IK)*TT+BNRT(IK)*(TT**0.75)+GNRT(IK)*(TT**0.16666666666))     
*
* usual formula
       CF2=(0.8/(2.*EDkeV))*eMD
*
       Elow =CMD(4)
       Ehigh=CMD(5)
*
*
      if(eMD.lt.Elow)  eMD=Elow
      if(eMD.gt.Ehigh) eMD=Ehigh
      efficiency=CMD(1)*(  eMD**CMD(2)  ) + CMD(3)*eMD
*
*
* modified NRT
        CF2=efficiency*CF2
*
        RETURN
        END
*
************************************************************************
*  
        Subroutine COS_DEFINE(IK,MK,T0,TPVA,COST)
*       ----------------------------------------
        parameter (maxc=21,maxc1=22)
*
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/PKA/ALPHA2(MAXC1,MAXC),E0(MAXC1,MAXC)
*
* T(M2)=[ 2M1*M2/(M1+M2)**2 ]* (  1-COS( TETA(CM) )) * T
*
* TG(TETA(LC))=SIN(TETA(CM))/( M1/M2 + COS(TETA(CM)) )
* 
        T=T0
        TM2=TPVA
* cos(teta) in CM
        COSTCM=1.-TM2/(T*0.5*ALPHA2(IK,MK))
        if(COSTCM.gt.1.) COSTCM =0.99999999
        if(COSTCM.lt.-1.) COSTCM=-0.9999999
        SINTCM=Sqrt(1.-COSTCM**2)
                    A11=A1
        If(IK.ne.1) A11=AT(IK-1)
*
        TETA=ATAN(   SINTCM/( (A11/AT(MK))+COSTCM )   )
        COST=COS(TETA) 
c       write(445,*)'COS(TCM),COST=',COSTCM,COST
*
        RETURN
        END
*
************************************************************************
*
        Subroutine CRITICAL_ENERGY
*       --------------------------
        parameter (maxc=21,maxc1=22)
*
* search root Tdam(E)-Ecrit=0, it is supposed, that d^2Tdam/dE^2 < 0
*
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        COMMON/NRT1/ANRT(MAXC1),BNRT(MAXC1),GNRT(MAXC1)
        Common/MERCURY/CMD(5),Ecrit,MD
        Common/SATURN/TcritLAB(MAXC1)
*
* Tcrit correspods to  Abs( Tdam(E)-Ecrit ) < Err1
        Err1=1.E-4
*
        NK1=NK+1
        If(Ecrit.le.0.0) Call Error('Ecri',0) 
*
        Do 70000 IK=1,NK1
*
         X0=Ecrit
         If(Tdam(IK,X0)-Ecrit)1,8000,90000
*
    1    h=0.1
    2    XU=X0*(1.+h)
             RK=(Tdam(IK,XU)-Tdam(IK,X0))/(XU-X0)
             X1=X0-(Tdam(IK,X0)-Ecrit)/RK
* Tcrit > 0.1 GeV ?
         If(X1.ge.1.e+5) then
                         Tcrit=X1
                         Print 91000,Tcrit
                         goto 9000
                         endif
         If(abs(Tdam(IK,X1)-Ecrit).lt.err1) then
         Tcrit=X1
         goto 9000
                                        endif
         If(Tdam(IK,X1)-Ecrit)1000, 8500, 2000
 1000    h=0.1
         X0=X1
         goto 2 
 2000    h=h/2.
         goto 2
c
 8000    Tcrit=X0
         goto 9000
 8500    Tcrit=X1
         goto 9000
c
 9000    continue
*
* keV --> MeV
        TcritLAB(ik)=Tcrit*0.001
70000   continue
*
*                                                       
        Return
*
*
90000   Print *,'Tcrit search failed !  Tdam(Xinitial) must be < Ecrit'
        Print *,'                                  press any key...'
        pause
        stop
91000   Format(70('*')/'*         Energy Tcrit =',g12.5,' keV',
     #  ' is not realistic',T69,'*'/70('*'))
        End
*
************************************************************************
*
        Subroutine DATATAB
*       ------------------
c A, W (amu), Ro (g/cm3) , <I> (eV) for elements
c
c Data from SRIM code
c  <I> is mean ionization potential (eV) checked by data in figures 
c  presented in http://www.srim.org/SRIM/SRIMPICS/IONIZ.htm,
c  except data noted below
c
c subroutine called from PRECALCULATION
c
      Common/DATATAB1/WTAB1(101),ROTAB1(101),RITAB1(101),IATAB1(101)
      Dimension IATAB(92), WTAB(92), ROTAB(92), RITAB(92)
*
*  H
      Data IATAB( 1),  WTAB( 1),  ROTAB( 1),  RITAB( 1)
     & /        1   ,    1.0079,   0.071486,    19.60/
* He
      Data IATAB( 2),  WTAB( 2),  ROTAB( 2),  RITAB( 2)
     & /        4   ,    4.0026,   0.125880,    39.00/
* Li
      Data IATAB( 3),  WTAB( 3),  ROTAB( 3),  RITAB( 3)
     & /        7   ,    6.9410,   0.534000,    42.20/
* Be
      Data IATAB( 4),  WTAB( 4),  ROTAB( 4),  RITAB( 4)
     & /        9   ,    9.0122,   1.848000,    63.70/
*  B
      Data IATAB( 5),  WTAB( 5),  ROTAB( 5),  RITAB( 5)
     & /       11   ,   10.8110,   2.350200,    76.00/
*  C
      Data IATAB( 6),  WTAB( 6),  ROTAB( 6),  RITAB( 6)
     & /       12   ,   12.0110,   2.253000,    79.10/
*  N
      Data IATAB( 7),  WTAB( 7),  ROTAB( 7),  RITAB( 7)
     & /       14   ,   14.0070,   1.026000,    84.20/
*  O
      Data IATAB( 8),  WTAB( 8),  ROTAB( 8),  RITAB( 8)
     & /       16   ,   15.9990,   1.426000,    96.00/
*  F
      Data IATAB( 9),  WTAB( 9),  ROTAB( 9),  RITAB( 9)
     & /       19   ,   18.9980,   1.111100,   107.00/
* Ne
      Data IATAB(10),  WTAB(10),  ROTAB(10),  RITAB(10)
     & /       20   ,   20.1797,   1.204000,   133.00/
* Na
      Data IATAB(11),  WTAB(11),  ROTAB(11),  RITAB(11)
     & /       23   ,   22.9898,   0.970000,   149.00/
* Mg
      Data IATAB(12),  WTAB(12),  ROTAB(12),  RITAB(12)
     & /       24   ,   24.3050,   1.736600,   156.00/
* Al
      Data IATAB(13),  WTAB(13),  ROTAB(13),  RITAB(13)
     & /       27   ,   26.9815,   2.702000,   170.00/
* Si
      Data IATAB(14),  WTAB(14),  ROTAB(14),  RITAB(14)
     & /       28   ,   28.0860,   2.321200,   171.00/
*  P
      Data IATAB(15),  WTAB(15),  ROTAB(15),  RITAB(15)
     & /       31   ,   30.9737,   1.821900,   173.00/
*  S
      Data IATAB(16),  WTAB(16),  ROTAB(16),  RITAB(16)
     & /       32   ,   32.0660,   2.068600,   184.00/
* Cl
      Data IATAB(17),  WTAB(17),  ROTAB(17),  RITAB(17)
     & /       35   ,   35.4530,   1.895600,   178.00/
* Ar
      Data IATAB(18),  WTAB(18),  ROTAB(18),  RITAB(18)
     & /       40   ,   39.9480,   1.650400,   190.00/
*  K
      Data IATAB(19),  WTAB(19),  ROTAB(19),  RITAB(19)
     & /       39   ,   39.0983,   0.863180,   190.00/
* Ca
      Data IATAB(20),  WTAB(20),  ROTAB(20),  RITAB(20)
     & /       40   ,   40.0800,   1.540000,   198.00/
* Sc
      Data IATAB(21),  WTAB(21),  ROTAB(21),  RITAB(21)
     & /       45   ,   44.9560,   2.989000,   225.00/
* Ti
      Data IATAB(22),  WTAB(22),  ROTAB(22),  RITAB(22)
     & /       48   ,   47.9000,   4.518900,   231.00/
*  V
      Data IATAB(23),  WTAB(23),  ROTAB(23),  RITAB(23)
     & /       51   ,   50.9420,   5.960000,   249.00/
* Cr
      Data IATAB(24),  WTAB(24),  ROTAB(24),  RITAB(24)
     & /       52   ,   51.9960,   7.200000,   265.00/
* Mn
      Data IATAB(25),  WTAB(25),  ROTAB(25),  RITAB(25)
     & /       55   ,   54.9380,   7.434100,   275.00/
* Fe
      Data IATAB(26),  WTAB(26),  ROTAB(26),  RITAB(26)
     & /       56   ,   55.8470,   7.865800,   286.00/
* Co
      Data IATAB(27),  WTAB(27),  ROTAB(27),  RITAB(27)
     & /       59   ,   58.9330,   8.900000,   306.00/
* Ni
      Data IATAB(28),  WTAB(28),  ROTAB(28),  RITAB(28)
     & /       58   ,   58.6900,   8.895500,   321.00/
* Cu
      Data IATAB(29),  WTAB(29),  ROTAB(29),  RITAB(29)
     & /       63   ,   63.5460,   8.920000,   332.00/
* Zn
      Data IATAB(30),  WTAB(30),  ROTAB(30),  RITAB(30)
     & /       64   ,   65.3900,   7.140000,   330.00/
* Ga
      Data IATAB(31),  WTAB(31),  ROTAB(31),  RITAB(31)
     & /       69   ,   69.7200,   5.904000,   334.00/
* Ge
      Data IATAB(32),  WTAB(32),  ROTAB(32),  RITAB(32)
     & /       74   ,   72.6100,   5.350000,   335.00/
* As
      Data IATAB(33),  WTAB(33),  ROTAB(33),  RITAB(33)
     & /       75   ,   74.9220,   5.727000,   353.00/
* Se
      Data IATAB(34),  WTAB(34),  ROTAB(34),  RITAB(34)
     & /       80   ,   78.9600,   4.810000,   351.00/
* Br
      Data IATAB(35),  WTAB(35),  ROTAB(35),  RITAB(35)
     & /       79   ,   79.9040,   3.199000,   317.00/
* Kr
      Data IATAB(36),  WTAB(36),  ROTAB(36),  RITAB(36)
     & /       84   ,   83.8000,   2.602100,   348.00/
* Rb
      Data IATAB(37),  WTAB(37),  ROTAB(37),  RITAB(37)
     & /       85   ,   85.4700,   1.532000,   364.00/
* Sr
      Data IATAB(38),  WTAB(38),  ROTAB(38),  RITAB(38)
     & /       88   ,   87.6200,   2.600000,   366.00/
*  Y
      Data IATAB(39),  WTAB(39),  ROTAB(39),  RITAB(39)
     & /       89   ,   88.9050,   4.469000,   375.00/
* Zr
      Data IATAB(40),  WTAB(40),  ROTAB(40),  RITAB(40)
     & /       90   ,   91.2200,   6.490000,   389.00/
* Nb
      Data IATAB(41),  WTAB(41),  ROTAB(41),  RITAB(41)
     & /       93   ,   92.9060,   8.570000,   417.00/
* Mo
      Data IATAB(42),  WTAB(42),  ROTAB(42),  RITAB(42)
     & /       98   ,   95.9400,  10.206000,   423.00/
* Tc
      Data IATAB(43),  WTAB(43),  ROTAB(43),  RITAB(43)
     & /       97   ,   97.0000,  11.500000,   428.00/
* Ru
      Data IATAB(44),  WTAB(44),  ROTAB(44),  RITAB(44)
     & /      102   ,  101.0700,  12.300000,   441.00/
* Rh
      Data IATAB(45),  WTAB(45),  ROTAB(45),  RITAB(45)
     & /      103   ,  102.9100,  12.399000,   468.00/
* Pd
      Data IATAB(46),  WTAB(46),  ROTAB(46),  RITAB(46)
     & /      106   ,  106.4000,  12.020000,   476.00/
* Ag
      Data IATAB(47),  WTAB(47),  ROTAB(47),  RITAB(47)
     & /      107   ,  107.8700,  10.473000,   488.00/
* Cd
      Data IATAB(48),  WTAB(48),  ROTAB(48),  RITAB(48)
     & /      114   ,  112.4000,   8.642000,   441.00/
* In
      Data IATAB(49),  WTAB(49),  ROTAB(49),  RITAB(49)
     & /      115   ,  114.8200,   7.300000,   481.00/
* Sn
      Data IATAB(50),  WTAB(50),  ROTAB(50),  RITAB(50)
     & /      120   ,  118.7100,   7.281600,   478.00/
* Sb
      Data IATAB(51),  WTAB(51),  ROTAB(51),  RITAB(51)
     & /      121   ,  121.7500,   6.684000,   472.00/
* Te
      Data IATAB(52),  WTAB(52),  ROTAB(52),  RITAB(52)
     & /      130   ,  127.6000,   6.250000,   485.00/
*  I
      Data IATAB(53),  WTAB(53),  ROTAB(53),  RITAB(53)
     & /      127   ,  126.9000,   4.937300,   455.00/
* Xe
      Data IATAB(54),  WTAB(54),  ROTAB(54),  RITAB(54)
     & /      132   ,  131.3000,   3.058900,   440.00/
* Cs
      Data IATAB(55),  WTAB(55),  ROTAB(55),  RITAB(55)
     & /      133   ,  132.9100,   1.878500,   488.00/
* Ba
      Data IATAB(56),  WTAB(56),  ROTAB(56),  RITAB(56)
     & /      138   ,  137.3270,   3.510000,   491.00/
* La
      Data IATAB(57),  WTAB(57),  ROTAB(57),  RITAB(57)
     & /      139   ,  138.9100,   6.173800,   472.00/
* Ce
      Data IATAB(58),  WTAB(58),  ROTAB(58),  RITAB(58)
     & /      140   ,  140.1200,   6.672400,   501.00/
* Pr
      Data IATAB(59),  WTAB(59),  ROTAB(59),  RITAB(59)
     & /      141   ,  140.9100,   6.773000,   513.00/
* Nd
      Data IATAB(60),  WTAB(60),  ROTAB(60),  RITAB(60)
     & /      142   ,  144.2400,   7.008000,   546.00/
* Pm
      Data IATAB(61),  WTAB(61),  ROTAB(61),  RITAB(61)
     & /      148   ,  148.0000,   6.475000,   560.00/
* Sm
      Data IATAB(62),  WTAB(62),  ROTAB(62),  RITAB(62)
     & /      152   ,  150.3600,   7.520000,   566.00/
* Eu
      Data IATAB(63),  WTAB(63),  ROTAB(63),  RITAB(63)
     & /      153   ,  151.9700,   5.244000,   580.00/
* Gd
      Data IATAB(64),  WTAB(64),  ROTAB(64),  RITAB(64)
     & /      158   ,  157.2500,   7.901000,   586.00/
* Tb
      Data IATAB(65),  WTAB(65),  ROTAB(65),  RITAB(65)
     & /      159   ,  158.9300,   8.230000,   614.00/
* Dy
      Data IATAB(66),  WTAB(66),  ROTAB(66),  RITAB(66)
     & /      164   ,  162.5000,   8.551000,   603.00/
* Ho
      Data IATAB(67),  WTAB(67),  ROTAB(67),  RITAB(67)
     & /      165   ,  164.9300,   8.795000,   641.00/
* Er
      Data IATAB(68),  WTAB(68),  ROTAB(68),  RITAB(68)
     & /      166   ,  167.2600,   9.066000,   661.00/
* Tm
      Data IATAB(69),  WTAB(69),  ROTAB(69),  RITAB(69)
     & /      169   ,  168.9300,   9.321000,   683.00/
* Yb
      Data IATAB(70),  WTAB(70),  ROTAB(70),  RITAB(70)
     & /      174   ,  173.0400,   6.960000,   684.00/
* Lu
      Data IATAB(71),  WTAB(71),  ROTAB(71),  RITAB(71)
     & /      175   ,  174.9700,   9.841000,   694.00/
* Hf
      Data IATAB(72),  WTAB(72),  ROTAB(72),  RITAB(72)
     & /      180   ,  178.4900,  13.310000,   675.00/
* Ta
      Data IATAB(73),  WTAB(73),  ROTAB(73),  RITAB(73)
     & /      181   ,  180.9500,  16.601000,   729.00/
*  W
      Data IATAB(74),  WTAB(74),  ROTAB(74),  RITAB(74)
     & /      184   ,  183.8500,  19.350000,   735.00/
* Re
      Data IATAB(75),  WTAB(75),  ROTAB(75),  RITAB(75)
     & /      187   ,  186.2000,  20.530001,   749.00/
* Os
      Data IATAB(76),  WTAB(76),  ROTAB(76),  RITAB(76)
     & /      192   ,  190.2000,  22.480000,   746.00/
* Ir
      Data IATAB(77),  WTAB(77),  ROTAB(77),  RITAB(77)
     & /      193   ,  192.2000,  22.421000,   757.00/
* Pt
      Data IATAB(78),  WTAB(78),  ROTAB(78),  RITAB(78)
     & /      195   ,  195.0800,  21.450001,   792.00/
* Au
      Data IATAB(79),  WTAB(79),  ROTAB(79),  RITAB(79)
     & /      197   ,  196.9700,  19.311001,   789.00/
* Hg
      Data IATAB(80),  WTAB(80),  ROTAB(80),  RITAB(80)
     & /      202   ,  200.5900,  13.546200,   800.00/
* Tl
      Data IATAB(81),  WTAB(81),  ROTAB(81),  RITAB(81)
     & /      205   ,  204.3800,  11.850000,   810.00/
* Pb
      Data IATAB(82),  WTAB(82),  ROTAB(82),  RITAB(82)
     & /      208   ,  207.1900,  11.343700,   787.00/
* Bi
      Data IATAB(83),  WTAB(83),  ROTAB(83),  RITAB(83)
     & /      209   ,  208.9800,   9.800000,   819.00/
* Po (no fig for <I>)
      Data IATAB(84),  WTAB(84),  ROTAB(84),  RITAB(84)
     & /      209   ,  210.0000,   9.251100,   830.00/
* At <I> is not well defined from SRIM data (see original files)
      Data IATAB(85),  WTAB(85),  ROTAB(85),  RITAB(85)
     & /      210   ,  210.0000,  10.000000,   756.95/
* Rn <I> is not well defined from SRIM data (see original files)
      Data IATAB(86),  WTAB(86),  ROTAB(86),  RITAB(86)
     & /      222   ,  222.0000,   9.910000,   736.54/
* Fr (no fig for <I>)
      Data IATAB(87),  WTAB(87),  ROTAB(87),  RITAB(87)
     & /      223   ,  223.0000,  10.000000,   827.00/
* Ra (no fig for <I>)
      Data IATAB(88),  WTAB(88),  ROTAB(88),  RITAB(88)
     & /      226   ,  226.0000,   5.022200,   826.00/
* Ac (no fig for <I>)
      Data IATAB(89),  WTAB(89),  ROTAB(89),  RITAB(89)
     & /      227   ,  227.0000,  10.000000,   841.00/
* Th (no fig for <I>)
      Data IATAB(90),  WTAB(90),  ROTAB(90),  RITAB(90)
     & /      232   ,  232.0000,  11.658000,   847.00/
* Pa (no fig for <I>)
      Data IATAB(91),  WTAB(91),  ROTAB(91),  RITAB(91)
     & /      231   ,  231.0000,  15.370000,   878.00/
*  U
      Data IATAB(92),  WTAB(92),  ROTAB(92),  RITAB(92)
     & /      238   ,  238.0300,  19.042999,   842.00/
c
c
      Do i=1,92
      IATAB1(i)=IATAB(i)
      WTAB1(i) =WTAB(i) 
      ROTAB1(i)=ROTAB(i)
      RITAB1(i)=RITAB(i)
      enddo
          Do i=93,101
          IATAB1(i)=0
          WTAB1(i) =0.0
          ROTAB1(i)=0.0
          RITAB1(i)=0.0
          enddo
      Return
      End   
*
************************************************************************
*
       Subroutine dEdXNUC_RECALC(Z1,Z2,A1,A2,E,sN)
*      -------------------------------------------
c Z1,A1: projectile, Z2,A2: target
c 
c
       Real*8 Z,EL,RL,rksi,eps,t,sNd
c
c E (MeV)
c
       Z=(Z1**0.666666d0+Z2**0.6666666d0)**1.5d0
c
       EL=3.07358d-05*Z1*Z2*(Z**0.33333333d0)*( (A1/A2)+1.d0 )
c (no coeff, n0)
       RL=(Z**0.6666666d0) *(  (A1+A2)**2  )/(A1*A2)
c
       rksi=1.309d0
c
       eps=E/EL                              
       t=((2.d0*rksi)**0.6666666d0)*(eps**0.8888888d0)
c
       sNd=(EL/RL)*(1.d0/eps)*
     # (  -dsqrt(t)/dsqrt(1.+t)   +dlog(dsqrt(t)+dsqrt(1.d0+t))  )
c
       sN=real(sNd)
       Return
       End
*
************************************************************************
*
       Subroutine DEDX_SPAR
*      --------------------
* Calculation of dE/dx by SPAR (Armstrong, Chandler) routine
*
* This subroutine should be executed after 
*     subr INCREASE_DATA_ARRAY, where NMAX is calculated
*
* units for stopping power [MeV/cm], range [cm]
*
       parameter (maxc=21,maxc1=22)
       Character OUTSPAR*12, C5*5
       Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
*
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
*
       Common/STARS1/ dSdX1(MAXC1,MAXC,10002), 
     # dEdXNuc1(MAXC1,MAXC,10002), 
     # dEdXNuc0Ed1(MAXC1,MAXC,10002), dEdXNucEdTm1(MAXC1,MAXC,10002), 
     # CST1(MAXC1,MAXC,10002), NMAX
       Common/ISTOP/ISTOP
       Common/VENUS/RI(MAXC)
       Dimension TmpE(10002),dxdE(10002)
*
       if(istop.ne.1) return
* 
*
* Condensed matter supposed
      If(RO.le.0.01)  goto 91000
*
* Mean <I> for compound (only for printing)
           RIL=0.d0
           Do i=1,NK
           RIL= RIL+FR(i)*ZT(i)*alog( RI(i) )
           Enddo
           RIL=2.718281828**(RIL/Z2)
*
      jj=2 ! condensed element
          if(NK.ne.1) then
* check if all components are isotopes of the same element
          IZT0=ifix( ZT(1)+0.001)
          do i=1,NK
          IZT=ifix( ZT(i)+0.001)
          if(IZT.ne.IZT0) then
                          jj=4   ! condensed compound
                          goto 1
                          endif
          IZT0=IZT
          enddo
                      endif
    1     continue
*
*
      NK1=NK+1
*
*
*
      Do  IK=1,NK1   
*     ------------
* IK - id of the moving ion,   IK=1: primary particle
*
*
* Projectile
      if(IK.eq.1) then
                     ZPR=Z1
                     APR=A1
                  else
                     ZPR=ZT(IK-1)
                     APR=AT(IK-1)
                  endif
*
        IZA=1000*ifix(ZPR+0.001)+ifix(APR+0.001)
        Write(C5,'(i5)')IZA
        outspar=C5//'.sto'
        open(21,file=outspar)

        Write(21,90001)ZPR,APR,IK,Z2,A2,JJ,RO,RN0,RIL*1.e+6
        Write(21,90002)
        Write(21,90003)
*
*
        Do I=1,999999999
*
* J=(lg(E)+6)*1000+1  means that energy can changes from 10**-6 MeV
* If 10002 array dimension will be increased change also 1000 below
* and in other subroutines (i.e. MODEL)
        RLG=Float(I-1)/1000. -6.
        E=10.**RLG   ! Energy (MeV)
! NMAX is already defined in subr INCREASE_DATA_ARRAY and check < 5 GeV is done 
       If(I.gt.NMAX) goto 7000
! Attention. NMAX is the same for all material components, it is
* supposed that SL_NLS code which is executed before IOTA code 
* was stopped at the same energy for all components
*
         Call SPAR0(ZPR, APR, E, dEdxTOTS, dEdxNS, JJ)
*
* total stopping power
          dEdx(IK,i)  =dEdxTOTS
* nuclear stopping
          dEdxN1(IK,i)=dEdxNS
* 
* calculate total path from 1/ dE/dx integration (lin-lin)
            TmpE(i)=E
                                dxdE(i)=0.0
            if(dEdxTOTS.ne.0.0) dxdE(i)=1./dEdxTOTS
       if(i.eq.1) then 
                  Rp1(IK,i)   =0.0
                  else
       Rp1(IK,i)=Rp1(IK,i-1)+(TmpE(i)-TmpE(i-1))*
     #           (dxdE(i)+dxdE(i-1))/2.
                 endif
*
*
        Enddo    !  Do I1=1,999999999
 7000   continue
*
* write results 
* units for printing MeV/mg/cm2, cm
c                   prc=1./(1000.*RO)
                   prc=1.
        Do i=1,NMAX
        Write(21,90004) TmpE(i), prc*(dEdx(IK,i)-dEdxN1(IK,i)) ,
     #                            prc*dEdxN1(IK,i), Rp1(IK,i)
        Enddo
        close(21)
*
*
        Enddo    !  Do IK=1,NK1
*       -----------------------
*
*
               iiii=1
c        if(iiii.eq.1) stop
        Return
c
c
90001   Format(' Stopping power from SPAR (MCNPX)'/
     #  ' projectile ',f6.1,f8.2,'       IK =',i3,
     #  /' medium     ',f6.1,f8.2,'    condensed   JJ =',i2,
     #  /' density =',f8.3,' g/cm3     n0 =',1pe12.5,' cm-3'
     #  /' mean ioniz pot = ',0pf8.2,' eV')
90002   Format(/' units  E [MeV],  dE/dx [MeV/mg/cm2],  R [cm] ')
90003   Format(/'     E        dE/dx(electr)  dE/dx(nucl)',
     #  '       R (total) '/ 61('-'))
90004   Format(1pe12.5,2e14.5,e17.5)
c
91000   Print 91001
91001   Format(/' Gaseous target is not allowed ! '
     #  /20x,'Change subr DEDXSPAR  !!')
        print *,'                        press any key...'
        pause
        stop
c
        End
*
************************************************************************
*
         Subroutine  DEDX_ZIEGLER_READ(IK, IR, RO0, Ex, dEdx, Rp, NdE,
     #   dEdxN)
*        -------------------------------------------------------------
c
c Ex,  dEdx  - energy and total stopping power   (Ziegler/SRIM)
c      dEdxN - nuclear stopping power            (Ziegler/SRIM)
c
         parameter (maxc=21)
         Character C12*12,C33*33,C7*7,CID3*3,CID2*2, C17*17
         Character C6*6, C80*80
         Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
         Common/Basic/Z1,A1,Z2,A2,AW,ROOO,RN0
         Dimension Rp(1501), Ex(1501), dEdx(1501)
         Dimension dEdxN(1501)
         Dimension ExTMP(1501),dEdxETMP(1501), dEdxE(1501)
         Dimension ExTMP2(1501),dEdxETMP2(1501)
         If(IK.eq.1) then
                     Zini=Z1
                     Aini=A1
                     else
                     Zini=ZT(IK-1)
                     Aini=AT(IK-1)
                     endif
                     IZT=Ifix(Zini+0.001)
                     IAT=Ifix(Aini+0.001)
*
* find "Ion ="
*
         Do i=1,111111111
         read(IR,'(a6)',end=90001)C6
         If(C6.eq.' Ion =')             then  
         backspace ir
         read(ir,'(a80)')C80
*
* Get Z,A from SRIM output 
         Call ZieION(C80,Zzie,Azie)
*
*
                                        goto 11
                                        endif ! If(C6.eq.' Ion =')
         Enddo
*
*
* find "Target density"
*
 11      Do i=1,111111111
         read(IR,'(a17)',end=90005)C17
         If(C17.eq.' Target Density =') then  ! 1)
         backspace ir
         read(ir,'(t18,e12.0)')RO
            if(RO.ne.RO0) then                ! 2)
            print 1,IZT,IAT,RO0,RO
  1         format(1x,'  W A R N I N G !'/1x,
     #      'for ',i3,i4,' RO(input)=',g12.5,' BUT  Ziegler(RO)=',
     #      g12.5/1x,'The last one will be used to recover dEdx')
            print *,'                   press any key to continue'
            pause
                          endif                ! 2)
         goto 2
                                        endif  ! 1)
         Enddo
*
* find line "Stopping units"
*
  2      do i=1,111111111
         read(IR,'(a17)',end=90006)C17
         If(C17.eq.' Stopping Units =') then
             backspace ir
             read(IR,'(a33)',end=90006)C33
             if(C33.ne.' Stopping Units =  MeV / (mg/cm2)') then
             Print *,' Units of stopping power must be MeV/mg/cm2 !'
             print *,'                         press any key...'
             pause
             stop
                                                            endif
          goto 3
                                        endif
          enddo
*
* skip 4 lines
  3      do i=1,4
         read(IR,*,end=90007)
         enddo
*
         read(IR,'(a12)')C12
         if(C12.ne.'----------- ') Call error('----',12)
*
* Begin reading
*
* transformation of SRIM data 
*
         i=1
           Ex(1)=0.0
           dEdx(1)=0.0
           Rp(1)=0.0
           dEdxN(1)=0.0
c
c
         Do iii=1,1111111       ! ---c y c l e begins----
         read(IR,'(a7)')C7 
         if(C7.eq.'-------') goto 2000 
         backspace IR
         read(IR,'(e7.0,1x, a3,   e12.0,   e11.0,    e8.0,1x, a2)')
     #             EN,       CID3, dEdx_el, dEdx_nuc, RRR,       CID2
         if(CID3.ne.'eV '.and.CID3.ne.'keV'.and.CID3.ne.'MeV'.
     #   and.CID3.ne.'GeV') call ERROR(' ev?',11111)
*
* energy ---> MeV
                            ENERGY_MULT=1.0
         if(CID3.eq.'eV ')  ENERGY_MULT=1.E-06
         if(CID3.eq.'keV')  ENERGY_MULT=1.E-03
         if(CID3.eq.'GeV')  ENERGY_MULT=1.E+03
*
         if(CID2.ne.'A '.and.CID2.ne.'um'.and.CID2.ne.'mm'
     #   .and.CID2.ne.'cm'.and.CID2.ne.'m ') call ERROR(' um?',11111)
*
* all units ---> cm
                           RANGE_MULT=1.
         if(CID2.eq.'A ')  RANGE_MULT=1.E-08     ! 1 A=10**-10 m
         if(CID2.eq.'um')  RANGE_MULT=1.E-04     ! 1 um=micron= 10**-6 m
         if(CID2.eq.'mm')  RANGE_MULT=0.1        ! 1 mm=0.001 m
         if(CID2.eq.'m ')  RANGE_MULT=100.       ! 1 m =100 cm 
* 1)
* MeV/(mg/cm2) ----> MeV/(g/cm2)
         dEdx_sum= 1000.*( dEdx_el+dEdx_nuc)
         dEdx_nuc2= 1000.*dEdx_nuc
* 2)
* MeV/(g/cm2) ----> MeV/cm
         dEdx_sum= dEdx_sum*RO
         dEdx_nuc2= dEdx_nuc2*RO
*
         Energy=EN* ENERGY_MULT
         Range= RRR* RANGE_MULT
*
* fill arrays
         i=i+1
                  if(i.gt.1501)  Call Error('DEDX',1501)
         Ex(i)=Energy
         dEdx(i)=dEdx_sum
         dEdxN(i)= dEdx_nuc2
         Rp(i)=Range
         Enddo                  ! ---c y c l e finished----
         call error('_Zie',11111)
*
* end of reading
2000     NdE=i
*
*
* Recalculate stopping if Z=Z', but A.ne.A'
*
         IZzie=Ifix(Zzie+0.001)
         If(IZzie.ne.IZT) then
         Print 3000,Zini,Aini,Zzie,Azie
3000     Format(' SRIM data failure !!!'/1x,' Current incident ion is ',
     #   f5.1,f8.2/20x,'BUT'/' SRIM data are prepared for ',f5.1,f8.2)
         print *,'                           press any key...'
         pause
         stop
                          endif
* no recalculation if A-A' < 1
         If( abs(Azie-Aini).lt.1.0) Return
*
         If(NK.ne.1) then
         Print 3100
3100     Format(70('*')/'*',25x,'W A R N I N G !',t70,'*'/'*',
     #   4x,' for compounds stopping power will not be recalculated',
     #   t70,'*'/70('*')//1x,
     #   'press any key to continue  calculations ...')
         pause
         Return
                     endif
*
* Recalculation
* 
* i) electronic stopping
*
         Do i=1,NdE
         ExTMP(i)=Ex(i)*Aini/Azie
         dEdxETMP(i)=dEdx(i)-dEdxN(i)
         Enddo  
c 
         if(Aini-Azie) 4000,4000,5000
c
c A' < A ==> lack of high energy data, get them by interp two last points
c
4000        Do i=1,NdE
            m=i
            if(ExTMP(NdE).le.Ex(i)) goto 4010
            Enddo
         call Error('4010',NdE)
4010         X1=ExTMP(NdE-1)
             X2=ExTMP(NdE)
             Y1=dEdxETMP(NdE-1)
             Y2=dEdxETMP(NdE)
             INTS=2
         j=NdE
         Do i=m,NdE
         j=j+1
                  if(j.gt.1501)  Call Error('j :1',1501)
         ExTMP(j)=Ex(i)
         WL=ExTMP(j)
         Call INTERMEDIATE(X1,X2,Y1,Y2,WL,INTS,RESINT)
         dEdxETMP(j)=RESINT
         Enddo
         NdETMP=j
         goto 7000
c 
c A' > A ==> lack of low energy data, get them by interp two first points
c
5000        Do i=2,NdE
            m=i-1
            if(ExTMP(2).le.Ex(i)) goto 5010  ! "2" is first non-zero value
            Enddo
         call Error('5010',NdE)
5010         X1=ExTMP(2)
             X2=ExTMP(3)
             Y1=dEdxETMP(2)
             Y2=dEdxETMP(3)
             INTS=2
         j=1
         ExTMP2(j)=0.0
         dEdxETMP2(j)=0.0
c
         Do i=2,m
         j=j+1
         ExTMP2(j)=Ex(i)
         WL=ExTMP2(j)
         Call INTERMEDIATE(X1,X2,Y1,Y2,WL,INTS,RESINT)
         dEdxETMP2(j)=RESINT
         Enddo
c
           Do i=2,NdE
           j=j+1
                  if(j.gt.1501)  Call Error('j :2',1501)
           ExTMP2(j)=ExTMP(i)
           dEdxETMP2(j)=dEdxETMP(i)
           Enddo
         NdETMP=j
           Do i=1,NdETMP
           ExTMP(i)=ExTMP2(i)
           dEdxETMP(i)=dEdxETMP2(i)
           Enddo
c
c recover old energy grid
c
7000     Do i=1,NdE
         E=Ex(i)
         Call ARRAYINT(0,ExTMP,dEdxETMP, NdETMP, E, 2, RES)
         dEdxE(i)=RES
         Enddo 
*
* ii) nuclear stopping
*
       Do i=2,NdE
       E=Ex(i)
       Call dEdXnuc_recalc(Zzie,Z2,Azie,A2,E,sNzie)
       Call dEdXnuc_recalc(Zini,Z2,Aini,A2,E,sNini)
       If(sNzie.eq.0.0) Call error('snzi',0)
c
       dEdxN(i)=dEdxN(i)*sNini/sNzie
       Enddo
*
* total stopping 
                           open(22,file='renorm.sto') ! test printing
       Write(22,7500)Zini,Aini,Zzie,Azie,Z2,A2
7500   Format(' Incident ion  ', f5.1,f8.2/
     # ' SRIM data for ',f5.1,f8.2/25x,' Target ',f5.1,f8.2//
     #' Energy [MeV],   Stopping power [MeV/cm]'//
     #'     E         dE/dx(elec)     dE/dx(nucl) '/44('-'))
c
       Do i=1,NdE
       dEdx(i)=dEdxN(i)+dEdxE(i)
       Write(22,'(1pe11.4,e14.3,e16.3)')Ex(i),dEdxE(i),dEdxN(i)
       Enddo
c
       Return
c
c
90001    Print *,'------- End of SRIM output file ------'
         Print *,'  Phrase "Ion =" is not found'
         print *,'                         press any key...'
         pause
         stop
90005    Print *,'-------  End of SRIM output file ------'
         Print *,'  Phrase "Target density" is not found'
         print *,'                         press any key...'
         pause
         stop
90006    Print *,'-------  End of SRIM output file ------'
         Print *,'  Phrase "Stopping units" is not found'
         print *,'                         press any key...'
         pause
         stop
90007    Print *,'-------  End of SRIM output file ------'
         Print *,'               UNEXPECTED !'
         print *,'                         press any key...'
         pause
         stop
         End
*
************************************************************************
*
       Subroutine DISPERS(KEY)
*      -----------------------
       Common/SUNDI/DIVel1(405),DIFRENKEL(405),DIVel5
       Common/SUN/Vel1L(405),Tmean1,Vel2Tm(405),Vel3Pl(405),
     #            R1,R1p,Tplay1,Vel4(405),Nel(405)
       Common/MEMORY/NFRENKEL(405)
       Common/SUN2/ZV5,Vel5,NN(405)
*
       Common/DIMEMO/DV1(405),DFREN(405),DV5
*
       If(Key.eq.2) goto 2
* store data before the history
       Do i=1,405
       DV1(i)=Vel1L(i)
       DFREN(i)=float(NFRENKEL(i))
       Enddo
       DV5=Vel5
       Return
* sum
  2     continue
        SUMV1=0.0
        SUMF=0.0
        Do i=1,405
        SUMV1=SUMV1+Vel1L(i)-DV1(i)   ! = result for the current history
        SUMF= SUMF +float(NFRENKEL(i))-DFREN(i)
          DIVel1(i)    =DIVel1(i)   +SUMV1**2
          DIFRENKEL(i) =DIFRENKEL(i)+SUMF**2
        Enddo   
*
        DIVel5=DIVel5+ (Vel5-DV5)**2
        Return
        End
*
************************************************************************
*
        Subroutine END_OF_CALCULATION
*       -----------------------------
        Write(33,1)
  1     Format(33(1h*),'e*n*d',35(1h*))
        Return
        end
*
************************************************************************
*
         Subroutine Error(phrase,I)
*        --------------------------
         Character phrase*4
         write(6,1)phrase,I
1        Format(1x,'        ???   ',a4/1x,
     *   'ERROR !!!          number=',i7)
         print *,'                       press <Enter>...'   
         pause
         stop
         end
*
************************************************************************
*  
         FUNCTION F(X) 
*        -------------
* Scattering f(x)= f(t^1/2) function
*
         Common/PARAM01/IDSDT
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
*
         If(IDSDT.eq.0)  then
*
         F=ALP1*(X**BET1)*(   ( 1.+( ALP2*(X**BET2) )**BET3)**BET4  )
         Return
                         else
*
* Burenkov et al function
*
         F=FBUR(X)
         Return
                         endif
         End
*
************************************************************************
*
         FUNCTION FBUR(X) 
*        ---------------
* Burenkov et al function
         If(X.le.0.04) then
           RJ=1.
           A1=0.088
           A2=1.
           A3=0.2
           goto 1
           endif
         If(0.04.lt.X  .and.  X.le.1.0) then
           RJ=1.
           A1=0.23
           A2=1.3
           A3=0.4
           goto 1
           endif
         If(1.0.lt.X  .and.  X.le.40.) then
           RJ=0.0
           A1=0.4563
           A2=0.0
           A3=0.3
           goto 1
           endif
         If(X.gt.40.) then
           RJ=0.0
           A1=0.5
           A2=0.0
           A3=0.0
           endif
1        FBUR=A1*(X**(RJ/2.))*(X+A2)/(  (X+A3)**2 )
         Return
         End
*
************************************************************************
*
         Function FINDP(S80,C10)
*        ---------------------------------
* Find phrase C10*XX (here XX=1) in line S80*80
* N = position of the last symbol of C10 in S80
* N = 0 if the phrase not found
*
         Character S80*80, C10*1
         NS=80
         NC=1
                            N=0         
         Do 2000 I=1,NS
               i1=I
               i2=I+NC-1
               if(i2.gt.NS) goto 2000
         if(s80(I1:I2).eq.C10) goto 3000
2000     continue      
         findp=float(N)  
         return
*
3000     continue
         N=i2 
         findp=float(N)
         return
         end
*
******************************************************************
*
         Subroutine FT12CHOICE(idsdt)
*        --------------------------
* Main formula
* f(x)=Lambda* x**(1-2m) [1+ {2*Lambda*x**(2*(1-m)}**q ]**(-1/q)
*
* Parameters are taken mainly from   W.Eckstein, "Computer Simulation
* of Ion-Solid Interactions"  Springer, Berlin, 1991, p.59, Table 4.8
*
*
* alp1 = L,  bet1 = (1-2*m),  alp2 = 2*L
* bet2 = 2*(1-m), bet3= q,    bet4 = -1/q
*
         Common/JUPITER/ALP1,ALP2,BET1,BET2,BET3,BET4
         Common/AUX1/rlambda,rm,q
*
         if(idsdt.eq.1) return   ! --> Burenkov et al function
         if(idsdt.eq.0) goto 10   
         goto(888,888,888,888,888,888,888,888,888,10,
     #        11,12,13,14,15), idsdt
         goto 888
*
* Original Winterbon et al parameters
10       rlambda=1.309
         rm=1./3.
         q=2./3.
         goto 777
*
* Thomas-Fermi-Sommerfeld
11       rlambda=1.7
         rm=0.311
         q=0.588
         goto 777
*
* Bohr
12       rlambda=2.37
         rm=0.103
         q=0.570
         goto 777
* 
* Lenz-Jensen
13       rlambda=2.92
         rm=0.191
         q=0.512
         goto 777
* 
* Moliere
14       rlambda=3.07
         rm=0.216
         q=0.530
         goto 777
*
* U.Littmark, J.F.Ziegler, "Handbook of Range Distributions"
* Kr-C potential
15       rlambda=3.35
         rm=0.2328
         q=0.4445
*
*
777      alp1=rlambda
         bet1=1.-2.*rm
         alp2=2.*rlambda
         bet2=2.*(1.-rm)
         bet3=q
         bet4=-1./q
!
         idsdt=0
         Return 
*
  888    Print 999,idsdt
  999    Format(' ERROR:    Parameters of f(t^1/2) are not known !'/
     #   '           idsdt=',i5,' is not correct.')      
         Print *,'                     press any key...'
         pause
         stop
         End
*
************************************************************************
*
        Subroutine GET_FILE_NAMES(IU,NK,NF)
*       ----------------------------------
*
* To get NK-number file names (max 12 charactres) from input lines
* written in arbitrary order.
*
*    Any number of lines can be used to write NK file names
* Example (NK=7) (no "c" in real input):
c---------------e x a m p l e-----------------
c abc.dat    cde.dat
c   qweert.dat q.dat   w.w   www.dat  iuiu.inp
c---------------------------------------------
*    Any line beginning from * is the comment and will be omitted.
*    Reading stops when all NK names will be obtained.
*    Input line lenght is max 80 characters.
*
* IU     - number of input device
* NK     - number of names of the files to be read
* NF(NK) - name of files
*
        Character C80*80, NF*12, NFTMP*12
        Dimension NF(NK)
c
 400    Read(IU,'(a80)') C80    
        if(C80(1:1).eq.'*') goto 400
          MK=0
 1      Do J=1,80
        i=J
        If(C80(j:j).ne.' ') goto 2
        Enddo
* only blank line left
        If(MK.gt.NK)  goto 90000
        If(MK.eq.NK)  return
* MK < NK
 500    Read(IU,'(a80)') C80    
        if(C80(1:1).eq.'*') goto 500
        goto 1
*
 2      MK=MK+1        
        If(MK.gt.NK)  goto 90000
        NFTMP='            '
           L=0 
           Do M=i,80
           If(C80(m:m).eq.' ') goto 3
           L=L+1 
           If(L.gt.12) goto 91000
           NFTMP(L:L)=C80(M:M)
           C80(M:M)=' '
           Enddo
 3      NF(MK)=NFTMP
        If(MK.eq.NK) Return
        goto 1
*
90000   Print *,'***** Subr.GET_FILE_NAMES'
        Print *,' Number of files MK exceeds NK(input) !'
        print *,'                         press any key...'
        pause
        stop
91000   Print *,'***** Subr.GET_FILE_NAMES'
        Print *,' One of the file name exceeds 12 characters !'
        Print *,'               CHANGE INPUT   '
        print *,'                         press any key...'
        pause
        stop
*
        END
*
************************************************************************
*
      Subroutine GRAPH(Y,F,N3,IALOG)                                     
*     ------------------------------
* IALOG .ne.0 : Log scale for Y             
      COMMON/MAIIPR/IPR1                                                
      DIMENSION Y(N3),F(N3),F1(11250)                                     
      INTEGER A1(40),B1,C1,D1,D2,D3,D4,D5,D6                            
      DATA B1,C1,D1,D2,D5,D6/1H*,1H ,1H!,1H-,1HI,1H./                   
       IF(N3.GT.11250)then
       Print*,' BAD operation in the code GRAPH'
       STOP
       endif
      N1=1                                                              
      W=F(1)                                                            
      DO 1 L=1,N3                                                       
      IF(ABS(W).GT.ABS(F(L)))GOTO 1                                     
      W=F(L)                                                            
    1 CONTINUE                                                          
      IF(W.NE.0.)GOTO 70                                                
      WRITE(IPR1,41)                                                    
   41 FORMAT(1X,' GRAPH:  maximal value identically equal to zero')      
      RETURN                                                            
   70 IF(IALOG.NE.0)GOTO 199                                            
      WRITE(IPR1,60)                                                    
   60 FORMAT(/3X,'   X           Y       ',4X,4('.........!'))          
      T=40./ABS(W)                                                      
      DO 300 I=1,N3                                                     
  300 F1(I)=F(I)                                                        
      GOTO 7                                                            
  199 WMIN=1.E+10                                                       
      DO 200 I=1,N3                                                     
      IF(F(I).NE.0..AND.F(I).LT.WMIN)WMIN=F(I)                          
  200 CONTINUE                                                          
      IMAX=-8                                                           
  210 IF(W.LE.10.**IMAX)GOTO 220                                        
      IMAX=IMAX+1                                                       
      GOTO 210                                                          
  220 IMIN=IMAX                                                         
  230 IF(WMIN.GE.10.**IMIN)GOTO 240                                     
      IMIN=IMIN-1                                                       
      GOTO 230                                                          
  240 R10=10.**IMIN                                                     
      IF(IMIN.EQ.IMAX)GOTO 250                                          
      WW1=FLOAT(IMIN)                                                   
      WW=FLOAT(IMAX-IMIN)                                               
      R20=10.**IMAX                                                     
      WRITE(IPR1,62)R10,R20                                             
   62 FORMAT(1X,5X,'semilogarithmic net        '/3X,23X,E8.2,32X,E8.2)  
      GOTO 260                                                          
  250 WW1=ALOG10(WMIN)                                                  
      WW=ALOG10(WMAX)-ALOG10(WMIN)                                      
  260 DO 270 I=1,N3                                                     
      FF=F(I)                                                           
      IF(FF.EQ.0.)FF=R10                                                
  270 F1(I)=ALOG10(FF)-WW1                                              
      WRITE(IPR1,60)                                                    
      T=40./WW                                                          
    7 CONTINUE                                                          
      DO 3 I=1,N3                                                       
      X=F1(I)                                                           
      N=INT(X*T)                                                        
      IF(I.EQ.N3)GOTO 105                                               
      IF(I.EQ.N1*10)GOTO 107                                            
      D4=C1                                                             
      GOTO 108                                                          
  105 D4=D6                                                             
      GOTO 108                                                          
  107 D4=D2                                                             
      N1=N1+1                                                           
  108 N2=1                                                              
      DO 4 J1=1,40                                                      
      IF(J1.EQ.20)GOTO 110                                              
      IF(J1.EQ.1.OR.J1.EQ.40)GOTO 24                                    
      D3=D4                                                             
      GOTO 25                                                           
   24 D3=D5                                                             
   25 CONTINUE                                                          
      GOTO 111                                                          
  110 D3=D1                                                             
      N2=N2+1                                                           
  111 CONTINUE                                                          
      IF(J1.EQ.N)GOTO 101                                               
      A1(J1)=D3                                                         
      GOTO 102                                                          
  101 A1(J1)=B1                                                         
  102 CONTINUE                                                          
    4 CONTINUE                                                          
      WRITE(IPR1,61)Y(I),F(I),A1                                        
   61 FORMAT(1PE12.5,1X,E12.5,5X,40A1)                                  
    3 CONTINUE                                                          
      RETURN                                                            
      END                                                               
*
************************************************************************
*
       Subroutine INCREASE_DATA_ARRAY
*      ------------------------------
       parameter (maxc=21,maxc1=22)
       Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
*
       Common/dEdxMain01/Ex01(MAXC1,1501), dEdx01(MAXC1,1501),
     # Rp01(MAXC1,1501), dEdxN01(MAXC1,1501),NdE01(MAXC1)
*
       Common/Lindhard01/Energy01(MAXC1,MAXC,1701),  
     # dSdX01(MAXC1,MAXC,1701), dEdX_Nuc01(MAXC1,MAXC,1701), 
     # dEdX_Nuc_0Ed01(MAXC1,MAXC,1701), 
     # dEdX_Nuc_Ed_Tmax01(MAXC1,MAXC,1701),  
     # CST01(MAXC1,MAXC,1701), NSL01(MAXC1,MAXC)
*
* corresponds to /dEdxMain01/
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
* corresponds to /Lindhard01/
       Common/STARS1/ dSdX1(MAXC1,MAXC,10002), 
     # dEdXNuc1(MAXC1,MAXC,10002), 
     # dEdXNuc0Ed1(MAXC1,MAXC,10002), dEdXNucEdTm1(MAXC1,MAXC,10002), 
     # CST1(MAXC1,MAXC,10002), NMAX
*
       Common/istop/istop
       Dimension TMP1(1701),TMP2(1701),TMP3(1701),TMP4(1701),
     #           TMP5(1701),TMP6(1701)
*
* =1 test printing, 0 no  
       itestxs=0 
*
       If(itestxs.ne.0) open(21,file='test.xs')
       If(itestxs.ne.0) Write(21,1000)
1000   Format('   I       E        dSdX      dEdX_Nuc',
     # '    dEdX_Nuc     dEdX_Nuc      CST'/
     # '                               (tot)      [0-Ed]',
     # '       [Ed-Tmax]    (barn)'/77('-'))
*
*
      NK1=NK+1
*
*
* General arrays preparation
*****************************
*
*
                               if(istop.ne.-1) goto 3001
* Ziegler data
* ============
*
      Do 2000 IK=1,NK1   
*     -------------
* IK - id of the moving ion
*
        NdE01tmp=NdE01(IK)
        Do II=1, NdE01tmp
        TMP1(II)=Ex01(IK,II)
        TMP2(II)=dEdx01(IK,II)
        TMP3(II)=dEdxN01(IK,II)
        TMP4(II)=Rp01(IK,II)
        Enddo
*
        Emaxtmp=Amin1(5000.,TMP1( NdE01tmp) )
        Do I=1,999999999
*
* J=(lg(E)+6)*1000+1  means that energy can changes from 10**-6 MeV
* If 10002 array dimension will be increased change also 1000 below
* and in other subroutines (i.e. MODEL, DEDX_SPAR)
        RLG=Float(I-1)/1000. -6.
        E=10.**RLG
* E > 5000 MeV is not considered
        If(E.gt.Emaxtmp) goto 2000
! Attention. NMAX is the same for all material components, it is
* supposed that SL_LNS code which is executed before IOTA code 
* was stopped at the same energy for all components
        NMAX=I
        If(NMAX.gt.10002) Call Error('NMAX',10002)
        Call ARRAYINT(0,TMP1,TMP2, NdE01tmp,E,2, RES1)
        Call ARRAYINT(0,TMP1,TMP3, NdE01tmp,E,2, RES2)
        Call ARRAYINT(0,TMP1,TMP4, NdE01tmp,E,2, RES3)
          dEdx(IK,NMAX)  =RES1
          dEdxN1(IK,NMAX)=RES2
          Rp1(IK,NMAX)   =RES3
        Enddo    !  Do I1=1,999999999
 2000   Continue !  Do IK=1,NK1
*
*
*
* Cross-sections obtained by Lindhard approach
* ============================================
*
 3001                          continue
*
      Do 3 IK=1,NK1   
*     -------------
*
* IK - id of the moving ion
* MK - id of the material component
*
      Do 2 MK=1,NK
*     ------------
*
      If(itestxs.ne.0) Write(21,11) IK,MK
11    Format('Interaction (ion id)  ',i2,' +',i3)
*
        NSL01tmp=NSL01(IK,MK)
        Do II=1, NSL01tmp
        TMP1(II)=Energy01(IK,MK,II)
        TMP2(II)=dSdX01(IK,MK,II)
        TMP3(II)=dEdX_Nuc01(IK,MK,II)
        TMP4(II)=dEdX_Nuc_0Ed01(IK,MK,II)
        TMP5(II)=dEdX_Nuc_Ed_Tmax01(IK,MK,II)
        TMP6(II)=CST01(IK,MK,II)
        Enddo
*
      Emaxtmp=Amin1(5000.,TMP1( NSL01tmp) )
      Do I=1,999999999
*
* J=(lg(E)+6)*1000+1  means that energy can changes from 10**-6 MeV
* If 10002 array dimension will be increased change also 1000 below
* and in other subroutines ( MODEL, DEDX_SPAR, ...)
        RLG=Float(I-1)/1000. -6.
        E=10.**RLG
* E > 5000 MeV is not considered
        If(E.gt.Emaxtmp) goto 2
        NMAX=I
        If(NMAX.gt.10002) Call Error('NMAX',10002)
*
*        
        Call ARRAYINT(0,TMP1,TMP2, NSL01tmp,E,2, RES1)
        Call ARRAYINT(0,TMP1,TMP3, NSL01tmp,E,2, RES2)
        Call ARRAYINT(0,TMP1,TMP4, NSL01tmp,E,2, RES3)
        Call ARRAYINT(0,TMP1,TMP5, NSL01tmp,E,2, RES4)
        Call ARRAYINT(0,TMP1,TMP6, NSL01tmp,E,2, RES5)
       If(itestxs.ne.0) Write(21,1)I,E,RES1,RES2,RES3,RES4,RES5
1      Format(i5,g12.5,5g12.5)
          dSdX1(IK,MK,NMAX)        =RES1  
          dEdXNuc1(IK,MK,NMAX)     =RES2
          dEdXNuc0Ed1(IK,MK,NMAX)  =RES3
          dEdXNucEdTm1(IK,MK,NMAX) =RES4
* barn ---> cm2
          CST1(IK,MK,NMAX)         =RES5*1.e-24
       EndDo
*
*
   2   Continue
   3   Continue
*
        If(itestxs.ne.0) close(21)
        Return
        End
*
************************************************************************
*
        Subroutine INDICATOR(IK,T,IDE)
*       ------------------------------
        Common/EKIN1/EKIN(405),HEK,MEK ! MEK can be less than 405
*
        If(IK.ne.1) goto 2000
        Do I=1,405
        IDE=I
        If(T.le.EKIN(i)) Return
        Enddo
*
        Print *,'SUBR. INDICATOR   T SEEMS STRANGE =',T
        Call ERROR('IDE ',00000)
* to check IDE for non primary particle
2000    If(IDE.gt.0.and.IDE.le.405)   Return
* IDE <= 0 or > 405
*
        Print *,'SUBR. INDICATOR:   E R R O R !   IDE =',IDE
        Call ERROR('IDE ',00000)
        End
*
************************************************************************
*
       Subroutine Initialize_and_Zeroize(T00)
*      --------------------------------------
       parameter (maxc1=22)
       Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
*
       Common/urand1/iyg
       Common/SUN/Vel1L(405),Tmean1,Vel2Tm(405),Vel3Pl(405),
     #            R1,R1p,Tplay1,Vel4(405),Nel(405)
       Common/Interr/Interr1
       Common/MOON/XX(105),DD(105),DDF(105),TK(105),HST
       COMMON/RECSTORE/TKIN(50003),ZZ(50003),NKO(50003),INDIC(50003),
     #                 NREC
       COMMON/MEMORY/NFRENKEL(405)
       Common/CUT1/rmaxpl,itot,icut
       Common/EKIN1/EKIN(405),HEK,MEK ! MEK can be less than 405
       Common/SUN2/ZV5,Vel5,NN(405)
       Common/SUNDI/DIVel1(405),DIFRENKEL(405),DIVel5
               iyg=1
       T0=T00
*
*
*                                             Ziegler Range
       JE=Ifix((alog10(T0)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
*
* Ziegler Range for projectile
       RZ=Rp1(1,JE)
*
       RFULL=(1.+0.333333*A2/A1)*RZ     !  For effective A2
*   
       HST=RFULL/20.
       XXX=-HST
*
       Do i=1,105
       XXX=XXX+HST
       XX(i)=XXX
       DD(i)=0.0
       DDF(i)=0.0
       TK(i)=0.0
       enddo
*
*   
         MEK=200       ! should be less than 405 
         HEK=T0/FLOAT(MEK)
         EEE=-HEK+0.5*HEK
*
         Do i=1,405
         EEE=EEE+HEK
         EKIN(i)=EEE
         enddo
*
* indent for Z where the primary energy lost = 5 %
         ZV5= 0.05*T0/dEdx(1,JE)
         Vel5=0.0 
         DIVel5=0.0 
*
* Zeroize 
* -------
*
        Do i=1,405
        Nel(i)   =0
        NN(i)    =0
        Vel1L(i) =0.
        DIVel1(i)=0.
        Vel2Tm(i)=0.
        Vel3Pl(i)=0.
        Vel4(i)  =0.
        Enddo
*
        Tmean1=0.
        R1=0.
        R1p=0.
        Tplay1=0.0
*
        Interr1=0
        Icut=0
        Itot=0
*
        Do i=1,50003
        Tkin(i)=0.0
        ZZ(i)=0.0
        NKO(i)=0
        enddo 
        NREC=0
*
        Do i=1,405
        NFRENKEL(i)=0
        DIFRENKEL(i)=0.0
        Enddo
c
        Return
        End
*
************************************************************************
*
           Subroutine INTERMEDIATE(X1,X2,Y1,Y2,WL,INTS,RESINT)
*          ---------------------------------------------------
           If(INTS.eq.1) goto 1
           If(INTS.eq.2) goto 2
           If(INTS.eq.3) goto 3
           If(INTS.eq.4) goto 4
           If(INTS.eq.5) goto 5
           Print *,
     #     'This interpolation scheme ',INTS,' is not supported'
           Print *,'                        press any key...'
           pause
           Stop
* Histogr
1          RESINT =  Y1  
           Return
* Lin-lin
2          Call REGR1(X1,X2,Y1,Y2,AAA,BBB)  
           RESINT =  AAA * WL + BBB 
           Return
* Lin(lg)-lin
3          aX1=alog10(x1) 
           aX2=alog10(x2) 
           aY1=y1 
           aY2=y2 
           aWL=alog10(wl)
           Call REGR1(aX1,aX2,aY1,aY2,AAA,BBB)  
           RESINT =  AAA * aWL + BBB  
           Return
* Lin-lin(lg)
4          aX1=x1 
           aX2=x2 
           aY1=alog10(y1)
           aY2=alog10(y2) 
           aWL=wl
           Call REGR1(aX1,aX2,aY1,aY2,AAA,BBB)  
           RESINT = 10.**( AAA * aWL + BBB ) 
           Return
* Lin(lg)-lin(lg)
5          aX1=alog10(x1) 
           aX2=alog10(x2) 
           aY1=alog10(y1) 
           aY2=alog10(y2) 
           aWL=alog10(wl)
           Call REGR1(aX1,aX2,aY1,aY2,AAA,BBB)  
           RESINT = 10.**(   AAA * aWL + BBB  )
           Return
           End
C
C***********************************************************************
C
          Subroutine REGR1(x1,x2,y1,y2,a,b)                             
          Rr=x2-x1                                                      
          A=(y2-y1)/rr                                                  
          B=(y1*x2-x1*y2)/rr                                            
          Return                                                        
          End
*
************************************************************************
*
       Subroutine LINDINT(T00)
*      -----------------------
*
       parameter (maxc=21,maxc1=22)
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
*
       Common/STARS1/ dSdX1(MAXC1,MAXC,10002), 
     # dEdXNuc1(MAXC1,MAXC,10002),  dEdXNuc0Ed1(MAXC1,MAXC,10002), 
     # dEdXNucEdTm1(MAXC1,MAXC,10002), CST1(MAXC1,MAXC,10002), NMAX
       Common/Edmin/Edmin ! It is not minimal displacement energy
       Common/BASIC/Z1,A1,Z2,A2,AW,RO,RN0  
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       Common/SUN/Vel1L(405),Tmean1,Vel2Tm(405),Vel3Pl(405),
     #            R1,R1p,Tplay1,Vel4(405),Nel(405)
*
       T=T00
       X=0.0
*
       IK=1  ! primary particle
*
*
*                                             Ziegler Range
       JE=Ifix((alog10(T)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
*
* Ziegler Range for projectile
       RZ=Rp1(1,JE)
*
       RFULL=(1.+0.333333*A2/A1)*RZ     !  For effective A2
*
        DO 1000 ILIL=1,11111111
* Get "energy indicator number" for current T 
*   IDE corresponds only to the energy of primary particle (IK=1)
       Call INDICATOR(IK,T,IDE)
* general array index        
       JE=Ifix((alog10(T)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
*
c Define STEP for x(STEP) and dT (DT)
c (energy step is 0.01 from current energy of particles)
         STOPPING=dEdx(IK,JE)
         DT=0.01*T
         STEP=DT/STOPPING
*
         dSdx=0.0
         Do MK=1,NK
         dSdx=dSdx+dSdx1(IK,MK,JE)*FR(MK)
         Enddo
*
         Vel4(IDE)=Vel4(IDE)+dSdx*STEP
cc         Write(551,*)'T,STEP,VEL4,DT=',T,STEP,VEL4,DT
         T=T-DT
*
* stop option
         If(T.lt.EDmin) goto 2000
         X=X+STEP
***      if(X.gt.RFULL)  goto 2000
*                  
*
1000     Continue
                                                call error('str ',1000)
2000     Continue
*
         Return
         End 
*
************************************************************************
*
        Subroutine MDPARAM(IZ0,NOTE)
*       --------------------------------------------
        Character NOTE*50
        Common/MERCURY/CMD(5),Ecrit,MD
*
* Here are default parameters for efficiency obtained from MD 
* calculations
*
* General formula for efficiency :  eff=C(1)*eMD**C(2) + C(3)*eMD
*
*  introduce
*            a) C(1)-C(3)
*            b) C(4):   eMD(keV) the lowest energy where effic=const
*            c) C(5):   eMD(keV) the highest energy where effic=const
*            d) Ecrit (keV):   eMD < Ecrit: MD;  eMD > Ecrit: BCA
*
* Note. eMD is not the incident ion energy, it is equal 
*       approximately to the damage energy in the NRT formula
*
* Identification only for Z
*
        If(IZ0.eq.26) goto 26
        If(IZ0.eq.29) goto 29
        If(IZ0.eq.74) goto 74
        goto 99999
c
c Iron          
c ----
c
  26    NOTE='from Stoller '
        CMD(1) = 0.5608
        CMD(2) =-0.3029
        CMD(3) = 3.227e-03
        CMD(4) = 0.0
        CMD(5) = 40.0
        Ecrit  = 40.0
        return
c
c Copper
c ------
c
  29    NOTE='from Caturla et al '
        CMD(1) = 0.7066
        CMD(2) =-0.437
        CMD(3) = 2.28E-03 
        CMD(4) = 0.451
        CMD(5) = 20.00
        Ecrit  = 20.00
        return
c
c Tungsten
c --------
c
  74    NOTE='from Caturla et al '
        CMD(1) = 1.0184
        CMD(2) =-0.667
        CMD(3) = 5.06E-03
        CMD(4) = 1.0
        CMD(5) = 31.02
        Ecrit  = 31.02
        return
*
*
*
99999   Print 1,IZ0
        Write(33,1)IZ0
    1   Format(/' Default parameters for calculation of efficiency',
     #  ' of defect production '/'           according to MD',
     #  ' are ABSENT for Z=',i3,'  !!!'/20x,'Check Subr. MDPARAM !'/)
        Print *,'Chiao !'
        Print *,'                      press any key...'
        pause
        stop
        end
*
************************************************************************
*
       Subroutine MODEL(IK,T00,Z00,IDE)
*      --------------------------------
*
* IK  = 1 primary ion, 2,3,... =material component
* Example:
* dEdx(1,10002) is the full stopping power for the INITIAL particle +
*               composite material
* dEdx(2,10002) is the full stopping power for the FIRST component
*               of the material with the composite material  etc.
* dSdX1(1,1,10002) is the stopping power "considering defect production"
*               for the interaction of the INITIAL particle with 
*               the energy transfer to FIRST material component (this
*               PKA is moving in the media with the effective Z,A (see
*               separate code SL_LNSXX, XX=ver))
* dSdX1(1,2,10002) is for the INITIAL particle and energy
*               transfer to the SECOND material component
* dSdX1(2,1,10002) is for the FIRST material component and energy
*               transfer to the same FIRST material component
* dSdX1(2,2,10002) is for the FIRST material component and energy
*               transfer to the SECOND material component
* etc.
* NK            is the number of material components (max 7)
*  
*
       parameter (maxc=21,maxc1=22)
       Common/BASIC/Z1,A1,Z2,A2,AW,RO,RN0  
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       Common/Edmin/Edmin ! Edmin is not minimal displacement energy
       Common/STARS1/ dSdX1(MAXC1,MAXC,10002), 
     # dEdXNuc1(MAXC1,MAXC,10002), dEdXNuc0Ed1(MAXC1,MAXC,10002),
     # dEdXNucEdTm1(MAXC1,MAXC,10002), CST1(MAXC1,MAXC,10002), NMAX
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
       Common/Interr/Interr1
       Common/SUN/Vel1L(405),Tmean1,Vel2Tm(405),Vel3Pl(405),
     #            R1,R1p,Tplay1,Vel4(405),Nel(405)
       Common/MOON/XX(105),DD(105),DDF(105),TK(105),HST
       Common/MEMORY/NFRENKEL(405)
       Common/SUN2/ZV5,Vel5,NN(405)
       Common/SATURN/TcritLAB(MAXC1)
       Dimension CSS(MAXC)
* 
       T=T00
       X=0.0  ! along the trajectory
       Z=0.0  ! along the z-axis
       ZD=Z00
       Tcrit=TcritLAB(ik)
* general array index        
       JE=Ifix((alog10(T)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
*
*
*
         TplH1=0.0   ! Tplay for single history
*
  1      Continue      ! General loop
* Get "energy indicator number" for current T 
*   IDE corresponds only to the energy of primary particle 
*   and is not changed for any other generations
       Call INDICATOR(IK,T,IDE)
*
       If(IK.eq.1) NN(ide)=NN(ide)+1
*
*
* Estimation "elastic proton path" 
* general array index        
       JE=Ifix((alog10(T)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
* define total cross-section
       CSS(1)=FR(1)*CST1(IK,1,JE)
       If(NK.eq.1) goto 2
       DO MK=2,NK
       CSS(MK)=CSS(MK-1)+FR(MK)*CST1(IK,MK,JE)
       Enddo
 2     CSelT=CSS(NK)
                   If(CSelT.le.0.0) goto 2000
*
       dLel=1./(CSelT*RN0)  ! xsect in cm2
*
*
* STEP definition :
*
* Alternative  counting   DT0=dEdx(IK,JE)*STEP
! DT1 = only electronic component
       DT1=(   dEdx(IK,JE)-dEdxN1(IK,JE)  )
! DT2 = nucl stopp power for Tk < Ed
             dEdXNuc0Ed=0.0
             Do MK=1,NK 
             dEdXNuc0Ed=dEdXNuc0Ed+dEdXNuc0Ed1(IK,MK,JE)*FR(MK)
             Enddo 
       DT2=dEdXNuc0Ed
*
       DT3=DT1+DT2
* Free path/10.
       ST1=dLel/10.
                                                      ST2=1.e+20
* Change of T = 0.05 due to el.loss and nucl.loss < Ed
       If(DT3.gt.0.0) ST2=0.05*T/DT3
       STEP=AMIN1(ST1,ST2)
*
*
* Play if ELASTIC interaction occurs (for the transferring of the
* energy > Ed)
c
        PREL=STEP/dLel
        PR0=RANDOM(0)
        IEL=0 
        COST=1.0
*
        if(PR0.le.PREL)               then
*"Elastic" interaction occurs !
        IEL=1
*
* Define (play) the type of the component of the composite material
        PR00=RANDOM(0)
            If(NK.eq.1) then
            LK=1
            goto 3
            endif
        DO MK=1,NK 
        LK=MK
        If(PR00 .le. CSS(MK)/CSelt) goto 3
        ENDDO 
        print *,' It is not corr play:',CSS
  3     Continue
*
             Tmean=dEdXNucEdTm1(IK,LK,JE)/(CSelT*RN0)
        If(IK.eq.1 ) then 
             Nel(IDE)=Nel(IDE)+1
             DISPLL=dSdx1(IK,LK,JE)/(CSelT*RN0)
             Vel1L(IDE)=Vel1L(IDE)+DISPLL
ccc             Tmean=dEdXNucEdTm1(IK,LK,JE)/(CSelT*RN0)
             Tmean1=Tmean+Tmean1
             Vel2Tm(IDE)=Vel2Tm(IDE)+CF(LK+1,LK,Tmean)   ! LK
                      endif
* play T of PKA basing on dS/dT above Ed
ccccc                        TPVA=  0.0
ccccc        If(ED(LK).lt.T) TPVA=  TPKA(IK,LK,T,Tmean)                
        TPVA=  TPKA(IK,LK,T,Tmean)                
*
        if(IK.eq.1)  then
* define cos of the scattering
        CALL COS_DEFINE(IK,LK,T,TPVA,COST)
           Tplay1=Tplay1+TPVA
           Vel3Pl(IDE)=Vel3Pl(IDE)+CF(LK+1,LK,TPVA)     ! LK
                      endif
* 
        If(T.le.Tcrit) goto 7000    !   MD
*
*
        T=T-TPVA
*
        TplH1=TplH1+TPVA   ! Tplay for single history
*
*
        If(TPVA.gt.Tcrit) then
        CALL STORE_IN(LK,TPVA,ZD,IDE)
* number of Frenkel pairs
        NFRENKEL(IDE)=NFRENKEL(IDE)+1      
                          else  ! do not remember this particle
* MD
                          Frcut=0.0  
        If(TPVA.gt.0.0)   FRcut=CF2(LK+1,LK,TPVA) +0.5
        NFRENKEL(IDE)=NFRENKEL(IDE)+Ifix(FRcut)
                          endif
*
        If(T.le.Tcrit) goto 7000    !   MD
*
*
        If(ZD.le.ZV5) Vel5=Vel5+1.
*
        Do IR=1,105
        If(ZD.le.XX(IR)) then
        DDF(IR)=DDF(IR)+ 1.  ! Direct summing
        goto 499
        endif
        enddo
*
*
499     If(IK.ne.1) goto 510
        Do IR=1,105
        If(Z.le.XX(IR)) then
        DD(IR)=DD(IR)+ DISPLL  ! Lindhard component is summing
        goto 500
        endif
        enddo
                                      endif !  if(PR0.le.PREL)
 500    continue
*End ---elastic
*
        Do IR=1,105
        If(Z.le.XX(IR)) then
        TK(IR)=TK(IR)+ T*STEP
        goto 510
        endif
        enddo
*
510     continue
ccc        Write(777,*)(DT1+DT2)*STEP/T
*
        If(T.le.Tcrit) goto 7000    !   MD
*
*
        T=T-DT3*STEP
*
*
        If(T.le.Tcrit) goto 7000    !   MD
*
* stop option
*
cccccc      If(TplH1.gt.T00) then
cccccc      Interr1=Interr1+1
cccccc      goto 2000
cccccc      endif
*
* usual end of history
         If(T.lt.EDmin) goto 2000
         X=X+STEP
                      DZ=STEP
         If(IEL.ne.0) DZ=STEP*COST
         Z=Z+DZ
         ZD=ZD+DZ
*                  
*
*
         Goto 1
*
*
*
2000     If(IK.eq.1) then 
         R1=R1+X    
         R1p=R1p+Z  
                     endif
         Return
*
*
*
* Interrupt history taking MD results for the rest energy
7000    continue
*noalloy, because
        LK=1
                       Frcut=0.0  
cccc    If(T.gt.0.0)   FRcut=CF2(LK+1,LK,T) +0.5
        If(T.gt.0.0)   FRcut=CF2(IK,LK,T) +0.5
        NFRENKEL(IDE)= NFRENKEL(IDE)+Ifix(FRcut)
        goto 2000 
c
c
        End 
*
************************************************************************
*
          Subroutine NRT_COEFF(Z1,Z2,A1,A2,ANRT,BNRT,GNRT)
*         -----------------------------------------------
          PI=3.1415926
          A0=0.52918E-08    ! Bohr radius, cm
          EL=4.8E-10        ! electron charge
C Classical NRT, Nucl.Eng.Des., 1975 :
C         RK0=0.1337*(Z1**(1./6.))*SQRT(Z1/A1)                            
C Robinson
          RK0=0.0793*(Z1**0.6666666)*SQRT(Z2)*((A1+A2)**1.5)/         (
     #    (A1**1.5)*SQRT(A2)*((Z1**0.666666666+Z2**0.66666666)**0.75) )
C
          AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )/
     #          SQRT(Z1**0.6666666+Z2**0.6666666)
          E0=Z1*Z2*(EL**2)*(A1+A2)/(AA*A2)
            E0=E0/1.6E-06    !  erg ---> MeV
            E0=1000.*E0      !      ---> keV
            EE=1./E0
C
         ANRT=RK0*EE         
         BNRT=0.40244*RK0*(EE**0.75)                                          
         GNRT=3.4008*RK0*(EE**0.1666666666)                                   
         RETURN
         END
*
************************************************************************
*
        Subroutine PRECALCULATION
*       -------------------------
        parameter (maxc=21,maxc1=22,maxe=50001)
        Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12
        Character CTASK_NAME*80, C50*50
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/PKA/ALPHA2(MAXC1,MAXC),E0(MAXC1,MAXC)
        COMMON/NRT1/ANRT(MAXC1),BNRT(MAXC1),GNRT(MAXC1)
        Common/Edmin/Edmin 
        Common/PARAM01/IDSDT
        Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     #  OUTNAM
        Common/MERCURY/CMD(5),Ecrit,MD
        Common/DATATAB1/WTAB(101),ROTAB(101),RITAB(101),IATAB(101)
        Common/ISTOP/ISTOP
        Common/VENUS/RI(MAXC)
        Common/EARTH/IDEFMD,CTASK_NAME,C50
        Common/AUX1/rlambdaft12,rmft12,qft12
        Common/SATURN/TcritLAB(MAXC1)
        Common/EIN/EIN(MAXE),NH(MAXE),KEIN
        Dimension TmpEn(MAXE)
*
                            AVO=6.022E+23     ! Avogadro
        IZ1=ifix(Z1+0.001)
*
* Get masses, density and <I> 
        Call DATATAB
* 
* Get projectile A, if absent
        If(A1.le.0.0) then 
                      A1=WTAB(IZ1)
                      endif
                      If(A1.le.0.0) Call Error(' A1 ',000)
                      IA1=ifix(A1+0.001) 
* 
* Get A for material components, if absent
        do i=1,nk
        If(AT(i).le.0.0) then 
                      IZT=ifix(ZT(i)+0.001)              
                      AT(i)=WTAB(IZT)
                      endif
                      If(AT(i).le.0.0) Call Error(' AT ',i)
        enddo
*
* Density
        if(RO.le.0.0) then
                      IZT=ifix(ZT(NK)+0.001)  ! check for NK=1 in sub read_inp
                      RO=ROTAB(IZT) 
                      endif
                      If(RO.le.0.0) Call Error(' RO ',NK)
* 
* Mean ionization potential for SPAR calculation, if chosen
        if(istop.eq.1) then
        do i=1,nk
        IZT=ifix(ZT(i)+0.001)              
        RI(i)=RITAB(IZT)*1.E-6  ! eV --> MeV (SPAR)
        If(RI(i).le.0.0) Call Error(' RI ',i)
        enddo
                       endif
*
*
* Normalize fractions on unity
           sum=0.0
           do i=1,nk
           sum=sum+FR(i)
           enddo
           Do i=1,nk
           FR(I)=FR(I)/SUM
           Enddo
*
* Get effective Z and A
           Z2=0.0
           A2=0.0
        Do i=1,nk
        Z2=Z2+FR(I)*ZT(I)
        A2=A2+FR(I)*AT(I)
        Enddo
           AW=A2
*
* Atoms (molecules)
        RN0=AVO*RO/AW     ! at/cm3
        DA=(1./RN0)**0.33333333  ! ave dist betw at (not used)
*
* Min ED for the composite material
* ! Edmin is not minimal displacement energy
        Edmin=1.E+10
        do i=1,nk
        If(ED(i).lt.Edmin) Edmin=ED(i)
        enddo
*
* omit input energies < Edmin
        ke=0        
        Do i=1,KEIN
        If(EIN(i).ge.Edmin) then
        ke=ke+1
        TmpEn(ke)=EIN(i)
                            endif
        Enddo
        Do i=1,ke
        EIN(i)=TmpEn(i)
        Enddo
        KEIN=KE
*
        NK1=NK+1
* 
* NRT coefficients for effective material Z,A
        Do IK=1,NK1
         If(IK.eq.1) then
                     Z111=Z1
                     A111=A1
                     endif
         If(IK.ne.1) then
                     Z111=ZT(IK-1)
                     A111=AT(IK-1)
                     endif
        Call NRT_COEFF(Z111,Z2,A111,A2,ATRN,BTRN,GTRN)
        ANRT(IK)=ATRN
        BNRT(IK)=BTRN
        GNRT(IK)=GTRN
        Enddo
*
* For joint BCA-MD calculations define "critical" energy for each ion
       If(MD.eq.1) Call CRITICAL_ENERGY
*
*
* Data for Lindhard F(x) function
* -------------------------------
          PI=3.1415926
          EL=4.8E-10        ! electron charge
          A0=0.52918E-08    ! cm
*
* IK =1, 2...  1 = projectile, other material component
* MK =1, 2...    = material component
*
*
         DO IK=1,NK1
         If(IK.eq.1) then
                     Z111=Z1
                     A111=A1
                     endif
         If(IK.ne.1) then
                     Z111=ZT(IK-1)
                     A111=AT(IK-1)
                     endif
         DO MK=1,NK
         Z222=ZT(MK) 
         A222=AT(MK) 
c
* LNS:
          AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )
     #         /SQRT(Z111**0.6666666+Z222**0.6666666)
* Firsov
          If(IDSDT.ne.0) 
     #    AA=A0*(  (9.*Pi*Pi/128.)**0.333333333  )
     #         /(   ( SQRT(Z111)+SQRT(Z222) )**0.666666666   )
*
*
          E0(IK,MK)=Z111*Z222*(EL**2)*(A111+A222)/(AA*A222)
            E0(IK,MK)=E0(IK,MK)/1.6E-06    !  erg ---> MeV
          ALPHA2(IK,MK)=4.*A111*A222/((A111+A222)**2)
          PIA2=Pi*(AA**2)            
          ENDDO 
          ENDDO 
*
*********************************************************************
* open main output file and write basic information 
*
        open(33,file=OUTNAM)
        Write(33,*)' I O T A   C O D E'
        Write(33,'(a80)')CTASK_NAME
        Write(33,*)' '
*
        Write(33,1000)IZ1,A1
 1000   Format(1x,'Primary particle (Z,A)',i3,f8.2) 
        Write(33,1001)
 1001   Format(' Material      at %    Ed (eV)')
        Do IK=1,NK
        IZ=Ifix(ZT(IK)+0.0001)
        FR0=FR(IK)*100.
        Write(33,1002)IZ,AT(ik),FR0,ED(IK)*1.e+06
 1002   Format(i3,f8.2,f9.2,f9.1)
        Enddo
        If(IDSDT.eq.0) Write(33,1003)rlambdaft12,rmft12,qft12
 1003   Format(' F(t1/2) function: LNS   L=',f6.3,
     #  '  m=',f6.3,'  q=',f6.3)
        If(IDSDT.ne.0) Write(33,1004)
 1004   Format(' F(t1/2) function: Burenkov et al')
*
             If(MD.eq.1)      then
             Write(33,701)
701          Format(/t27,'Joint BCA-MD simulation')
             If(IDEFMD.eq.1) Write(33,7011)C50
7011         Format(' default parameters   ',a50)
*
        if(ifix(ZT(1)+0.001).eq.IZ1.and.ifix(AT(1)+0.001).eq.IA1) then
        Write(33,702)TcritLAB(1)*1000.
702     Format(' MD below Tcrit =',f6.2,' keV')
                                                                  else
        if(TcritLAB(1)*1000..lt.1.e+3) then
        Write(33,7021)TcritLAB(1)*1000.,TcritLAB(2)*1000.
                                       else
        Write(33,7022)TcritLAB(1)*1000.,TcritLAB(2)*1000.
                                       endif
7021    Format(' MD below Tcrit =',f6.2,' keV (projectile); =',f6.2,
     #  ' keV (ion of target)')
7022    Format(' MD below Tcrit =',g12.5,' keV (projectile); =',f6.2,
     #  ' keV (ion of target)')
        If(TcritLAB(1).ge.100.) Write(33,7023)TcritLAB(1)
7023    Format(70('*')/'*         Energy Tcrit =',g12.5,' keV',
     #  ' is not realistic',T70,'*'/70('*'))
                                                                  endif
*
             Write(33,703)(CMD(i),i=1,3)
703          Format(' efficiency(MD)=',f7.4,'*( eMD**(',f8.4,') ) +',
     #       1pe10.3,'*eMD')
             Write(33,704)CMD(4),CMD(5)
704          Format(' constant effciency below',f7.3,' keV and above',
     #       f7.2,' keV'/)
                              endif
        If(istop.eq.-1) Write(33,*)' Stopping power: Ziegler, SRIM'
        If(istop.eq. 1) Write(33,*)' Stopping power: Armstrong, SPAR'
*
*
          Write(33,1005)RO,RN0
 1005     Format(' Density =',f8.4,' g/cm3    n0=',1pe12.5,' 1/cm3')
          Write(33,1006)Z2,A2
 1006     Format(' Z(eff) =',f6.2,'    A(eff)=',f7.2)
          Write(33,1007)
 1007     Format(' Note. Nuclear nonelastic interactions ',
     #    'are not considered here')
*
          Return
          End 
*
************************************************************************
*
       Subroutine PRINT(T0,Nhist)
*      --------------------------
       parameter (maxc=21,maxc1=22)
       Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12
       Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     # OUTNAM
*
       Common/BASIC/Z1,A1,Z2,A2,AW,RO,RN0  
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       Common/SKY1/dEdx(MAXC1,10002),dEdxN1(MAXC1,10002),
     # Rp1(MAXC1,10002)
       Common/SUN/Vel1L(405),Tmean1,Vel2Tm(405),Vel3Pl(405),
     #            R1,R1p,Tplay1,Vel4(405),Nel(405)
       Common/STARS1/ dSdX1(MAXC1,MAXC,10002), 
     # dEdXNuc1(MAXC1,MAXC,10002), dEdXNuc0Ed1(MAXC1,MAXC,10002),
     # dEdXNucEdTm1(MAXC1,MAXC,10002), CST1(MAXC1,MAXC,10002), NMAX
       Common/Interr/Interr1
       Common/MOON/XX(105),DD(105),DDF(105),TK(105),HST
       COMMON/MAIIPR/IPR1                                                
       COMMON/MEMORY/NFRENKEL(405)
       Common/CUT1/rmaxpl,itot,icut
       Common/OPTIONS1/igraph,maxplay
       Common/EKIN1/EKIN(405),HEK,MEK ! MEK can be less than 405
       Common/SUN2/ZV5,Vel5,NN(405)
       Common/SUNDI/DIVel1(405),DIFRENKEL(405),DIVel5
       Common/MERCURY/CMD(5),Ecrit,MD
       Common/ISTOP/ISTOP
       Dimension EKIN2(405)
*
* Output file is opened in Subr. Read_input
*
*
       JE=Ifix((alog10(T0)+6.)*1000.)+1
                   If(JE.le.0.or.JE.gt.10002) Call Error(' JE ',11111)
* SRIM or SPAR range for projectile
       RZ=Rp1(1,JE)
       if(istop.eq.-1) RFULL=(1.+0.333333*A2/A1)*RZ     !  for effective A2
       if(istop.eq. 1) RFULL=RZ                      
*
*
            RNel=0.0
            Do i=1,405
            RNel=RNel+Float(Nel(i))/Float(Nhist)
            Enddo
*
        Do i=1,405
        Vel1L(i) =Vel1L(i) /Float(Nhist) 
        Vel2Tm(i)=Vel2Tm(i)/Float(Nhist)
        Vel3Pl(i)=Vel3Pl(i)/Float(Nhist)
        Enddo
*
        Vel5=Vel5/Float(Nhist)
*
* Sum
              Vel1LS =0.0
              Vel2TmS=0.0
              Vel3PlS=0.0
              Vel4S  =0.0
        Do i=1,405
        Vel1LS =Vel1LS +Vel1L(i)
        Vel2TmS=Vel2TmS+Vel2Tm(i)
        Vel3PlS=Vel3PlS+Vel3Pl(i)
        Vel4S  =Vel4S  +Vel4(i)  
        Enddo
*
* delta = Root[ M(ksi**2) -M**2 ] /M
        DIS1= DIVel1(405)/Float(Nhist) -Vel1LS**2 
* additional dividing /N  (  see Barashenkov,Toneev (4.6)  )
        DIS1= DIS1/Float(Nhist)
        DEL11=SQRT(  DIS1  )
                          ERR1=100.
        If(Vel1LS.ne.0.0) ERR1=100.*DEL11/Vel1LS
*
        Tmean1=Tmean1/Float(Nhist)
        Tplay1=Tplay1/Float(Nhist)
        R1=R1/Float(Nhist)
        R1p=R1p/Float(Nhist)
ccccc   Vel4=Vel4/Float(Nhist)
*
        If(MD.eq.1) then
        Write(33,701)
701     Format(35(1H*),'BCA+MD',37(1H*))
                    else
        Write(33,1)
1       Format(78(1H*))
                    endif
        Write(33,2)T0, Nhist
2       Format(1x,'Primary energy ',1pg12.5,' MeV'/1x,
     #  ' Number of events ',i7) !1x,60('-'))
*
        CFNRT=0.0
        Do MK=1,NK
        CFNRT=CFNRT+CF(1,MK,T0)*FR(MK)
        Enddo         
*
        Write(33,*)'                             ',
     #  '                           error %      /NRT '
        Write(33,30)CFNRT,CFNRT/CFNRT
30      Format(1x,
     #  'Simple NRT-formula prediction               =',g12.5
     #  ,t69,f6.3,'  (1)')
*
        If(MD.eq.0) Write(33,3)Vel1LS,ERR1, Vel1LS/CFNRT
3       Format(1x,
     #'Number of vacancies (Lindhard, free path )  =',f8.2,
     # '  (',f6.2,')'
     #  ,t69,f6.3,'  (2)')
*
        Write(33,31)Vel4S,Vel4S/CFNRT
31      Format(1x,
     #'Number of vacancies (Lindhard, integration) =',f8.2
     #  ,t69,f6.3,'  (3)')
*
        FRENK1=0.0
        Do i=1,405
        FRENK1=FRENK1+float(NFRENKEL(i))/float(Nhist) 
        Enddo
*
* delta 
        DISF=  DIFRENKEL(405)/Float(Nhist) - FRENK1**2
        DISF=  DISF/Float(Nhist)
        DELF=SQRT(  DISF )
                          ERRF=100.
        If(FRENK1.ne.0.0) ERRF=100.*DELF/FRENK1
*
        Write(33,32)
32      Format(76('-'))
        Write(33,9)FRENK1,ERRF,FRENK1/CFNRT
9       Format(1x,
     #  'Number of Frenkel pairs (direct counting)   =',f8.2
     #  ,'  (',f6.2,')'
     #  ,t69,f6.3,'  (4)')
*
* unit=555
        If(MD.ne.0) Write(55,555)
     #  T0, FRENK1/CFNRT, (ERRF/100.)*FRENK1/CFNRT, FRENK1, 
     #                    (ERRF/100.)*FRENK1,       CFNRT
555     Format(1pg12.5,  0pf8.3, f8.3, f14.2, f9.2, f14.2)
*
*
        Write(33,32)
*
* "Modified" counting = direct count *0.8 ( "as in NRT" )
        If(MD.eq.0) Write(33,10)0.8*FRENK1, ERRF, 0.8*FRENK1/CFNRT
10      Format(1x,
     #  'Modified counting                           =',f8.2
     #  ,'  (',f6.2,')'
     #  ,t69,f6.3/)
*
        CFTRN=0.0
*
* NRT formula for pure material weighted with given fractions
        If(NK.eq.1) goto 1000 
* 
        CFTRN=0.0
        Do MK=1,NK
             Z222=ZT(MK)
             A222=AT(MK)
             ED2=ED(MK)
        Call NRT_COEFF(Z1,Z222,A1,A222,ATRN,BTRN,GTRN)
        CFTRN=CFTRN+FR(MK)*CF1(ED2,ATRN,BTRN,GTRN,T0)
        Enddo
        Write(33,11)CFTRN  
11      Format(1x,
     #  'NRT-formula for pure material components weighted =',f8.2
     #  ,T69,'      ','  (5)')
 1000   continue
*
        If(MD.eq.0) Write(33,4)Vel2TmS,Vel2TmS/CFNRT
4       Format(1x,
     #  'Number of vacancies from Tmean calc               =',f8.2
     #  ,t69,f6.3)
*
        If(MD.eq.0) Write(33,5)Vel3PLS,Vel3PLS/CFNRT
5       Format(1x,
     #  'Number of vacancies from Tplay calc               =',f8.2
     #  ,t69,f6.3)
*
* Get displacement cross-sections
* Lindhard, code SL_LNS :
        CSDL=0.0
        Do MK=1,NK
        CSDL=CSDL+FR(MK)*dSdx1(1,MK,JE)/RN0
        Enddo
        CSDL=CSDL*1.e+24
* Direct counting :
cc        CSelT=0.0
cc        DO MK=1,NK
cc        CSelT=CSelT+FR(MK)*CST1(1,MK,JE)
cc        Enddo
cc        Call INDICATOR(1,T0,IDE)
cc        if(IDE.eq.1) EKINCHECK=0.5*  EKIN(ide) 
cc        if(IDE.ge.1) EKINCHECK=0.5*( EKIN(ide)+ EKIN(ide-1) )
cc        CSDDIR1=CSelT*float(NFRENKEL(ide))/NN(ide) !float(Nhist)
cc        CSDDIR1=CSDDIR1*1.e+24
c
ccccc        CSDDIR3=CSelT*1.e+24*Vel1L(ide)*float(Nhist)/NN(ide)
cc
        CSDDIR=1.e+24*Vel5/(RN0*ZV5)
* 
* delta
        DISCS= DIVEL5/Float(Nhist) - Vel5**2
        DISCS= DISCS/Float(Nhist)
        DELCS=SQRT(  DISCS )
                                          ERRCS=100.
        If(CSDDIR.ne.0.0.and.Vel5.ne.0.0) ERRCS=100.*DELCS/Vel5
*
        If(NK.eq.1) Write(33,51)CSDL
  51    Format(/
     #  ' Displacement cross-section (Lindhard, integr)   (b) =',
     #  1pg12.5,
     #  T69,'      ','  (6)')
        If(NK.ne.1) then
        Write(33,52)CSDL
  52    Format(/
     #  ' Displacement cross-section (Lindhard, weighted) (b) =',
     #  1pg12.5,
     #  T69,'      ','  (6)')
        Write(33,53) (dSdx1(1,MK,JE)/(1.e-24*RN0),MK=1,NK)
  53    Format(' Components: ',1pg12.5,4g12.5)
                     endif
        If(MD.eq.0) Write(33,54)CSDDIR,ERRCS
  54    Format(
     #  ' Displacement cross-section (direct counting)    (b) =',
     #  1pg12.5,  ' (',  0pf6.2,   ') (7)' )
*
        If(MD.eq.0) Write(33,55)0.8*CSDDIR,ERRCS
  55    Format(
     #  '                            (modified count )    (b) =',
     #  1pg12.5,  ' (',  0pf6.2,   ')    '/)
ccc        Write(33,*)EKINCHECK
*
* unit=44
        If(MD.eq.0) then
        Write(44,111)T0,CFNRT,Vel1LS,Vel4S,FRENK1,CFTRN,CSDL,CSDDIR
 111    Format(1pg12.5,   0pf10.2,  4f10.2,1pg12.5,g12.5)
                    else
        Write(44,111)T0,CFNRT, 0.0  ,Vel4S,FRENK1,CFTRN,CSDL, 0.0    
                    endif
*         
*
*
        If(MD.eq.0) Write(33,6)Tmean1,Tplay1
6       Format(1x,'Tmean =',1pe12.5,' MeV     Tplay=',g12.5) 
*
        If(MD.eq.0) then  
        if(istop.eq.-1) Write(33,7)RZ,RFULL,R1
   7    Format(
     #' Path (Ziegler,evl)=',1pe10.3,' cm,  total=',e10.3,' cm'/
     #' Path (total,calc )                      =',e10.3,' cm')
        if(istop.eq.1) Write(33,8)RFULL,R1
   8    Format(' Total path (SPAR)=',1pe10.3,' cm',
     #'   path (total,calc)=',e10.3,' cm')
                    else
        if(istop.eq.-1) Write(33,17)RZ
  17    Format(' Path (Ziegler,evl)=',1pe10.3,' cm')
        if(istop.eq.1) Write(33,18)RFULL
  18    Format(' Total path (SPAR)=',1pe10.3,' cm')
                    endif
*
*
        Write(33,81)Interr1
81      Format(1x,' Histories interrupted (subr model)=', i12)
                      tpc=0.0
        if(itot.ne.0) tpc=100.*float(icut)/float(itot)
*
        If(maxplay.gt.1) then
        Write(33,82)tpc,maxplay
  82    Format(1x,' T play was cut (TPKA rout) =',f16.3,
     #  '  %    Maxplay=',i9)
                         endif
        If(maxplay.lt.0) then
        Write(33,821)tpc
 821    Format(1x,' T play was cut (TPKA rout) =',f16.3,
     #  '  %    no limitation on Maxplay')
                         endif
        If(tpc.gt.5.0.and.maxplay.gt.1) write(33,83)tpc
  83    Format(26('*'),' W A R N I N G ',30('*')/'*',
     #  f15.3,' is too much,  increase Maxplay in input',
     #  ' file         *'/26('*'),' W A R N I N G ',30('*'))
*
* GRAPHs preparation
* 
        Sum=0.0
        Sumf=0.0
        Sumt=0.0
        do i=1,105
*
        DD(i)=DD(i)/float(Nhist)
        DDF(i)=DDF(i)/float(Nhist)
c recalculation to the fluens 1/cm2
        DD(i)=DD(i)/(HST*RN0)
        DDF(i)=DDF(i)/(HST*RN0)
*
        TK(i)=TK(i)/(HST*float(Nhist))
        sum=sum+DD(i)
        sumf=sumf+DDF(i)
        sumt=sumt+TK(i)
        enddo
*
* check the maximal i-number, where DD .ne. 0
        do i=1,105
        j=105-i+1
        if(DD(j).ne.0.0) goto 100
        enddo
        j=105
 100    if(j.le.105-2) j=j+2
        jddmax=j
*
c
c For BCA-MD no damage profile
        If(MD.eq.1.and.igraph.ne.0) then
                                    Write(33,101)
 101    Format(/' (no damage profiles for joint BCA-MD calculations)')
                                    igraph=0
                                    endif
        If(igraph.eq.0) goto 2000
*
        IPR1=33
        DD(1)=0.0
        Write(33,12)
  12    Format(/
     #  ' Profile of damage from Lindhard dS/dx (free path )')
*
        Write(33,13)
  13    Format(
     # ' X=(cm)  Y=(dpa), result is normalized on primary ',
     # 'ion fluence 1/cm**2')
*
        Call GRAPH(XX,DD,jddmax,0)                                         
*
        Write(33,14)Sum,Sum*(HST*RN0)
  14    Format(
     # ' Sum(Y)=',1pe13.5,' dpa','    (unnormalized)= ',g12.5/)
*
        Write(33,15)
  15    Format(/
     #  ' Profile of damage from direct counting            ')
        Write(33,13)
*
        Call GRAPH(XX,DDF,jddmax,0)                                         
        Write(33,14)Sumf,Sumf*(HST*RN0)
*
*        
2000    continue
*
*
*
* Get cascade function for different primary energies 
*
* energy corresponds to the middle of interval
        Do i=2,405
        EKIN2(i)=0.5*( EKIN(i)+ EKIN(i-1) )
        Enddo
        EKIN2(1)=EKIN(1)/2. ! (see subr.Initialize_)
*
        MEK1=MEK+1
        If(MD.eq.0) then
        Write(33,16) 
  16    Format(' Number of vacancies at different',
     #' primary energies from current calculation'/
     #'                                   ',
     #'    [explanation (2),(3),(4) see above]'/75('-')/
     #'    Energy     dS/dx(free path)  ',
     #' dS/dx(integr)     Direct counting'/
     #'     (MeV)          (2)       ',
     #  '        (3)               (4)')
              Vel1LS2 =0.0
              Vel4S2  =0.0
              FRENK2  =0.0
        Do i=1,MEK1
              Vel1LS2 =Vel1LS2 +Vel1L(i)
              Vel4S2  =Vel4S2  +Vel4(i)
              FRENK2  =FRENK2  +float(NFRENKEL(i))/float(Nhist)
        Write(33,19) EKIN2(i),Vel1LS2, Vel4S2,FRENK2
  19    Format(1pg12.4,4x,     0pg12.5, 2(6x,g12.5))
        Enddo
                    endif ! If(MD.eq.0)
*
        Write(33,*)' '
        Write(33,*)' '
        Return
        End 
*
************************************************************************
*
       Function RANDOM(NO ARGUMENT)
*      --------------------------------
*
* random number generator
*
**** GNU Fortran pseudo random generator:
****
****
      RANDOM=RAND(0)
**
**
** WATCOM Fortram pseudo random number generator
** generator is initialized in Subroutine Initialize_and_Zeroize
** See   Common/urand1/iyg;    iyg=1
**
**      Common/urand1/iyg
**      RANDOM=URAND(iyg)
**
       Return
       End
*
************************************************************************
*
        Subroutine READ_DATA
*       --------------------
        parameter (maxc=21,maxc1=22)
        Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12
        Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     #  OUTNAM
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
*
        Common/dEdxMain01/Ex01(MAXC1,1501), dEdx01(MAXC1,1501),
     #  Rp01(MAXC1,1501), dEdxN01(MAXC1,1501),NdE01(MAXC1)
*
        Common/Lindhard01/Energy01(MAXC1,MAXC,1701), 
     #  dSdX01(MAXC1,MAXC,1701), 
     #  dEdX_Nuc01(MAXC1,MAXC,1701), dEdX_Nuc_0Ed01(MAXC1,MAXC,1701),
     #  dEdX_Nuc_Ed_Tmax01(MAXC1,MAXC,1701),
     #  CST01(MAXC1,MAXC,1701), NSL01(MAXC1,MAXC)
*
        Common/istop/istop
*
        Dimension Ex01tmp(1501), dEdx01tmp(1501),Rp01tmp(1501), 
     #  dEdxN01tmp(1501) ! NdE01tmp
c
c
c
      NK1=NK+1
*
      if(istop.ne.-1) goto 2
* 
* istop=-1
*
* Reading dE/dx from SRIM/Ziegler OUTPUT
* ---------------------------------------
      Do IK=1,NK1
*
                                                        IR=21
      open(IR,file=INPNAM_DEDX(IK))
      read(ir,*,end=90003)
      backspace ir
*                                    
      Call dEdX_ZIEGLER_READ(IK, IR, RO, Ex01tmp, dEdx01tmp, Rp01tmp,
     #                       NdE01tmp,   dEdxN01tmp)
* Now units for range and stopping power are Rp(cm), Ex(MeV), dEdx(MeV/cm)
       NdE01(IK)=NdE01tmp
* fill arrays
       do J=1,NdE01tmp
       Ex01(IK,J)   =Ex01tmp(J)   
       dEdx01(IK,J) =dEdx01tmp(J) 
       Rp01(IK,J)   =Rp01tmp(J)   
       dEdxN01(IK,J)=dEdxN01tmp(J)
       enddo
*
       close(IR)
       Enddo ! Do IK=1,NK1
*
*
  2    continue
*
*
* Reading data prepared by SL_LNSxx code
* --------------------------------------
      Do IK=1,NK1   
*
      if(IK.eq.1) then
                  IZP=ifix(Z1+0.001)
                  IAP=ifix(A1+0.001)
                  else
                  IZP=ifix(ZT(IK-1)+0.001)
                  IAP=ifix(AT(IK-1)+0.001)
                  endif
*
* IK - id of the moving ion
* MK - id of the material component
*
      Do MK=1,NK
      IZC=ifix(ZT(MK)+0.001)
      IAC=ifix(AT(MK)+0.001)
                                                         IR=21
      open(IR,file=INPNAM_XS(IK,MK))
        Read(IR,*,end=90001)Z10,A10,Z20,A20
        IZ10=ifix(Z10+0.001)
        IA10=ifix(A10+0.001)
        IZ20=ifix(Z20+0.001)
        IA20=ifix(A20+0.001)
        If(IZ10.ne.IZP .or. IA10.ne.IAP .or. 
     #     IZ20.ne.IZC .or. IA20.ne.IAC) goto 90002
        do iii=1,MAXC
        read(IR,*) 
        enddo
*
        NSL01tmp=1
        Energy01(IK,MK,NSL01tmp)=0.0
        dSdX01(IK,MK,NSL01tmp)  =0.0
        dEdX_Nuc01(IK,MK,NSL01tmp)=0.0
        dEdX_Nuc_0Ed01(IK,MK,NSL01tmp)=0.0
        dEdX_Nuc_Ed_Tmax01(IK,MK,NSL01tmp)=0.0
        CST01(IK,MK,NSL01tmp)=0.0
*
        Do iii=1,111111111
* 1    2     3               4               5                  6 
* T0,  DSDX, DEDX_nuc_total, DEDX_nuc_0_Ed,  DEDX_nuc_Ed_Tmax,  CS_Ed_Tmax
           Read(IR,*,end=4000) XXX1, XXX2, XXX3, XXX4, XXX5, XXX6
           NSL01tmp=NSL01tmp+1
           If(NSL01tmp.gt.1701) Call Error('Dime',1701)
*
           Energy01(IK,MK,NSL01tmp)=XXX1
           dSdX01(IK,MK,NSL01tmp)  =XXX2
           dEdX_Nuc01(IK,MK,NSL01tmp)=XXX3
           dEdX_Nuc_0Ed01(IK,MK,NSL01tmp)=XXX4
           dEdX_Nuc_Ed_Tmax01(IK,MK,NSL01tmp)=XXX5
           CST01(IK,MK,NSL01tmp)=XXX6
*
        Enddo ! Do iii=1,111111111
        Call Error('????',IR)
*
4000    continue
*
        NSL01(IK,MK)=NSL01tmp
*
        close(IR)
*
        Enddo !   Do MK=1,NK
        Enddo !   Do IK=1,NK1   
*
check if data are prepared by SL_LNS code up to the same energy
        Do IK=1,NK1   
        Do MK=1,NK
        If(NSL01(IK,MK).ne.NSL01(1,1)) goto 90004
        enddo
        enddo
*
        Return
*
*
90001   Print *,' File with the cross-sections from SL_LNS ',
     #  ' code is ABSENT'
        print *,' for ',IZP,IAP,' +',IZC,IAC,' interactions !'
        print *,'                       press any key...'
        pause
        stop
90002   Print 90012,INPNAM_XS(IK,MK),IZP,IAP,IZC,IAC,Z10,A10,Z20,A20
90012   Format(1x,' Input file with the cross-sections ',a12/1x,
     #  ' for ',i3,i5,' +',i3,i5,' interactions '/1x,
     #  '     contains the information '/1x,
     #  ' for ',2f6.1,' +',2f6.1,' interactions - E R R O R')
        print *,'                       press any key...'
        pause
        stop
90003   Print 90013,INPNAM_DEDX(IK)
90013   Format(//30x,'E  R  R  O  R'
     #  //' There are NO input file from SRIM (Ziegler)',
     #  ' code '//1x,'                          NAME =  ',a12//)
        print *,'                       press any key...'
        pause
        stop
90004   Print 90014
90014   Format(//30x,'E  R  R  O  R'
     #  //' Data prepared by SL_LNS code for different components ',
     #  ' do not coincide !'//1x,'  Delete corresponding files and ',
     #  ' run SL_LNS again.'//)
        print *,'                                     press any key...'
        pause
        stop
        End
*
************************************************************************
*
        Subroutine READ_INPUT
*       ---------------------
* + write general information in output file
c
        parameter (maxc=21,maxc1=22,maxe=50001)
        Character CTASK_NAME*80
        Character INPNAM_XS*12, INPNAM_DEDX*12, OUTNAM*12, OUTNAM2*12
        Character OUTNAM3*12
        Character NF(MAXC)*12,  C50*50, C80*80
        Common/FILENAMES/INPNAM_XS(MAXC1,MAXC),INPNAM_DEDX(MAXC1),
     #  OUTNAM
        Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/EIN/EIN(MAXE),NH(MAXE),KEIN
        Common/OPTIONS1/igraph,maxplay
        Common/CUT1/rmaxpl,itot,icut
        Common/PARAM01/IDSDT
        Common/MERCURY/CMD(5),Ecrit,MD
        Common/ISTOP/ISTOP
        Common/EARTH/IDEFMD,CTASK_NAME,C50
        Common/SATURN/TcritLAB(MAXC1)
        Print *,' Wait a bit...'
c
        open(1,file='input')
c
c
c find line with problem name
        call star(1)
        read(1,'(a80)')CTASK_NAME
c
c find line with graph printing option and maxplay
        call star(1)
c
c dS/dT
c IDSDT=0, 10(=0), 11-15 LNS expression; 
c      =1                Burenkov et al
c Tlim maximal energy for SL_LNS code
        read(1,*)igraph,maxplay,Tlim,IDSDT
        if(maxplay.eq.0) maxplay=250000  ! default option
           If(Tlim.gt.5200.)then
           Print *,'           E R R O R  in INPUT file       '
           Print *,'Maximal energy should be below 5.2 GeV  !'
           Print *,'                       press any key...'
           pause
           stop
           endif
c
        If(Tlim.le.0.0) Tlim=5000.
c
c Define f(t^1/2) function parametrs 
        Call FT12CHOICE(IDSDT)
c
c
        If(IDSDT.ne.0.and.IDSDT.ne.1) then
        Print *,'           E R R O R  in INPUT file       '
        Print *,'  IDSDT parameter is incorrect'
        Print *,'                          press any key...'
        pause
        stop
        endif
c
        rmaxpl=float(maxplay) 
        if(maxplay.lt.0) rmaxpl=1.e+9 
c
c try to find line with BCA-MD instruction
        call star(1)
        read(1,'(a80)')C80
c "BCA-MD" is identified by "B" or "M" letter 
        if(findp(C80,'B').ne.0. .or. findp(C80,'M').ne.0. .or. 
     #     findp(C80,'b').ne.0. .or. findp(C80,'m').ne.0. ) then
c
        MD=1
        
c find information needed for BCA-MD joint calculations
        call star(1)
c
c general formula for efficiency :  eff=C(1)*eMD**C(2) + C(3)*eMD
c if T(keV) < CMD(4) eff=const   (see function CF2)
c          and
c if T(keV) > CMD(5) eff=const 
        read(1,*,err=9919) (CMD(i),i=1,5),Ecrit
                                                           IDEFMD=0                                             
        if(CMD(1).eq.0.0.and.CMD(2).eq.0.0.and.CMD(3).eq.0.0.and.
     #  CMD(4).eq.0.0.and.CMD(5).eq.0.0.and.Ecrit.eq.0.0) IDEFMD=1
c
                          if(IDEFMD.eq.0) then   ! no default MD parameters
        if(CMD(4).lt.1. .or. Ecrit.lt.1.0)      Call Error(' keV',1)
        if(CMD(4).gt.1000. .or. Ecrit.gt.1000.) Call Error(' keV',1000)
        if(CMD(1).eq.0.0.and.CMD(2).eq.0.0.and.CMD(3).eq.0.0.and.
     #  CMD(4).ne.0.0.or.CMD(5).ne.0.0.or.Ecrit.ne.0.0) 
     #                                           Call Error('MDde',0)
c
                                          endif   
                                                            else
        MD=0
            Do itcritlab=1,maxc1
            TcritLAB(itcritlab)=-1.E+6
            Enddo
        backspace 1
                                                            endif
c
c
c
c find line with Z1, A1 of projectile
        call star(1)
        read(1,*,err=9929)Z1,A1
c
c find line with RO (density of the material), number of material components
c and option to calculate dE/dx
        call star(1)
        read(1,*)RO, NK
                 backspace 1
                 istop=0
                 read(1,'(a80)')C80
c
c Ziegler = SRIM (identified by "Z", "I")
        if(findp(C80,'Z').ne.0.0.or.findp(C80,'z').ne.0.0  
     #  .or.findp(C80,'I').ne.0.0.or.findp(C80,'i').ne.0.0) istop=-1  
c
c Armstrong=SPAR (identified by "A")
        if(findp(C80,'A').ne.0.0.or.findp(C80,'a').ne.0.0)  istop=+1  
c
c
        If(istop.eq.0) then 
        Print *,' '
        Print *,' Model to obtain dE/dx is not identified !!'
        print *,'                                press any key...'
        pause
        stop
        endif
c
        If(NK.gt.MAXC) then 
        Print *,'Number of components > ',MAXC,' !'
        print *,'                       press any key...'
        pause
        stop
        endif
c
c 
        If(RO.le.0. .and. NK.ne.1) then
        Print *,' '
        Print *,
     #  '      NO  default density for compounds !!!'
        print *,'                           press any key...'
        pause
        stop
        endif
c
c 
        If(MD.ne.0 .and. NK.ne.1) then
        Print *,
     #  'Joint BCA-MD calculations are not tested for compounds yet !'
        Print *,
     #  '  (!!!)  See comments *noalloy in Subr MODEL and READ_INP'
        print *,'                        press any key...'
        pause
        stop
        endif
c
c
c find file names with the specific cross-sections from SL_LNSxx code
c (run before) for each component of the media and dE/dx from SRIM 
c for projectile + media
        call star(1)
        Call GET_FILE_NAMES(1,NK,NF)
        Do MK=1,NK
        INPNAM_XS(1,MK)=NF(MK)
        Enddo
*
        if(istop.eq.-1) then 
        call star(1)
        Call GET_FILE_NAMES(1,1,NF)
        INPNAM_DEDX(1)=NF(1)
                        endif    
c
c find lines with the description of material componets
        Do IK=1,NK
        call star(1)
        read(1,*,err=90000)ZZ,AA, FR0, ED0
                             If(ED0.le.0.0) ED0=40.0  ! default = 40 eV
        IZ=ifix(ZZ+0.001)
*
* default parameters for MD efficiency
*noalloy
        If(MD.eq.1 .and. IDEFMD.eq.1) Call MDPARAM(IZ,C50)
*
*
        ZT(IK)=ZZ
        AT(IK)=AA
        FR(IK)=FR0
        ED(IK)=ED0 * 1.e-06    ! eV --> MeV
c
        call star(1)
        Call GET_FILE_NAMES(1,NK,NF)
        Do MK=1,NK
        INPNAM_XS(IK+1,MK)=NF(MK)
        Enddo
*
        if(istop.eq.-1) then
        call star(1)
        Call GET_FILE_NAMES(1,1,NF)
        INPNAM_DEDX(IK+1)=NF(1)
                        endif 
*
        Enddo ! Do IK=1,NK
*
* find line with output file name
        call star(1)
        if(MD.eq.0) then
        Call GET_FILE_NAMES(1,2,NF)
        OUTNAM=NF(1)
        OUTNAM2=NF(2)
                    else
* for BCA-MD get 3 file names
        Call GET_FILE_NAMES(1,3,NF)
        OUTNAM=NF(1)
        OUTNAM2=NF(2)
        OUTNAM3=NF(3)
                   endif
*
* find lines with energies
        Do ir=1,11111111
        call star(1)
        read(1,*,err=2,end=2)EE,NHH
            If(ir.gt.MAXE) then
            print *,' T O O   M U C H   I N P U T   E N E R G I E S  !'
            print *,' Change parameter MAXE in the code !'
            print *,'                                 press any key...'
            pause
            stop
            endif 
        EIN(ir)=ABS(EE)
             If(TLIM.le.EIN(ir)) then
             Print *,'           E R R O R  in INPUT file      '
             Print *,'Input energy  ',EIN(ir),'  > TLIM ! '
             Print *,'                      press any key...'
             pause
             stop
             endif
*  
        NH(ir)=NHH
        KEIN=ir
        if(EE.lt.0.0) goto 2
        Enddo
 2      Close(1)
*
****************************************************************************
* open part of output files (units 44,55)
* (main output file is open in subr precalculation)
*
        open(44,file=OUTNAM2)
        If(MD.eq.0) Write(44,2000)OUTNAM
 2000   Format(' See explanation of (1), (2),...',
     #  ' in main output file:  "',a12,' "'/)
        If(MD.ne.0) Write(44,2001)OUTNAM
 2001   Format(' See explanation of (1), (3),...',
     #  ' in main output file:  "',a12,' "'/)
        Write(44,2002)
 2002   Format(
     #  ' E(MeV)         (1)       (2)',
     #  '       (3)       (4)       (5)       (6)       (7)'/86('-'))
*
        If(MD.eq.0) Return
        open(55,file=OUTNAM3)
        Write(55,2003)
 2003   Format(
     #  'Eff[iciency]= N(direct counting)/N(NRT)'//
     #  '    T0         Eff +/- dEff  ',
     #  '    N(direct) +/- dN(FR)     N(NRT)'/65('-'))
*        
*
        Return
*
 9919   Call Error(' MD ',9919)
 9929   Call Error('Z,A ',9929)
90000   print 90001
90001   Format(/'  E R R O R  in input file INPUT !!!'
     #  /'  Possible reason:  dE/dx model chosen is inconsistent ',
     #  /'                    with the file names introduced in INPUT'  
     #  /'  Note:   SPAR option - names should be omitted'
     #  /'          SRIM option - names should be given')
        print *,'                              press any key...'
        pause
        stop
        End
*
************************************************************************
*
       Subroutine SPAR0(ZPR, APR, E, dEdxTOTS, dEdxNS ,JJ)
*      ---------------------------------------------------
       parameter (maxc=21,maxc1=22)
       real *8 spar, e_proj, proj_m, z_proj, avz, at_den, bari_ln, 
     # fme_(maxc), a_(maxc), del_pr, sparN
*
       Common/Basic/Z1,A1,Z2,A2,AW,RO,RN0
       Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
       Common/VENUS/RI(MAXC)
       Dimension iza_(maxc)
*
*
       e_proj= E
       proj_m= APR*931.5d0  !    mass in MeV
       z_proj= ZPR
*
       avz=0.d0
       bari_ln=0.d0
           Do i=1,NK
           avz=avz+FR(i)*ZT(i)
           bari_ln= bari_ln+FR(i)*ZT(i)*alog( RI(i) )
           fme_(i)= FR(i)
           a_(i)  = AT(i)
                IZT=ifix(ZT(i)+0.001)
                IAT=ifix(AT(i)+0.001)
                iza_(i)=1000*IZT+IAT
           enddo
       bari_ln=bari_ln/avz
*
       at_den=RN0/1.d+24  ! 1/b-cm
       nel1=NK
c
c
       stopping=spar(e_proj,proj_m,z_proj,avz,at_den,bari_ln,fme_,a_,   
     # iza_,nel1,jj,del_pr,sparN)                                             
c       
       dEdxTOTS=real(stopping)
       dEdxNS=real(sparN)
c
       Return
       end 
*
*
************************************************************************
*
      function spar(e_proj,proj_m,z_proj,avz,at_den,bari_ln,fme_,a_,   
     # iza_,nel1,jj,del_pr,sparN)                                             
*
!       REAL dedx CODING                                                
!       dedx for heavy ion, protons,pions,muons                         
!       units: MeV/cm                                                   
!                                                                       
!         e_proj = projectile kinetic energy (MeV)                      
!         proj_m = projectile mass (MeV)                                
!         z_proj = projectile charge number                             
!         avz = <Z> for the medium                                      
!             = SUM fme_(i)*z(i)                                        
!         at_den = atomic density (1/barn-cm)                           
!         bari_ln = <ln I> with I in MeV                                
!                 = SUM fme_(i)*z(i)*ln I(i) / <Z>                      
!         fme_(i)  = array of atom fracions i=1,...,nel1                
!         a_(i) = array of mass numbers i=1,...,nel1                    
!                  (more properly, atomic weights)                      
!         iza_(i) = array of 1000*Z + A numbers i=1,...,nel1            
!         nel1 = number of isotopes in medium                           
!         jj:                                                           
!            jj=1 gaseous element                                       
!            jj=2 condensed element                                     
!            jj=3 gaseous mixture                                       
!            jj=4 condensed mixture                                     
* added
!         sparN = nuclear stopping power           
!                                       
!                                
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      parameter (prot_mass=938.2723128d0)                               
      parameter (prot_m=prot_mass)                                      
      dimension fme_(nel1), a_(nel1)                                    
      dimension iza_(nel1)                                              
      data elow /1.31d0/, ehigh /5.24d0/                                
      e_prot=e_proj*prot_m/proj_m                                       
      del_pr=dp0                                                        
**
      stpN1=0.d0
      stpN2=0.d0
**
      if (e_prot.gt.elow) stp1=z_proj**2*dedx1(e_prot,proj_m,avz,at_den 
     & ,bari_ln,fme_(1),iza_(1),nel1,jj,del_pr)                         
      if (e_prot.lt.ehigh) stp2=dedx0(e_proj,proj_m,z_proj,avz,at_den   
     & ,fme_(1),a_(1),iza_(1),nel1, stpN2)                                     
      fx=(e_prot-elow)/(ehigh-elow)                                     
      fx=min(dp1,max(dp0,fx))                                           
c
      spar=fx*stp1+(dp1-fx)*stp2                                        
**
      sparN=fx*stpN1+(dp1-fx)*stpN2                                        
      return                                                            
      end                                                               
*
************************************************************************
*
      function dedx0(e_proj,proj_m,z_proj,avz,at_den,fme_,a_,iza_,nel1,
     &               stpN2)
!                                                                       
!       dedx for heavy ion, protons,pions,muons                         
!                                                                       
!       units: MeV/cm                                                   
!                                                                       
!       low energy models from SPAR.                                    
!       equivalent proton energy < 8 MeV.                               
!                                                                       
!         e_proj = projectile kinetic energy (MeV)                      
!         proj_m = projectile mass (MeV)                                
!         z_proj = projectile charge number                             
!         avz = <Z> for the medium                                      
!             = SUM fme_(i)*z(i)                                        
!         at_den = atomic density (1/barn-cm)                           
!         fme_  = array of atom fracions i=1,...,nel1                   
!         a_(i) = array of mass numbers i=1,...,nel1                    
!                  (more properly, atomic weights)                      
!         iza_(i) = array of 1000*Z + A numbers i=1,...,nel1            
!         nel1 = number of isotopes in medium                           
!                                                                       
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      parameter (emass=0.5109990615d0)                                  
      parameter (av_num=0.6022136736d0)                                 
      parameter (el_rad=0.28179409238d0)                                
      parameter (stp_con=dp4*dppi*el_rad**2*emass)                      
      parameter (prot_mass=938.2723128d0)                               
      parameter (prot_m=prot_mass)                                      
      parameter (om30=1.0d-30)                                          
      dimension a_(nel1), fme_(nel1)                                    
      dimension iza_(nel1)                                              
      se=dp0                                                            
      snuc=dp0                                                          
      if (e_proj.eq.dp0) go to 20                                       
      rel_m=proj_m/prot_m                                               
      if (e_proj.gt.8.d0*rel_m) stop ' energy too large in DEDX0 '      
      fac1=z_proj**dpth                                                 
      bcut1=.07d0*fac1**2                                               
      bcut2=.0046d0*fac1                                                
      gammasq=(e_proj/proj_m+dp1)**2                                    
      betasq=(gammasq-dp1)/gammasq                                      
      beta=sqrt(betasq)                                                 
      beta0=beta                                                        
      fac0=dp1                                                          
      if (beta0.lt.bcut2) then                                          
!-----                                                                  
! BETA0 < BCUT2                                                         
        beta=bcut2                                                      
        betasq=beta**2                                                  
        gammasq=dp1/(dp1-betasq)                                        
        ei=(sqrt(gammasq)-dp1)*proj_m                                   
        fac0=sqrt(e_proj/ei)                                            
      endif                                                             
      a7=stp_con*avz*at_den*f_linhard(betasq,avz)/betasq                
      zsq=z_proj*z_proj                                                 
      se=zsq*fac0*a7                                                    
      if (beta0.ge.bcut1) go to 20                                      
!-----                                                                  
! Compute electronic stopping power                                     
      temp=(dp1-exp(-125.d0*beta/fac1**2))**2                           
      se=se*temp                                                        
!-----                                                                  
! Compute nuclear stopping power                                        
      do 10 j=1,nel1                                                    
      z = iza_(j)/1000                                                  
      q1=sqrt(fac1**2+z**dp2th)                                         
      q2=a_(j)+rel_m                                                    
      q3=z_proj*z                                                       
      fj=3.255d+04*a_(j)/(q2*q3*q1)                                     
      gj=1.96d-4*a_(j)*q2*q1/(q3*rel_m)                                 
      ej=fj*e_proj                                                      
      if (ej.gt.1.d+03) go to 10                                        
      if (ej.gt.dp4) then                                               
        dedp=0.5455d0*log(ej)/(ej*(dp1-0.9988d0*ej**(-1.5391d0)))       
      else                                                              
        dedp=4.46426d0*sqrt(ej)*exp(-2.542d0*ej**0.277d0)               
      endif                                                             
      sj=(a_(j)*at_den*fme_(j)/av_num)*dedp/gj                          
      snuc=snuc+sj                                                      
   10 continue                                                          
!-----                                                                  
   20 continue                                                          
      dedx0=max(se+snuc,om30)                                           
**
      stpN2=snuc
      return                                                            
      end                                                               
*
************************************************************************
*
      function dedx1 (e_prot,proj_m,avz,at_den,bari_ln,fme_,iza_,nel1,  
     & jj,del_pr)                                                       
!                                                                       
!       dedx for heavy ion, protons,pions,muons                         
!                                                                       
!       compute energy loss above about 1-mev (eone).                   
!       limit determined by validity of Janni shell correction.         
!                                                                       
!         e_prot = equivalent proton kinetic energy (MeV)               
!         proj_m = projectile mass (MeV)                                
!         avz = <Z> for the medium                                      
!             = SUM fme_(i)*z(i)                                        
!         at_den = atomic density (1/barn-cm)                           
!         bari_ln = <ln I> with I in MeV                                
!                 = SUM fme_(i)*z(i)*ln I(i) /<Z>                       
!         fme_  = array of atom fracions i=1,...,nel1                   
!         iza_(i) = array of 1000*Z + A numbers i=1,...,nel1            
!         nel1 = number of isotopes in medium                           
!         jj:                                                           
!            jj=1 gaseous element                                       
!            jj=2 condensed element                                     
!            jj=3 gaseous mixture                                       
!            jj=4 condensed mixture                                     
!                                                                       
!        this function computes the energy loss and if necessary        
!        weights it over all elements to get the energy loss for a      
!        compound or mixture.                                           
!                                                                       
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      dimension fme_(nel1)                                              
      dimension iza_(nel1)                                              
!                                                                       
!        con = 2 pi M(el)c**2 R(el)**2 N(Avagadro)                      
!                                                                       
      parameter (emass=0.5109990615d0)                                  
      parameter (prot_mass=938.2723128d0)                               
      parameter (av_num=0.6022136736d0)                                 
      parameter (el_rad=0.28179409238d0)                                
      parameter (alpfsc=7.2973530791728595d-03)                         
      parameter (con=2.0*dppi*emass*el_rad**2*av_num)                   
!                                                                       
      parameter (eone=1.30d0)                                           
!                                                                       
      logical ptraut                                                    
!                                                                       
      data ikshl /1/, ilshl /1/, imshl /1/, inshl /1/, ioshl /1/, ipshl 
     & /1/                                                              
!                                                                       
      if (e_prot.lt.eone) stop ' e_prot.lt.eone in DEDX1 '              
!                                                                       
      rstmas=prot_mass                                                  
      s=e_prot/rstmas                                                   
      gamma=dp1+s                                                       
      betasq=s*(s+dp2)/gamma**2                                         
      dedx1=0.                                                          
!                                                                       
!         Get Bethe-Bloch term                                          
!                                                                       
      t_0=dp2*emass*betasq/(dp1-betasq)                                 
      t_max=t_0/(dp1+dp2*gamma*(emass/proj_m)+(emass/proj_m)**2)        
      b_b=log(t_0*t_max)-dp2*(bari_ln+betasq)                           
!                                                                       
!         Get density correction                                        
!                                                                       
      del=del1(betasq,avz,at_den,bari_ln,jj)                            
!                                                                       
!         Get shell correction from Janni code                          
!                                                                       
      c_ovr_z=dp0                                                       
      zsum=dp0                                                          
      ptraut=.false.                                                    
      do 10 l=1,nel1                                                    
      z = iza_(l)/1000                                                  
      t=z*fme_(l)                                                       
      zsum=zsum+t                                                       
      cklmno=shellj(z,e_prot,ck1,cl1,cl2,cl,cm1,cm2,cm3,cm,cn1,cn2,cn3  
     & ,cn4,cn,co1,co2,co3,co,cp1,cp2,cp3,cp,ikshl,ilshl,imshl,inshl    
     & ,ioshl,ipshl,ptraut)                                             
      c_ovr_z=c_ovr_z+t*cklmno/z                                        
   10 continue                                                          
      c_ovr_z=c_ovr_z/zsum                                              
!                                                                       
      dedx1=b_b-dp2*c_ovr_z-del                                         
      dedx1=dedx1+dppi*sqrt(betasq)*alpfsc                              
      dedx1=(con*at_den/av_num)*avz*dedx1/betasq                        
      del_pr=(con*at_den/av_num)*avz*del/betasq                         
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function alin (xv,x,y,nxy,intflg)                                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!     linear interpolation routine.  interpolates a table of y as a     
!     function of x at entry point xv.                                  
!     the x array may be in ascending or descending order, but it must  
!     be monotonic. if intflg = 'old', the routine will skip the binary 
!     search section.                                                   
!                                                                       
!        called from -                                                  
!             safer                                                     
!                                                                       
!     routine by harry m. murphy,  afwl/dyvm,  23 july 1978.            
!     updated by henry j. happ iii, tetra corp, 7 october 1981 to       
!     allow for both ascending and descending order.                    
!     updated by hjh dec82 to add the intflg parameter.                 
!                                                                       
      dimension x(nxy), y(nxy)                                          
!                                                                       
!     original code had:     integer i, l, m, nxy                       
      character*3 intflg                                                
!                                                                       
!     original code had:     real delta, xo                             
!                                                                       
      logical error                                                     
!                   start.  make xv and nxy local.                      
      alin=0.0                                                          
      xo=xv                                                             
      if (intflg.eq.'old') go to 50                                     
!                                                                       
      l=1                                                               
      m=nxy                                                             
      error=m.lt.2                                                      
      if (error) write (16,70)                                          
      if (error) go to 60                                               
!                   check for descending order.                         
      if (x(1).gt.x(nxy)) go to 20                                      
!                   ascending order.                                    
!                   do binary search of array x for the entry point.    
      i=(l+m)/2                                                         
   10 if (xo.gt.x(i)) l=i                                               
      if (xo.le.x(i)) m=i                                               
      i=(l+m)/2                                                         
      if (l.lt.i) go to 10                                              
      go to 40                                                          
!                   descending order.                                   
!                   do binary search of array x for the entry point.    
   20 i=(l+m)/2                                                         
   30 if (xo.lt.x(i)) l=i                                               
      if (xo.ge.x(i)) m=i                                               
      i=(l+m)/2                                                         
      if (l.lt.i) go to 30                                              
!                   we have the entry point.  calculate delta.          
   40 delta=x(i+1)-x(i)                                                 
      error=delta.eq.0.0                                                
      if (error) write (16,80) i                                        
      if (error) go to 60                                               
!                   do linear interpolation.                            
   50 alin=y(i)+(y(i+1)-y(i))*(xo-x(i))/delta                           
!                   return.                                             
   60 return                                                            
!                                                                       
   70 format ('0function alin error.  table length less than 2.')       
   80 format ('0function alin error.  ',                                
     & 'independent variable array is bi-valued at i =',i5,'.')         
      end                                                               
*
************************************************************************
*
      function alin3d (xo,yo,x,y,z,nx,ny,intflg)                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!     linear 3-dimensional interpolation.  interpolates a table, z(i,j),
!     as a function of x(i) and y(j) at entry points, xo and yo.        
!     the surface is assumed to be defined by the following function -  
!                   z(x,y) = a + b*x + c*y + d*x*y                      
!     if intflg = 'old', the binary search section will be by-passed.   
!                                                                       
!     n o t e -   both x and y arrays must be in ascending order.       
!                                                                       
!     routine by harry m. murphy,  afwl/satr,  30 january 1976.         
!                                                                       
      dimension x(nx), y(ny), z(nx,ny)                                  
      character*3 intflg                                                
!                                                                       
!                   start.  check array dimensions.                     
      alin3d=0.0                                                        
      nerr=1                                                            
      if (intflg.eq.'old') go to 50                                     
      if ((nx.lt.2).or.(ny.lt.2)) go to 60                              
!                   search x-array for entry point.                     
      do 10 i=2,nx                                                      
      if (x(i).ge.xo) go to 20                                          
   10 continue                                                          
      i=nx                                                              
   20 dx=x(i)-x(i-1)                                                    
!                   check for duplicate values in the x-array.          
      nerr=2                                                            
      if (dx.eq.0.0) go to 60                                           
!                   search y-array for entry point.                     
      do 30 j=2,ny                                                      
      if (y(j).ge.yo) go to 40                                          
   30 continue                                                          
      j=ny                                                              
   40 dy=y(j)-y(j-1)                                                    
!                   check for duplicate values in the y-array.          
      nerr=3                                                            
      if (dy.eq.0.0) go to 60                                           
!                   ready to interpolate.  compute frx and fry.         
      frx=(xo-x(i-1))/dx                                                
      fry=(yo-y(j-1))/dy                                                
!                   interpolate in z,y(j-1) plane.                      
   50 z1=z(i-1,j-1)+frx*(z(i,j-1)-z(i-1,j-1))                           
!                   interpolate in z,y(j) plane.                        
      z2=z(i-1,j)+frx*(z(i,j)-z(i-1,j))                                 
!                   interpolate in z,xo plane.                          
      alin3d=z1+fry*(z2-z1)                                             
      go to 70                                                          
!                   error message.                                      
   60 write (16,80) nerr,nx,ny,xo,yo                                    
!                   return.                                             
   70 return                                                            
!                                                                       
   80 format (1x/' function alin3d error.  error number ',i2,'.'/       
     & ' 1 - length of x- or y-arrays (or both) less than 2.'/          
     & ' 2 - duplicate values in the x-array.'/                         
     & ' 3 - duplicate values in the y-array.'/1x/                      
     &' nx =',i4,'    ny =',i4,'    xo =',1pe12.4,'    yo =',1pe12.4/1x)
      end                                                               
*
************************************************************************
*
      block data atmdat                                                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
!                                                                       
!       1 h   hydrogen      atmwt:    1.0080  density:  0.0000898       
      data (shel(i,  1),i=1,max_shell)/ 1.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  1),i=1,max_shell)/ 1.359811d+01, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  1),i=1,max_shell)/ 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       2 he  helium        atmwt:    4.0026  density:  0.0001770       
      data (shel(i,  2),i=1,max_shell)/ 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  2),i=1,max_shell)/ 2.458678d+01, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  2),i=1,max_shell)/ 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       3 li  lithium       atmwt:    6.9390  density:  0.5300000       
      data (shel(i,  3),i=1,max_shell)/ 2.00d+00, 1.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  3),i=1,max_shell)/ 5.475000d+01, 5.390000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  3),i=1,max_shell)/ 3.000000d-01, 1.700000d+00,   
     &        1.700000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       4 be  beryllium     atmwt:    9.0122  density:  1.8200001       
      data (shel(i,  4),i=1,max_shell)/ 2.00d+00, 2.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  4),i=1,max_shell)/ 1.110000d+02, 9.320000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  4),i=1,max_shell)/ 3.000000d-01, 2.050000d+00,   
     &        2.050000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       5 b   boron         atmwt:   10.8110  density:  2.3399999       
      data (shel(i,  5),i=1,max_shell)/ 2.00d+00, 2.00d+00, 1.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  5),i=1,max_shell)/ 1.880000d+02, 1.292000d+01,    
     &       4.700000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  5),i=1,max_shell)/ 3.000000d-01, 2.400000d+00,   
     &        2.400000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       6 c   carbon        atmwt:   12.0112  density:  2.2200000       
      data (shel(i,  6),i=1,max_shell)/ 2.00d+00, 2.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  6),i=1,max_shell)/ 2.838000d+02, 1.651000d+01,    
     &       6.400000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  6),i=1,max_shell)/ 3.000000d-01, 2.750000d+00,   
     &        2.750000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       7 n   nitrogen      atmwt:   14.0067  density:  0.0012510       
      data (shel(i,  7),i=1,max_shell)/ 2.00d+00, 2.00d+00, 3.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  7),i=1,max_shell)/ 4.016000d+02, 2.010000d+01,    
     &       9.200000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  7),i=1,max_shell)/ 3.000000d-01, 3.100000d+00,   
     &        3.100000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       8 o   oxygen        atmwt:   15.9994  density:  0.0014290       
      data (shel(i,  8),i=1,max_shell)/ 2.00d+00, 2.00d+00, 4.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  8),i=1,max_shell)/ 5.320000d+02, 2.370000d+01,    
     &       7.100000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  8),i=1,max_shell)/ 3.000000d-01, 3.450000d+00,   
     &        3.450000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!       9 f   fluorine      atmwt:   18.9984  density:  0.0016960       
      data (shel(i,  9),i=1,max_shell)/ 2.00d+00, 2.00d+00, 5.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i,  9),i=1,max_shell)/ 6.854000d+02, 3.100000d+01,    
     &       8.600000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i,  9),i=1,max_shell)/ 3.000000d-01, 3.800000d+00,   
     &        3.800000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      10 ne  neon          atmwt:   20.1830  density:  0.0008990       
      data (shel(i, 10),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 10),i=1,max_shell)/ 8.669000d+02, 4.500000d+01,    
     &       1.830000d+01, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 10),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      11 na  sodium        atmwt:   22.9898  density:  0.9700000       
      data (shel(i, 11),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 11),i=1,max_shell)/ 1.072100d+03, 6.330000d+01,    
     &       3.110000d+01, 5.138000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 11),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 8.800000d+00, 8.800000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      12 mg  magnesium     atmwt:   24.3120  density:  1.7400000       
      data (shel(i, 12),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 12),i=1,max_shell)/ 1.305000d+03, 8.940000d+01,    
     &       5.140000d+01, 7.644000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 12),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 9.150000d+00, 9.150000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      13 al  aluminum      atmwt:   26.9815  density:  2.6989999       
      data (shel(i, 13),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 13),i=1,max_shell)/ 1.559600d+03, 1.177000d+02,    
     &       7.310000d+01, 1.010000d+01, 2.700000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 13),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 9.500000d+00, 9.500000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      14 si  silicon       atmwt:   28.0860  density:  2.3299999       
      data (shel(i, 14),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 14),i=1,max_shell)/ 1.838900d+03, 1.487000d+02,    
     &       9.920000d+01, 1.134000d+01, 7.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 14),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 9.850000d+00, 9.850000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      15 p   phosphorus    atmwt:   30.9738  density:  1.8200001       
      data (shel(i, 15),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 3.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 15),i=1,max_shell)/ 2.145500d+03, 1.893000d+02,    
     &       1.322000d+02, 1.318800d+01, 6.400000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 15),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.020000d+01, 1.020000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      16 s   sulfur        atmwt:   32.0640  density:  2.0699999       
      data (shel(i, 16),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 4.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 16),i=1,max_shell)/ 2.472000d+03, 2.292000d+02,    
     &       1.648000d+02, 1.503600d+01, 6.700000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 16),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.055000d+01, 1.055000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      17 cl  chlorine      atmwt:   35.4530  density:  0.0032140       
      data (shel(i, 17),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 5.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 17),i=1,max_shell)/ 2.822400d+03, 2.702000d+02,    
     &       2.008000d+02, 1.750000d+01, 6.800000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 17),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.090000d+01, 1.090000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      18 a   argon         atmwt:   39.9480  density:  0.0017840       
      data (shel(i, 18),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 18),i=1,max_shell)/ 3.202900d+03, 3.200000d+02,    
     &       2.462000d+02, 2.530000d+01, 1.240000d+01, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 18),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      19 k   potassium     atmwt:   39.1020  density:  0.8600000       
      data (shel(i, 19),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 19),i=1,max_shell)/ 3.607400d+03, 3.771000d+02,    
     &       2.949000d+02, 3.390000d+01, 1.780000d+01, 0.000000d+00,    
     &       4.339000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 19),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 0.000000d+00,   
     &        1.680000d+01, 1.680000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      20 ca  calcium       atmwt:   40.0800  density:  1.5500000       
      data (shel(i, 20),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 0.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 20),i=1,max_shell)/ 4.038100d+03, 4.378000d+02,    
     &       3.482000d+02, 4.370000d+01, 2.540000d+01, 0.000000d+00,    
     &       6.111000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 20),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 0.000000d+00,   
     &        1.715000d+01, 1.715000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      21 sc  scandium      atmwt:   44.9560  density:  2.9920001       
      data (shel(i, 21),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 21),i=1,max_shell)/ 4.492800d+03, 5.004000d+02,    
     &       4.044000d+02, 5.380000d+01, 3.230000d+01, 6.600000d+00,    
     &       6.540000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 21),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.800000d+01,   
     &        1.800000d+01, 1.800000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      22 ti  titanium      atmwt:   47.9000  density:  4.5400000       
      data (shel(i, 22),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 2.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 22),i=1,max_shell)/ 4.966400d+03, 5.637000d+02,    
     &       4.585000d+02, 6.030000d+01, 3.460000d+01, 3.700000d+00,    
     &       6.820000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 22),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.835000d+01,   
     &        1.885000d+01, 1.885000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      23 v   vanadium      atmwt:   50.9420  density:  6.1100001       
      data (shel(i, 23),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 3.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 23),i=1,max_shell)/ 5.465100d+03, 6.282000d+02,    
     &       5.167000d+02, 6.650000d+01, 3.780000d+01, 2.200000d+00,    
     &       6.740000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 23),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.870000d+01,   
     &        1.970000d+01, 1.970000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      24 cr  chromium      atmwt:   51.9960  density:  7.1900001       
      data (shel(i, 24),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 5.00d+00, 1.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 24),i=1,max_shell)/ 5.989200d+03, 6.946000d+02,    
     &       5.791000d+02, 7.410000d+01, 4.250000d+01, 2.300000d+00,    
     &       6.764000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 24),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.905000d+01,   
     &        2.115000d+01, 2.115000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      25 mn  manganese     atmwt:   54.9380  density:  7.4299998       
      data (shel(i, 25),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 5.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 25),i=1,max_shell)/ 6.539000d+03, 7.690000d+02,    
     &       6.458000d+02, 8.390000d+01, 4.860000d+01, 3.300000d+00,    
     &       7.432999d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 25),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.940000d+01,   
     &        2.140000d+01, 2.140000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      26 fe  iron          atmwt:   55.8470  density:  7.8699999       
      data (shel(i, 26),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 6.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 26),i=1,max_shell)/ 7.112000d+03, 8.461000d+02,    
     &       7.146000d+02, 9.290000d+01, 5.400000d+01, 3.600000d+00,    
     &       7.870000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 26),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 1.975000d+01,   
     &        2.225000d+01, 2.225000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      27 co  cobalt        atmwt:   58.9332  density:  8.8999996       
      data (shel(i, 27),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 7.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 27),i=1,max_shell)/ 7.708900d+03, 9.256000d+02,    
     &       7.861000d+02, 1.007000d+02, 5.950000d+01, 2.900000d+00,    
     &       7.860000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 27),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.010000d+01,   
     &        2.310000d+01, 2.310000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      28 ni  nickel        atmwt:   58.7100  density:  8.8999996       
      data (shel(i, 28),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 8.00d+00, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 28),i=1,max_shell)/ 8.332800d+03, 1.008100d+03,    
     &       8.633000d+02, 1.118000d+02, 6.810000d+01, 3.600000d+00,    
     &       7.630000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 28),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.045000d+01,   
     &        2.395000d+01, 2.395000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      29 cu  copper        atmwt:   63.5400  density:  8.8999996       
      data (shel(i, 29),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 1.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 29),i=1,max_shell)/ 8.978900d+03, 1.096600d+03,    
     &       9.410000d+02, 1.198000d+02, 7.360000d+01, 1.600000d+00,    
     &       7.724000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 29),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.080000d+01,   
     &        2.530000d+01, 2.530000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      30 zn  zinc          atmwt:   65.3700  density:  7.1329999       
      data (shel(i, 30),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 30),i=1,max_shell)/ 9.658600d+03, 1.193600d+03,    
     &       1.031200d+03, 1.359000d+02, 8.660000d+01, 8.100000d+00,    
     &       9.391000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 30),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.565000d+01, 2.565000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      31 ga  gallium       atmwt:   65.7200  density:  5.9099998       
      data (shel(i, 31),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 1.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 31),i=1,max_shell)/ 1.036710d+04, 1.297700d+03,    
     &       1.128800d+03, 1.581000d+02, 1.048000d+02, 1.740000d+01,    
     &       6.000000d+00, 8.350000d-02, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 31),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.600000d+01, 2.600000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      32 ge  germanium     atmwt:   72.5900  density:  5.3230000       
      data (shel(i, 32),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 2.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 32),i=1,max_shell)/ 1.110310d+04, 1.414300d+03,    
     &       1.232200d+03, 1.800000d+02, 1.243000d+02, 2.870000d+01,    
     &       1.130000d+01, 8.778000d-01, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 32),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.635000d+01, 2.635000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      33 as  arsenic       atmwt:   74.9216  density:  5.7300000       
      data (shel(i, 33),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 3.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 33),i=1,max_shell)/ 1.186670d+04, 1.526500d+03,    
     &       1.340800d+03, 2.035000d+02, 1.434000d+02, 4.120000d+01,    
     &       1.665000d+01, 2.500000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 33),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.670000d+01, 2.670000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      34 se  selenium      atmwt:   78.9600  density:  4.8099999       
      data (shel(i, 34),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 4.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 34),i=1,max_shell)/ 1.265780d+04, 1.653900d+03,    
     &       1.456000d+03, 2.315000d+02, 1.650000d+02, 5.670000d+01,    
     &       2.190000d+01, 5.600000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 34),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.695000d+01, 2.695000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      35 br  bromine       atmwt:   79.9090  density:  3.1199999       
      data (shel(i, 35),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 5.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 35),i=1,max_shell)/ 1.347370d+04, 1.782000d+03,    
     &       1.572900d+03, 2.565000d+02, 1.854000d+02, 6.950000d+01,    
     &       2.730000d+01, 4.900000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 35),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.730000d+01, 2.730000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      36 kr  krypton       atmwt:   83.8000  density:  0.0037330       
      data (shel(i, 36),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 36),i=1,max_shell)/ 1.432560d+04, 1.921000d+03,    
     &       1.701000d+03, 2.890000d+02, 2.182000d+02, 8.890000d+01,    
     &       2.400000d+01, 1.060000d+01, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 36),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      37 rb  rubidium      atmwt:   85.4700  density:  1.5300000       
      data (shel(i, 37),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 0.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 37),i=1,max_shell)/ 1.519970d+04, 2.065100d+03,    
     &       1.834100d+03, 3.221000d+02, 2.429000d+02, 1.110000d+02,    
     &       2.930000d+01, 1.440000d+01, 0.000000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 37),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 0.000000d+00, 0.000000d+00,   
     &        3.480000d+01, 3.480000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      38 sr  strontium     atmwt:   87.6200  density:  2.5400000       
      data (shel(i, 38),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 0.00d+00,   
     &    0.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 38),i=1,max_shell)/ 1.610460d+04, 2.216300d+03,    
     &       1.973100d+03, 3.575000d+02, 2.744000d+02, 1.340000d+02,    
     &       3.770000d+01, 1.990000d+01, 0.000000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 38),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 0.000000d+00, 0.000000d+00,   
     &        3.515000d+01, 3.515000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      39 y   yttrium       atmwt:   88.9050  density:  4.4499998       
      data (shel(i, 39),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+00,   
     &    0.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 39),i=1,max_shell)/ 1.703840d+04, 2.372500d+03,    
     &       2.117700d+03, 3.936000d+02, 3.063000d+02, 1.585000d+02,    
     &       4.540000d+01, 2.560000d+01, 4.860000d-01, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 39),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.600000d+01, 0.000000d+00,   
     &        3.600000d+01, 3.600000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      40 zr  zirconium     atmwt:   91.2200  density:  6.5000000       
      data (shel(i, 40),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 2.00d+00,   
     &    0.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 40),i=1,max_shell)/ 1.799760d+04, 2.531600d+03,    
     &       2.264500d+03, 4.303000d+02, 3.373000d+02, 1.812000d+02,    
     &       5.130000d+01, 2.870000d+01, 1.800000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 40),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.635000d+01, 0.000000d+00,   
     &        3.685000d+01, 3.685000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      41 nb  niobium       atmwt:   92.9060  density:  8.5699997       
      data (shel(i, 41),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 4.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 41),i=1,max_shell)/ 1.898560d+04, 2.697700d+03,    
     &       2.417600d+03, 4.684000d+02, 3.707000d+02, 2.060000d+02,    
     &       5.810000d+01, 3.390000d+01, 3.200000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 41),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.705000d+01, 0.000000d+00,   
     &        3.820000d+01, 3.820000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      42 mo  molybdenum    atmwt:   95.9400  density: 10.1999998       
      data (shel(i, 42),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 5.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 42),i=1,max_shell)/ 1.999950d+04, 2.865500d+03,    
     &       2.572600d+03, 5.046000d+02, 4.010000d+02, 2.286000d+02,    
     &       6.180000d+01, 3.480000d+01, 1.800000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 42),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.740000d+01, 0.000000d+00,   
     &        3.905000d+01, 3.905000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      43 tc  technetium    atmwt:   99.0000  density: 11.4600000       
      data (shel(i, 43),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 6.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 43),i=1,max_shell)/ 2.104400d+04, 3.042500d+03,    
     &       2.735000d+03, 5.460000d+02, 4.349000d+02, 2.546000d+02,    
     &       7.200000d+01, 3.890000d+01, 1.900000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 43),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.775000d+01, 0.000000d+00,   
     &        3.990000d+01, 3.990000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      44 ru  ruthenium     atmwt:  101.0700  density: 12.1999998       
      data (shel(i, 44),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 7.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 44),i=1,max_shell)/ 2.211720d+04, 3.224000d+03,    
     &       2.902400d+03, 5.850000d+02, 4.717000d+02, 2.815000d+02,    
     &       7.490000d+01, 4.310000d+01, 2.000000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 44),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.810000d+01, 0.000000d+00,   
     &        4.075000d+01, 4.075000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      45 rh  rhodium       atmwt:  102.9050  density: 12.4399996       
      data (shel(i, 45),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 8.00d+00,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 45),i=1,max_shell)/ 2.321990d+04, 3.411900d+03,    
     &       3.074900d+03, 6.271000d+02, 5.086000d+02, 3.093000d+02,    
     &       8.100000d+01, 4.790000d+01, 2.500000d+00, 0.000000d+00,    
     &       1.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 45),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.845000d+01, 0.000000d+00,   
     &        4.160000d+01, 4.160000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      46 pd  palladium     atmwt:  106.4000  density: 12.0000000       
      data (shel(i, 46),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 46),i=1,max_shell)/ 2.435030d+04, 3.604300d+03,    
     &       3.251800d+03, 6.699000d+02, 5.453000d+02, 3.373000d+02,    
     &       8.640000d+01, 5.110000d+01, 1.500000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 46),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      47 ag  silver        atmwt:  107.8700  density: 10.4899998       
      data (shel(i, 47),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 47),i=1,max_shell)/ 2.551400d+04, 3.805800d+03,    
     &       3.437400d+03, 7.175000d+02, 5.878000d+02, 3.697000d+02,    
     &       9.520000d+01, 5.930000d+01, 3.300000d+00, 0.000000d+00,    
     &       3.700000d-02, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 47),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.330000d+01, 4.330000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      48 cd  cadmium       atmwt:  112.4000  density:  8.6499996       
      data (shel(i, 48),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 48),i=1,max_shell)/ 2.671120d+04, 4.018000d+03,    
     &       3.632200d+03, 7.702000d+02, 6.336000d+02, 4.071000d+02,    
     &       1.076000d+02, 6.690000d+01, 9.300000d+00, 0.000000d+00,    
     &       6.280000d-01, 0.000000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 48),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.365000d+01, 4.365000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      49 in  indium        atmwt:  114.8200  density:  7.3099999       
      data (shel(i, 49),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 1.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 49),i=1,max_shell)/ 2.793990d+04, 4.237500d+03,    
     &       3.834000d+03, 8.256000d+02, 6.832000d+02, 4.469000d+02,    
     &       1.219000d+02, 7.740000d+01, 1.620000d+01, 0.000000d+00,    
     &       1.938000d+00, 8.000000d-01, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 49),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.400000d+01, 4.400000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      50 sn  tin           atmwt:  118.6900  density:  7.2979999       
      data (shel(i, 50),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 2.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 50),i=1,max_shell)/ 2.920010d+04, 4.464700d+03,    
     &       3.992400d+03, 8.838000d+02, 7.354000d+02, 4.890000d+02,    
     &       1.365000d+02, 8.860000d+01, 2.390000d+01, 0.000000d+00,    
     &       3.960000d+00, 1.100000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 50),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.435000d+01, 4.435000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      51 sb  antimony      atmwt:  121.7500  density:  6.6910000       
      data (shel(i, 51),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 3.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 51),i=1,max_shell)/ 3.049120d+04, 4.698300d+03,    
     &       4.256300d+03, 9.437000d+02, 7.887000d+02, 5.322000d+02,    
     &       1.520000d+02, 9.840000d+01, 3.140000d+01, 0.000000d+00,    
     &       6.700000d+00, 2.100000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 51),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.470000d+01, 4.470000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      52 te  tellurium     atmwt:  127.6000  density:  6.2399998       
      data (shel(i, 52),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 4.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 52),i=1,max_shell)/ 3.181380d+04, 4.939200d+03,    
     &       4.476700d+03, 1.006000d+03, 8.442000d+02, 5.773000d+02,    
     &       1.683000d+02, 1.102000d+02, 3.980000d+01, 0.000000d+00,    
     &       1.160000d+01, 2.300000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 52),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.505000d+01, 4.505000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      53 i   iodine        atmwt:  126.9044  density:  4.9299998       
      data (shel(i, 53),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 5.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 53),i=1,max_shell)/ 3.316940d+04, 5.188100d+03,    
     &       4.704600d+03, 1.072100d+03, 9.025000d+02, 6.253000d+02,    
     &       1.864000d+02, 1.227000d+02, 4.960000d+01, 0.000000d+00,    
     &       1.360000d+01, 3.300000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 53),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.505000d+01, 4.505000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      54 xe  xenon         atmwt:  131.3000  density:  0.0058800       
      data (shel(i, 54),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 54),i=1,max_shell)/ 3.456140d+04, 5.452800d+03,    
     &       4.942900d+03, 1.140000d+03, 9.680000d+02, 6.723000d+02,    
     &       2.080000d+02, 1.467000d+02, 6.600000d+01, 0.000000d+00,    
     &       1.810000d+01, 7.800000d+00, 0.000000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 54),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.575000d+01, 4.575000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      55 cs  cesium        atmwt:  132.9050  density:  1.9000000       
      data (shel(i, 55),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 1.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 55),i=1,max_shell)/ 3.598460d+04, 5.714300d+03,    
     &       5.185600d+03, 1.217100d+03, 1.031000d+03, 7.325000d+02,    
     &       2.308000d+02, 1.669000d+02, 7.760000d+01, 0.000000d+00,    
     &       2.270000d+01, 1.220000d+01, 0.000000d+00, 0.000000d+00,    
     &       3.893000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 55),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.575000d+01, 4.575000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      56 ba  barium        atmwt:  137.3400  density:  3.5000000       
      data (shel(i, 56),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 56),i=1,max_shell)/ 3.744060d+04, 5.988800d+03,    
     &       5.435300d+03, 1.292800d+03, 1.099400d+03, 7.884000d+02,    
     &       2.530000d+02, 1.858000d+02, 9.120000d+01, 0.000000d+00,    
     &       3.910000d+01, 1.560000d+01, 0.000000d+00, 0.000000d+00,    
     &       5.210000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 56),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.575000d+01, 4.575000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      57 la  lanthanum     atmwt:  138.9100  density:  6.1500001       
      data (shel(i, 57),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    0.00d+00, 2.00d+00, 6.00d+00, 1.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 57),i=1,max_shell)/ 3.892460d+04, 6.266300d+03,    
     &       5.686600d+03, 1.361300d+03, 1.163900d+03, 8.401000d+02,    
     &       2.704000d+02, 1.986000d+02, 9.890000d+01, 0.000000d+00,    
     &       3.230000d+01, 1.440000d+01, 5.610000d+00, 0.000000d+00,    
     &       5.610000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 57),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 0.000000d+00,   
     &        4.575000d+01, 4.575000d+01, 5.400000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      58 ce  cerium        atmwt:  140.1200  density:  6.9000001       
      data (shel(i, 58),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    2.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 58),i=1,max_shell)/ 4.044300d+04, 6.548800d+03,    
     &       5.943800d+03, 1.434600d+03, 1.229100d+03, 8.923000d+02,    
     &       2.896000d+02, 2.152000d+02, 1.100000d+02, 1.000000d-01,    
     &       3.780000d+01, 1.980000d+01, 0.000000d+00, 0.000000d+00,    
     &       5.700000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 58),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.635000d+01,   
     &        4.745000d+01, 4.745000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      59 pr  praseodymium  atmwt:  140.9070  density:  6.6300001       
      data (shel(i, 59),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    3.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 59),i=1,max_shell)/ 4.199060d+04, 6.834800d+03,    
     &       6.202300d+03, 1.511000d+03, 1.289800d+03, 9.410000d+02,    
     &       3.045000d+02, 2.269000d+02, 1.132000d+02, 2.000000d+00,    
     &       3.740000d+01, 2.230000d+01, 0.000000d+00, 0.000000d+00,    
     &       5.800000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 59),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.670000d+01,   
     &        4.830000d+01, 4.830000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      60 nd  neodymium     atmwt:  144.2400  density:  7.0500002       
      data (shel(i, 60),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    4.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 60),i=1,max_shell)/ 4.356890d+04, 7.126000d+03,    
     &       6.464700d+03, 1.575300d+03, 1.350100d+03, 9.888000d+02,    
     &       3.152000d+02, 2.339000d+02, 1.175000d+02, 1.500000d+00,    
     &       3.750000d+01, 2.110000d+01, 0.000000d+00, 0.000000d+00,    
     &       5.900000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 60),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.705000d+01,   
     &        4.915000d+01, 4.915000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      61 pm  promethium    atmwt:  145.0000  density:  1.0000000       
      data (shel(i, 61),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    5.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 61),i=1,max_shell)/ 4.518400d+04, 7.427900d+03,    
     &       6.736000d+03, 1.650000d+03, 1.414100d+03, 1.039200d+03,    
     &       3.360000d+02, 2.420000d+02, 1.204000d+02, 3.500000d+00,    
     &       4.100000d+01, 2.700000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 61),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.740000d+01,   
     &        5.000000d+01, 5.000000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      62 sm  samarium      atmwt:  150.3500  density:  7.5000000       
      data (shel(i, 62),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    6.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 62),i=1,max_shell)/ 4.683420d+04, 7.736800d+03,    
     &       7.014000d+03, 1.722800d+03, 1.480200d+03, 1.093100d+03,    
     &       3.457000d+02, 2.565000d+02, 1.290000d+02, 5.500000d+00,    
     &       3.740000d+01, 2.130000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.100000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 62),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.775000d+01,   
     &        5.085000d+01, 5.085000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      63 eu  europium      atmwt:  151.9600  density:  5.2399998       
      data (shel(i, 63),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    7.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 63),i=1,max_shell)/ 4.851900d+04, 8.052000d+03,    
     &       7.297000d+03, 1.800000d+03, 1.547200d+03, 1.145700d+03,    
     &       3.602000d+02, 2.702000d+02, 1.332000d+02, 2.800000d+00,    
     &       3.180000d+01, 2.200000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.200000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 63),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.810000d+01,   
     &        5.170000d+01, 5.170000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      64 gd  gadolinium    atmwt:  157.2500  density:  7.9499998       
      data (shel(i, 64),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    7.00d+00, 2.00d+00, 6.00d+00, 1.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 64),i=1,max_shell)/ 5.023910d+04, 8.375600d+03,    
     &       7.586500d+03, 1.880800d+03, 1.616100d+03, 1.201200d+03,    
     &       3.758000d+02, 2.797000d+02, 1.405000d+02, 2.700000d+00,    
     &       3.610000d+01, 2.030000d+01, 1.020000d+00, 0.000000d+00,    
     &       6.300000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 64),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.810000d+01,   
     &        5.170000d+01, 5.170000d+01, 6.100000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      65 tb  terbium       atmwt:  158.9240  density:  8.2720003       
      data (shel(i, 65),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    9.00d+00, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 65),i=1,max_shell)/ 5.199570d+04, 8.708000d+03,    
     &       7.882800d+03, 1.967500d+03, 1.689500d+03, 1.258100d+03,    
     &       3.979000d+02, 3.476000d+02, 1.470000d+02, 2.600000d+00,    
     &       3.900000d+01, 2.540000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.400000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 65),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.880000d+01,   
     &        5.340000d+01, 5.340000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      66 dy  dysprosium    atmwt:  162.5000  density:  8.5600004       
      data (shel(i, 66),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.00d+01, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 66),i=1,max_shell)/ 5.378850d+04, 9.045800d+03,    
     &       8.185300d+03, 2.046800d+03, 1.758700d+03, 1.313700d+03,    
     &       4.163000d+02, 3.123000d+02, 1.542000d+02, 4.200000d+00,    
     &       6.290000d+01, 2.630000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.500000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 66),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.915000d+01,   
     &        5.425000d+01, 5.425000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      67 ho  holmium       atmwt:  164.9300  density:  8.8030005       
      data (shel(i, 67),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.10d+01, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 67),i=1,max_shell)/ 5.561770d+04, 9.394200d+03,    
     &       8.494400d+03, 2.128300d+03, 1.832000d+03, 1.371400d+03,    
     &       4.357000d+02, 3.250000d+02, 1.610000d+02, 3.700000d+00,    
     &       5.120000d+01, 2.030000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.600000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 67),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.950000d+01,   
     &        5.510000d+01, 5.510000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      68 er  erbium        atmwt:  167.2600  density:  9.0509996       
      data (shel(i, 68),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.20d+01, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 68),i=1,max_shell)/ 5.748550d+04, 9.751300d+03,    
     &       8.811100d+03, 2.206500d+03, 1.908800d+03, 1.431300d+03,    
     &       4.491000d+02, 3.431000d+02, 1.721000d+02, 4.300000d+00,    
     &       5.980000d+01, 2.940000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.700000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 68),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 4.985000d+01,   
     &        5.595000d+01, 5.595000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      69 tm  thulium       atmwt:  168.9340  density:  9.3500004       
      data (shel(i, 69),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.30d+01, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 69),i=1,max_shell)/ 5.938960d+04, 1.011570d+04,    
     &       9.132400d+03, 2.306800d+03, 1.987100d+03, 1.491100d+03,    
     &       4.717000d+02, 3.612000d+02, 1.796000d+02, 5.300000d+00,    
     &       5.320000d+01, 3.230000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.800000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 69),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.020000d+01,   
     &        5.680000d+01, 5.680000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      70 yb  ytterbium     atmwt:  173.0400  density:  7.0100002       
      data (shel(i, 70),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 0.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 70),i=1,max_shell)/ 6.133230d+04, 1.048640d+04,    
     &       9.460900d+03, 2.398100d+03, 2.061400d+03, 1.552000d+03,    
     &       4.872000d+02, 3.701000d+02, 1.915000d+02, 6.300000d+00,    
     &       5.410000d+01, 2.340000d+01, 0.000000d+00, 0.000000d+00,    
     &       6.900000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 70),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 0.000000d+00, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      71 lu  lutetium      atmwt:  174.9700  density:  9.8719997       
      data (shel(i, 71),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 71),i=1,max_shell)/ 6.331380d+04, 1.087040d+04,    
     &       9.796300d+03, 2.491200d+03, 2.143500d+03, 1.613900d+03,    
     &       5.062000d+02, 3.847000d+02, 1.999000d+02, 6.900000d+00,    
     &       5.680000d+01, 2.800000d+01, 1.414000d+00, 0.000000d+00,    
     &       7.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 71),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.800000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      72 hf  hafnium       atmwt:  178.4900  density: 13.2900000       
      data (shel(i, 72),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 2.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 72),i=1,max_shell)/ 6.535080d+04, 1.127070d+04,    
     &       1.015000d+04, 2.600900d+03, 2.236500d+03, 1.689000d+03,    
     &       5.381000d+02, 4.087000d+02, 2.187000d+02, 1.710000d+01,    
     &       6.490000d+01, 3.430000d+01, 3.199000d+00, 0.000000d+00,    
     &       7.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 72),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.835000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      73 ta  tantalum      atmwt:  180.9480  density: 16.6000004       
      data (shel(i, 73),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 3.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 73),i=1,max_shell)/ 6.741640d+04, 1.168150d+04,    
     &       1.050860d+04, 2.708000d+03, 2.331300d+03, 1.763600d+03,    
     &       5.655000d+02, 4.346000d+02, 2.353000d+02, 2.500000d+01,    
     &       7.110000d+01, 4.060000d+01, 5.700000d+00, 0.000000d+00,    
     &       7.880000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 73),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.870000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      74 w   tungsten      atmwt:  183.8500  density: 19.2999992       
      data (shel(i, 74),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 4.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 74),i=1,max_shell)/ 6.952500d+04, 1.209980d+04,    
     &       1.087540d+04, 2.819600d+03, 2.427900d+03, 1.840400d+03,    
     &       5.950000d+02, 4.584000d+02, 2.521000d+02, 3.500000d+01,    
     &       7.710000d+01, 4.120000d+01, 6.100000d+00, 0.000000d+00,    
     &       7.980000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 74),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.905000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      75 re  rhenium       atmwt:  186.2000  density: 21.0200005       
      data (shel(i, 75),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 5.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 75),i=1,max_shell)/ 7.167640d+04, 1.252670d+04,    
     &       1.124700d+04, 2.931700d+03, 2.524400d+03, 1.915900d+03,    
     &       6.250000d+02, 4.811000d+02, 2.669000d+02, 4.060000d+01,    
     &       8.280000d+01, 4.010000d+01, 3.500000d+00, 0.000000d+00,    
     &       7.870000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 75),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.940000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      76 os  osmium        atmwt:  190.2000  density: 22.5000000       
      data (shel(i, 76),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 6.00d+00, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 76),i=1,max_shell)/ 7.387080d+04, 1.296800d+04,    
     &       1.162795d+04, 3.048500d+03, 2.624700d+03, 1.995400d+03,    
     &       6.543000d+02, 5.023000d+02, 2.811000d+02, 4.630000d+01,    
     &       8.370000d+01, 5.170000d+01, 3.650000d+00, 0.000000d+00,    
     &       8.700000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 76),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 6.975000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      77 ir  iridium       atmwt:  192.2000  density: 22.5000000       
      data (shel(i, 77),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 9.00d+00, 0.00d+00, 0.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 77),i=1,max_shell)/ 7.611100d+04, 1.341850d+04,    
     &       1.201960d+04, 3.173700d+03, 2.729300d+03, 2.078200d+03,    
     &       6.901000d+02, 5.357000d+02, 3.031000d+02, 6.190000d+01,    
     &       9.520000d+01, 5.670000d+01, 3.800000d+00, 0.000000d+00,    
     &       0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 77),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.010000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      78 pt  platinum      atmwt:  195.0900  density: 21.4500008       
      data (shel(i, 78),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 9.00d+00, 0.00d+00, 1.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 78),i=1,max_shell)/ 7.839480d+04, 1.387990d+04,    
     &       1.241810d+04, 3.296000d+03, 2.830900d+03, 2.161700d+03,    
     &       7.220000d+02, 5.641000d+02, 3.220000d+02, 7.270000d+01,    
     &       1.017000d+02, 5.850000d+01, 2.200000d+00, 0.000000d+00,    
     &       2.200000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 78),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.080000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      79 au  gold          atmwt:  196.9670  density: 19.3199997       
      data (shel(i, 79),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 1.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 79),i=1,max_shell)/ 8.072490d+04, 1.435280d+04,    
     &       1.282610d+04, 3.424900d+03, 2.810400d+03, 2.248400d+03,    
     &       7.588000d+02, 5.946000d+02, 3.429000d+02, 8.460000d+01,    
     &       1.078000d+02, 6.270000d+01, 2.500000d+00, 0.000000d+00,    
     &       2.125000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 79),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      80 hg  mercury       atmwt:  200.5900  density: 13.5500002       
      data (shel(i, 80),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    0.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 80),i=1,max_shell)/ 8.310280d+04, 1.483930d+04,    
     &       1.324630d+04, 3.561600d+03, 3.062800d+03, 2.339900d+03,    
     &       8.003000d+02, 6.239000d+02, 3.690000d+02, 1.003000d+02,    
     &       1.203000d+02, 6.900000d+01, 6.400000d+00, 0.000000d+00,    
     &       2.050000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 80),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      81 tl  thallium      atmwt:  204.3700  density: 11.8500004       
      data (shel(i, 81),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    1.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 81),i=1,max_shell)/ 8.553040d+04, 1.534670d+04,    
     &       1.367770d+04, 3.704100d+03, 3.186100d+03, 2.677400d+03,    
     &       8.455000d+02, 6.651000d+02, 3.874000d+02, 1.206000d+02,    
     &       1.363000d+02, 8.750000d+01, 1.420000d+01, 0.000000d+00,    
     &       9.820984d+00, 5.325640d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 81),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      82 pb  lead          atmwt:  207.1900  density: 11.3400002       
      data (shel(i, 82),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    2.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 82),i=1,max_shell)/ 8.800450d+04, 1.586080d+04,    
     &       1.411760d+04, 3.850700d+03, 3.310300d+03, 2.775100d+03,    
     &       8.936000d+02, 7.042000d+02, 4.240000d+02, 1.405000d+02,    
     &       1.473000d+02, 9.540000d+01, 2.050000d+01, 0.000000d+00,    
     &       1.247910d+01, 6.522878d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 82),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      83 bi  bismuth       atmwt:  208.9800  density:  9.8000002       
      data (shel(i, 83),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    3.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 83),i=1,max_shell)/ 9.052590d+04, 1.638750d+04,    
     &       1.456480d+04, 3.999100d+03, 3.436600d+03, 2.878200d+03,    
     &       9.382000d+02, 7.420000d+02, 4.518000d+02, 1.596000d+02,    
     &       1.593000d+02, 1.048000d+02, 2.540000d+01, 0.000000d+00,    
     &       1.517993d+01, 7.783154d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 83),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      84 po  polonium      atmwt:  210.0000  density:  9.2399998       
      data (shel(i, 84),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    4.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 84),i=1,max_shell)/ 9.310500d+04, 1.693930d+04,    
     &       1.502900d+04, 4.149400d+03, 2.578000d+03, 2.740500d+03,    
     &       9.953000d+02, 7.780000d+02, 2.618000d+02, 1.780000d+02,    
     &       1.710000d+02, 1.205000d+02, 3.140000d+01, 0.000000d+00,    
     &       1.795434d+01, 9.047603d+00, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 84),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      85 at  astatine      atmwt:  210.0000  density:  1.0000000       
      data (shel(i, 85),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    5.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 85),i=1,max_shell)/ 9.572990d+04, 1.749300d+04,    
     &       1.549910d+04, 4.317000d+03, 3.717000d+03, 2.847700d+03,    
     &       1.042000d+03, 8.130000d+02, 5.332000d+02, 1.980000d+02,    
     &       1.850000d+02, 1.305000d+02, 3.500000d+01, 0.000000d+00,    
     &       2.081512d+01, 1.033083d+01, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 85),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      86 rn  radon         atmwt:  222.0000  density:  0.0097300       
      data (shel(i, 86),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 0.00d+00/                                 
      data (eshel(i, 86),i=1,max_shell)/ 9.840400d+04, 1.804900d+04,    
     &       1.597820d+04, 4.482000d+03, 3.848500d+03, 2.956900d+03,    
     &       1.097000d+03, 8.485000d+02, 5.666000d+02, 2.210000d+02,    
     &       2.000000d+02, 1.400000d+02, 4.100000d+01, 0.000000d+00,    
     &       2.376976d+01, 1.168082d+01, 0.000000d+00, 0.000000d+00/    
      data (slater(i, 86),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      87 fr  francium      atmwt:  223.0000  density:  1.0000000       
      data (shel(i, 87),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 1.00d+00/                                 
      data (eshel(i, 87),i=1,max_shell)/ 1.011370d+05, 1.863900d+04,    
     &       1.646880d+04, 4.652000d+03, 3.995000d+03, 3.068000d+03,    
     &       1.153000d+03, 8.950000d+02, 5.901000d+02, 2.430000d+02,    
     &       2.150000d+02, 1.505000d+02, 4.700000d+01, 0.000000d+00,    
     &       3.065796d+01, 1.709332d+01, 0.000000d+00, 3.206738d+00/    
      data (slater(i, 87),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      88 ra  radium        atmwt:  226.1100  density:  5.0000000       
      data (shel(i, 88),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i, 88),i=1,max_shell)/ 1.039219d+05, 1.923670d+04,    
     &       1.696430d+04, 4.822000d+03, 4.140600d+03, 3.176600d+03,    
     &       1.208400d+03, 9.680000d+02, 6.193000d+02, 2.989000d+02,    
     &       2.544000d+02, 1.766000d+02, 6.720000d+01, 0.000000d+00,    
     &       3.727737d+01, 2.229600d+01, 0.000000d+00, 4.045973d+00/    
      data (slater(i, 88),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      89 ac  actinium      atmwt:  227.0000  density: 10.0699997       
      data (shel(i, 89),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 89),i=1,max_shell)/ 1.067553d+05, 1.984000d+04,    
     &       1.747710d+04, 5.002000d+03, 4.282500d+03, 3.294600d+03,    
     &       1.269000d+03, 9.850000d+02, 6.749000d+02, 3.194000d+02,    
     &       2.490000d+02, 1.911000d+02, 6.200000d+01, 0.000000d+00,    
     &       4.176300d+01, 2.572710d+01, 6.839527d+00, 4.378916d+00/    
      data (slater(i, 89),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      90 th  thorium       atmwt:  232.0380  density: 11.5000000       
      data (shel(i, 90),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 0.00d+00, 2.00d+00,   
     &    6.00d+00, 2.00d+00, 2.00d+00/                                 
      data (eshel(i, 90),i=1,max_shell)/ 1.096509d+05, 2.047210d+04,    
     &       1.799670d+04, 5.182300d+03, 4.438200d+03, 3.411400d+03,    
     &       1.329500d+03, 1.067700d+03, 6.952000d+02, 3.398000d+02,    
     &       2.902000d+02, 2.056000d+02, 9.110000d+01, 0.000000d+00,    
     &       4.604696d+01, 2.903428d+01, 8.045585d+00, 4.644417d+00/    
      data (slater(i, 90),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 0.000000d+00,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      91 pa  protactinium  atmwt:  231.0000  density: 15.3699999       
      data (shel(i, 91),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 91),i=1,max_shell)/ 1.126014d+05, 2.110460d+04,    
     &       1.852340d+04, 5.366900d+03, 4.587300d+03, 3.526500d+03,    
     &       1.387100d+03, 1.115500d+03, 7.258000d+02, 3.653500d+02,    
     &       3.096000d+02, 2.229000d+02, 9.410000d+01, 4.100000d+01,    
     &       4.453813d+01, 2.744113d+01, 6.151785d+00, 4.486076d+00/    
      data (slater(i, 91),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 7.835000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      92 u   uranium       atmwt:  238.0300  density: 18.7000008       
      data (shel(i, 92),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 3.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 92),i=1,max_shell)/ 1.156061d+05, 2.175740d+04,    
     &       1.905690d+04, 5.548000d+03, 4.742800d+03, 3.639600d+03,    
     &       1.440800d+03, 1.158700d+03, 7.590000d+02, 3.861000d+02,    
     &       3.237000d+02, 2.272000d+02, 1.006000d+02, 4.000000d+01,    
     &       4.575399d+01, 2.816893d+01, 7.248821d+00, 4.534187d+00/    
      data (slater(i, 92),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 7.870000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      93 np  neptunium     atmwt:  236.0000  density: 19.5000000       
      data (shel(i, 93),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 4.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 93),i=1,max_shell)/ 1.186780d+05, 2.242680d+04,    
     &       1.960530d+04, 5.723200d+03, 4.900400d+03, 3.758000d+03,    
     &       1.500700d+03, 1.207200d+03, 7.931000d+02, 4.092000d+02,    
     &       2.840600d+02, 2.447000d+02, 1.053000d+02, 1.891800d+01,    
     &       4.689330d+01, 2.883935d+01, 7.319500d+00, 4.580142d+00/    
      data (slater(i, 93),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 7.905000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      94 pu  plutonium     atmwt:  239.5000  density:  1.0000000       
      data (shel(i, 94),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 6.00d+00, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i, 94),i=1,max_shell)/ 1.218180d+05, 2.309720d+04,    
     &       1.016150d+04, 5.932900d+03, 5.048900d+03, 3.785300d+03,    
     &       1.558600d+03, 1.243400d+03, 8.251000d+02, 4.391000d+02,    
     &       3.519000d+02, 2.403000d+02, 1.107000d+02, 1.578587d+01,    
     &       4.473443d+01, 2.671669d+01, 0.000000d+00, 4.357530d+00/    
      data (slater(i, 94),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 7.940000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      95 am  americium     atmwt:  241.5000  density: 11.6999998       
      data (shel(i, 95),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 7.00d+00, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i, 95),i=1,max_shell)/ 1.250270d+05, 2.377290d+04,    
     &       2.072400d+04, 6.120500d+03, 5.188600d+03, 3.989500d+03,    
     &       1.617100d+03, 1.273700d+03, 8.531000d+02, 5.193597d+02,    
     &       2.986612d+02, 2.393917d+02, 1.341365d+02, 1.716888d+01,    
     &       4.566691d+01, 2.722132d+01, 0.000000d+00, 4.396543d+00/    
      data (slater(i, 95),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 7.975000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      96 cm  curium        atmwt:  244.0000  density:  1.0000000       
      data (shel(i, 96),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 7.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 96),i=1,max_shell)/ 1.282200d+05, 2.446000d+04,    
     &       2.135450d+04, 6.288000d+03, 5.346000d+03, 4.099000d+03,    
     &       1.643000d+03, 1.297000d+03, 9.317500d+02, 5.528479d+02,    
     &       3.149589d+02, 2.541209d+02, 1.457501d+02, 2.365988d+01,    
     &       4.998929d+01, 3.071444d+01, 7.419701d+00, 4.709437d+00/    
      data (slater(i, 96),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.010000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      97 bk  berkelium     atmwt:  246.5000  density:  1.8200001       
      data (shel(i, 97),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 8.00d+00, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i, 97),i=1,max_shell)/ 1.315900d+05, 2.527500d+04,    
     &       2.191850d+04, 6.556000d+03, 5.562000d+03, 4.249000d+03,    
     &       1.755000d+03, 1.394500d+03, 9.667255d+02, 5.803174d+02,    
     &       3.251598d+02, 2.629126d+02, 1.519194d+02, 2.518271d+01,    
     &       5.094308d+01, 3.113784d+01, 7.425603d+00, 4.750665d+00/    
      data (slater(i, 97),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.045000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      98 cf  californium   atmwt:  249.0000  density:  1.0000000       
      data (shel(i, 98),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.00d+01, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i, 98),i=1,max_shell)/ 1.359600d+05, 2.611000d+04,    
     &       2.259000d+04, 6.754000d+03, 5.734000d+03, 4.375000d+03,    
     &       1.799000d+03, 1.447500d+03, 9.949350d+02, 6.011509d+02,    
     &       3.287153d+02, 2.652231d+02, 1.521090d+02, 2.115171d+01,    
     &       4.823654d+01, 2.856410d+01, 0.000000d+00, 4.505117d+00/    
      data (slater(i, 98),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.080000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!      99 es  einsteinium   atmwt:  252.0000  density:  1.0000000       
      data (shel(i, 99),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.10d+01, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i, 99),i=1,max_shell)/ 1.394900d+05, 2.690000d+04,    
     &       2.321500d+04, 6.977000d+03, 5.913000d+03, 4.502000d+03,    
     &       1.868000d+03, 1.500500d+03, 1.030351d+03, 6.291335d+02,    
     &       3.386902d+02, 2.738072d+02, 1.580945d+02, 2.243757d+01,    
     &       4.976088d+01, 2.896738d+01, 0.000000d+00, 4.539206d+00/    
      data (slater(i, 99),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.115000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!     100 fm  fermium       atmwt:  255.0000  density:  1.0000000       
      data (shel(i,100),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.20d+01, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i,100),i=1,max_shell)/ 1.430900d+05, 2.770000d+04,    
     &       2.385500d+04, 7.205000d+03, 6.095000d+03, 4.632000d+03,    
     &       1.937000d+03, 1.556500d+03, 1.066157d+03, 6.574910d+02,    
     &       3.486600d+02, 2.823725d+02, 1.641291d+02, 2.370735d+01,    
     &       4.980909d+01, 2.935301d+01, 0.000000d+00, 4.572398d+00/    
      data (slater(i,100),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.150000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!     101 md  mendelevium   atmwt:  256.0000  density:  1.0000000       
      data (shel(i,101),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.30d+01, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i,101),i=1,max_shell)/ 1.467800d+05, 2.853000d+04,    
     &       2.450000d+04, 7.441000d+03, 6.282500d+03, 4.762500d+03,    
     &       2.010000d+03, 1.612000d+03, 1.102359d+03, 6.862322d+02,    
     &       3.586338d+02, 2.909509d+02, 1.700962d+02, 2.496196d+01,    
     &       5.056311d+01, 2.972275d+01, 0.000000d+00, 4.604774d+00/    
      data (slater(i,101),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.185000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!     102 no  nobelium      atmwt:  257.0000  density:  1.0000000       
      data (shel(i,102),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.40d+01, 2.00d+00,   
     &    6.00d+00, 0.00d+00, 2.00d+00/                                 
      data (eshel(i,102),i=1,max_shell)/ 1.505400d+05, 2.938000d+04,    
     &       2.516000d+04, 7.675000d+03, 6.466500d+03, 4.889000d+03,    
     &       2.078000d+03, 1.662000d+03, 1.138966d+03, 7.153544d+02,    
     &       3.686172d+02, 2.995406d+02, 1.761215d+02, 2.620301d+01,    
     &       5.129894d+01, 3.007841d+01, 0.000000d+00, 4.636457d+00/    
      data (slater(i,102),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.220000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
!     103 lw  lawrencium    atmwt:  258.0000  density:  1.0000000       
      data (shel(i,103),i=1,max_shell)/ 2.00d+00, 2.00d+00, 6.00d+00,   
     &    2.00d+00, 6.00d+00, 1.00d+01, 2.00d+00, 6.00d+00, 1.00d+01,   
     &    1.40d+01, 2.00d+00, 6.00d+00, 1.00d+01, 1.40d+01, 2.00d+00,   
     &    6.00d+00, 1.00d+00, 2.00d+00/                                 
      data (eshel(i,103),i=1,max_shell)/ 1.543800d+05, 3.024000d+04,    
     &       2.582000d+04, 7.900000d+03, 6.585000d+03, 5.005000d+03,    
     &       2.140000d+03, 1.705000d+03, 1.184044d+03, 7.528936d+02,    
     &       3.861821d+02, 3.155453d+02, 1.890647d+02, 3.395034d+01,    
     &       5.615359d+01, 3.392451d+01, 7.272140d+00, 4.984900d+00/    
      data (slater(i,103),i=1,max_shell)/ 3.000000d-01, 4.150000d+00,   
     &        4.150000d+00, 1.125000d+01, 1.125000d+01, 2.115000d+01,   
     &        2.765000d+01, 2.765000d+01, 3.915000d+01, 5.055000d+01,   
     &        5.765000d+01, 5.765000d+01, 7.115000d+01, 8.255000d+01,   
     &        0.000000d+00, 0.000000d+00, 0.000000d+00, 0.000000d+00/   
      end                                                               
*
************************************************************************
*
      function del1 (betasq,avz,at_den,bari_ln,jj)                      
!                                                                       
!     density effect correction Sternheimer                             
!                                                                       
!         betasq = (v/c)**2 for the projectile                          
!         avz = <Z> for the medium                                      
!             = SUM fme_(i)z_(i)                                        
!         at_den = atomic density (1/barn-cm)                           
!         bari_ln = <ln I> with I in MeV                                
!                 = SUM fme_(i)z_(i) ln I(i) /<Z>                       
!         jj:                                                           
!            jj=1 gaseous element                                       
!            jj=2 condensed element                                     
!            jj=3 gaseous mixture                                       
!            jj=4 condensed mixture                                     
!                                                                       
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      parameter (emass=0.5109990615d0)                                  
      parameter (el_rad=0.28179409238d0)                                
      parameter (alpfsc=7.2973530791728595d-03)                         
      parameter (del_con1=dp4*dppi*el_rad**3*(emass/alpfsc)**2*1.d-12)  
      parameter (ten_ln=2.3025851d0)                                    
      parameter (del_con2=dp1/ten_ln)                                   
      parameter (del_con3=dp2*ten_ln)                                   
      etasq=betasq/(dp1-betasq)                                         
      bari_ev=1.d+6*exp(bari_ln)                                        
      cb=dp1-log(del_con1*avz*at_den)+dp2*bari_ln                       
      if (mod(jj,2).eq.0) then                                          
        xb=dp2+min(1,int(bari_ev/100.d0))                               
        xa=max(0.2d0,0.326d0*cb-dph*xb)                                 
      else                                                              
        xb=dp4+min(1,int(cb/12.25d0))                                   
        xa=max(0.1d0*min(20,max(16,int(dp2*cb)-3)),0.326d0*cb-dph*xb)   
      endif                                                             
      x=del_con2*dph*log(etasq)                                         
      if (x.gt.xa) then                                                 
        del=del_con3*x-cb+(cb-del_con3*xa)*((xb-min(x,xb))/(xb-xa))**3  
        del=max(del,dp0)                                                
      else                                                              
        del=dp0                                                         
      endif                                                             
      del1=del                                                          
      return                                                            
      end                                                               
*
************************************************************************
*
      function eta (z,numshl,betasq)                                    
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this routine computes the eta value using           
!                   the physics in :                                    
!                                                                       
!                     h. bichsel, passage of charged particles through  
!                     matter, in american institute of physics handbook,
!                     third edition (d. gray, ed.), mcgraw-hill book    
!                     company inc., new york (1972).                    
!                                                                       
!                   eta is calculated from equation 3.13 of the above   
!                   reference, the relativistic correction, 1.0/(1.0-bet
!                   recommended by bichsel has been applied.            
!                                                                       
!        author :   daniel pickens / joe janni                          
!                   computer sciences corporation  / afwl               
!                   10 september 1983                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   numshl - the shell number, values from 1 to 18.     
!                            (max_shell = 18 in block8.h)               
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  eta    - the eta value                              
!                                                                       
!        errors :   stop 'eta is le zero in function eta'               
!                                                                       
      parameter (emass=0.5109990615d0)                                  
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
!                                                                       
!        compute the eta value remembering to multiply by 10**6,        
!        (1000000), inorder to convert to the same units.               
!                                                                       
      iz=nint(z)                                                        
      eta=emass*1000000.0*betasq/(2.0*eshel(1,1)*(1.0-betasq)*(z-slater 
     & (numshl,iz))**2)                                                 
!                                                                       
!        check the bounds of the eta value, if zero or negative,        
!        then an error has resulted, so print a error message out       
!        and stop.                                                      
!                                                                       
      if (eta.le.0.0) stop 'eta is le zero in function eta'             
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function f_linhard (betasq,avz)                                   
!                                                                       
!         betasq = (v/c)**2 for the projectile                          
!         avz = <Z> for the medium                                      
!             = SUM fme_(i)z_(i)                                        
!         f_linhard = calculated value of shell correction              
!                                                                       
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
      parameter (alpfsc=7.2973530791728595d-03)                         
      parameter (prot_mass=938.2723128d0)                               
      parameter (cutoff=(dp1+8.d0/prot_mass)**2)                        
      data zal /12.95d0/, zh2o /3.34d0/                                 
      data p1, p2, p3, p4, p5 /4.774248d-4,1.143478d-3,-5.633920d-2,4.76
     & 3953d-1,4.844536d-1/                                             
      data w1, w2, w3, w4, w5, w6, w7, w8 /-1.819954d-6,-2.232760d-5,1.2
     & 19912d-4,1.837873d-3,-4.457574d-3,-6.837103d-2,5.266586d-1,3.7437
     & 15d-1/                                                           
!-----------------------------------------------------------------------
      y=log(betasq/(avz*alpfsc**2))                                     
      if (avz.gt.zal) go to 10                                          
      xl1=exp(w1*y**7+w2*y**6+w3*y**5+w4*y**4+w5*y**3+w6*y**2+w7*y+w8)  
      if (avz.gt.zh2o) go to 10                                         
      xl=xl1                                                            
      go to 20                                                          
   10 continue                                                          
      xl=exp(p1*y**4+p2*y**3+p3*y**2+p4*y+p5)                           
      if (avz.gt.zal) go to 20                                          
      xl2=xl                                                            
      xl=xl1+(avz-zh2o)/(zal-zh2o)*(xl2-xl1)                            
   20 continue                                                          
      f_linhard=xl                                                      
      return                                                            
      end                                                               
*
************************************************************************
*
      function shelbl (z,betasq,cl1,cl2,ptraut)                         
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell correction       
!                   using the physics discribed in reference 138.       
!                                                                       
!                     h. bichsel, "the l-shell correction in            
!                     stopping power," usc-136-120 (1967).              
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   13 may 1984                                         
!                                                                       
!        inputs :   iz     - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable, if true then author and 
!                            reference information is written to scratch
!                                                                       
!        outputs :  shelbl - the l-shell correction as computed using   
!                            Bichsel method and data.                   
!                   cl1    - the l-shell, s-subshell correction.        
!                   cl2    - the l-shell, p-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd1(2), thtgd(7), shllgd(112,7), s(7), t(7), u(7), v(
     & 7), etagd2(112), b(2,7)                                          
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
      data etagd1 /0.0,0.01/                                            
!                                                                       
      data thtgd /0.35,0.40,0.45,0.50,0.55,0.60,0.65/                   
!                                                                       
      data s /10.0371,8.8015,7.9116,7.2501,6.7451,6.3503,6.0345/        
      data t /28.1449,26.1070,24.4501,23.0729,21.9061,20.8993,20.0154/  
      data u /1.503,1.732,1.876,1.955,1.989,1.999,2.004/                
      data v /1.543,1.520,1.506,1.500,1.498,1.499,1.500/                
      data w /4.0/                                                      
      data x /4.43/                                                     
!                                                                       
      data (b(i,1),i=1,2) /0.0000,0.0442/                               
      data (b(i,2),i=1,2) /0.0000,0.0291/                               
      data (b(i,3),i=1,2) /0.0000,0.9184/                               
      data (b(i,4),i=1,2) /0.0000,0.0131/                               
      data (b(i,5),i=1,2) /0.0000,0.0090/                               
      data (b(i,6),i=1,2) /0.0000,0.0063/                               
      data (b(i,7),i=1,2) /0.0000,0.0044/                               
!                                                                       
      data etagd2 /0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.10,0.1
     & 1,0.12,0.13,0.14,0.15,0.20,0.25,0.30,0.35,0.40,0.45,0.50,0.55,0.6
     & 0,0.65,0.70,0.75,0.80,0.85,0.90,0.95,1.00,1.05,1.10,1.15,1.20,1.2
     & 5,1.30,1.35,1.40,1.45,1.50,1.55,1.60,1.65,1.70,1.75,1.80,1.85,1.9
     & 0,1.95,2.00,2.05,2.10,2.15,2.20,2.25,2.30,2.35,2.40,2.45,2.50,2.5
     & 5,2.60,2.65,2.70,2.75,2.80,2.85,2.90,2.95,3.00,3.05,3.10,3.15,3.2
     & 0,3.25,3.30,3.35,3.40,3.45,3.50,3.55,3.60,3.65,3.70,3.75,3.80,3.8
     & 5,3.90,3.95,4.00,4.05,4.10,4.15,4.20,4.25,4.30,4.35,4.40,4.45,4.5
     & 0,4.55,4.60,4.65,4.70,4.75,4.80,4.85,4.90,4.95,5.00/             
!                                                                       
!        theta is 0.350.                                                
!                                                                       
      data (shllgd(i,1),i=1,112) /-18.1218,-11.3605,-7.6084,-5.1188,-3.3
     & 297,-1.9845,-0.19434,-0.1217,0.5361,1.0680,1.5012,1.8558,2.1471,2
     & .3867,2.5837,3.1427,3.3055,3.2900,3.1926,3.0592,2.9128,2.7650,2.6
     & 217,2.4858,2.3584,2.2398,2.1298,2.0278,1.9335,1.8461,1.7651,1.690
     & 0,1.6202,1.5552,1.4947,1.4382,1.3854,1.3359,1.2896,1.2460,1.2051,
     & 1.1665,1.1301,1.0958,1.0633,1.0326,1.0034,0.9757,0.9494,0.9244,0.
     & 9006,0.8779,0.8563,0.8356,0.8158,0.7969,0.7788,0.7615,0.7449,0.72
     & 89,0.7136,0.6989,0.6847,0.6711,0.6579,0.6453,0.6331,0.6213,0.6100
     & ,0.5990,0.5884,0.5781,0.5682,0.5586,0.5494,0.5403,0.5316,0.5232,0
     & .5150,0.5070,0.4993,0.4918,0.4845,0.4774,0.4705,0.4638,0.4573,0.4
     & 509,0.4447,0.4387,0.4329,0.4271,0.4216,0.4161,0.4108,0.4057,0.400
     & 6,0.3957,0.3909,0.3862,0.3816,0.3771,0.3727,0.3684,0.3642,0.3601,
     & 0.3561,0.3522,0.3483,0.3446,0.3409,0.3373/                       
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (shllgd(i,2),i=1,112) /-14.4545,-8.5037,-5.1970,-3.0059,-1.43
     & 66,-0.2626,0.6400,1.3467,1.9069,2.3547,2.7145,3.0044,3.2380,3.425
     & 9,3.5762,3.9554,3.9956,3.8906,3.7247,3.5372,3.3468,3.1626,2.9887,
     & 2.8266,2.6765,2.5381,2.4107,2.2933,2.1851,2.0853,1.9931,1.9077,1.
     & 8286,1.7551,1.6868,1.6231,1.5635,1.5079,1.4558,1.4068,1.3608,1.31
     & 75,1.2767,1.2382,1.2017,1.1673,1.1346,1.1036,1.0741,1.0461,1.0195
     & ,0.9941,0.9698,0.9467,0.9246,0.9034,0.8831,0.8637,0.8451,0.8272,0
     & .8101,0.7936,0.7778,0.7625,0.7478,0.7336,0.7200,0.7068,0.6941,0.6
     & 818,0.6699,0.6584,0.6473,0.6366,0.6262,0.6161,0.6063,0.5968,0.587
     & 6,0.5787,0.5700,0.5616,0.5534,0.5455,0.5378,0.5302,0.5229,0.5158,
     & 0.5089,0.5021,0.4955,0.4891,0.4829,0.4768,0.4708,0.4650,0.4594,0.
     & 4538,0.4484,0.4431,0.4380,0.4329,0.4280,0.4232,0.4185,0.4139,0.40
     & 94,0.4049,0.4006,0.3964,0.3923,0.3882/                           
!                                                                       
!        theta is 0.450.                                                
!                                                                       
      data (shllgd(i,3),i=1,112) /-12.0035,-6.6343,-3.6427,-1.6597,-0.24
     & 15,0.8162,1.6257,2.2557,2.7513,3.1439,3.4558,3.7037,3.9001,4.0547
     & ,4.1752,4.4406,4.4042,4.2439,4.0360,3.8154,3.5983,3.3921,3.1997,3
     & .0218,2.8582,2.7080,2.5701,2.4434,2.3270,2.2198,2.1209,2.0295,1.9
     & 448,1.8663,1.7932,1.7252,1.6617,1.6024,1.5468,1.4947,1.4457,1.399
     & 6,1.3561,1.3151,1.2763,1.2396,1.2049,1.1719,1.1406,1.1108,1.0824,
     & 1.0554,1.0296,1.0050,0.9814,0.9589,0.9374,0.9167,0.8969,0.8779,0.
     & 8597,0.8422,0.8253,0.8090,0.7934,0.7783,0.7638,0.7498,0.7362,0.72
     & 32,0.7105,0.6983,0.6865,0.6750,0.6640,0.6532,0.6428,0.6327,0.6229
     & ,0.6134,0.6042,0.5952,0.5865,0.5781,0.5698,0.5618,0.5540,0.5464,0
     & .5390,0.5318,0.5248,0.5180,0.5113,0.5048,0.4985,0.4923,0.4862,0.4
     & 803,0.4746,0.4689,0.4634,0.4581,0.4528,0.4476,0.4426,0.4377,0.432
     & 9,0.4282,0.4235,0.4190,0.4146,0.4103/                            
!                                                                       
!        theta is 0.50.                                                 
!                                                                       
      data (shllgd(i,4),i=1,112) /-10.3281,-5.3904,-2.6292,-0.7955,0.516
     & 1,1.4929,2.2386,2.8167,3.2692,3.6252,3.9056,4.1261,4.2984,4.4317,
     & 4.5331,4.7269,4.6432,4.4492,4.2160,3.9756,3.7427,3.5236,3.3203,3.
     & 1332,2.9617,2.8046,2.6607,2.5287,2.4076,2.2961,2.1933,2.0985,2.01
     & 06,1.9292,1.8535,1.7830,1.7173,1.6558,1.5983,1.5443,1.4937,1.4460
     & ,1.4010,1.3586,1.3185,1.2806,1.2446,1.2105,1.1781,1.1473,1.1180,1
     & .0901,1.0634,1.0380,1.0137,0.9904,0.9681,0.9468,0.9263,0.9067,0.8
     & 878,0.8697,0.8523,0.8355,0.8193,0.8037,0.7887,0.7742,0.7602,0.746
     & 7,0.7336,0.7210,0.7088,0.6970,0.6855,0.6744,0.6636,0.6532,0.6431,
     & 0.6333,0.6237,0.6145,0.6054,0.5967,0.5882,0.5799,0.5718,0.5640,0.
     & 5563,0.5489,0.5416,0.5346,0.5276,0.5209,0.5144,0.5080,0.5017,0.49
     & 56,0.4896,0.4838,0.4781,0.4726,0.4671,0.4618,0.4566,0.4515,0.4465
     & ,0.4416,0.4369,0.4322,0.4276,0.4231/                             
!                                                                       
!        theta is 0.550.                                                
!                                                                       
      data (shllgd(i,5),i=1,112) /-9.1652,-4.5568,-1.9690,-0.2453,0.9894
     & ,1.9092,2.6107,3.1534,3.5770,3.9087,4.1687,4.3715,4.5285,4.6482,4
     & .7376,4.8875,4.7757,4.5621,4.3145,4.0630,3.8213,3.5950,3.3858,3.1
     & 937,3.0179,2.8571,2.7100,2.5752,2.4515,2.3378,2.2331,2.1364,2.046
     & 9,1.9639,1.8869,1.8151,1.7482,1.6857,1.6271,1.5723,1.5207,1.4722,
     & 1.4265,1.3833,1.3426,1.3040,1.2675,1.2328,1.1999,1.1686,1.1388,1.
     & 1104,1.0833,1.0575,1.0327,1.0091,0.9865,0.9648,0.9440,0.9240,0.90
     & 49,0.8865,0.8687,0.8517,0.8353,0.8194,0.8042,0.7894,0.7752,0.7615
     & ,0.7482,0.7354,0.7230,0.7110,0.6993,0.6880,0.6771,0.6665,0.6562,0
     & .6462,0.6365,0.6271,0.6180,0.6091,0.6004,0.5920,0.5838,0.5758,0.5
     & 681,0.5605,0.5531,0.5460,0.5390,0.5321,0.5254,0.5189,0.5126,0.506
     & 4,0.5003,0.4944,0.4886,0.4830,0.4774,0.4720,0.4667,0.4616,0.4565,
     & 0.4516,0.4467,0.4420,0.4373,0.4328/                              
!                                                                       
!        theta is 0.60.                                                 
!                                                                       
      data (shllgd(i,6),i=1,112) /-8.3512,-4.0007,-1.5468,0.0938,1.2720,
     & 2.1509,2.8216,3.3403,3.7445,4.0606,4.3074,4.4992,4.6467,4.7583,4.
     & 8406,4.9652,4.8381,4.6142,4.3592,4.1023,3.8564,3.6267,3.4147,3.22
     & 04,3.0426,2.8802,2.7316,2.5956,2.4708,2.3561,2.2505,2.1530,2.0628
     & ,1.9793,1.9016,1.8293,1.7620,1.6990,1.6400,1.5847,1.5328,1.4840,1
     & .4380,1.3946,1.3535,1.3147,1.2779,1.2430,1.2099,1.1784,1.1484,1.1
     & 198,1.0926,1.0666,1.0417,1.0179,0.9951,0.9733,0.9524,0.9323,0.913
     & 0,0.8945,0.8767,0.8595,0.8430,0.8271,0.8117,0.7969,0.7826,0.7688,
     & 0.7555,0.7425,0.7300,0.7180,0.7063,0.6949,0.6839,0.6732,0.6629,0.
     & 6529,0.6431,0.6336,0.6244,0.6155,0.6068,0.5983,0.5901,0.5821,0.57
     & 43,0.5667,0.5592,0.5520,0.5450,0.5381,0.5314,0.5249,0.5185,0.5122
     & ,0.5061,0.5002,0.4944,0.4887,0.4831,0.4777,0.4724,0.4672,0.4621,0
     & .4571,0.4522,0.4475,0.4428,0.4382/                               
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (shllgd(i,7),i=1,112) /-7.7789,-3.6354,-1.2879,0.2883,1.4240,
     & 2.2732,2.9223,3.4248,3.8164,4.1226,4.3614,4.5466,4.6887,4.7957,4.
     & 8742,4.9861,4.8522,4.6243,4.3667,4.1080,3.8607,3.6300,3.4173,3.22
     & 24,3.0441,2.8813,2.7324,2.5961,2.4711,2.3562,2.2504,2.1528,2.0625
     & ,1.9788,1.9010,1.8286,1.7611,1.6981,1.6391,1.5837,1.5317,1.4829,1
     & .4368,1.3933,1.3522,1.3134,1.2765,1.2416,1.2085,1.1769,1.1469,1.1
     & 183,1.0910,1.0650,1.0401,1.0162,0.9935,0.9716,0.9507,0.9306,0.911
     & 3,0.8927,0.8749,0.8577,0.8412,0.8252,0.8098,0.7950,0.7807,0.7669,
     & 0.7535,0.7406,0.7281,0.7160,0.7043,0.6929,0.6819,0.6712,0.6608,0.
     & 6508,0.6410,0.6315,0.6223,0.6134,0.6047,0.5962,0.5879,0.5799,0.57
     & 21,0.5645,0.5571,0.5498,0.5428,0.5359,0.5292,0.5226,0.5162,0.5100
     & ,0.5039,0.4979,0.4921,0.4864,0.4808,0.4754,0.4701,0.4649,0.4598,0
     & .4548,0.4499,0.4451,0.4404,0.4358/                               
!                                                                       
!         initialize the correction value to zero.                      
!                                                                       
      iz=nint(z)                                                        
      cl1=0.0                                                           
      cl2=0.0                                                           
      shelbl=0.0                                                        
!                                                                       
!        first check to make sure that there are electrons in this      
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(2,iz).eq.0.0).and.(shel(3,iz).eq.0.0)) return           
!                                                                       
!        compute the average theta value. then, check the               
!        theta, if it is zero, then return.                             
!                                                                       
      thetal=((shel(2,iz)*thetas(2,iz))+(shel(3,iz)*thetas(3,iz)))/(shel
     & (2,iz)+shel(3,iz))                                               
!                                                                       
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the average eta value then check its range to          
!        determine which computation to use for shelbl.                 
!                                                                       
      etaval=((eshel(2,iz)*eta(z,2,betasq))+(eshel(3,iz)*eta(z,3,betasq)
     & ))/(eshel(2,iz)+eshel(3,iz))                                     
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than 0.01).          
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.lt.0.01)) then                    
!                                                                       
!        compute the 'b' value first.                                   
!        interpolate to obtain the b value since data is available.     
!                                                                       
        ngrid=2                                                         
        ngrid2=7                                                        
        bvalue=alin3d(etaval,thetal,etagd1,thtgd,b,ngrid,ngrid2,ildaln) 
!                                                                       
!         actual computation of the low eta l-shell correction.         
!                                                                       
        shelbl=alin(thetal,thtgd,s,ngrid2,ildaln)*log(etaval)+alin      
     &  (thetal,thtgd,t,ngrid2,ildaln)-bvalue                           
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the l-shell correction medium eta values.             
!                                                                       
      ngrid=112                                                         
      ngrid2=7                                                          
      if ((etaval.ge.0.01).and.(etaval.le.5.0)) shelbl=alin3d(etaval    
     & ,thetal,etagd2,thtgd,shllgd,ngrid,ngrid2,ildaln)                 
!                                                                       
!        evaluate the l-shell correction for high eta values.           
!                                                                       
      ngrid=7                                                           
      if (etaval.gt.5.0) shelbl=alin(thetal,thtgd,u,ngrid,ildaln)/etaval
     & +alin(thetal,thtgd,v,ngrid,ildaln)/(etaval**2)-w/(etaval**3)+x/  
     & (etaval**4)                                                      
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format (                                                          
     & 'l-shell - bichsel''s total shell method, usc-136-120 (1967).')  
      end                                                               
*
************************************************************************
*
      function shelbm (z,betasq,cm1,cm2,cm3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell correction       
!                   using the physics discribed in reference:           
!                                                                       
!                     h. bichsel, "stopping power of m electrons        
!                     for heavy charged particles," physical review a,  
!                     vol. 28, p1147 (1983)                             
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   20 may 1984                                         
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable, if true then author and 
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelbm - the m-shell correction as computed using   
!                            Bichsel method and data.                   
!                   cm1    - s subshell correction.                     
!                   cm2    - p subshell correction.                     
!                   cm3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
!        compute the correction for each subshell via routines          
!        subb1m, subb2m, and subb3m. then, compute the total            
!        shell correction using the values of the subshells.            
!                                                                       
      logical ptraut                                                    
!                                                                       
      cm1=subb1m(z,betasq)                                              
      cm2=subb2m(z,betasq)                                              
      cm3=subb3m(z,betasq)                                              
!                                                                       
      shelbm=cm1+cm2+cm3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('m-shell - bichsel''s subshell method, physical',         
     & ' review a, vol. 28, p 1147 (1968).')                            
      end                                                               
*
************************************************************************
*
      function sheljl (znumb,bsq,cl1,cl2,ptraut)                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        this function computes the l-shell correction                  
!        using the janni method.                                        
!                                                                       
!        ptraut - variable specifying to write out author               
!                 and reference information to scratch file.            
!                                                                       
      dimension zst(5)                                                  
      dimension pz(5)                                                   
      dimension qz(5)                                                   
      dimension rl(5)                                                   
      dimension sl(5)                                                   
      dimension ble(16)                                                 
      dimension bld(16,5)                                               
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
      data zst /10.0,20.0,30.0,45.0,103.0/                              
!     data pz/1.12,1.50,1.88,1.99,2.0/                                  
      data pz /0.55,1.50,1.88,1.99,2.0/                                 
!     data qz/1.357,1.6934,2.0298,2.1358,2.1519/                        
      data qz /0.8524,1.6934,2.0298,2.1358,2.1519/                      
!     data rl/12.162,10.037,7.912,6.745,6.034/                          
      data rl /13.756,10.037,7.912,6.745,6.034/                         
      data sl /31.840,28.145,24.450,21.906,20.015/                      
      data ble /0.,.05,.1,.15,.2,.25,.3,.35,.4,.45,.5,.55,.6,.65,.7,.75/
      data bld /0.0,2.25,5.10,7.64,10.4,12.94,14.96,16.88,18.63,20.02,21
     & .38,22.55,23.72,24.70,25.68,26.64,0.,1.85,4.,6.4,8.8,11.,12.82,14
     & .5,16.,17.26,18.44,19.47,20.5,21.38,22.26,23.08,0.,1.4,3.1,5.16,7
     & .2,9.06,10.68,12.12,13.37,14.5,15.5,16.39,17.28,18.06,18.84,19.52
     & ,0.,1.1,2.53,4.27,6.1,7.76,9.26,10.56,11.72,12.7,13.6,14.39,15.18
     & ,15.84,16.5,17.12,0.,.7,1.9,3.52,5.2,6.73,8.1,9.36,10.4,11.33,12.
     & 2,12.93,13.66,14.28,14.9,15.46/                                  
!                                                                       
!        note that the following values for pz,qz,rl,and sl were        
!        obtained by linear extrapolation to z=10.                      
!          1.12,1.357,12.162,31.84     direct linear extrapolation      
!          0.55,0.8524,13.756,31.84     final values based on aluminum  
!        these values were empirically modified to obtain a best fit    
!        in aluminum.  the bld values now in the array for z=10 are     
!        directly obtained by linear extrapolation without alteration.  
!                                                                       
      z=znumb                                                           
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        initialize the subshell and shell corrections to zero.         
!                                                                       
      cl1=0.0                                                           
      cl2=0.0                                                           
      sheljl=0.0                                                        
!                                                                       
      if (z.le.6.0) return                                              
!                                                                       
      slater=4.15                                                       
      etaval=(18800.0*bsq)/((z-slater)*(z-slater)*(1.0-bsq))            
!                                                                       
      if (z.lt.10.0) z=10.0                                             
!                                                                       
      neta=16                                                           
      nz=5                                                              
!                                                                       
      reta=1.0/etaval                                                   
      if (etaval.gt.3.0) sheljl=reta*(alin(z,zst,pz,nz,ildaln)+reta*(1.5
     & +reta*(-4.0+reta*4.4)))                                          
!                                                                       
      if ((etaval.gt.0.7).and.(etaval.le.3.0)) sheljl=alin(z,zst,qz,nz  
     & ,ildaln)/etaval                                                  
      if (etaval.le.0.7) sheljl=alin(z,zst,rl,nz,ildaln)*log(etaval)    
     & +alin(z,zst,sl,nz,ildaln)-alin3d(etaval,z,ble,zst,bld,neta,nz    
     & ,ildaln)                                                         
!                                                                       
      if (znumb.lt.10.0) sheljl=sheljl*(znumb-2.0)/8.0                  
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('l-shell - janni''s total shell method.')                 
      end                                                               
*
************************************************************************
*
      function sheljm (z,betasq,cm1,cm2,cm3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell correction       
!                   using the janni method. this is the original method 
!                   of computing the m shell correction. the computation
!                   is a individual subshell method using scaling based 
!                   on the janni l shell method.                        
!                                                                       
!        author :   joe janni - original                                
!                   daniel pickens - revised                            
!                     computer sciences corporation                     
!                     30 june 1984                                      
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - variable specifying to write out author    
!                            and reference information to scratch file. 
!                                                                       
!        outputs :  sheljm - the m-shell correction as computed using   
!                            Janni method.                              
!                   cm1    - s subshell correction.                     
!                   cm2    - p subshell correction.                     
!                   cm3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      logical ptraut                                                    
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
!                                                                       
      j=nint(z)                                                         
      cm1=0.0                                                           
      cm2=0.0                                                           
      cm3=0.0                                                           
      sheljm=0.0                                                        
      if (z.lt.25.0) return                                             
!                                                                       
!        set the m-shell scaling factor.                                
!                                                                       
      fudge=1.6                                                         
      beta=sqrt(betasq)                                                 
!                                                                       
      cm1=subshl(z,beta,fudge,shel(4,j),shel(2,j),shel(3,j),eshel(4,j)  
     & ,eshel(2,j))                                                     
!                                                                       
      if (cm1.lt.0.0) cm1=1.5*cm1                                       
!                                                                       
      cm2=subshl(z,beta,fudge,shel(5,j),shel(2,j),shel(3,j),eshel(5,j)  
     & ,eshel(3,j))                                                     
!                                                                       
      if (cm2.lt.0.0) cm2=1.5*cm2                                       
!                                                                       
      cm3=subshl(z,beta,fudge,shel(6,j),shel(2,j),shel(3,j),eshel(6,j)  
     & ,eshel(3,j))                                                     
!                                                                       
      if (cm3.lt.0.0) cm3=1.5*cm3                                       
!                                                                       
      sheljm=cm1+cm2+cm3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('m-shell - janni''s subshell method.')                    
      end                                                               
*
************************************************************************
*
      function sheljn (z,bsqp,c1,c2,c3,c4,ptraut)                       
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the n-shell correction       
!                   using the janni method. this is the original method 
!                   of computing the n shell correction. the computation
!                   is a individual subshell method using scaling based 
!                   on the janni l shell method.                        
!                                                                       
!        author :   joe janni - original                                
!                   daniel pickens - revised                            
!                     computer sciences corporation                     
!                     30 june 1984                                      
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   bsqp   - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical varaible, if true then author and 
!                            reference information written to scratch fi
!                                                                       
!        outputs :  sheljn - the n-shell correction as computed using   
!                            Janni method.                              
!                   c1     - s subshell correction.                     
!                   c2     - p subshell correction.                     
!                   c3     - d subshell correction.                     
!                   c4     - f subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
      iz=nint(z)                                                        
      c1=0.0                                                            
      c2=0.0                                                            
      c3=0.0                                                            
      c4=0.0                                                            
      sheljn=0.0                                                        
      if (iz.le.26) return                                              
!                                                                       
      fudge=1.8                                                         
      beta=sqrt(bsqp)                                                   
!                                                                       
      if ((iz.ge.26).and.(iz.le.36)) then                               
!                                                                       
        sheljn=(shel(4,iz)/8.0)*1.0e-4*z*(1.0-bsqp)/bsqp                
      else                                                              
!                                                                       
        c1=subshl(z,beta,fudge,shel(7,iz),shel(2,iz),shel(3,iz),eshel(7 
     &  ,iz),eshel(2,iz))                                               
!                                                                       
        c2=subshl(z,beta,fudge,shel(8,iz),shel(2,iz),shel(3,iz),eshel(8 
     &  ,iz),eshel(3,iz))                                               
!                                                                       
        if (shel(9,iz).gt.0.0) c3=subshl(z,beta,fudge,shel(9,iz),shel(2 
     &  ,iz),shel(3,iz),eshel(9,iz),eshel(3,iz))                        
!                                                                       
        if (shel(10,iz).gt.0.0) c4=subshl(z,beta,fudge,shel(10,iz),shel(
     &  2,iz),shel(3,iz),eshel(10,iz),eshel(3,iz))                      
!                                                                       
        sheljn=c1+c2+c3+c4                                              
!                                                                       
      endif                                                             
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('n-shell - janni''s subshell method.')                    
      end                                                               
*
************************************************************************
*
      function sheljo (z,bsqp,c1,c2,c3,ptraut)                          
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the o-shell correction       
!                   using the janni method. this is the original method 
!                   of computing the o shell correction. the computation
!                   is a individual subshell method using scaling based 
!                   on the janni l shell method.                        
!                                                                       
!        author :   joe janni - original                                
!                   daniel pickens - revised                            
!                     computer sciences corporation                     
!                     30 june 1984                                      
!                                                                       
!        inputs :   z       - the atomic number of the element.         
!                   bsqp    - the converted kinetic energy to           
!                             velocity squared.                         
!                   ptraut  - logical variable, if true then author and 
!                             reference information written to scratch f
!                                                                       
!        outputs :  sheljo - the o-shell correction as computed using   
!                            Janni method.                              
!                   c1     - s subshell correction.                     
!                   c2     - p subshell correction.                     
!                   c3     - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
      iz=nint(z)                                                        
      c1=0.0                                                            
      c2=0.0                                                            
      c3=0.0                                                            
      sheljo=0.0                                                        
      if (iz.lt.57) return                                              
!                                                                       
      fudge=1.8                                                         
      beta=sqrt(bsqp)                                                   
!                                                                       
      c1=subshl(z,beta,fudge,shel(11,iz),shel(2,iz),shel(3,iz),eshel(11 
     & ,iz),eshel(2,iz))                                                
!                                                                       
      c2=subshl(z,beta,fudge,shel(12,iz),shel(2,iz),shel(3,iz),eshel(12 
     & ,iz),eshel(3,iz))                                                
!                                                                       
      if (shel(13,iz).gt.0.0) c3=subshl(z,beta,fudge,shel(13,iz),shel(2 
     & ,iz),shel(3,iz),eshel(13,iz),eshel(3,iz))                        
!                                                                       
      sheljo=c1+c2+c3                                                   
      if (z.ge.81.0) sheljo=(c1+c2+c3)/4.0                              
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('o-shell - janni''s subshell method.')                    
      end                                                               
*
************************************************************************
*
      function sheljp (z,bsqp,c1,c2,c3,ptraut)                          
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the p-shell correction       
!                   using the janni method. this is the original method 
!                   of computing the p shell correction. the computation
!                   is a individual subshell method using scaling based 
!                   on the janni l shell method.                        
!                                                                       
!        author :   joe janni - original                                
!                   daniel pickens - revised                            
!                     computer sciences corporation                     
!                     30 june 1984                                      
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   bsqp   - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - logical variable,if true then author and   
!                            reference information written to scratch fi
!                                                                       
!        outputs :  sheljp - the p-shell correction as computed using   
!                            Janni method.                              
!                   c1     - s subshell correction.                     
!                   c2     - p subshell correction.                     
!                   c3     - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
      c1=0.0                                                            
      c2=0.0                                                            
      c3=0.0                                                            
      sheljp=0.0                                                        
      iz=z                                                              
      if (iz.lt.82) return                                              
!                                                                       
      fudge=1.0                                                         
      beta=sqrt(bsqp)                                                   
!                                                                       
      c1=subshl(z,beta,fudge,shel(15,iz),shel(2,iz),shel(3,iz),eshel(15 
     & ,iz),eshel(2,iz))                                                
!                                                                       
      if (shel(16,iz).gt.0.0) c2=subshl(z,beta,fudge,shel(16,iz),shel(2 
     & ,iz),shel(3,iz),eshel(16,iz),eshel(3,iz))                        
!                                                                       
      if (shel(17,iz).gt.0.0) c3=subshl(z,beta,fudge,shel(17,iz),shel(2 
     & ,iz),shel(3,iz),eshel(17,iz),eshel(3,iz))                        
!                                                                       
      sheljp=c1+c2+c3                                                   
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('p-shell - janni''s subshell method.')                    
      end                                                               
*
************************************************************************
*
      function shelkk (z,betasq,ptraut)                                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the k-shell correction       
!                   using the physics discribed in reference 141:       
!                                                                       
!                     g. khandelwal, "shell corrections for k-          
!                     and l- electrons," nuclear physics, vol. a116,    
!                     p 97 (1968).                                      
!                                                                       
!                   and in the reference:                               
!                                                                       
!                     g. khandelwal, "stopping power of k and           
!                     l electrons," physical review a., vol 5,          
!                     number 26 (november 1982).                        
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   18 september 1983                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - logical variable,if true then author and   
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelkk - the k-shell correction as computed using   
!                            Khandelwal method and data.                
!                   author - the author and what kind of method used    
!                            to compute the correction.                 
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(30), thetgd(20), b(30,20), s(20), t(20), u(20), v(
     & 20)                                                              
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
      data etagd /0.0,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,0.
     & 060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800,1
     & .000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000,10.000/     
!                                                                       
      data thetgd /0.640,0.650,0.660,0.680,0.700,0.720,0.740,0.750,0.760
     & ,0.780,0.800,0.820,0.840,0.850,0.860,0.880,0.900,0.920,0.940,0.95
     & 0/                                                               
!                                                                       
      data s /1.9477,1.9232,1.8996,1.8550,1.8137,1.7754,1.7396,1.7223,1.
     & 7063,1.6752,1.6461,1.6189,1.5933,1.5811,1.5693,1.5467,1.5254,1.50
     & 53,1.4863,1.4772/                                                
!                                                                       
      data t /2.5222,2.5125,2.5026,2.4821,2.4608,2.4388,2.4163,2.4000,2.
     & 3933,2.3701,2.3466,2.3229,2.2992,2.2872,2.2753,2.2515,2.2277,2.20
     & 40,2.1804,2.1686/                                                
!                                                                       
      data u /1.9999,2.0134,2.0258,2.0478,2.0662,2.0807,2.0945,2.0999,2.
     & 1049,2.1132,2.1197,2.1246,2.1280,2.1292,2.1301,2.1310,2.1310,2.13
     & 00,2.1283,2.1271/                                                
!                                                                       
      data v /8.3410,8.3373,8.3340,8.3287,8.3247,8.3219,8.3201,8.3194,8.
     & 3191,8.3188,8.3191,8.1399,8.3211,8.3218,8.3226,8.3244,8.3264,8.32
     & 85,8.3308,8.3320/                                                
!                                                                       
      data w /45.0/                                                     
!                                                                       
!        a correction for eta = 2.0 and 3.0 recommended by              
!        khandelwal in his letter of april 3, 1967, has been            
!        implimented in the 'b' data.                                   
!                                  joe janni, 7 january 1984            
!                                                                       
!        the above corrections at eta = 2.0 and eta  3.0 seemc        to
!        in the shell correction, which should be a smooth function.    
!                                  joe janni, 20 may 1984               
!                                                                       
!        theta is 0.640.                                                
!                                                                       
      data (b(i,1),i=1,30) /0.00000000,.255370e-6,.120435e-5,.594048e-5,
     & .337432e-4,.108909e-3,.513606e-3,.142650e-2,.300358e-2,.534739e-2
     & ,.125417e-1,.231795e-1,.638389e-1,.121472e+0,.272329e+0,.451685e+
     & 0,.644677e+0,.842380e+0,.103945e+1,.123272e+1,.160140e+1,.194211e
     & +1,.225442e+1,.240045e+1,.267381e+1,.285324e+1,.393031e+1,.521181
     & e+1,.602191e+1,.677535e+1/                                       
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (b(i,2),i=1,30) /0.00000000,.228346e-6,.108140e-5,.536428e-5,
     & .307181e-4,.998212e-4,.475845e-3,.133245e-2,.282358e-2,.505294e-2
     & ,.119441e-1,.222009e-1,.617003e-1,.118035e+0,.266239e+0,.443063e+
     & 0,.633705e+0,.829235e+0,.102430e+1,.121570e+1,.158102e+1,.191876e
     & +1,.222842e+1,.237323e+1,.264430e+1,.282067e+1,.388961e+1,.516014
     & e+1,.596269e+1,.670792e+1/                                       
!                                                                       
!        theta is 0.660.                                                
!                                                                       
      data (b(i,3),i=1,30) /0.00000000,.204459e-6,.972171e-6,.484882e-5,
     & .279850e-4,.915431e-4,.441006e-3,.124485e-2,.265469e-2,.477507e-2
     & ,.113754e-1,.212640e-1,.596350e-1,.114701e+0,.260304e+0,.434647e+
     & 0,.622986e+0,.816391e+0,.100949e+1,.119907e+1,.156111e+1,.189596e
     & +1,.220304e+1,.234666e+1,.261552e+1,.278891e+1,.384998e+1,.510992
     & e+1,.590517e+1,.664249e+1/                                       
!                                                                       
!        theta is 0.680.                                                
!                                                                       
      data (b(i,4),i=1,30) /0.00000000,.164573e-6,.788464e-6,.326860e-5,
     & .232783e-4,.771154e-4,.379175e-3,.108721e-2,.234750e-2,.426536e-2
     & ,.103189e-1,.195083e-1,.557135e-1,.108326e+0,.248882e+0,.418404e+
     & 0,.602273e+0,.791559e+0,.980856e+0,.116692e+1,.152263e+1,.185192e
     & +1,.215406e+1,.229539e+1,.256000e+1,.272769e+1,.377376e+1,.501353
     & e+1,.579496e+1,.651728e+1/                                       
!                                                                       
!        theta is 0.700.                                                
!                                                                       
      data (b(i,5),i=1,30) /0.00000000,.133148e-6,.642391e-6,.326860e-5,
     & .194200e-4,.651154e-4,.326458e-3,.950341e-3,.207396e-2,.381132e-2
     & ,.936187e-2,.178989e-1,.520542e-1,.102320e+0,.238022e+0,.402900e+
     & 0,.582470e+0,.767800e+0,.953454e+0,.113615e+1,.148582e+1,.180983e
     & +1,.210727e+1,.224644e+1,.250703e+1,.266934e+1,.370128e+1,.492217
     & e+1,.565226e+1,.639903e+1/                                       
!                                                                       
!        theta is 0.720.                                                
!                                                                       
      data (b(i,6),i=1,30) /0.00000000,.108253e-6,.525688e-6,.269889e-5,
     & .162480e-4,.551033e-4,.281460e-3,.831425e-3,.183861e-2,.340681e-2
     & ,.849478e-2,.164235e-1,.486383e-1,.966589e-1,.227689e+0,.388089e+
     & 0,.563515e+0,.745041e+0,.927198e+0,.110667e+1,.145057e+1,.176954e
     & +1,.206251e+1,.219963e+1,.245641e+1,.261363e+1,.363226e+1,.483543
     & e+1,.555344e+1,.628715e+1/                                       
!                                                                       
!        theta is 0.740.                                                
!                                                                       
      data (b(i,7),i=1,30) /0.00000000,.884294e-7,.432017e-6,.223662e-5,
     & .136329e-4,.467351e-4,.243007e-3,.728042e-3,.162855e-2,.304636e-2
     & ,.770916e-2,.150707e-1,.454488e-1,.913200e-1,.217848e+0,.373925e+
     & 0,.545354e+0,.723214e+0,.902008e+0,.107838e+1,.141676e+1,.173092e
     & +1,.201964e+1,.215480e+1,.240798e+1,.256036e+1,.356642e+1,.475293
     & e+1,.545962e+1,.618112e+1/                                       
!                                                                       
!        theta is 0.750.                                                
!                                                                       
      data (b(i,8),i=1,30) /0.00000000,.800602e-7,.392247e-6,.203881e-5,
     & .125008e-4,.430763e-4,.225918e-3,.681511e-3,.153305e-2,.288111e-2
     & ,.734446e-2,.144371e-1,.439340e-1,.887650e-1,.213103e+0,.367073e+
     & 0,.536554e+0,.712631e+0,.889791e+0,.106466e+1,.140036e+1,.171220e
     & +1,.199887e+1,.213309e+1,.238451e+1,.253458e+1,.353461e+1,.471316
     & e+1,.541445e+1,.613015e+1/                                       
!                                                                       
!        theta is 0.760.                                                
!                                                                       
      data (b(i,9),i=1,30) /0.00000000,.725636e-7,.356497e-6,.186011e-5,
     & .114707e-4,.397259e-4,.210106e-3,.638103e-3,.144336e-2,.272510e-2
     & ,.699730e-2,.138803e-1,.424699e-1,.862830e-1,.208471e+0,.360369e+
     & 0,.527935e+0,.702260e+0,.877814e+0,.105121e+1,.138429e+1,.169385e
     & +1,.197852e+1,.211182e+1,.236154e+1,.250935e+1,.350352e+1,.467433
     & e+1,.537040e+1,.608046e+1/                                       
!                                                                       
!        theta is 0.780.                                                
!                                                                       
      data (b(i,10),i=1,30) /0.00000000,.598040e-7,.295345e-6,.155232e-5
     & ,.967802e-5,.338425e-4,.181920e-3,.559802e-3,.128002e-2,.242872e-
     & 2,.635222e-2,.126929e-1,.396872e-1,.815290e-1,.199528e+0,.347383e
     & +0,.511214e+0,.682122e+0,.854544e+0,.102508e+1,.135307e+1,.165823
     & e+1,.193902e+1,.207055e+1,.231700e+1,.246044e+1,.344334e+1,.45993
     & 5e+1,.528542e+1,.598474e+1/                                      
!                                                                       
!        theta is 0.800.                                                
!                                                                       
      data (b(i,11),i=1,30) /0.00000000,.494946e-7,.245620e-6,.129981e-5
     & ,.818757e-5,.288935e-4,.157744e-3,.491584e-3,.113590e-2,.218336e-
     & 2,.576765e-2,.116498e-1,.370873e-1,.770407e-1,.190997e+0,.334935e
     & +0,.495148e+0,.662752e+0,.832167e+0,.999934e+0,.132303e+1,.162396
     & e+1,.190104e+1,.203087e+1,.227419e+1,.241350e+1,.338569e+1,.45277
     & 2e+1,.520436e+1,.589359e+1/                                      
!                                                                       
!        theta is 0.820.                                                
!                                                                       
      data (b(i,12),i=1,30) /0.00000000,.411274e-7,.205023e-6,.109192e-5
     & ,.694501e-5,.247216e-4,.136980e-3,.432104e-3,.100867e-2,.195562e-
     & 2,.523785e-2,.106934e-1,.346580e-1,.728020e-1,.182852e+0,.322994e
     & +0,.479700e+0,.644104e+0,.810602e+0,.975701e+0,.129408e+1,.159095
     & e+1,.186448e+1,.199269e+1,.223302e+1,.236837e+1,.333039e+1,.44591
     & 8e+1,.512695e+1,.580666e+1/                                      
!                                                                       
!        theta is 0.840.                                                
!                                                                       
      data (b(i,13),i=1,30) /0.00000000,.343072e-7,.171747e-6,.920187e-6
     & ,.590633e-5,.211973e-4,.119122e-3,.380200e-3,.896410e-3,.175244e-
     & 2,.475768e-2,.981623e-2,.323878e-1,.687981e-1,.175074e+0,.311533e
     & +0,.464834e+0,.626136e+0,.789811e+0,.952331e+0,.126616e+1,.155913
     & e+1,.182925e+1,.195590e+1,.219337e+1,.232494e+1,.327728e+1,.43935
     & 3e+1,.505290e+1,.572366e+1/                                      
!                                                                       
!        theta is 0.850.                                                
!                                                                       
      data (b(i,14),i=1,30) /0.00000000,.313778e-7,.157398e-6,.845709e-6
     & ,.545200e-5,.196439e-4,.111147e-3,.356771e-3,.845134e-3,.165921e-
     & 2,.453473e-2,.940534e-2,.313090e-1,.668798e-1,.171315e+0,.305974e
     & +0,.457610e+0,.617396e+0,.779591e+0,.940953e+0,.125257e+1,.154364
     & e+1,.181210e+1,.193800e+1,.217409e+1,.230383e+1,.325150e+1,.43617
     & 2e+1,.501707e+1,.568353e+1/                                      
!                                                                       
!        theta is 0.860.                                                
!                                                                       
      data (b(i,15),i=1,30) /0.00000000,.287247e-7,.144370e-6,.777847e-6
     & ,.503578e-5,.182138e-4,.103744e-3,.334870e-3,.797023e-3,.157113e-
     & 2,.432246e-2,.901187e-2,.302661e-1,.650152e-1,.167641e+0,.300525e
     & +0,.450519e+0,.608811e+0,.769748e+0,.929772e+0,.123921e+1,.152842
     & e+1,.179526e+1,.192042e+1,.215515e+1,.228311e+1,.322622e+1,.43305
     & 6e+1,.498200e+1,.564429e+1/                                      
!                                                                       
!        theta is 0.880.                                                
!                                                                       
      data (b(i,16),i=1,30) /0.00000000,.241370e-7,.121760e-6,.659488e-6
     & ,.430423e-5,.156829e-4,.904832e-4,.295248e-3,.709244e-3,.140928e-
     & 2,.392793e-2,.827424e-2,.282832e-1,.614403e-1,.160536e+0,.289946e
     & +0,.436726e+0,.592092e+0,.750373e+0,.907979e+0,.121317e+1,.149875
     & e+1,.176244e+1,.188617e+1,.211827e+1,.224277e+1,.317706e+1,.42701
     & 0e+1,.491402e+1,.556830e+1/                                      
!                                                                       
!        theta is 0.900.                                                
!                                                                       
      data (b(i,17),i=1,30) /0.00000000,.203521e-7,.103022e-6,.560760e-6
     & ,.368791e-5,.135313e-4,.790324e-4,.260584e-3,.631597e-3,.126476e-
     & 2,.357027e-2,.759781e-2,.264300e-1,.580617e-1,.153743e+0,.279776e
     & +0,.423427e+0,.575948e+0,.731650e+0,.886910e+0,.118799e+1,.147007
     & e+1,.173072e+1,.185307e+1,.208265e+1,.220383e+1,.312971e+1,.42119
     & 9e+1,.484877e+1,.549547e+1/                                      
!                                                                       
!        theta is 0.920.                                                
!                                                                       
      data (b(i,18),i=1,30) /0.00000000,.172179e-7,.874397e-7,.478154e-6
     & ,.316738e-5,.116984e-4,.691311e-4,.230230e-3,.562872e-3,.113566e-
     & 2,.324599e-2,.697750e-2,.246978e-1,.548682e-1,.147244e+0,.269992e
     & +0,.410597e+0,.560350e+0,.713543e+0,.866525e+0,.116362e+1,.144232
     & e+1,.170004e+1,.182107e+1,.204822e+1,.216620e+1,.308403e+1,.41560
     & 6e+1,.478608e+1,.542560e+1/                                      
!                                                                       
!        theta is 0.940.                                                
!                                                                       
      data (b(i,19),i=1,30) /0.00000000,.146132e-7,.744373e-7,.408831e-6
     & ,.272664e-5,.101339e-4,.605576e-4,.203626e-3,.502006e-3,.102029e-
     & 2,.295200e-2,.640864e-2,.230790e-1,.518492e-1,.141026e+0,.260576e
     & +0,.398213e+0,.545268e+0,.696021e+0,.846790e+0,.114002e+1,.141545
     & e+1,.167034e+1,.179009e+1,.201490e+1,.212982e+1,.303994e+1,.41021
     & 9e+1,.472577e+1,.535848e+1/                                      
!                                                                       
!        theta is 0.950.                                                
!                                                                       
      data (b(i,20),i=1,30) /0.00000000,.134782e-7,.687555e-7,.378413e-6
     & ,.253200e-5,.943891e-5,.567088e-4,.191576e-3,.474226e-3,.967285e-
     & 3,.281537e-2,.614216e-2,.223096e-1,.504022e-1,.138018e+0,.256001e
     & +0,.392181e+0,.537913e+0,.687470e+0,.837159e+0,.112850e+1,.140232
     & e+1,.165584e+1,.177496e+1,.199863e+1,.211207e+1,.301845e+1,.40759
     & 9e+1,.469647e+1,.532590e+1/                                      
!                                                                       
      iz=nint(z)                                                        
      shelkk=0.0                                                        
!                                                                       
!        if the element is hydrogen, then return.                       
!                                                                       
      if (iz.eq.1) return                                               
!                                                                       
!        obtain the theta value.                                        
!                                                                       
      thetak=thetas(1,iz)                                               
!                                                                       
!        initialize the grid size constants.                            
!                                                                       
      numgrd=20                                                         
      numgd2=30                                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for shelkk                            
!                                                                       
      etaval=eta(z,1,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than or equal        
!        to 10.0).                                                      
!                                                                       
      if (etaval.le.10.0) then                                          
!                                                                       
!        interpolate to obtain the b value.                             
!                                                                       
        bvalue=alin3d(etaval,thetak,etagd,thetgd,b,numgd2,numgrd,ildaln)
!                                                                       
!         actual computation of the low eta k-shell correction.         
!                                                                       
        shelkk=alin(thetak,thetgd,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetak,thetgd,t,numgrd,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the k-shell correction for higher eta.                
!                                                                       
      if (etaval.gt.10.0) shelkk=alin(thetak,thetgd,u,numgrd,ildaln)    
     & /etaval+alin(thetak,thetgd,v,numgrd,ildaln)/(etaval**2)-w/(etaval
     & **3)                                                             
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('k-shell - khandelwal''s total shell method, ',           
     & 'nuclear physics, vol. a116, p 97 (1968).')                      
      end                                                               
*
************************************************************************
*
      function shelkl (z,betasq,cl1,cl2,ptraut)                         
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell correction       
!                   using the physics discribed in reference 141:       
!                                                                       
!                     g. khandelwal, "shell corrections for k-          
!                     and l- electrons," nuclear physics, vol. a116,    
!                     p 97 (1968).                                      
!                                                                       
!                   and in the reference:                               
!                                                                       
!                     g. khandelwal, "stopping power of k and           
!                     l electrons," physical review a., vol 5,          
!                     number 26 (november 1982).                        
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   13 may 1984                                         
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - flag specifying to write out author        
!                            and reference information to scratch file. 
!                                                                       
!        outputs :  shelkl - the l-shell correction as computed using   
!                            Khandelwal method and data.                
!                   cl1    - the l-shell, s-subshell correction.        
!                   cl2    - the l-shell, p-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        first initialize the shell and subshell corrections to zero.   
!                                                                       
      iz=nint(z)                                                        
      cl1=0.0                                                           
      cl2=0.0                                                           
      shelkl=0.0                                                        
!                                                                       
!        check to make sure that there are electrons in this            
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(2,iz).eq.0.0).and.(shel(3,iz).eq.0.0)) return           
!                                                                       
!        compute the correction for each subshell via routines          
!        subk1l and subk2l. the values of c1 and c2 are the correction  
!        per total subshell.                                            
!                                                                       
      cl1=subk1l(z,betasq)                                              
      cl2=subk2l(z,betasq)                                              
!                                                                       
!        add the two election correction values to obtain the           
!        correction for the total correction of the l shell.            
!                                                                       
      shelkl=cl1+cl2                                                    
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('l-shell - khandelwal''s subshell method,',               
     & ' nuclear physics, vol. a116, p 97 (1968).')                     
      end                                                               
*
************************************************************************
*
      function shelkm (z,betasq,cm1,cm2,cm3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell correction       
!                   using the physics discribed in reference 137:       
!                                                                       
!                     g. khandelwal and e. merzbacher,                  
!                     "stopping power of m electrons,"                  
!                     physical review, vol 144, p 349 (1966)            
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   20 may 1984                                         
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable, if true then author and 
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelkm - the m-shell correction as computed using   
!                            Khandelwal method and data.                
!                   cm1    - s subshell correction (set to zero, used   
!                            here for consistency).                     
!                   cm2    - p subshell correction (set to zero, used   
!                            here for consistency).                     
!                   cm3    - d subshell correction (set to zero, used   
!                            here for consistency).                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(25), thetgd(3), b(25,3), s(3), t(3), u(3)         
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
      data etagd /0.0,0.005,0.01,0.03,0.05,0.08,0.1,0.2,0.3,0.4,0.5,0.6,
     & 0.7,0.8,0.9,1.0,1.1,1.25,1.5,1.75,2.0,2.25,3.5,5.0,10.0/         
!                                                                       
      data thetgd /0.35,0.450,0.55/                                     
!                                                                       
      data s /41.37,24.29,17.88/                                        
!                                                                       
      data t /129.8,89.92,72.28/                                        
!                                                                       
      data u /0.24,0.39,0.75/                                           
!                                                                       
      data (b(i,1),i=1,25) /0.0,2.2,4.2,12.2,19.8,30.2,36.70,62.43,79.08
     & ,91.12,100.48,108.13,114.60,120.22,125.12,129.53,133.52,138.84,14
     & 6.42,152.84,158.39,167.60,181.54,196.37,225.07/                  
!                                                                       
      data (b(i,2),i=1,25) /0.0,1.8,3.2,9.0,14.3,22.0,26.44,44.97,56.52,
     & 64.61,70.74,75.87,79.78,83.32,86.37,89.10,91.55,94.80,99.39,103.2
     & 5,106.57,112.03,120.24,128.95,145.83/                            
      data (b(i,3),i=1,25) /0.0,1.3,2.5,7.0,11.3,17.4,20.85,36.13,45.53,
     & 52.02,56.87,60.94,63.93,66.67,69.01,71.10,72.97,75.44,78.91,81.81
     & ,84.30,88.36,94.45,100.91,113.38/                                
!                                                                       
!        initialize the m-shell correction value to zero.               
!                                                                       
      iz=nint(z)                                                        
      shelkm=0.0                                                        
      cm1=0.0                                                           
      cm2=0.0                                                           
      cm3=0.0                                                           
!                                                                       
!        first check to make sure that there are electrons in this      
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(4,iz).eq.0.0).and.(shel(5,iz).eq.0.0).and.(shel(6,iz).eq
     & .0.0)) return                                                    
!                                                                       
!        compute the average theta value. then, check the               
!        theta, if it is zero then return.                              
!                                                                       
      thetam=((shel(4,iz)*thetas(4,iz))+(shel(5,iz)*thetas(5,iz))+(shel(
     & 6,iz)*thetas(6,iz)))/(shel(4,iz)+shel(5,iz)+shel(6,iz))          
!                                                                       
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the average eta value then check its range to          
!        determine which computation to use for shelkm.                 
!                                                                       
      etaval=((eshel(4,iz)*eta(z,4,betasq))+(eshel(5,iz)*eta(z,5,betasq)
     & )+(eshel(6,iz)*eta(z,6,betasq)))/(eshel(4,iz)+eshel(5,iz)+eshel(6
     & ,iz))                                                            
!                                                                       
!        initialize the grid size constants.                            
!                                                                       
      numgrd=3                                                          
      numgd2=25                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than                 
!        or equal to 2).                                                
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.le.2.0)) then                     
!                                                                       
!        compute the 'b' value first. interpolate to obtain             
!        the b value from available data.                               
!                                                                       
        bvalue=alin3d(etaval,thetam,etagd,thetgd,b,numgd2,numgrd,ildaln)
!                                                                       
!         actual computation of the low eta m-shell correction.         
!                                                                       
        shelkm=alin(thetam,thetgd,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetam,thetgd,t,numgrd,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the m-shell correction for higher eta values.         
!                                                                       
      if (etaval.gt.2.0) shelkm=alin(thetam,thetgd,u,numgrd,ildaln)     
     & /etaval                                                          
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut if true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('m-shell - khandelwal''s total shell method,',            
     & ' physical review, vol. 144, p 349 (1966).')                     
      end                                                               
*
************************************************************************
*
      function shellj (z,t,ck,cl1,cl2,cl,cm1,cm2,cm3,cm,cn1,cn2,cn3,cn4 
     & ,cn,co1,co2,co3,co,cp1,cp2,cp3,cp,ikshl,ilshl,imshl,inshl,ioshl  
     & ,ipshl,ptraut)                                                   
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!        JANNI SHELL CORRECTION CODING                                  
!                                                                       
!        purpose :  this routine is a mini-executive that directs       
!                   the calling of the shell correction routines        
!                   based upon the specific author/method that          
!                   is requested.                                       
!                                                                       
!        author :   daniel pickens, computer sciences corporation       
!                   10 june 1984.                                       
!        revised:   j.lopez, csc, oct 1985.                             
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   t      - is the energy value.                       
!                   ptraut - logical variable, if true then author      
!                            and reference information is writen        
!                            to scratch file 10 for later printing.     
!                                                                       
!        outputs :  ck     - the k shell correction.                    
!                   cl1    - the l shell, s subshell correction.        
!                   cl2    - the l shell, p subshell correction.        
!                   cl     - the l shell correction.                    
!                   cm1    - the m shell, s subshell correction.        
!                   cm2    - the m shell, p subshell correction.        
!                   cm3    - the m shell, d subshell correction.        
!                   cm     - the m shell correction.                    
!                   cn1    - the n shell, s subshell correction.        
!                   cn2    - the n shell, p subshell correction.        
!                   cn3    - the n shell, d subshell correction.        
!                   cn4    - the n shell, f subshell correction.        
!                   cn     - the n shell correction.                    
!                   co1    - the o shell, s subshell correction.        
!                   co2    - the o shell, p subshell correction.        
!                   co3    - the o shell, d subshell correction.        
!                   co     - the o shell correction.                    
!                   cp1    - the p shell, s subshell correction.        
!                   cp2    - the p shell, p subshell correction.        
!                   cp     - the p shell correction.                    
!                   shell  - the total shell correction.                
!                                                                       
!        errors :   none.                                               
!                                                                       
!     if ptraut is true print the shell corrections.                    
!                                                                       
      logical ptraut                                                    
!                                                                       
      parameter (prot_mass=938.2723128d0)                               
      parameter (e=prot_mass)                                           
!                                                                       
      s=t/e                                                             
      betasq=s*(s+dp2)/(s+dp1)**2                                       
!                                                                       
!        shell corrections:                                             
!                                                                       
!        k-shell                                               value    
!        routine name  author         type                     ikshl    
!        ------------  -------------- ---------------------    ----     
!        shelwk        m. walske      total shell (default)      1      
!        shelkk        g. khandelwal  total shell                2      
!                                                                       
      if (ikshl.eq.1) then                                              
        ck=shelwk(z,betasq,ptraut)                                      
      elseif (ikshl.eq.2) then                                          
        ck=shelkk(z,betasq,ptraut)                                      
      else                                                              
        stop 'shellj - select type of k-shell correction'               
      endif                                                             
!                                                                       
!        l-shell                                               value    
!        routine name  author         type                     ilshl    
!        ------------  -------------- ---------------------    ----     
!        shlbil        h. bichsel     indiv.subshell(default)    1      
!        sheljl        j. janni       total shell(original)      2      
!        shelwl        m. walske      total shell                3      
!        shelkl        g. khandelwal  individual subshell        4      
!        shelbl        h. bichsel     total shell                5      
!                                                                       
      if (ilshl.eq.1) then                                              
        cl=shlbil(z,betasq,cl1,cl2,ptraut)                              
      elseif (ilshl.eq.2) then                                          
        cl=sheljl(z,betasq,cl1,cl2,ptraut)                              
      elseif (ilshl.eq.3) then                                          
        cl=shelwl(z,betasq,cl1,cl2,ptraut)                              
      elseif (ilshl.eq.4) then                                          
        cl=shelkl(z,betasq,cl1,cl2,ptraut)                              
      elseif (ilshl.eq.5) then                                          
        cl=shelbl(z,betasq,cl1,cl2,ptraut)                              
      else                                                              
        stop 'shellj - select type of l-shell correction'               
      endif                                                             
!                                                                       
!        m-shell                                               value    
!        routine name  author         type                     imshl    
!        ------------  -------------- ---------------------    ----     
!        shelbm        h. bichsel     indiv. subshell(default)   1      
!        sheljm        j. janni       indiv. subshell(original   2      
!                                     scaling  method)                  
!        shelkm        g. khandelwal  total shell                3      
!        shlkim        g. khandelwal  indiv. subshell            4      
!        shelsm        scaled from l  indiv. subhsell(scaled     5      
!                                     using Bichsel subshell            
!                                                                       
      if (imshl.eq.1) then                                              
        cm=shelbm(z,betasq,cm1,cm2,cm3,ptraut)                          
      elseif (imshl.eq.2) then                                          
        cm=sheljm(z,betasq,cm1,cm2,cm3,ptraut)                          
      elseif (imshl.eq.3) then                                          
        cm=shelkm(z,betasq,cm1,cm2,cm3,ptraut)                          
      elseif (imshl.eq.4) then                                          
        cm=shlkim(z,betasq,cm1,cm2,cm3,ptraut)                          
      elseif (imshl.eq.5) then                                          
        cm=shelsm(z,betasq,cm1,cm2,cm3,ptraut)                          
      else                                                              
        stop 'shellj - select type of m-shell correction'               
      endif                                                             
!                                                                       
!        n-shell                                               value    
!        routine name  author         type                     inshl    
!        ------------  -------------- ---------------------    ----     
!        shelsn        scaled from m  indiv. subshell (scaled    1      
!                                     using Bichsel subshell            
!                                     m shell)                          
!        sheljn        j. janni       indiv. subshell            2      
!                                     (original method using            
!                                     Janni l shell)                    
!                                                                       
      if (inshl.eq.1) then                                              
        cn=shelsn(z,betasq,cn1,cn2,cn3,cn4,ptraut)                      
      elseif (inshl.eq.2) then                                          
        cn=sheljn(z,betasq,cn1,cn2,cn3,cn4,ptraut)                      
      else                                                              
        stop 'shellj - select type of n-shell correction'               
      endif                                                             
!                                                                       
!        o-shell                                               value    
!        routine name  author         type                     ioshl    
!        ------------  -------------- ---------------------    ----     
!        shelso        scaled from m  indiv. subshell(scaled     1      
!                                     using Bichsel subshell            
!                                     m shell)                          
!        sheljo        j. janni       indiv. subshell(original   2      
!                                     method using Janni                
!                                     l shell)                          
!                                                                       
      if (ioshl.eq.1) then                                              
        co=shelso(z,betasq,co1,co2,co3,ptraut)                          
      elseif (ioshl.eq.2) then                                          
        co=sheljo(z,betasq,co1,co2,co3,ptraut)                          
      else                                                              
        stop 'shellj - select type of o-shell correction'               
      endif                                                             
!                                                                       
!        p-shell                                               value    
!        routine name  author         type                     ipshl    
!        ------------  -------------- ---------------------    ----     
!        shelsp        scaled from m  indiv. subshell (scaled    1      
!                                     using Bichsel subshell            
!                                     m shell)                          
!        sheljp        j. janni       indiv. subshell            2      
!                                     (original method using            
!                                     Janni l shell)                    
!                                                                       
      if (ipshl.eq.1) then                                              
        cp=shelsp(z,betasq,cp1,cp2,cp3,ptraut)                          
      elseif (ipshl.eq.2) then                                          
        cp=sheljp(z,betasq,cp1,cp2,cp3,ptraut)                          
      else                                                              
        stop 'shellj - select type of p-shell correction'               
      endif                                                             
!                                                                       
!        add all the shell corrections together to obtain               
!        the total shell correction.                                    
!                                                                       
      shellj=ck+cl+cm+cn+co+cp                                          
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function shelsm (z,betasq,cm1,cm2,cm3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell correction       
!                   using the scaled method. this method involves       
!                   scaling the bichsel l shell correction to produce   
!                   the m shell correction. the physics in this         
!                   routine is described in reference 133:              
!                                                                       
!                     h. bichsel, "higher shell corrections in stopping 
!                     power," univ of southern california linear        
!                     accelerator group technical report no. 3 (1961).  
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   15 september 1984                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - logical variable, if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelsm - the m-shell correction as computed using   
!                            scaling method.                            
!                   cm1    - s subshell correction.                     
!                   cm2    - p subshell correction.                     
!                   cm3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        initialize the shell and subshell corrections to zero.         
!                                                                       
      iz=nint(z)                                                        
      cm1=0.0                                                           
      cm2=0.0                                                           
      cm3=0.0                                                           
      shelsm=0.0                                                        
!                                                                       
!        set the m-shell scaling factor.                                
!                                                                       
      fudge=1.6                                                         
!                                                                       
!        compute each of the subshell corrections separately, using     
!        the scaling method based upon the bichsel l shell.             
!                                                                       
!        the s subshell is first. compute the ratio, verify that        
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(2,iz).ne.0.0).and.(eshel(4,iz).ne.0.0)) then           
        ratio=eshel(2,iz)/eshel(4,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual m shell, s subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cm1=(shel(4,iz)/shel(2,iz))*(1.0-betasq)    
     &  *subb1l(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cm1.lt.0.0) cm1=1.5*cm1                                     
      endif                                                             
!                                                                       
!        the p subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(3,iz).ne.0.0).and.(eshel(5,iz).ne.0.0)) then           
        ratio=eshel(3,iz)/eshel(5,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual m shell, p subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cm2=(shel(5,iz)/shel(3,iz))*(1.0-betasq)    
     &  *subb2l(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cm2.lt.0.0) cm2=1.5*cm2                                     
      endif                                                             
!                                                                       
!        the d subshell is last. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(3,iz).ne.0.0).and.(eshel(6,iz).ne.0.0)) then           
        ratio=eshel(3,iz)/eshel(6,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual m shell, d subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cm3=(shel(6,iz)/shel(3,iz))*(1.0-betasq)    
     &  *subb2l(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cm3.lt.0.0) cm3=1.5*cm3                                     
      endif                                                             
!                                                                       
!        compute the total scaled m shell by adding up the subshell     
!        corrections.                                                   
!                                                                       
      shelsm=cm1+cm2+cm3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('m-shell - scaled subshell method.')                      
      end                                                               
*
************************************************************************
*
      function shelsn (z,betasq,cn1,cn2,cn3,cn4,ptraut)                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the n-shell correction       
!                   using the scaled method. this method involves       
!                   scaling the bichsel m shell correction to produce   
!                   the m shell correction. the physics in this         
!                   routine is described in reference 133:              
!                                                                       
!                     h. bichsel, "higher shell corrections in stopping 
!                     power," univ of southern california linear        
!                     accelerator group technical report no. 3 (1961).  
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   15 september 1984                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable, if true then author and 
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelsn - the n-shell correction as computed using   
!                            scaling method.                            
!                   cn1    - s subshell correction.                     
!                   cn2    - p subshell correction.                     
!                   cn3    - d subshell correction.                     
!                   cn4    - f subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        initialize the shell and subshell corrections to zero.         
!                                                                       
      iz=nint(z)                                                        
      cn1=0.0                                                           
      cn2=0.0                                                           
      cn3=0.0                                                           
      cn4=0.0                                                           
      shelsn=0.0                                                        
!                                                                       
!        set the n-shell scaling factor.                                
!                                                                       
      fudge=1.8                                                         
!                                                                       
!        compute each of the subshell corrections separately, using     
!        the scaling method based upon the bichsel m shell.             
!                                                                       
!        the s subshell is first. compute the ratio, verify that        
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(4,iz).ne.0.0).and.(eshel(7,iz).ne.0.0)) then           
        ratio=eshel(4,iz)/eshel(7,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual n shell, s subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cn1=(shel(7,iz)/shel(4,iz))*(1.0-betasq)    
     &  *subb1m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cn1.lt.0.0) cn1=1.0*cn1                                     
      endif                                                             
!                                                                       
!        the p subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(5,iz).ne.0.0).and.(eshel(8,iz).ne.0.0)) then           
        ratio=eshel(5,iz)/eshel(8,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual n shell, p subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cn2=(shel(8,iz)/shel(5,iz))*(1.0-betasq)    
     &  *subb2m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cn2.lt.0.0) cn2=1.0*cn2                                     
      endif                                                             
!                                                                       
!        the d subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(6,iz).ne.0.0).and.(eshel(9,iz).ne.0.0)) then           
        ratio=eshel(6,iz)/eshel(9,iz)                                   
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual n shell, d subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cn3=(shel(9,iz)/shel(6,iz))*(1.0-betasq)    
     &  *subb3m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cn3.lt.0.0) cn3=1.0*cn3                                     
      endif                                                             
!                                                                       
!        the f subshell is last. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(6,iz).ne.0.0).and.(eshel(10,iz).ne.0.0)) then          
        ratio=eshel(6,iz)/eshel(10,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual n shell, f subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cn4=(shel(10,iz)/shel(6,iz))*(1.0-betasq)   
     &  *subb3m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cn4.lt.0.0) cn4=1.0*cn4                                     
      endif                                                             
!                                                                       
!        compute the total scaled n shell by adding up the subshell     
!        corrections.                                                   
!                                                                       
      shelsn=cn1+cn2+cn3+cn4                                            
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut flag set.                               
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('n-shell - scaled subshell method.')                      
      end                                                               
*
************************************************************************
*
      function shelso (z,betasq,co1,co2,co3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the o-shell correction       
!                   using the scaled method. this method involves       
!                   scaling the bichsel m shell correction to produce   
!                   the o shell correction. the physics in this         
!                   routine is described in reference 133:              
!                                                                       
!                     h. bichsel, "higher shell corrections in stopping 
!                     power," univ of southern california linear        
!                     accelerator group technical report no. 3 (1961).  
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   15 september 1984                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable,if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelso - the o-shell correction as computed using   
!                            scaling method.                            
!                   co1    - s subshell correction.                     
!                   co2    - p subshell correction.                     
!                   co3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        initialize the shell and subshell corrections to zero.         
!                                                                       
      iz=nint(z)                                                        
      co1=0.0                                                           
      co2=0.0                                                           
      co3=0.0                                                           
      shelso=0.0                                                        
!                                                                       
!        set the o-shell scaling factor.                                
!                                                                       
      fudge=1.8                                                         
!                                                                       
!        compute each of the subshell corrections separately, using     
!        the scaling method based upon the bichsel m shell.             
!                                                                       
!        the s subshell is first. compute the ratio, verify that        
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(4,iz).ne.0.0).and.(eshel(11,iz).ne.0.0)) then          
        ratio=eshel(4,iz)/eshel(11,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual o shell, s subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) co1=(shel(11,iz)/shel(4,iz))*(1.0-betasq)   
     &  *subb1m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (co1.lt.0.0) co1=1.0*co1                                     
      endif                                                             
!                                                                       
!        the p subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(5,iz).ne.0.0).and.(eshel(12,iz).ne.0.0)) then          
        ratio=eshel(5,iz)/eshel(12,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual o shell, p subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) co2=(shel(12,iz)/shel(5,iz))*(1.0-betasq)   
     &  *subb2m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (co2.lt.0.0) co2=1.0*co2                                     
      endif                                                             
!                                                                       
!        the d subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(6,iz).ne.0.0).and.(eshel(13,iz).ne.0.0)) then          
        ratio=eshel(6,iz)/eshel(13,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual o shell, d subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) co3=(shel(13,iz)/shel(6,iz))*(1.0-betasq)   
     &  *subb3m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (co3.lt.0.0) co3=1.0*co3                                     
      endif                                                             
!                                                                       
!        compute the total scaled o shell by adding up the subshell     
!        corrections.                                                   
!                                                                       
      shelso=co1+co2+co3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('o-shell - scaled subshell method.')                      
      end                                                               
*
************************************************************************
*
      function shelsp (z,betasq,cp1,cp2,cp3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the p-shell correction       
!                   using the scaled method. this method involves       
!                   scaling the bichsel m shell correction to produce   
!                   the p shell correction. the physics in this         
!                   routine is described in reference 133:              
!                                                                       
!                     h. bichsel, "higher shell corrections in stopping 
!                     power," univ of southern california linear        
!                     accelerator group technical report no. 3 (1961).  
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   15 september 1984                                   
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut - flag specifying to write out author        
!                            and reference information to scratch file. 
!                                                                       
!        outputs :  shelsp - the p-shell correction as computed using   
!                            scaling method.                            
!                   cp1    - s subshell correction.                     
!                   cp2    - p subshell correction.                     
!                   cp3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        initialize the shell and subshell corrections to zero.         
!                                                                       
      iz=nint(z)                                                        
      cp1=0.0                                                           
      cp2=0.0                                                           
      cp3=0.0                                                           
      shelsp=0.0                                                        
!                                                                       
!        set the p-shell scaling factor.                                
!                                                                       
      fudge=1.0                                                         
!                                                                       
!        compute each of the subshell corrections separately, using     
!        the scaling method based upon the bichsel m shell.             
!                                                                       
!        the s subshell is first. compute the ratio, verify that        
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(4,iz).ne.0.0).and.(eshel(15,iz).ne.0.0)) then          
        ratio=eshel(4,iz)/eshel(15,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual p shell, s subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cp1=(shel(15,iz)/shel(4,iz))*(1.0-betasq)   
     &  *subb1m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cp1.lt.0.0) cp1=1.0*cp1                                     
      endif                                                             
!                                                                       
!        the p subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(5,iz).ne.0.0).and.(eshel(16,iz).ne.0.0)) then          
        ratio=eshel(5,iz)/eshel(16,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual p shell, p subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cp2=(shel(16,iz)/shel(5,iz))*(1.0-betasq)   
     &  *subb2m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cp2.lt.0.0) cp2=1.0*cp2                                     
      endif                                                             
!                                                                       
!        the d subshell is next. compute the ratio, verify that         
!        electrons actually in the subshell, if not then bypass         
!        computation.                                                   
!                                                                       
      if ((eshel(6,iz).ne.0.0).and.(eshel(17,iz).ne.0.0)) then          
        ratio=eshel(6,iz)/eshel(17,iz)                                  
!                                                                       
!        then compute the scaled beta squared value.                    
!                                                                       
        bsqscl=(betasq*ratio)/fudge                                     
!                                                                       
!        check scaled beta squared value and then compute the           
!        actual p shell, d subshell correction.                         
!                                                                       
        if (bsqscl.le.0.99) cp3=(shel(17,iz)/shel(6,iz))*(1.0-betasq)   
     &  *subb3m(z,bsqscl)/(1.0-bsqscl)                                  
!                                                                       
        if (cp3.lt.0.0) cp3=1.0*cp3                                     
      endif                                                             
!                                                                       
!        compute the total scaled o shell by adding up the subshell     
!        corrections.                                                   
!                                                                       
      shelsp=cp1+cp2+cp3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('p-shell - scaled subshell method.')                      
      end                                                               
*
************************************************************************
*
      function shelwk (z,betasq,ptraut)                                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the k-shell correction       
!                   using the physics discribed in reference 129:       
!                                                                       
!                     m. walske, "stopping power of k-electrons,"       
!                     physical review,  vol 88, number 6 (1952).        
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   13 may 1984                                         
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable,if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelwk - the k-shell correction as computed using   
!                            Walske method and data.                    
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd1(26), thtgd1(3), shlkgd(26,3), thtgd2(5), s(5), t(
     & 5), u(5), v(5), w(5), etagd2(12), b(12,3)                        
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
!        note, the eta grid, theta 1 grid, and the k-shell correction   
!        grid below is taken from an article by bichsel.                
!                                                                       
      data etagd1 /0.500,0.526,0.556,0.588,0.625,0.645,0.714,0.769,0.833
     & ,0.909,1.000,1.110,1.250,1.430,1.540,1.670,1.820,2.000,2.220,2.50
     & 0,2.860,3.330,4.000,5.000,10.00,20.00/                           
!                                                                       
      data thtgd1 /0.7,0.8,0.9/                                         
!                                                                       
      data (shlkgd(i,1),i=1,26) /0.619,0.667,0.711,0.753,0.796,0.836,0.8
     & 73,0.907,0.936,0.958,0.974,0.983,0.982,0.961,0.941,0.916,0.885,0.
     & 849,0.805,0.755,0.694,0.621,0.537,0.450,0.2407,0.1153/           
      data (shlkgd(i,2),i=1,26) /0.710,0.757,0.797,0.833,0.870,0.903,0.9
     & 35,0.966,0.991,1.013,1.025,1.029,1.019,0.993,0.973,0.947,0.916,0.
     & 878,0.831,0.776,0.708,0.635,0.555,0.460,0.2460,0.1180/           
      data (shlkgd(i,3),i=1,26) /0.745,0.784,0.824,0.862,0.899,0.933,0.9
     & 64,0.991,1.013,1.031,1.041,1.043,1.033,1.003,0.981,0.955,0.923,0.
     & 886,0.840,0.783,0.720,0.645,0.560,0.465,0.2472,0.1186/           
!                                                                       
      data thtgd2 /0.700,0.750,0.800,0.850,0.900/                       
!                                                                       
      data s /1.8133,1.7223,1.6457,1.5807,1.5250/                       
!                                                                       
      data t /2.4603,2.4044,2.3462,2.2868,2.2273/                       
!                                                                       
      data u /2.0662,2.0999,2.1196,2.1290,2.1309/                       
!                                                                       
      data v /7.3246,7.3194,7.3191,7.3218,7.3263/                       
!                                                                       
      data w /45.0,45.0,45.0,45.0,45.0/                                 
!                                                                       
      data etagd2 /0.0,0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.45,0.5,0.55
     & /                                                                
!                                                                       
      data b /0.0,0.0,0.01,0.05,0.11,0.17,0.24,0.32,0.40,0.49,0.58,0.67,
     & 0.0,0.0,0.01,0.04,0.07,0.13,0.19,0.26,0.33,0.41,0.49,0.58,0.0,0.0
     & ,0.01,0.03,0.06,0.10,0.15,0.21,0.28,0.35,0.44,0.46/              
!                                                                       
      iz=nint(z)                                                        
      shelwk=0.0                                                        
!                                                                       
!        if the element is hydrogen then return.                        
!                                                                       
      if (iz.eq.1) return                                               
!                                                                       
!        obtain the theta value.                                        
!                                                                       
      thetak=thetas(1,iz)                                               
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for shelwk                            
!                                                                       
      etaval=eta(z,1,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values, eta less than 0.5.            
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.lt.0.50)) then                    
!                                                                       
!        compute the 'b' value first.                                   
!        interpolate to obtain the b value since data is available.     
!                                                                       
        ngrid=12                                                        
        ngrid2=3                                                        
        bvalue=alin3d(etaval,thetak,etagd2,thtgd1,b,ngrid,ngrid2,ildaln)
!                                                                       
!         actual computation of the low eta k-shell correction.         
!                                                                       
        ngrid3=5                                                        
        shelwk=alin(thetak,thtgd2,s,ngrid3,ildaln)*log(etaval)+alin     
     &  (thetak,thtgd2,t,ngrid3,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the k-shell correction medium eta values.             
!                                                                       
      if ((etaval.ge.0.50).and.(etaval.le.20.0)) then                   
        ngrid=26                                                        
        ngrid2=3                                                        
        shelwk=alin3d(etaval,thetak,etagd1,thtgd1,shlkgd,ngrid,ngrid2   
     &  ,ildaln)                                                        
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the k-shell correction for high eta values.           
!                                                                       
      ngrid3=5                                                          
      if (etaval.gt.20.0) shelwk=alin(thetak,thtgd2,u,ngrid3,ildaln)    
     & /etaval+alin(thetak,thtgd2,v,ngrid3,ildaln)/(etaval**2)-alin     
     & (thetak,thtgd2,w,ngrid3,ildaln)/(etaval**3)                      
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format('k-shell - walske''s total shell method, physical review,',
     & ' vol. 88 (1952).')                                              
      end                                                               
*
************************************************************************
*
      function shelwl (z,betasq,cl1,cl2,ptraut)                         
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell correction       
!                   using the physics discribed in reference 130:       
!                                                                       
!                     m. walske, "stopping power of l-electrons,"       
!                     physical review,  vol 101, number 26 (1956).      
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   13 may 1984                                         
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable,if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shelwl - the l-shell correction as computed using   
!                            Walske method and data.                    
!                   cl1    - the l-shell, s-subshell correction.        
!                   cl2    - the l-shell, p-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd1(5), thtgd(4), shllgd(6,4), s(4), t(4), u(4),     
     & etagd2(6), b(5,4)                                                
      character*3 ildaln                                                
      logical ptraut                                                    
!                                                                       
      data etagd1 /0.0,0.25,0.50,0.75,1.0/                              
!                                                                       
      data thtgd /0.35,0.45,0.55,0.65/                                  
!                                                                       
      data s /10.0371,7.9116,6.7451,6.0345/                             
!                                                                       
      data t /28.1449,24.4501,21.9061,20.0154/                          
!                                                                       
      data u /1.5032,1.8756,1.9890,2.0040/                              
!                                                                       
      data etagd2 /1.0,3.5,10.0,25.0,100.0,1000.0/                      
!                                                                       
      data (shllgd(i,1),i=1,6) /1.6934,0.4917,0.1619,0.06235,0.01516,0.0
     & 01505/                                                           
      data (shllgd(i,2),i=1,6) /2.0298,0.5950,0.1988,0.07719,0.01888,0.0
     & 01877/                                                           
      data (shllgd(i,3),i=1,6) /2.1358,0.6268,0.2100,0.08171,0.02001,0.0
     & 01991/                                                           
      data (shllgd(i,4),i=1,6) /2.1519,0.6312,0.2116,0.08232,0.02016,0.0
     & 02006/                                                           
!                                                                       
      data b /0.0,11.0,18.40,23.10,26.52,0.0,9.80,15.60,19.70,22.48,0.0,
     & 7.90,13.70,17.10,19.8,0.0,6.80,12.20,15.50,17.89/                
!                                                                       
!        initialize.                                                    
!                                                                       
      iz=nint(z)                                                        
      cl1=0.0                                                           
      cl2=0.0                                                           
      shelwl=0.0                                                        
!                                                                       
!        first check to make sure that there are electrons in this      
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(2,iz).eq.0.0).and.(shel(3,iz).eq.0.0)) return           
!                                                                       
!        compute the average theta value. then, check the value,        
!        if the theta is zero, then return                              
!                                                                       
      thetal=((shel(2,iz)*thetas(2,iz))+(shel(3,iz)*thetas(3,iz)))/(shel
     & (2,iz)+shel(3,iz))                                               
!                                                                       
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the average eta value then check its range to          
!        determine which computation to use for shelwl.                 
!                                                                       
      etaval=((eshel(2,iz)*eta(z,2,betasq))+(eshel(3,iz)*eta(z,3,betasq)
     & ))/(eshel(2,iz)+eshel(3,iz))                                     
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than 1.0).           
!                                                                       
      if ((etaval.lt.1.0).and.(etaval.ge.0.0)) then                     
!                                                                       
!        compute the 'b' value first.                                   
!        interpolate to obtain the b value since data is available.     
!                                                                       
        ngrid=5                                                         
        ngrid2=4                                                        
        bvalue=alin3d(etaval,thetal,etagd1,thtgd,b,ngrid,ngrid2,ildaln) 
!                                                                       
!        actual computation of the low eta l-shell correction.          
!                                                                       
        shelwl=alin(thetal,thtgd,s,ngrid2,ildaln)*log(etaval)+alin      
     &  (thetal,thtgd,t,ngrid2,ildaln)-bvalue                           
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the l-shell correction medium eta values.             
!                                                                       
      ngrid=6                                                           
      ngrid2=4                                                          
      if ((etaval.ge.1.0).and.(etaval.le.1000.0)) shelwl=alin3d(etaval  
     & ,thetal,etagd2,thtgd,shllgd,ngrid,ngrid2,ildaln)                 
!                                                                       
!        evaluate the l-shell correction for high eta values.           
!                                                                       
      ngrid=4                                                           
      if (etaval.gt.1000.0) shelwl=alin(thetal,thtgd,u,ngrid,ildaln)    
     & /etaval                                                          
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('l-shell -  walske''s total shell method, ',              
     & 'physical review, vol. 101 (1956).')                             
      end                                                               
*
************************************************************************
*
      function shlbil (z,betasq,cl1,cl2,ptraut)                         
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell                  
!                   correction using the physics discribed in           
!                   reference 138. in this case each subshell           
!                   is calculated separately (in routines               
!                   subb1l and subb2l).                                 
!                                                                       
!                     h. bichsel, "the l-shell correction in            
!                     stopping power," usc-136-120 (1967).              
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable,if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shlbil - the l-shell correction as computed using   
!                            Bichsel method and data.                   
!                   cl1    - the l-shell, s-subshell correction.        
!                   cl2    - the l-shell, p-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        first initialize the shell and subshell corrections to zero.   
!                                                                       
      iz=nint(z)                                                        
      cl1=0.0                                                           
      cl2=0.0                                                           
      shlbil=0.0                                                        
!                                                                       
!        check to make sure that there are electrons in this            
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(2,iz).eq.0.0).and.(shel(3,iz).eq.0.0)) return           
!                                                                       
!        compute the correction for each subshell via routines          
!        subb1l and subb2l. the values of c1 and c2 are the correction  
!        per total subshell.                                            
!                                                                       
      cl1=subb1l(z,betasq)                                              
      cl2=subb2l(z,betasq)                                              
!                                                                       
!        add the two subshell correction values to obtain the           
!        total correction of the l shell.                               
!                                                                       
      shlbil=cl1+cl2                                                    
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format                                                            
     & ('l-shell - bichsel''s subshell method, usc-136-120 (1967).')    
      end                                                               
*
************************************************************************
*
      function shlkim (z,betasq,cm1,cm2,cm3,ptraut)                     
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell correction       
!                   using the physics discribed in reference 137:       
!                                                                       
!                     g. khandelwal and e. merzbacher,                  
!                     "stopping power of m electrons,"                  
!                     physical review, vol 144, number 1 (1966)         
!                                                                       
!                   and in the reference:                               
!                                                                       
!                     g. khandelwal, "stopping power of m electrons     
!                     for heavy charged particles," unpublished         
!                     paper, 9 oct. 1982                                
!                                                                       
!                   and using data supplied in a letter from            
!                   g. khandelwal to joe janni dated 31 january, 1968.  
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   30 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                   ptraut  - logical variable,if true then author and  
!                            reference information written to scratch fi
!                                                                       
!        outputs :  shlkim - the m-shell correction as computed using   
!                            Khandelwal method and data.                
!                   cm1    - s subshell correction.                     
!                   cm2    - p subshell correction.                     
!                   cm3    - d subshell correction.                     
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      logical ptraut                                                    
!                                                                       
!        first, initialize the correction values.                       
!                                                                       
      iz=nint(z)                                                        
      cm1=0.0                                                           
      cm2=0.0                                                           
      cm3=0.0                                                           
      shlkim=0.0                                                        
!                                                                       
!        check to make sure that there are electrons in this            
!        shell. if there are no electrons, return.                      
!                                                                       
      if ((shel(4,iz).eq.0.0).and.(shel(5,iz).eq.0.0).and.(shel(6,iz).eq
     & .0.0)) return                                                    
!                                                                       
!        compute the correction for each subshell via routines          
!        subk1m, subk2m, and subk3m. then, compute the total            
!        shell correction using the values of the subshells.            
!                                                                       
      cm1=subk1m(z,betasq)                                              
      cm2=subk2m(z,betasq)                                              
      cm3=subk3m(z,betasq)                                              
!                                                                       
      shlkim=cm1+cm2+cm3                                                
!                                                                       
!        write out the author and reference information to              
!        scratch file if ptraut is true.                                
!                                                                       
      if (ptraut) write (10,10)                                         
!                                                                       
      return                                                            
!                                                                       
   10 format ('m-shell - khandelwal''s subshell method, ',              
     & 'physical review, vol. 144 (1966).')                             
      end                                                               
*
************************************************************************
*
      function subb1l (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell, s-subshell      
!                   correction using the physics discribed in           
!                   reference 138.                                      
!                                                                       
!                     h. bichsel, "the l-shell correction in            
!                     stopping power," usc-136-120 (1967).              
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subb1l - the l-shell, s-subshell correction as      
!                            computed using Bichsel method and data.    
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd1(2), thtgd(7), shllgd(112,7), s(7), t(7), u(7), v(
     & 7), etagd2(112), b(2,7)                                          
      character*3 ildaln                                                
!                                                                       
      data etagd1 /0.0,0.01/                                            
!                                                                       
      data thtgd /0.35,0.40,0.45,0.50,0.55,0.60,0.65/                   
!                                                                       
      data s /10.0371,8.8015,7.9116,7.2501,6.7451,6.3503,6.0345/        
      data t /28.1449,26.1070,24.4501,23.0729,21.9061,20.8993,20.0154/  
      data u /1.503,1.732,1.876,1.955,1.989,1.999,2.004/                
      data v /1.543,1.520,1.506,1.500,1.498,1.499,1.500/                
      data w /4.0/                                                      
      data x /4.43/                                                     
!                                                                       
      data (b(i,1),i=1,2) /0.0000,0.0442/                               
      data (b(i,2),i=1,2) /0.0000,0.0291/                               
      data (b(i,3),i=1,2) /0.0000,0.9184/                               
      data (b(i,4),i=1,2) /0.0000,0.0131/                               
      data (b(i,5),i=1,2) /0.0000,0.0090/                               
      data (b(i,6),i=1,2) /0.0000,0.0063/                               
      data (b(i,7),i=1,2) /0.0000,0.0044/                               
!                                                                       
      data etagd2 /0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.10,0.1
     & 1,0.12,0.13,0.14,0.15,0.20,0.25,0.30,0.35,0.40,0.45,0.50,0.55,0.6
     & 0,0.65,0.70,0.75,0.80,0.85,0.90,0.95,1.00,1.05,1.10,1.15,1.20,1.2
     & 5,1.30,1.35,1.40,1.45,1.50,1.55,1.60,1.65,1.70,1.75,1.80,1.85,1.9
     & 0,1.95,2.00,2.05,2.10,2.15,2.20,2.25,2.30,2.35,2.40,2.45,2.50,2.5
     & 5,2.60,2.65,2.70,2.75,2.80,2.85,2.90,2.95,3.00,3.05,3.10,3.15,3.2
     & 0,3.25,3.30,3.35,3.40,3.45,3.50,3.55,3.60,3.65,3.70,3.75,3.80,3.8
     & 5,3.90,3.95,4.00,4.05,4.10,4.15,4.20,4.25,4.30,4.35,4.40,4.45,4.5
     & 0,4.55,4.60,4.65,4.70,4.75,4.80,4.85,4.90,4.95,5.00/             
!                                                                       
!        theta is 0.350.                                                
!                                                                       
      data (shllgd(i,1),i=1,112) /-18.1218,-11.3605,-7.6084,-5.1188,-3.3
     & 297,-1.9845,-0.19434,-0.1217,0.5361,1.0680,1.5012,1.8558,2.1471,2
     & .3867,2.5837,3.1427,3.3055,3.2900,3.1926,3.0592,2.9128,2.7650,2.6
     & 217,2.4858,2.3584,2.2398,2.1298,2.0278,1.9335,1.8461,1.7651,1.690
     & 0,1.6202,1.5552,1.4947,1.4382,1.3854,1.3359,1.2896,1.2460,1.2051,
     & 1.1665,1.1301,1.0958,1.0633,1.0326,1.0034,0.9757,0.9494,0.9244,0.
     & 9006,0.8779,0.8563,0.8356,0.8158,0.7969,0.7788,0.7615,0.7449,0.72
     & 89,0.7136,0.6989,0.6847,0.6711,0.6579,0.6453,0.6331,0.6213,0.6100
     & ,0.5990,0.5884,0.5781,0.5682,0.5586,0.5494,0.5403,0.5316,0.5232,0
     & .5150,0.5070,0.4993,0.4918,0.4845,0.4774,0.4705,0.4638,0.4573,0.4
     & 509,0.4447,0.4387,0.4329,0.4271,0.4216,0.4161,0.4108,0.4057,0.400
     & 6,0.3957,0.3909,0.3862,0.3816,0.3771,0.3727,0.3684,0.3642,0.3601,
     & 0.3561,0.3522,0.3483,0.3446,0.3409,0.3373/                       
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (shllgd(i,2),i=1,112) /-14.4545,-8.5037,-5.1970,-3.0059,-1.43
     & 66,-0.2626,0.6400,1.3467,1.9069,2.3547,2.7145,3.0044,3.2380,3.425
     & 9,3.5762,3.9554,3.9956,3.8906,3.7247,3.5372,3.3468,3.1626,2.9887,
     & 2.8266,2.6765,2.5381,2.4107,2.2933,2.1851,2.0853,1.9931,1.9077,1.
     & 8286,1.7551,1.6868,1.6231,1.5635,1.5079,1.4558,1.4068,1.3608,1.31
     & 75,1.2767,1.2382,1.2017,1.1673,1.1346,1.1036,1.0741,1.0461,1.0195
     & ,0.9941,0.9698,0.9467,0.9246,0.9034,0.8831,0.8637,0.8451,0.8272,0
     & .8101,0.7936,0.7778,0.7625,0.7478,0.7336,0.7200,0.7068,0.6941,0.6
     & 818,0.6699,0.6584,0.6473,0.6366,0.6262,0.6161,0.6063,0.5968,0.587
     & 6,0.5787,0.5700,0.5616,0.5534,0.5455,0.5378,0.5302,0.5229,0.5158,
     & 0.5089,0.5021,0.4955,0.4891,0.4829,0.4768,0.4708,0.4650,0.4594,0.
     & 4538,0.4484,0.4431,0.4380,0.4329,0.4280,0.4232,0.4185,0.4139,0.40
     & 94,0.4049,0.4006,0.3964,0.3923,0.3882/                           
!                                                                       
!        theta is 0.450.                                                
!                                                                       
      data (shllgd(i,3),i=1,112) /-12.0035,-6.6343,-3.6427,-1.6597,-0.24
     & 15,0.8162,1.6257,2.2557,2.7513,3.1439,3.4558,3.7037,3.9001,4.0547
     & ,4.1752,4.4406,4.4042,4.2439,4.0360,3.8154,3.5983,3.3921,3.1997,3
     & .0218,2.8582,2.7080,2.5701,2.4434,2.3270,2.2198,2.1209,2.0295,1.9
     & 448,1.8663,1.7932,1.7252,1.6617,1.6024,1.5468,1.4947,1.4457,1.399
     & 6,1.3561,1.3151,1.2763,1.2396,1.2049,1.1719,1.1406,1.1108,1.0824,
     & 1.0554,1.0296,1.0050,0.9814,0.9589,0.9374,0.9167,0.8969,0.8779,0.
     & 8597,0.8422,0.8253,0.8090,0.7934,0.7783,0.7638,0.7498,0.7362,0.72
     & 32,0.7105,0.6983,0.6865,0.6750,0.6640,0.6532,0.6428,0.6327,0.6229
     & ,0.6134,0.6042,0.5952,0.5865,0.5781,0.5698,0.5618,0.5540,0.5464,0
     & .5390,0.5318,0.5248,0.5180,0.5113,0.5048,0.4985,0.4923,0.4862,0.4
     & 803,0.4746,0.4689,0.4634,0.4581,0.4528,0.4476,0.4426,0.4377,0.432
     & 9,0.4282,0.4235,0.4190,0.4146,0.4103/                            
!                                                                       
!        theta is 0.50.                                                 
!                                                                       
      data (shllgd(i,4),i=1,112) /-10.3281,-5.3904,-2.6292,-0.7955,0.516
     & 1,1.4929,2.2386,2.8167,3.2692,3.6252,3.9056,4.1261,4.2984,4.4317,
     & 4.5331,4.7269,4.6432,4.4492,4.2160,3.9756,3.7427,3.5236,3.3203,3.
     & 1332,2.9617,2.8046,2.6607,2.5287,2.4076,2.2961,2.1933,2.0985,2.01
     & 06,1.9292,1.8535,1.7830,1.7173,1.6558,1.5983,1.5443,1.4937,1.4460
     & ,1.4010,1.3586,1.3185,1.2806,1.2446,1.2105,1.1781,1.1473,1.1180,1
     & .0901,1.0634,1.0380,1.0137,0.9904,0.9681,0.9468,0.9263,0.9067,0.8
     & 878,0.8697,0.8523,0.8355,0.8193,0.8037,0.7887,0.7742,0.7602,0.746
     & 7,0.7336,0.7210,0.7088,0.6970,0.6855,0.6744,0.6636,0.6532,0.6431,
     & 0.6333,0.6237,0.6145,0.6054,0.5967,0.5882,0.5799,0.5718,0.5640,0.
     & 5563,0.5489,0.5416,0.5346,0.5276,0.5209,0.5144,0.5080,0.5017,0.49
     & 56,0.4896,0.4838,0.4781,0.4726,0.4671,0.4618,0.4566,0.4515,0.4465
     & ,0.4416,0.4369,0.4322,0.4276,0.4231/                             
!                                                                       
!        theta is 0.550.                                                
!                                                                       
      data (shllgd(i,5),i=1,112) /-9.1652,-4.5568,-1.9690,-0.2453,0.9894
     & ,1.9092,2.6107,3.1534,3.5770,3.9087,4.1687,4.3715,4.5285,4.6482,4
     & .7376,4.8875,4.7757,4.5621,4.3145,4.0630,3.8213,3.5950,3.3858,3.1
     & 937,3.0179,2.8571,2.7100,2.5752,2.4515,2.3378,2.2331,2.1364,2.046
     & 9,1.9639,1.8869,1.8151,1.7482,1.6857,1.6271,1.5723,1.5207,1.4722,
     & 1.4265,1.3833,1.3426,1.3040,1.2675,1.2328,1.1999,1.1686,1.1388,1.
     & 1104,1.0833,1.0575,1.0327,1.0091,0.9865,0.9648,0.9440,0.9240,0.90
     & 49,0.8865,0.8687,0.8517,0.8353,0.8194,0.8042,0.7894,0.7752,0.7615
     & ,0.7482,0.7354,0.7230,0.7110,0.6993,0.6880,0.6771,0.6665,0.6562,0
     & .6462,0.6365,0.6271,0.6180,0.6091,0.6004,0.5920,0.5838,0.5758,0.5
     & 681,0.5605,0.5531,0.5460,0.5390,0.5321,0.5254,0.5189,0.5126,0.506
     & 4,0.5003,0.4944,0.4886,0.4830,0.4774,0.4720,0.4667,0.4616,0.4565,
     & 0.4516,0.4467,0.4420,0.4373,0.4328/                              
!                                                                       
!        theta is 0.60.                                                 
!                                                                       
      data (shllgd(i,6),i=1,112) /-8.3512,-4.0007,-1.5468,0.0938,1.2720,
     & 2.1509,2.8216,3.3403,3.7445,4.0606,4.3074,4.4992,4.6467,4.7583,4.
     & 8406,4.9652,4.8381,4.6142,4.3592,4.1023,3.8564,3.6267,3.4147,3.22
     & 04,3.0426,2.8802,2.7316,2.5956,2.4708,2.3561,2.2505,2.1530,2.0628
     & ,1.9793,1.9016,1.8293,1.7620,1.6990,1.6400,1.5847,1.5328,1.4840,1
     & .4380,1.3946,1.3535,1.3147,1.2779,1.2430,1.2099,1.1784,1.1484,1.1
     & 198,1.0926,1.0666,1.0417,1.0179,0.9951,0.9733,0.9524,0.9323,0.913
     & 0,0.8945,0.8767,0.8595,0.8430,0.8271,0.8117,0.7969,0.7826,0.7688,
     & 0.7555,0.7425,0.7300,0.7180,0.7063,0.6949,0.6839,0.6732,0.6629,0.
     & 6529,0.6431,0.6336,0.6244,0.6155,0.6068,0.5983,0.5901,0.5821,0.57
     & 43,0.5667,0.5592,0.5520,0.5450,0.5381,0.5314,0.5249,0.5185,0.5122
     & ,0.5061,0.5002,0.4944,0.4887,0.4831,0.4777,0.4724,0.4672,0.4621,0
     & .4571,0.4522,0.4475,0.4428,0.4382/                               
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (shllgd(i,7),i=1,112) /-7.7789,-3.6354,-1.2879,0.2883,1.4240,
     & 2.2732,2.9223,3.4248,3.8164,4.1226,4.3614,4.5466,4.6887,4.7957,4.
     & 8742,4.9861,4.8522,4.6243,4.3667,4.1080,3.8607,3.6300,3.4173,3.22
     & 24,3.0441,2.8813,2.7324,2.5961,2.4711,2.3562,2.2504,2.1528,2.0625
     & ,1.9788,1.9010,1.8286,1.7611,1.6981,1.6391,1.5837,1.5317,1.4829,1
     & .4368,1.3933,1.3522,1.3134,1.2765,1.2416,1.2085,1.1769,1.1469,1.1
     & 183,1.0910,1.0650,1.0401,1.0162,0.9935,0.9716,0.9507,0.9306,0.911
     & 3,0.8927,0.8749,0.8577,0.8412,0.8252,0.8098,0.7950,0.7807,0.7669,
     & 0.7535,0.7406,0.7281,0.7160,0.7043,0.6929,0.6819,0.6712,0.6608,0.
     & 6508,0.6410,0.6315,0.6223,0.6134,0.6047,0.5962,0.5879,0.5799,0.57
     & 21,0.5645,0.5571,0.5498,0.5428,0.5359,0.5292,0.5226,0.5162,0.5100
     & ,0.5039,0.4979,0.4921,0.4864,0.4808,0.4754,0.4701,0.4649,0.4598,0
     & .4548,0.4499,0.4451,0.4404,0.4358/                               
!                                                                       
!         initialize the correction value to zero.                      
!                                                                       
      iz=nint(z)                                                        
      subb1l=0.0                                                        
!                                                                       
!        obtain the theta then check it, if theta is zero, then         
!        return.                                                        
!                                                                       
      thetal=thetas(2,iz)                                               
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to                  
!        determine which computation to use for subb1l.                 
!                                                                       
      etaval=eta(z,2,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than 0.01).          
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.lt.0.01)) then                    
!                                                                       
!        compute the 'b' value first.                                   
!        interpolate to obtain the b value since data is available.     
!                                                                       
        ngrid=2                                                         
        ngrid2=7                                                        
        bvalue=alin3d(etaval,thetal,etagd1,thtgd,b,ngrid,ngrid2,ildaln) 
!                                                                       
!         actual computation of the low eta l-shell correction.         
!                                                                       
        subb1l=alin(thetal,thtgd,s,ngrid2,ildaln)*log(etaval)+alin      
     &  (thetal,thtgd,t,ngrid2,ildaln)-bvalue                           
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the l-shell correction medium eta values.             
!                                                                       
      ngrid=112                                                         
      ngrid2=7                                                          
      if ((etaval.ge.0.01).and.(etaval.le.5.0)) subb1l=alin3d(etaval    
     & ,thetal,etagd2,thtgd,shllgd,ngrid,ngrid2,ildaln)                 
!                                                                       
!        evaluate the l-shell correction for high eta values.           
!                                                                       
      ngrid=7                                                           
      if (etaval.gt.5.0) subb1l=alin(thetal,thtgd,u,ngrid,ildaln)/etaval
     & +alin(thetal,thtgd,v,ngrid,ildaln)/(etaval**2)-w/(etaval**3)+x/  
     & (etaval**4)                                                      
!                                                                       
!        now compute the whole subshell correction from the             
!        per electron subshell correction previously computed.          
!                                                                       
      subb1l=shel(2,iz)*subb1l/(shel(2,iz)+shel(3,iz))                  
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subb1m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, s-subshell      
!                   correction using the physics discribed in the       
!                   reference :                                         
!                                                                       
!                     h. bichsel, "stopping power of m electrons        
!                     for heavy charged particles," physical review a,  
!                     vol. 28, p1147 (1983) and unpublished             
!                     private communication 9 oct 1982.                 
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subb1m - the m-shell, s-subshell correction as      
!                            computed using Bichsel method and data.    
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(34), thetgd(8), s(8), t(8), u(8), shelgd(34,8)    
      character*3 ildaln                                                
!                                                                       
      data etagd /0.0013,0.0016,0.0020,0.0025,0.0032,0.0040,0.0050,0.006
     & 3,0.0079,0.0100,0.0126,0.0158,0.0200,0.0251,0.0316,0.0398,0.0501,
     & 0.0631,0.0794,0.1000,0.1259,0.1585,0.1995,0.2512,0.3162,0.3981,0.
     & 5012,0.6310,0.7943,1.0000,1.2589,1.5849,1.9953,2.5119/           
!                                                                       
      data thetgd /0.27,0.315,0.36,0.45,0.54,0.63,0.72,0.81/            
!                                                                       
      data s /2.1737,2.0136,1.8891,1.7087,1.5845,1.4941,1.4256,1.3720/  
!                                                                       
      data t /8.5062,7.8469,7.3328,6.5745,6.0342,5.6239,5.2982,5.0310/  
!                                                                       
      data u /0.2539,0.2539,0.2541,0.2547,0.2551,0.2553,0.2552,0.2548/  
!                                                                       
      data v /0.01/                                                     
!                                                                       
!        theta is 0.27.                                                 
!                                                                       
      data (shelgd(i,1),i=1,34) /-6.009,-5.508,-5.009,-4.510,-4.013,-3.5
     & 20,-3.033,-2.556,-2.094,-1.651,-1.235,-0.853,-0.511,-0.215,0.030,
     & 0.223,0.366,0.464,0.523,0.550,0.552,0.536,0.507,0.468,0.425,0.380
     & ,0.336,0.293,0.253,0.216,0.182,0.151,0.124,0.101/                
!                                                                       
!        theta is 0.315.                                                
!                                                                       
      data (shelgd(i,2),i=1,34) /-5.599,-5.135,-4.672,-4.209,-3.747,-3.2
     & 88,-2.833,-2.387,-1.952,-1.535,-1.142,-0.780,-0.456,-0.175,0.058,
     & 0.241,0.377,0.469,0.524,0.549,0.550,0.534,0.504,0.466,0.423,0.379
     & ,0.335,0.292,0.252,0.215,0.181,0.151,0.124,0.101/                
!                                                                       
!        theta is 0.360.                                                
!                                                                       
      data (shelgd(i,3),i=1,34) /-5.282,-4.847,-4.412,-3.978,-3.544,-3.1
     & 11,-2.682,-2.258,-1.845,-1.448,-1.072,-0.724,-0.413,-0.143,0.082,
     & 0.258,0.388,0.476,0.529,0.552,0.552,0.535,0.505,0.467,0.424,0.379
     & ,0.335,0.293,0.253,0.215,0.181,0.151,0.124,0.101/                
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (shelgd(i,4),i=1,34) /-4.835,-4.442,-4.049,-3.655,-3.262,-2.8
     & 69,-2.478,-2.090,-1.708,-1.337,-0.984,-0.656,-0.359,-0.102,0.112,
     & 0.281,0.405,0.489,0.538,0.559,0.558,0.539,0.508,0.469,0.426,0.381
     & ,0.336,0.294,0.253,0.216,0.182,0.151,0.124,0.101/                
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (shelgd(i,5),i=1,34) /-4.546,-4.181,-3.817,-3.452,-3.087,-2.7
     & 23,-2.359,-1.996,-1.636,-1.284,-0.946,-0.629,-0.340,-0.087,0.123,
     & 0.290,0.412,0.495,0.543,0.563,0.561,0.542,0.510,0.471,0.427,0.382
     & ,0.337,0.294,0.254,0.216,0.182,0.152,0.125,0.101/                
!                                                                       
!        theta is 0.63.                                                 
!                                                                       
      data (shelgd(i,6),i=1,34) /-4.353,-4.009,-3.665,-3.321,-2.977,-2.6
     & 33,-2.290,-1.946,-1.605,-1.267,-0.940,-0.629,-0.343,-0.092,0.119,
     & 0.287,0.410,0.494,0.543,0.563,0.561,0.542,0.511,0.471,0.427,0.382
     & ,0.337,0.294,0.254,0.217,0.182,0.152,0.125,0.101/                
!                                                                       
!        theta is 0.72.                                                 
!                                                                       
      data (shelgd(i,7),i=1,34) /-4.221,-3.893,-3.565,-3.236,-2.908,-2.5
     & 80,-2.252,-1.925,-1.597,-1.272,-0.953,-0.647,-0.363,-0.110,0.104,
     & 0.275,0.401,0.487,0.538,0.560,0.559,0.540,0.509,0.470,0.427,0.382
     & ,0.337,0.294,0.254,0.216,0.182,0.152,0.125,0.101/                
!                                                                       
!        theta is 0.81.                                                 
!                                                                       
      data (shelgd(i,8),i=1,34) /-4.131,-3.815,-3.499,-3.183,-2.867,-2.5
     & 51,-2.236,-1.920,-1.605,-1.291,-0.980,-0.678,-0.394,-0.138,0.081,
     & 0.256,0.387,0.477,0.530,0.554,0.554,0.537,0.507,0.468,0.425,0.380
     & ,0.336,0.294,0.253,0.216,0.182,0.151,0.124,0.101/                
!                                                                       
!        initialize the subshell correction value to zero.              
!                                                                       
      iz=nint(z)                                                        
      subb1m=0.0                                                        
!                                                                       
!        obtain the theta value, then check the value, if               
!        theta is zero, then return.                                    
!                                                                       
      thetam=thetas(4,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for subb1m.                           
!                                                                       
      etaval=eta(z,4,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        compute subb1m for very low eta values (eta less               
!        than 0.0013).                                                  
!        note, b is very small and is approximated by zero in the       
!        equation below.                                                
!                                                                       
      ngrid=8                                                           
      if (etaval.lt.0.0013) subb1m=alin(thetam,thetgd,s,ngrid,ildaln)   
     & *log(etaval)+alin(thetam,thetgd,t,ngrid,ildaln)-0.0              
!                                                                       
!        evaluate for the low eta values, eta greater than or           
!        equal to 0.0013 but less than or equal to 2.5119.              
!                                                                       
      ngrid=34                                                          
      ngrid2=8                                                          
      if ((etaval.ge.0.0013).and.(etaval.le.2.5119)) subb1m=alin3d      
     & (etaval,thetam,etagd,thetgd,shelgd,ngrid,ngrid2,ildaln)          
!                                                                       
!        evaluate the s-subshell correction for high eta values.        
!                                                                       
      ngrid=8                                                           
      if (etaval.gt.2.5119) subb1m=alin(thetam,thetgd,u,ngrid,ildaln)   
     & /etaval+v/etaval**2                                              
!                                                                       
!        now normalize the whole subshell correction.                   
!                                                                       
      subb1m=shel(4,iz)*subb1m/2.0                                      
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subb2l (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell, p-subshell      
!                   correction using the physics discribed in           
!                   reference 138.                                      
!                                                                       
!                     h. bichsel, "the l-shell correction in            
!                     stopping power," usc-136-120 (1967).              
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subb2l - the l-shell, p-subshell correction         
!                            as computed using Bichsel method           
!                            and data.                                  
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd1(2), thtgd(7), shllgd(112,7), s(7), t(7), u(7), v(
     & 7), etagd2(112), b(2,7)                                          
      character*3 ildaln                                                
!                                                                       
      data etagd1 /0.0,0.01/                                            
!                                                                       
      data thtgd /0.35,0.40,0.45,0.50,0.55,0.60,0.65/                   
!                                                                       
      data s /10.0371,8.8015,7.9116,7.2501,6.7451,6.3503,6.0345/        
      data t /28.1449,26.1070,24.4501,23.0729,21.9061,20.8993,20.0154/  
      data u /1.503,1.732,1.876,1.955,1.989,1.999,2.004/                
      data v /1.543,1.520,1.506,1.500,1.498,1.499,1.500/                
      data w /4.0/                                                      
      data x /4.43/                                                     
!                                                                       
      data (b(i,1),i=1,2) /0.0000,0.0442/                               
      data (b(i,2),i=1,2) /0.0000,0.0291/                               
      data (b(i,3),i=1,2) /0.0000,0.9184/                               
      data (b(i,4),i=1,2) /0.0000,0.0131/                               
      data (b(i,5),i=1,2) /0.0000,0.0090/                               
      data (b(i,6),i=1,2) /0.0000,0.0063/                               
      data (b(i,7),i=1,2) /0.0000,0.0044/                               
!                                                                       
      data etagd2 /0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.08,0.09,0.10,0.1
     & 1,0.12,0.13,0.14,0.15,0.20,0.25,0.30,0.35,0.40,0.45,0.50,0.55,0.6
     & 0,0.65,0.70,0.75,0.80,0.85,0.90,0.95,1.00,1.05,1.10,1.15,1.20,1.2
     & 5,1.30,1.35,1.40,1.45,1.50,1.55,1.60,1.65,1.70,1.75,1.80,1.85,1.9
     & 0,1.95,2.00,2.05,2.10,2.15,2.20,2.25,2.30,2.35,2.40,2.45,2.50,2.5
     & 5,2.60,2.65,2.70,2.75,2.80,2.85,2.90,2.95,3.00,3.05,3.10,3.15,3.2
     & 0,3.25,3.30,3.35,3.40,3.45,3.50,3.55,3.60,3.65,3.70,3.75,3.80,3.8
     & 5,3.90,3.95,4.00,4.05,4.10,4.15,4.20,4.25,4.30,4.35,4.40,4.45,4.5
     & 0,4.55,4.60,4.65,4.70,4.75,4.80,4.85,4.90,4.95,5.00/             
!                                                                       
!        theta is 0.350.                                                
!                                                                       
      data (shllgd(i,1),i=1,112) /-18.1218,-11.3605,-7.6084,-5.1188,-3.3
     & 297,-1.9845,-0.19434,-0.1217,0.5361,1.0680,1.5012,1.8558,2.1471,2
     & .3867,2.5837,3.1427,3.3055,3.2900,3.1926,3.0592,2.9128,2.7650,2.6
     & 217,2.4858,2.3584,2.2398,2.1298,2.0278,1.9335,1.8461,1.7651,1.690
     & 0,1.6202,1.5552,1.4947,1.4382,1.3854,1.3359,1.2896,1.2460,1.2051,
     & 1.1665,1.1301,1.0958,1.0633,1.0326,1.0034,0.9757,0.9494,0.9244,0.
     & 9006,0.8779,0.8563,0.8356,0.8158,0.7969,0.7788,0.7615,0.7449,0.72
     & 89,0.7136,0.6989,0.6847,0.6711,0.6579,0.6453,0.6331,0.6213,0.6100
     & ,0.5990,0.5884,0.5781,0.5682,0.5586,0.5494,0.5403,0.5316,0.5232,0
     & .5150,0.5070,0.4993,0.4918,0.4845,0.4774,0.4705,0.4638,0.4573,0.4
     & 509,0.4447,0.4387,0.4329,0.4271,0.4216,0.4161,0.4108,0.4057,0.400
     & 6,0.3957,0.3909,0.3862,0.3816,0.3771,0.3727,0.3684,0.3642,0.3601,
     & 0.3561,0.3522,0.3483,0.3446,0.3409,0.3373/                       
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (shllgd(i,2),i=1,112) /-14.4545,-8.5037,-5.1970,-3.0059,-1.43
     & 66,-0.2626,0.6400,1.3467,1.9069,2.3547,2.7145,3.0044,3.2380,3.425
     & 9,3.5762,3.9554,3.9956,3.8906,3.7247,3.5372,3.3468,3.1626,2.9887,
     & 2.8266,2.6765,2.5381,2.4107,2.2933,2.1851,2.0853,1.9931,1.9077,1.
     & 8286,1.7551,1.6868,1.6231,1.5635,1.5079,1.4558,1.4068,1.3608,1.31
     & 75,1.2767,1.2382,1.2017,1.1673,1.1346,1.1036,1.0741,1.0461,1.0195
     & ,0.9941,0.9698,0.9467,0.9246,0.9034,0.8831,0.8637,0.8451,0.8272,0
     & .8101,0.7936,0.7778,0.7625,0.7478,0.7336,0.7200,0.7068,0.6941,0.6
     & 818,0.6699,0.6584,0.6473,0.6366,0.6262,0.6161,0.6063,0.5968,0.587
     & 6,0.5787,0.5700,0.5616,0.5534,0.5455,0.5378,0.5302,0.5229,0.5158,
     & 0.5089,0.5021,0.4955,0.4891,0.4829,0.4768,0.4708,0.4650,0.4594,0.
     & 4538,0.4484,0.4431,0.4380,0.4329,0.4280,0.4232,0.4185,0.4139,0.40
     & 94,0.4049,0.4006,0.3964,0.3923,0.3882/                           
!                                                                       
!        theta is 0.450.                                                
!                                                                       
      data (shllgd(i,3),i=1,112) /-12.0035,-6.6343,-3.6427,-1.6597,-0.24
     & 15,0.8162,1.6257,2.2557,2.7513,3.1439,3.4558,3.7037,3.9001,4.0547
     & ,4.1752,4.4406,4.4042,4.2439,4.0360,3.8154,3.5983,3.3921,3.1997,3
     & .0218,2.8582,2.7080,2.5701,2.4434,2.3270,2.2198,2.1209,2.0295,1.9
     & 448,1.8663,1.7932,1.7252,1.6617,1.6024,1.5468,1.4947,1.4457,1.399
     & 6,1.3561,1.3151,1.2763,1.2396,1.2049,1.1719,1.1406,1.1108,1.0824,
     & 1.0554,1.0296,1.0050,0.9814,0.9589,0.9374,0.9167,0.8969,0.8779,0.
     & 8597,0.8422,0.8253,0.8090,0.7934,0.7783,0.7638,0.7498,0.7362,0.72
     & 32,0.7105,0.6983,0.6865,0.6750,0.6640,0.6532,0.6428,0.6327,0.6229
     & ,0.6134,0.6042,0.5952,0.5865,0.5781,0.5698,0.5618,0.5540,0.5464,0
     & .5390,0.5318,0.5248,0.5180,0.5113,0.5048,0.4985,0.4923,0.4862,0.4
     & 803,0.4746,0.4689,0.4634,0.4581,0.4528,0.4476,0.4426,0.4377,0.432
     & 9,0.4282,0.4235,0.4190,0.4146,0.4103/                            
!                                                                       
!        theta is 0.500.                                                
!                                                                       
      data (shllgd(i,4),i=1,112) /-10.3281,-5.3904,-2.6292,-0.7955,0.516
     & 1,1.4929,2.2386,2.8167,3.2692,3.6252,3.9056,4.1261,4.2984,4.4317,
     & 4.5331,4.7269,4.6432,4.4492,4.2160,3.9756,3.7427,3.5236,3.3203,3.
     & 1332,2.9617,2.8046,2.6607,2.5287,2.4076,2.2961,2.1933,2.0985,2.01
     & 06,1.9292,1.8535,1.7830,1.7173,1.6558,1.5983,1.5443,1.4937,1.4460
     & ,1.4010,1.3586,1.3185,1.2806,1.2446,1.2105,1.1781,1.1473,1.1180,1
     & .0901,1.0634,1.0380,1.0137,0.9904,0.9681,0.9468,0.9263,0.9067,0.8
     & 878,0.8697,0.8523,0.8355,0.8193,0.8037,0.7887,0.7742,0.7602,0.746
     & 7,0.7336,0.7210,0.7088,0.6970,0.6855,0.6744,0.6636,0.6532,0.6431,
     & 0.6333,0.6237,0.6145,0.6054,0.5967,0.5882,0.5799,0.5718,0.5640,0.
     & 5563,0.5489,0.5416,0.5346,0.5276,0.5209,0.5144,0.5080,0.5017,0.49
     & 56,0.4896,0.4838,0.4781,0.4726,0.4671,0.4618,0.4566,0.4515,0.4465
     & ,0.4416,0.4369,0.4322,0.4276,0.4231/                             
!                                                                       
!        theta is 0.550.                                                
!                                                                       
      data (shllgd(i,5),i=1,112) /-9.1652,-4.5568,-1.9690,-0.2453,0.9894
     & ,1.9092,2.6107,3.1534,3.5770,3.9087,4.1687,4.3715,4.5285,4.6482,4
     & .7376,4.8875,4.7757,4.5621,4.3145,4.0630,3.8213,3.5950,3.3858,3.1
     & 937,3.0179,2.8571,2.7100,2.5752,2.4515,2.3378,2.2331,2.1364,2.046
     & 9,1.9639,1.8869,1.8151,1.7482,1.6857,1.6271,1.5723,1.5207,1.4722,
     & 1.4265,1.3833,1.3426,1.3040,1.2675,1.2328,1.1999,1.1686,1.1388,1.
     & 1104,1.0833,1.0575,1.0327,1.0091,0.9865,0.9648,0.9440,0.9240,0.90
     & 49,0.8865,0.8687,0.8517,0.8353,0.8194,0.8042,0.7894,0.7752,0.7615
     & ,0.7482,0.7354,0.7230,0.7110,0.6993,0.6880,0.6771,0.6665,0.6562,0
     & .6462,0.6365,0.6271,0.6180,0.6091,0.6004,0.5920,0.5838,0.5758,0.5
     & 681,0.5605,0.5531,0.5460,0.5390,0.5321,0.5254,0.5189,0.5126,0.506
     & 4,0.5003,0.4944,0.4886,0.4830,0.4774,0.4720,0.4667,0.4616,0.4565,
     & 0.4516,0.4467,0.4420,0.4373,0.4328/                              
!                                                                       
!        theta is 0.60.                                                 
!                                                                       
      data (shllgd(i,6),i=1,112) /-8.3512,-4.0007,-1.5468,0.0938,1.2720,
     & 2.1509,2.8216,3.3403,3.7445,4.0606,4.3074,4.4992,4.6467,4.7583,4.
     & 8406,4.9652,4.8381,4.6142,4.3592,4.1023,3.8564,3.6267,3.4147,3.22
     & 04,3.0426,2.8802,2.7316,2.5956,2.4708,2.3561,2.2505,2.1530,2.0628
     & ,1.9793,1.9016,1.8293,1.7620,1.6990,1.6400,1.5847,1.5328,1.4840,1
     & .4380,1.3946,1.3535,1.3147,1.2779,1.2430,1.2099,1.1784,1.1484,1.1
     & 198,1.0926,1.0666,1.0417,1.0179,0.9951,0.9733,0.9524,0.9323,0.913
     & 0,0.8945,0.8767,0.8595,0.8430,0.8271,0.8117,0.7969,0.7826,0.7688,
     & 0.7555,0.7425,0.7300,0.7180,0.7063,0.6949,0.6839,0.6732,0.6629,0.
     & 6529,0.6431,0.6336,0.6244,0.6155,0.6068,0.5983,0.5901,0.5821,0.57
     & 43,0.5667,0.5592,0.5520,0.5450,0.5381,0.5314,0.5249,0.5185,0.5122
     & ,0.5061,0.5002,0.4944,0.4887,0.4831,0.4777,0.4724,0.4672,0.4621,0
     & .4571,0.4522,0.4475,0.4428,0.4382/                               
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (shllgd(i,7),i=1,112) /-7.7789,-3.6354,-1.2879,0.2883,1.4240,
     & 2.2732,2.9223,3.4248,3.8164,4.1226,4.3614,4.5466,4.6887,4.7957,4.
     & 8742,4.9861,4.8522,4.6243,4.3667,4.1080,3.8607,3.6300,3.4173,3.22
     & 24,3.0441,2.8813,2.7324,2.5961,2.4711,2.3562,2.2504,2.1528,2.0625
     & ,1.9788,1.9010,1.8286,1.7611,1.6981,1.6391,1.5837,1.5317,1.4829,1
     & .4368,1.3933,1.3522,1.3134,1.2765,1.2416,1.2085,1.1769,1.1469,1.1
     & 183,1.0910,1.0650,1.0401,1.0162,0.9935,0.9716,0.9507,0.9306,0.911
     & 3,0.8927,0.8749,0.8577,0.8412,0.8252,0.8098,0.7950,0.7807,0.7669,
     & 0.7535,0.7406,0.7281,0.7160,0.7043,0.6929,0.6819,0.6712,0.6608,0.
     & 6508,0.6410,0.6315,0.6223,0.6134,0.6047,0.5962,0.5879,0.5799,0.57
     & 21,0.5645,0.5571,0.5498,0.5428,0.5359,0.5292,0.5226,0.5162,0.5100
     & ,0.5039,0.4979,0.4921,0.4864,0.4808,0.4754,0.4701,0.4649,0.4598,0
     & .4548,0.4499,0.4451,0.4404,0.4358/                               
!                                                                       
!         initialize the correction value to zero.                      
!                                                                       
      iz=nint(z)                                                        
      subb2l=0.0                                                        
!                                                                       
!        obtain the theta value then check it, if theta is              
!        zero then return.                                              
!                                                                       
      thetal=thetas(3,iz)                                               
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to                  
!        determine which computation to use for subb1l.                 
!                                                                       
      etaval=eta(z,3,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than 0.01).          
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.lt.0.01)) then                    
!                                                                       
!        compute the 'b' value first.                                   
!        interpolate to obtain the b value since data is available.     
!                                                                       
        ngrid=2                                                         
        ngrid2=7                                                        
        bvalue=alin3d(etaval,thetal,etagd1,thtgd,b,ngrid,ngrid2,ildaln) 
!                                                                       
!         actual computation of the low eta l-shell correction.         
!                                                                       
        subb2l=alin(thetal,thtgd,s,ngrid2,ildaln)*log(etaval)+alin      
     &  (thetal,thtgd,t,ngrid2,ildaln)-bvalue                           
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the l-shell correction medium eta values.             
!                                                                       
      ngrid=112                                                         
      ngrid2=7                                                          
      if ((etaval.ge.0.01).and.(etaval.le.5.0)) subb2l=alin3d(etaval    
     & ,thetal,etagd2,thtgd,shllgd,ngrid,ngrid2,ildaln)                 
!                                                                       
!        evaluate the l-shell correction for high eta values.           
!                                                                       
      ngrid=7                                                           
      if (etaval.gt.5.0) subb2l=alin(thetal,thtgd,u,ngrid,ildaln)/etaval
     & +alin(thetal,thtgd,v,ngrid,ildaln)/(etaval**2)-w/(etaval**3)+x/  
     & (etaval**4)                                                      
!                                                                       
!        now compute the whole subshell correction from the             
!        per electron subshell correction previously computed.          
!                                                                       
      subb2l=shel(3,iz)*subb2l/(shel(2,iz)+shel(3,iz))                  
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subb2m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, p-subshell      
!                   correction using the physics discribed in the       
!                   reference :                                         
!                                                                       
!                     h. bichsel, "stopping power of m electrons        
!                     for heavy charged particles," physical review a,  
!                     vol. 28, p1147 (1983)                             
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subb2m - the m-shell, p-subshell correction as      
!                            computed using Bichsel method and data.    
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(34), thetgd(7), s(7), t(7), u(7), shelgd(34,7)    
      character*3 ildaln                                                
!                                                                       
      data etagd /0.0013,0.0016,0.0020,0.0025,0.0032,0.0040,0.0050,0.006
     & 3,0.0079,0.0100,0.0126,0.0158,0.0200,0.0251,0.0316,0.0398,0.0501,
     & 0.0631,0.0794,0.1000,0.1259,0.1585,0.1995,0.2512,0.3162,0.3981,0.
     & 5012,0.6310,0.7943,1.0000,1.2589,1.5849,1.9953,2.5119/           
!                                                                       
      data thetgd /0.315,0.36,0.45,0.54,0.63,0.72,0.81/                 
!                                                                       
      data s /6.4289,5.8995,5.1587,4.6727,4.3349,4.0897,3.9058/         
!                                                                       
      data t /26.0020,24.0564,21.2825,19.3686,17.9452,16.8309,15.9256/  
!                                                                       
      data u /0.6524,0.6431,0.6457,0.6520,0.6546,0.6531,0.6484/         
!                                                                       
      data v /0.188/                                                    
!                                                                       
!        theta is 0.315.                                                
!                                                                       
      data (shelgd(i,1),i=1,34) /-16.928,-15.448,-13.969,-12.493,-11.020
     & ,-9.554,-8.100,-6.666,-5.264,-3.908,-2.617,-1.412,-0.318,0.640,1.
     & 442,2.070,2.521,2.799,2.924,2.924,2.827,2.662,2.450,2.207,1.946,1
     & .679,1.417,1.173,0.953,0.763,0.604,0.474,0.371,0.290/            
!                                                                       
!        theta is 0.360.                                                
!                                                                       
      data (shelgd(i,2),i=1,34) /-15.338,-13.980,-12.623,-11.266,-9.912,
     & -8.563,-7.223,-5.899,-4.600,-3.341,-2.139,-1.016,0.005,0.898,1.64
     & 3,2.222,2.632,2.877,2.975,2.954,2.842,2.667,2.448,2.200,1.937,1.6
     & 69,1.408,1.164,0.945,0.756,0.598,0.470,0.367,0.286/              
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (shelgd(i,3),i=1,34) /-12.165,-11.977,-10.790,-9.603,-8.417,-
     & 7.233,-6.054,-4.884,-3.730,-2.605,-1.524,-0.507,0.420,1.233,1.910
     & ,2.434,2.797,3.004,3.072,3.028,2.897,2.707,2.478,2.223,1.954,1.68
     & 1,1.417,1.171,0.950,0.760,0.601,0.472,0.369,0.288/               
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (shelgd(i,4),i=1,34) /-11.834,-10.758,-9.682,-8.607,-7.532,-6
     & .457,-5.386,-4.319,3.263,-2.225,-1.221,-0.269,0.606,1.379,2.025,2
     & .525,2.870,3.064,3.122,3.069,2.932,2.736,2.502,2.243,1.970,1.695,
     & 1.428,1.180,0.957,0.766,0.606,0.476,0.372,0.290/                 
!                                                                       
!        theta is 0.63.                                                 
!                                                                       
      data (shelgd(i,5),i=1,34) /-11.001,-10.003,-9.005,-8.007,-7.009,-6
     & .012,-5.016,-4.023,-3.036,-2.061,-1.110,-0.201,0.644,1.397,2.032,
     & 2.527,2.871,3.066,3.125,3.073,2.937,2.742,2.508,2.248,1.975,1.699
     & ,1.432,1.183,0.960,0.768,0.608,0.477,0.373,0.291/                
!                                                                       
!        theta is 0.72.                                                 
!                                                                       
      data (shelgd(i,6),i=1,34) /-10.478,-9.536,-8.595,-7.653,-6.712,-5.
     & 771,-4.830,-3.891,-2.956,-2.029,-1.118,-0.239,0.587,1.333,1.968,2
     & .470,2.823,3.027,3.095,3.050,2.919,2.728,2.497,2.240,1.969,1.695,
     & 1.428,1.180,0.958,0.766,0.606,0.476,0.372,0.291/                 
!                                                                       
!        theta is 0.81.                                                 
!                                                                       
      data (shelgd(i,7),i=1,34) /-10.155,-9.256,-8.357,-7.457,-6.558,-5.
     & 659,-4.761,-3.863,-2.967,-2.077,-1.198,-0.342,0.471,1.214,1.857,2
     & .372,2.740,2.959,3.040,3.006,2.884,2.701,2.475,2.223,1.955,1.683,
     & 1.419,1.173,0.952,0.762,0.603,0.473,0.370,0.289/                 
!                                                                       
!        initialize the subshell correction value to zero.              
!                                                                       
      iz=nint(z)                                                        
      subb2m=0.0                                                        
!                                                                       
!        obtain the theta value, then check the value, if               
!        theta is zero, then return.                                    
!                                                                       
      thetam=thetas(5,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for subb2m.                           
!                                                                       
      etaval=eta(z,5,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        compute subb2m for very low eta values (eta less               
!        than 0.0013).                                                  
!        note, b is very small and is approximated by zero in the       
!        equation below.                                                
!                                                                       
      ngrid=7                                                           
      if (etaval.lt.0.0013) subb2m=alin(thetam,thetgd,s,ngrid,ildaln)   
     & *log(etaval)+alin(thetam,thetgd,t,ngrid,ildaln)-0.0              
!                                                                       
!        evaluate for the low eta values, eta greater than or           
!        equal to 0.0013 but less than or equal to 2.5119.              
!                                                                       
      ngrid=34                                                          
      ngrid2=7                                                          
      if ((etaval.ge.0.0013).and.(etaval.le.2.5119)) subb2m=alin3d      
     & (etaval,thetam,etagd,thetgd,shelgd,ngrid,ngrid2,ildaln)          
!                                                                       
!        evaluate the p-subshell correction for high eta values.        
!                                                                       
      ngrid=7                                                           
      if (etaval.gt.2.5119) subb2m=alin(thetam,thetgd,u,ngrid,ildaln)   
     & /etaval+v/etaval**2                                              
!                                                                       
!        now normalize the whole subshell correction.                   
!                                                                       
      subb2m=shel(5,iz)*subb2m/6.0                                      
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subb3m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, d-subshell      
!                   correction using the physics discribed in the       
!                   reference :                                         
!                                                                       
!                     h. bichsel, "stopping power of m electrons        
!                     for heavy charged particles," physical review a,  
!                     vol. 28, p1147 (1983)                             
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   10 june 1984                                        
!                                                                       
!        inputs :   z     - the atomic number of the element.           
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subb3m - the m-shell, d-subshell correction as      
!                            computed using Bichsel method and data.    
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(30), thetgd(6), s(6), t(6), u(6), shelgd(30,6)    
      character*3 ildaln                                                
!                                                                       
      data etagd /0.0013,0.0016,0.0020,0.0025,0.0032,0.0040,0.0050,0.006
     & 3,0.0079,0.0100,0.0126,0.0158,0.0200,0.0251,0.0316,0.0398,0.0501,
     & 0.0631,0.0794,0.1000,0.1259,0.1585,0.1995,0.2512,0.3162,0.3981,0.
     & 5012,0.6310,0.7943,1.0000/                                       
!                                                                       
      data thetgd /0.36,0.45,0.54,0.63,0.72,0.81/                       
!                                                                       
      data s /10.4696,8.3353,7.1929,6.5217,6.0999,5.8209/               
!                                                                       
      data t /45.6579,39.4198,35.2355,32.2033,29.8843,28.0388/          
!                                                                       
      data u /1.0397,1.1432,1.1312,1.0848,1.0310,0.9791/                
!                                                                       
      data v /0.138/                                                    
!                                                                       
!        theta is 0.360.                                                
!                                                                       
      data (shelgd(i,1),i=1,30) /-24.253,-21.844,-19.437,-17.033,-14.633
     & ,-12.240,-9.860,-7.499,-5.170,-2.889,-0.683,1.414,3.361,5.105,6.5
     & 90,7.760,8.563,8.969,8.971,8.600,7.921,7.027,6.022,5.007,4.058,3.
     & 224,2.526,1.963,1.520,1.176/                                     
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (shelgd(i,2),i=1,30) /-16.239,-14.321,-12.403,-10.487,-8.573,
     & -6.665,-4.764,-2.881,-1.009,0.824,2.604,4.301,5.876,7.281,8.460,9
     & .355,9.916,10.109,9.927,9.396,8.580,7.570,6.468,5.370,4.354,3.464
     & ,2.720,2.119,1.645,1.276/                                        
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (shelgd(i,3),i=1,30) /-12.795,-11.139,-9.483,-7.829,-6.175,-4
     & .526,-2.881,-1.246,0.375,1.971,3.530,5.025,6.423,7.678,8.736,9.53
     & 6,10.026,10.168,9.950,9.397,8.568,7.550,6.445,5.347,4.332,3.444,2
     & .703,2.104,1.633,1.266/                                          
!                                                                       
!        theta is 0.63.                                                 
!                                                                       
      data (shelgd(i,4),i=1,30) /-11.345,-9.844,-8.342,-6.841,-5.341,-3.
     & 843,-2.349,-0.861,0.615,2.074,3.504,4.887,6.192,7.379,8.394,9.175
     & ,9.667,9.825,9.635,9.115,8.321,7.338,6.265,5.197,4.208,3.342,2.62
     & 0,2.037,1.578,1.222/                                             
!                                                                       
!        theta is 0.72.                                                 
!                                                                       
      data (shelgd(i,5),i=1,30) /-10.848,-9.443,-8.039,-6.635,-5.231,-3.
     & 828,-2.428,-1.033,0.354,1.727,3.077,4.391,5.644,6.800,7.806,8.603
     & ,9.129,9.335,9.199,8.736,7.997,7.066,6.039,5.011,4.055,3.218,2.51
     & 9,1.956,1.513,1.171/                                             
!                                                                       
!        theta is 0.81.                                                 
!                                                                       
      data (shelgd(i,6),i=1,30) /-10.830,-9.490,-8.150,-6.809,-5.469,-4.
     & 130,-2.792,-1.458,-0.130,1.187,2.485,3.755,4.976,6.117,7.131,7.95
     & 8,8.532,8.799,8.730,8.334,7.659,6.785,5.808,4.822,3.902,3.095,2.4
     & 20,1.877,1.450,1.120/                                            
!                                                                       
!        initialize the subshell correction value to zero.              
!                                                                       
      iz=nint(z)                                                        
      subb3m=0.0                                                        
!                                                                       
!        obtain the theta value, then check the value, if               
!        the theta is zero, return.                                     
!                                                                       
      thetam=thetas(6,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for subb3m.                           
!                                                                       
      etaval=eta(z,6,betasq)                                            
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        compute subb3m for very low eta values (eta less               
!        than 0.0013).                                                  
!        note, b is very small and is approximated by zero in the       
!        equation below.                                                
!                                                                       
      ngrid=6                                                           
      if (etaval.lt.0.0013) subb3m=alin(thetam,thetgd,s,ngrid,ildaln)   
     & *log(etaval)+alin(thetam,thetgd,t,ngrid,ildaln)-0.0              
!                                                                       
!        evaluate for the low eta values, eta greater than or           
!        equal to 0.0013 but less than or equal to 1.000.               
!                                                                       
      ngrid=30                                                          
      ngrid2=6                                                          
      if ((etaval.ge.0.0013).and.(etaval.le.1.0000)) subb3m=alin3d      
     & (etaval,thetam,etagd,thetgd,shelgd,ngrid,ngrid2,ildaln)          
!                                                                       
!        evaluate the d-subshell correction for high eta values.        
!                                                                       
      ngrid=6                                                           
      if (etaval.gt.1.0000) subb3m=alin(thetam,thetgd,u,ngrid,ildaln)   
     & /etaval+v/etaval**2                                              
!                                                                       
!        now normalize the whole subshell correction.                   
!                                                                       
      subb3m=shel(6,iz)*subb3m/10.0                                     
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subk1l (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell, s-subshell      
!                   correction using the khandelwal method. see the     
!                   main khandelwal l shell routine shelkl for          
!                   article references.                                 
!                                                                       
!        author :   routine by daniel pickens                           
!                   computer sciences corporation                       
!                   07 january 1984                                     
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to velocity sq
!                                                                       
!        outputs :  subk1l - the l-shell, s-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(29), thetgd(26), b(29,26), s(26), t(26), u(26), v(
     & 26)                                                              
      character*3 ildaln                                                
!                                                                       
      data etagd /0.000,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,
     & 0.060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800
     & ,1.000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000/          
!                                                                       
!        note : the top value of the theta grid has been changed        
!               from 0.660 to 0.75 inorder to be able to run all        
!               the elements. this was necessary because the grid       
!               supplied in the khandelwal article did not cover all    
!               the possible high theta values.                         
!                                                                       
      data thetgd /0.240,0.260,0.280,0.300,0.320,0.340,0.350,0.360,0.380
     & ,0.400,0.420,0.440,0.450,0.460,0.480,0.500,0.520,0.540,0.550,0.56
     & 0,0.580,0.600,0.620,0.640,0.650,0.750/                           
!                                                                       
      data s /15.3343,13.9389,12.7909,11.8343,11.0283,10.3424,10.0371,9.
     & 7537,9.2443,8.8005,8.4114,8.0683,7.9117,7.7641,7.4931,7.2506,7.03
     & 27,6.8362,6.7452,6.6584,6.4969,6.3498,6.2154,6.0923,6.0345,5.9792
     & /                                                                
!                                                                       
      data t /35.0669,33.4344,32.0073,30.7466,29.6226,28.6128,28.1449,27
     & .6991,26.8674,26.1061,25.4058,24.7587,24.4531,24.1583,23.5992,23.
     & 0771,22.5880,22.1285,21.9090,21.6958,21.2872,20.9006,20.5341,20.1
     & 859,20.0183,19.8546/                                             
!                                                                       
      data u /0.1215,0.5265,0.8411,1.0878,1.2828,1.4379,1.5032,1.5617,1.
     & 6608,1.7401,1.8036,1.8543,1.8756,1.8945,1.9262,1.9508,1.9696,1.98
     & 36,1.9890,1.9935,2.0001,2.0039,2.0053,2.0049,2.0040,2.0028/      
!                                                                       
      data w /4.0/                                                      
!                                                                       
      data x /4.3/                                                      
!                                                                       
!        the values for 'v' were obtained in part from:                 
!        hans bichsel, "the l-shell correction in stopping power",      
!        april 1967. for those values not available from bichsel,       
!        the numbers were obtained from a linear interpolation.         
!                                                                       
      data v /1.543,1.543,1.543,1.543,1.543,1.543,1.543,1.538,1.529,1.52
     & 0,1.515,1.509,1.506,1.505,1.502,1.500,1.499,1.499,1.498,1.498,1.4
     & 99,1.499,1.499,1.500,1.500,1.500/                                
!                                                                       
!        theta is 0.240.                                                
!                                                                       
      data (b(i,1),i=1,29) /0.00000000,.330060e-2,.741520e-2,.173350e-1,
     & .422580e-1,.759630e-1,.160710e+0,.263570e+0,.375360e+0,.493260e+0
     & ,.738100e+0,.986040e+0,.158680e+1,.214890e+1,.308760e+1,.386200e+
     & 1,.445800e+1,.495760e+1,.537030e+1,.576610e+1,.644580e+1,.695100e
     & +1,.740710e+1,.761070e+1,.797820e+1,.826982e+1,.953228e+1,.109722
     & e+2,.117356e+2/                                                  
!                                                                       
!        theta is 0.260.                                                
!                                                                       
      data (b(i,2),i=1,29) /0.00000000,.268890e-2,.600500e-2,.142610e-1,
     & .357280e-1,.656100e-1,.142480e+0,.237660e+0,.342120e+0,.453060e+0
     & ,.685070e+0,.921420e+0,.149740e+1,.203900e+1,.294510e+1,.369380e+
     & 1,.426880e+1,.475060e+1,.514780e+1,.553000e+1,.618630e+1,.667190e
     & +1,.711130e+1,.730730e+1,.766090e+1,.793442e+1,.915098e+1,.105323
     & e+2,.112565e+2/                                                  
!                                                                       
!        theta is 0.280.                                                
!                                                                       
      data (b(i,3),i=1,29) /0.00000000,.224140e-2,.493760e-2,.118220e-1,
     & .303080e-1,.567980e-1,.126560e+0,.214730e+0,.312480e+0,.417040e+0
     & ,.637280e+0,.863010e+0,.141630e+1,.193940e+1,.281590e+1,.354160e+
     & 1,.409780e+1,.456360e+1,.494700e+1,.531690e+1,.595230e+1,.642060e
     & +1,.684510e+1,.703440e+1,.737570e+1,.763312e+1,.880918e+1,.101384
     & e+2,.108282e+2/                                                  
!                                                                       
!        theta is 0.300.                                                
!                                                                       
      data (b(i,4),i=1,29) /0.00000000,.190780e-2,.412600e-2,.988710e-2,
     & .258030e-1,.492780e-1,.112600e+0,.194340e+0,.285900e+0,.384590e+0
     & ,.593970e+0,.809920e+0,.134240e+1,.184840e+1,.269800e+1,.340300e+
     & 1,.394210e+1,.439350e+1,.476440e+1,.512330e+1,.574000e+1,.619270e
     & +1,.660380e+1,.678710e+1,.711750e+1,.736062e+1,.850038e+1,.978340
     & e+1,.104423e+2/                                                  
!                                                                       
!        theta is 0.320.                                                
!                                                                       
      data (b(i,5),i=1,29) /0.00000000,.165240e-2,.350450e-2,.834910e-2,
     & .220530e-1,.428500e-1,.100320e+0,.176140e+0,.261990e+0,.355220e+0
     & ,.554530e+0,.761410e+0,.127460e+1,.176500e+1,.258990e+1,.327580e+
     & 1,.379940e+1,.423780e+1,.459740e+1,.494630e+1,.554620e+1,.598480e
     & +1,.638390e+1,.656180e+1,.688230e+1,.711252e+1,.821968e+1,.946120
     & e+1,.100926e+2/                                                  
!                                                                       
!        theta is 0.340.                                                
!                                                                       
      data (b(i,6),i=1,29) /0.00000000,.145240e-2,.302380e-2,.712460e-2,
     & .189320e-1,.373480e-1,.894860e-1,.159850e+0,.240380e+0,.328540e+0
     & ,.518460e+0,.716880e+0,.121220e+1,.168800e+1,.249020e+1,.315860e+
     & 1,.366810e+1,.409450e+1,.444380e+1,.478370e+1,.536820e+1,.579400e
     & +1,.618230e+1,.635530e+1,.666680e+1,.688542e+1,.796318e+1,.916730
     & e+1,.977390e+1/                                                  
!                                                                       
!        theta is 0.350.                                                
!                                                                       
      data (b(i,7),i=1,29) /0.00000000,.136700e-2,.282420e-2,.660860e-2,
     & .175720e-1,.349000e-1,.845440e-1,.152370e+0,.230360e+0,.316110e+0
     & ,.501560e+0,.695960e+0,.118280e+1,.165170e+1,.244320e+1,.310340e+
     & 1,.360620e+1,.402700e+1,.437150e+1,.470720e+1,.528450e+1,.570440e
     & +1,.608760e+1,.625830e+1,.656570e+1,.677882e+1,.784298e+1,.902970
     & e+1,.962480e+1/                                                  
!                                                                       
!        theta is 0.360.                                                
!                                                                       
      data (b(i,8),i=1,29) /0.00000000,.128950e-2,.264670e-2,.614720e-2,
     & .163310e-1,.326340e-1,.799070e-1,.145230e+0,.220820e+0,.304230e+0
     & ,.485360e+0,.675860e+0,.115440e+1,.161670e+1,.239790e+1,.305020e+
     & 1,.354660e+1,.396200e+1,.430200e+1,.463360e+1,.520410e+1,.561820e
     & +1,.599670e+1,.616520e+1,.646860e+1,.667652e+1,.772768e+1,.889780
     & e+1,.948190e+1/                                                  
!                                                                       
!        theta is 0.380.                                                
!                                                                       
      data (b(i,9),i=1,29) /0.00000000,.115290e-2,.234590e-2,.536360e-2,
     & .141650e-1,.285940e-1,.714410e-1,.132080e+0,.203040e+0,.282010e+0
     & ,.454880e+0,.637930e+0,.110080e+1,.155040e+1,.231200e+1,.294940e+
     & 1,.343370e+1,.383910e+1,.418040e+1,.449440e+1,.505200e+1,.545550e
     & +1,.582490e+1,.598930e+1,.628530e+1,.648352e+1,.751038e+1,.864960
     & e+1,.921330e+1/                                                  
!                                                                       
!        theta is 0.400.                                                
!                                                                       
      data (b(i,10),i=1,29) /0.00000000,.103520e-2,.210090e-2,.473200e-2
     & ,.123580e-1,.251300e-1,.639430e-1,.120230e+0,.186860e+0,.261650e+
     & 0,.426730e+0,.602770e+0,.105090e+1,.148860e+1,.223190e+1,.285540e
     & +1,.332850e+1,.372460e+1,.405780e+1,.436480e+1,.491060e+1,.530430
     & e+1,.566530e+1,.582600e+1,.611520e+1,.630452e+1,.730908e+1,.84200
     & 0e+1,.896510e+1/                                                 
!                                                                       
!        theta is 0.420.                                                
!                                                                       
      data (b(i,11),i=1,29) /0.00000000,.931600e-3,.189690e-2,.421870e-2
     & ,.108500e-1,.221600e-1,.572970e-1,.109540e+0,.172110e+0,.242950e+
     & 0,.400670e+0,.570080e+0,.100430e+1,.143080e+1,.215690e+1,.276740e
     & +1,.323010e+1,.361750e+1,.394330e+1,.424380e+1,.477860e+1,.516330
     & e+1,.551660e+1,.567390e+1,.595680e+1,.613802e+1,.712208e+1,.82071
     & 0e+1,.873500e+1/                                                 
!                                                                       
!        theta is 0.440.                                                
!                                                                       
      data (b(i,12),i=1,29) /0.00000000,.838830e-3,.172310e-2,.379760e-2
     & ,.959100e-2,.196120e-1,.514010e-1,.998810e-1,.158640e+0,.225760e+
     & 0,.376500e+0,.539610e+0,.960560e+0,.137650e+1,.208640e+1,.268470e
     & +1,.313780e+1,.351710e+1,.383600e+1,.413040e+1,.465510e+1,.503140
     & e+1,.537760e+1,.553170e+1,.580880e+1,.598242e+1,.694758e+1,.80087
     & 0e+1,.852090e+1/                                                 
!                                                                       
!        theta is 0.450.                                                
!                                                                       
      data (b(i,13),i=1,29) /0.00000000,.795870e-3,.164510e-2,.361490e-2
     & ,.904070e-2,.184780e-1,.487080e-1,.954060e-1,.152340e+0,.217670e+
     & 0,.365060e+0,.525140e+0,.939730e+0,.135060e+1,.205280e+1,.264520e
     & +1,.309370e+1,.346910e+1,.378480e+1,.407640e+1,.459620e+1,.496850
     & e+1,.531140e+1,.546400e+1,.573830e+1,.590842e+1,.686468e+1,.79146
     & 0e+1,.841930e+1/                                                 
!                                                                       
!        theta is 0.460.                                                
!                                                                       
      data (b(i,14),i=1,29) /0.00000000,.754940e-3,.157190e-2,.344790e-2
     & ,.853700e-1,.173270e-1,.461700e-1,.911500e-1,.146320e+0,.209910e+
     & 0,.354030e+0,.511150e+0,.919540e+0,.132550e+1,.202010e+1,.260700e
     & +1,.305090e+1,.342260e+1,.373510e+1,.402390e+1,.453910e+1,.490760
     & e+1,.524730e+1,.539840e+1,.567010e+1,.583622e+1,.678448e+1,.78235
     & 0e+1,.832110e+1/                                                 
!                                                                       
!        theta is 0.480.                                                
!                                                                       
      data (b(i,15),i=1,29) /0.00000000,.678630e-3,.143770e-2,.315340e-2
     & ,.765250e-2,.155530e-1,.415280e-1,.832490e-1,.135040e+0,.195300e+
     & 0,.333120e+0,.485200e+0,.880930e+0,.127740e+1,.195750e+1,.253360e
     & +1,.296900e+1,.333360e+1,.364000e+1,.392360e+1,.442990e+1,.479120
     & e+1,.512470e+1,.527310e+1,.553980e+1,.569992e+1,.663148e+1,.76500
     & 0e+1,.813420e+1/                                                 
!                                                                       
!        theta is 0.500.                                                
!                                                                       
      data (b(i,16),i=1,29) /0.00000000,.609050e-3,.131700e-2,.290170e-2
     & ,.690770e-2,.139430e-1,.374070e-1,.760980e-1,.124700e+0,.181790e+
     & 0,.313610e+0,.459560e+0,.844530e+0,.123190e+1,.189830e+1,.246420e
     & +1,.289150e+1,.324940e+1,.355020e+1,.382890e+1,.432690e+1,.468140
     & e+1,.500920e+1,.515500e+1,.541700e+1,.557112e+1,.648758e+1,.74872
     & 0e+1,.795880e+1/                                                 
!                                                                       
!        theta is 0.520.                                                
!                                                                       
      data (b(i,17),i=1,29) /0.00000000,.545610e-3,.120680e-2,.268320e-2
     & ,.627750e-2,.125610e-1,.337500e-1,.696190e-1,.115220e+0,.169310e+
     & 0,.295400e+0,.436130e+0,.810140e+0,.118880e+1,.184220e+1,.239840e
     & +1,.281810e+1,.316980e+1,.346520e+1,.373920e+1,.422950e+1,.457770
     & e+1,.490010e+1,.504340e+1,.530110e+1,.544962e+1,.635198e+1,.73338
     & 0e+1,.779380e+1/                                                 
!                                                                       
!        theta is 0.540.                                                
!                                                                       
      data (b(i,18),i=1,29) /0.00000000,.487860e-3,.110580e-2,.249040e-2
     & ,.574140e-2,.113720e-1,.305030e-1,.637520e-1,.106520e+0,.157760e+
     & 0,.278370e+0,.414100e+0,.777610e+0,.114800e+1,.178890e+1,.233600e
     & +1,.274840e+1,.309410e+1,.338450e+1,.365420e+1,.413710e+1,.447940
     & e+1,.479680e+1,.493790e+1,.519150e+1,.533472e+1,.622388e+1,.71892
     & 0e+1,.763840e+1/                                                 
!                                                                       
!        theta is 0.550.                                                
!                                                                       
      data (b(i,19),i=1,29) /0.00000000,.461000e-3,.105830e-2,.240190e-2
     & ,.550310e-2,.108410e-1,.290200e-1,.610280e-1,.102440e+0,.152310e+
     & 0,.270270e+0,.403570e+0,.761990e+0,.112840e+1,.176320e+1,.230590e
     & +1,.271480e+1,.305770e+1,.334570e+1,.361330e+1,.409280e+1,.443210
     & e+1,.474710e+1,.488720e+1,.513880e+1,.527952e+1,.616238e+1,.71199
     & 0e+1,.756390e+1/                                                 
!                                                                       
!        theta is 0.560.                                                
!                                                                       
      data (b(i,20),i=1,29) /0.00000000,.435420e-3,.101250e-2,.231780e-2
     & ,.528200e-2,.103480e-1,.276220e-1,.584360e-1,.985380e-1,.147060e+
     & 0,.262440e+0,.393360e+0,.746780e+0,.110920e+1,.173820e+1,.227650e
     & +1,.268210e+1,.302220e+1,.330790e+1,.357340e+1,.404950e+1,.438610
     & e+1,.469880e+1,.483780e+1,.508760e+1,.522582e+1,.610258e+1,.70525
     & 0e+1,.749150e+1/                                                 
!                                                                       
!        theta is 0.580.                                                
!                                                                       
      data (b(i,21),i=1,29) /0.00000000,.387950e-3,.926050e-3,.216150e-1
     & ,.488530e-2,.946380e-2,.250660e-1,.536190e-1,.912060e-1,.137150e+
     & 0,.247510e+0,.373810e+0,.717530e+0,.107230e+1,.168990e+1,.221990e
     & +1,.261900e+1,.295380e+1,.323490e+1,.349650e+1,.396610e+1,.429740
     & e+1,.460560e+1,.474260e+1,.498880e+1,.512242e+1,.598768e+1,.69231
     & 0e+1,.735260e+1/                                                 
!                                                                       
!        theta is 0.600.                                                
!                                                                       
      data (b(i,22),i=1,29) /0.00000000,.345110e-3,.845920e-3,.191810e-2
     & ,.453960e-2,.869840e-2,.227970e-1,.492540e-1,.844700e-1,.127960e+
     & 0,.233510e+0,.355370e+0,.689740e+0,.103720e+1,.164380e+1,.216590e
     & +1,.255870e+1,.288840e+1,.316520e+1,.342320e+1,.388660e+1,.421300
     & e+1,.451700e+1,.465210e+1,.489490e+1,.502412e+1,.587848e+1,.68003
     & 0e+1,.722080e+1/                                                 
!                                                                       
!        theta is 0.620.                                                
!                                                                       
      data (b(i,23),i=1,29) /0.00000000,.306580e-3,.771670e-3,.178560e-2
     & ,.423540e-2,.803360e-2,.207840e-1,.453000e-1,.782820e-1,.119430e+
     & 0,.220380e+0,.337960e+0,.663300e+0,.100370e+1,.159980e+1,.211420e
     & +1,.250110e+1,.282600e+1,.309880e+1,.335320e+1,.381080e+1,.413240
     & e+1,.443240e+1,.456580e+1,.480540e+1,.493042e+1,.577458e+1,.66835
     & 0e+1,.709570e+1/                                                 
!                                                                       
!        theta is 0.640.                                                
!                                                                       
      data (b(i,24),i=1,29) /0.00000000,.272020e-3,.702950e-3,.166220e-2
     & ,.396500e-2,.745350e-2,.189970e-1,.417180e-1,.725960e-1,.111520e+
     & 0,.208050e+0,.321500e+0,.638110e+0,.971620e+0,.155760e+1,.206470e
     & +1,.244600e+1,.276630e+1,.303520e+1,.328630e+1,.373840e+1,.405550
     & e+1,.435170e+1,.448340e+1,.472000e+1,.484112e+1,.567548e+1,.65724
     & 0e+1,.697670e+1/                                                 
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (b(i,25),i=1,29) /0.00000000,.256120e-3,.670580e-3,.160360e-2
     & ,.384040e-2,.719100e-2,.181800e-1,.400560e-1,.699280e-1,.107780e+
     & 0,.202170e+0,.313610e+0,.625970e+0,.956140e+0,.153720e+1,.204080e
     & +1,.241930e+1,.273740e+1,.300440e+1,.325390e+1,.370330e+1,.401830
     & e+1,.431270e+1,.444360e+1,.467870e+1,.479792e+1,.562768e+1,.65189
     & 0e+1,.691940e+1/                                                 
!                                                                       
!        theta is 0.750.                                                
!                                                                       
      data (b(i,26),i=1,29) /0.00000000,.241110e-3,.639470e-3,.154690e-2
     & ,.372210e-2,.694490e-2,.174110e-1,.384740e-1,.673710e-1,.104180e+
     & 0,.196470e+0,.305940e+0,.614110e+0,.931000e+0,.151720e+1,.201730e
     & +1,.239320e+1,.270910e+1,.297420e+1,.322220e+1,.366900e+1,.398190
     & e+1,.427450e+1,.440470e+1,.463830e+1,.475572e+1,.558098e+1,.64665
     & 0e+1,.686340e+1/                                                 
!                                                                       
      iz=nint(z)                                                        
      subk1l=0.0                                                        
!                                                                       
!        obtain the theta value. then check the theta, if zero          
!        then return.                                                   
!                                                                       
      thetal=thetas(2,iz)                                               
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for subk1l.                           
!                                                                       
      etaval=eta(z,2,betasq)                                            
!                                                                       
!        set the grid size constants.                                   
!                                                                       
      numgrd=26                                                         
      numgd2=29                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        note - the 3.0, 8.0, and 2.0 used in the evaluation of         
!        the shell correction were added by j. janni in order           
!        to better understand the equation, and are not present         
!        in the article by khandelwal.                                  
!                                                                       
!        evaluate for the low eta values.                               
!                                                                       
      if (etaval.le.7.0) then                                           
!                                                                       
!        compute the 'b' value by interpolation since there is          
!        data available.                                                
!                                                                       
        bvalue=alin3d(etaval,thetal,etagd,thetgd,b,numgd2,numgrd,ildaln)
!                                                                       
!        actual computation of the l-shell, s-subshell for low eta.     
!                                                                       
        subk1l=(alin(thetal,thetgd,s,numgrd,ildaln)*log(etaval))+alin   
     &  (thetal,thetgd,t,numgrd,ildaln)-4.62277*bvalue                  
      endif                                                             
!                                                                       
!        evaluate for the higher eta values.                            
!                                                                       
      if (etaval.gt.7.0) subk1l=alin(thetal,thetgd,u,numgrd,ildaln)     
     & /etaval+alin(thetal,thetgd,v,numgrd,ildaln)/(etaval**2)-w/(etaval
     & **3)+x/(etaval**4)                                               
!                                                                       
      subk1l=shel(2,iz)*subk1l/(shel(2,iz)+shel(3,iz))                  
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subk1m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, s subshell      
!                   correction using the total shell physics discribed  
!                   in reference 137:                                   
!                                                                       
!                     g. khandelwal and e. merzbacher,                  
!                     "stopping power of m electrons,"                  
!                     physical review, vol 144, number 1 (1966)         
!                                                                       
!                   and the subshell method in the reference:           
!                                                                       
!                     g. khandelwal, "stopping power of m electrons     
!                     for heavy charged particles," unpublished         
!                     paper, 9 oct. 1982                                
!                                                                       
!                   and using data supplied in a letter from            
!                   g. khandelwal to joe janni dated 31 january, 1968.  
!                                                                       
!                   the s,t,u and v values were obtained from "bichsel" 
!                   because khandelwal did not compute them.            
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   30 june 1984                                        
!                                                                       
!        inputs :   z       - the atomic number of the element.         
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subk1m - the m-shell, s subshell correction as      
!                            computed using Khandelwal method           
!                            and data.                                  
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(30), thtgd1(19), b(30,19), thtgd2(8), s(8), t(8), 
     & u(8)                                                             
      character*3 ildaln                                                
!                                                                       
      data etagd /0.000,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,
     & 0.060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800
     & ,1.000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000,10.000/   
!                                                                       
      data thtgd1 /0.24,0.26,0.28,0.30,0.32,0.34,0.35,0.36,0.38,0.40,0.4
     & 2,0.44,0.45,0.46,0.48,0.50,0.52,0.54,0.55/                       
!                                                                       
!        theta is 0.24.                                                 
!                                                                       
      data (b(i,1),i=1,30) /0.0000,0.0190,0.0395,0.0839,0.1851,0.3084,0.
     & 5874,0.8819,1.1754,1.4599,1.9914,2.4703,3.4652,4.2408,5.3818,6.18
     & 99,6.8064,7.2975,7.6997,8.0244,8.6249,9.0732,9.4433,9.6129,9.8984
     & ,10.2706,11.1708,12.2604,12.9592,13.6885/                        
!                                                                       
!        theta is 0.26.                                                 
!                                                                       
      data (b(i,2),i=1,30) /0.0000,0.0162,0.0334,0.0720,0.1625,0.2753,0.
     & 5350,0.8127,1.0916,1.3631,1.8724,2.3330,3.2926,4.0422,5.1456,5.92
     & 67,6.5221,6.9960,7.3836,7.6958,8.2753,8.7065,9.0621,9.2252,9.4990
     & ,9.8559,10.7182,11.7601,12.4276,13.1237/                         
!                                                                       
!        theta is 0.28.                                                 
!                                                                       
      data (b(i,3),i=1,30) /0.0000,0.0139,0.0286,0.0621,0.1432,0.2465,0.
     & 4886,0.7510,1.0164,1.2761,1.7654,2.2093,3.1372,3.8634,4.9332,5.69
     & 02,6.2670,6.7257,7.1005,7.4015,7.9624,8.3786,8.7214,8.8788,9.1423
     & ,9.4858,10.3148,11.3148,11.9548,12.6218/                         
!                                                                       
!        theta is 0.30.                                                 
!                                                                       
      data (b(i,4),i=1,30) /0.0000,0.0122,0.0248,0.0540,0.1267,0.2212,0.
     & 4474,0.6956,0.9487,1.1975,1.6683,2.0971,2.9961,3.7012,4.7408,5.47
     & 63,6.0364,6.4816,6.8449,7.1360,7.6805,8.0832,8.4147,8.5671,8.8213
     & ,9.1530,9.9524,10.9154,11.5311,12.1723/                          
!                                                                       
!        theta is 0.32.                                                 
!                                                                       
      data (b(i,5),i=1,30) /0.0000,0.0109,0.0218,0.0473,0.1124,0.1991,0.
     & 4104,0.6456,0.8873,1.1260,1.5799,1.9948,2.8674,3.5532,4.5654,5.28
     & 16,5.8267,6.2596,6.6127,6.8950,7.4246,7.8153,8.1367,8.2846,8.5307
     & ,8.8518,9.6248,10.5548,11.1487,11.7670/                          
!                                                                       
!        theta is 0.34.                                                 
!                                                                       
      data (b(i,6),i=1,30) /0.0000,0.0098,0.0193,0.0417,0.1001,0.1797,0.
     & 3773,0.5004,0.8314,1.0608,1.4989,1.9010,2.7492,3.4175,4.4047,5.10
     & 32,5.6348,6.0567,6.4005,6.6748,7.1912,7.5710,7.8833,8.0271,8.2659
     & ,8.5774,9.3268,10.2272,10.8017,11.3994/                          
!                                                                       
!        theta is 0.35.                                                 
!                                                                       
      data (b(i,7),i=1,30) /0.0000,0.0093,0.0183,0.0392,0.0946,0.1709,0.
     & 3620,0.6004,0.8053,1.0303,1.4609,1.8569,2.6937,3.3537,4.3293,5.01
     & 96,5.5448,5.9616,6.3010,6.5716,7.0818,7.4567,7.7648,7.9067,8.1420
     & ,8.4492,9.1876,10.0743,10.6398,11.2280/                          
!                                                                       
!        theta is 0.36.                                                 
!                                                                       
      data (b(i,8),i=1,30) /0.0000,0.0088,0.0173,0.0370,0.0895,0.1626,0.
     & 3474,0.5592,0.7804,1.0010,1.4244,1.8145,2.6403,3.2923,4.2568,4.93
     & 92,5.4584,5.8703,6.2056,6.4727,6.9770,7.3471,7.6512,7.7913,8.0234
     & ,8.3263,9.0544,9.9280,10.4850,11.0641/                           
!                                                                       
!        theta is 0.38.                                                 
!                                                                       
      data (b(i,9),i=1,30) /0.0000,0.0080,0.0157,0.0331,0.0804,0.1474,0.
     & 3205,0.5216,0.7335,0.9459,1.3557,1.7346,2.5395,3.1765,4.1199,4.78
     & 76,5.2954,5.6982,6.0259,6.2863,6.7797,7.1408,7.4374,7.5742,7.8003
     & ,8.0954,8.8041,9.6535,10.1946,10.7569/                           
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (b(i,10),i=1,30) /0.0000,0.0073,0.0143,0.0299,0.0725,0.1340,0
     & .2961,0.4873,0.6904,0.8951,1.2919,1.6604,2.4458,3.0689,3.9928,4.6
     & 469,5.1444,5.5387,5.8594,6.1137,6.5971,6.9501,7.2399,7.3736,7.594
     & 2,7.8822,8.5732,9.4006,9.9272,10.4742/                           
!                                                                       
!        theta is 0.42.                                                 
!                                                                       
      data (b(i,11),i=1,30) /0.0000,0.0067,0.0131,0.0271,0.0656,0.1221,0
     & .2739,0.4557,0.6506,0.8481,1.2327,1.5913,2.3585,2.9685,3.8744,4.5
     & 159,5.0038,5.3904,5.7046,5.9534,6.4275,6.7731,7.0566,7.1875,7.403
     & 0,7.6845,8.3594,9.1666,9.6799,10.2130/                           
!                                                                       
!        theta is 0.44.                                                 
!                                                                       
      data (b(i,12),i=1,30) /0.0000,0.0061,0.0121,0.0248,0.0596,0.1116,0
     & .2538,0.4268,0.6138,0.8044,1.1775,1.5268,2.2768,2.8747,3.7637,4.3
     & 935,4.8725,5.2520,5.5602,5.8038,6.2694,6.6082,6.8859,7.0143,7.225
     & 2,7.5007,8.1607,8.9493,9.4506,9.9709/                            
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (b(i,13),i=1,30) /0.0000,0.0058,0.0116,0.0238,0.0569,0.1067,0
     & .2444,0.4132,0.5964,0.7837,1.1512,1.4961,2.2379,2.8300,3.7110,4.3
     & 353,4.8101,5.1862,5.4915,5.7328,6.1944,6.5299,6.8049,6.9321,7.140
     & 8,7.4134,8.0665,8.8464,9.3420,9.8563/                            
!                                                                       
!        theta is 0.46.                                                 
!                                                                       
      data (b(i,14),i=1,30) /0.0000,0.0055,0.0111,0.0228,0.0544,0.1022,0
     & .2355,0.4001,0.5797,0.7637,1.1259,1.4664,2.2002,2.7867,3.6599,4.2
     & 789,4.7496,5.1224,5.4251,5.6640,6.1217,6.4541,6.7265,6.8526,7.059
     & 1,7.3291,7.9754,8.7470,9.2371,9.7456/                            
!                                                                       
!        theta is 0.48.                                                 
!                                                                       
      data (b(i,15),i=1,30) /0.0000,0.0050,0.0103,0.0211,0.0499,0.0939,0
     & .2188,0.3754,0.5480,0.7258,1.0776,1.4098,2.1282,2.7039,3.5623,4.1
     & 711,4.6342,5.0008,5.2983,5.5328,5.9833,6.3098,6.5773,6.7011,6.903
     & 7,7.1685,7.8022,8.5581,9.0379,9.5355/                            
!                                                                       
!        theta is 0.50.                                                 
!                                                                       
      data (b(i,16),i=1,30) /0.0000,0.0045,0.0096,0.0196,0.0459,0.0864,0
     & .0204,0.3527,0.5185,0.6904,1.0322,1.3565,2.0603,2.6258,3.4704,4.0
     & 697,4.5255,4.8864,5.1790,5.4094,5.8531,6.1742,6.4371,6.5588,6.757
     & 8,7.0179,7.6398,8.3811,8.8513,9.3389/                            
!                                                                       
!        theta is 0.52.                                                 
!                                                                       
      data (b(i,17),i=1,30) /0.0000,0.0041,0.0088,0.0183,0.0425,0.0798,0
     & .1896,0.3316,0.4910,0.6572,0.9896,1.3062,1.9962,2.5521,3.3835,3.9
     & 739,4.4229,4.7784,5.0666,5.2932,5.7305,6.0464,6.3051,6.4250,6.620
     & 5,6.8762,7.4872,8.2149,8.6763,9.1545/                            
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (b(i,18),i=1,30) /0.0000,0.0036,0.0082,0.0171,0.0394,0.0739,0
     & .1769,0.3121,0.4653,0.6261,0.9494,1.2588,1.9356,2.4823,3.3013,3.8
     & 832,4.3260,4.6764,4.9604,5.1833,5.6147,5.9259,6.1806,6.2987,6.491
     & 0,6.7426,7.3434,8.0585,8.5116,8.9811/                            
!                                                                       
!        theta is 0.55.                                                 
!                                                                       
      data (b(i,19),i=1,30) /0.0000,0.0034,0.0079,0.0165,0.0381,0.0712,0
     & .1709,0.3029,0.4532,0.6113,0.9302,1.2360,1.9065,2.4488,3.2618,3.8
     & 397,4.2794,4.6274,4.9094,5.1306,5.5592,5.8681,6.1209,6.2382,6.428
     & 9,6.6786,7.2746,7.9837,8.4329,8.8983/                            
!                                                                       
!        remember, the theta grid below and the s,t,u and v             
!        values are from "bichsel".                                     
!                                                                       
      data thtgd2 /0.27,0.315,0.36,0.45,0.54,0.63,0.72,0.81/            
!                                                                       
      data s /2.1737,2.0136,1.8891,1.7087,1.5845,1.4941,1.4256,1.3720/  
!                                                                       
      data t /8.5062,7.8469,7.3328,6.5745,6.0342,5.6239,5.2982,5.0310/  
!                                                                       
      data u /0.2539,0.2539,0.2541,0.2547,0.2551,0.2553,0.2552,0.2548/  
!                                                                       
      data v /0.01/                                                     
!                                                                       
!     data thtgd2/ 0.35, 0.450, 0.55 /                                  
!                                                                       
!     data s/ 41.37, 24.29, 17.88 /                                     
!                                                                       
!     data t/ 129.8, 89.92, 72.28 /                                     
!                                                                       
!     data u/ 0.24, 0.39, 0.75 /                                        
!                                                                       
!        initialize the m-shell, s subshell correction value to zero.   
!                                                                       
      iz=nint(z)                                                        
      subk1m=0.0                                                        
!                                                                       
!        obtain the theta value and then check the value, if            
!        theta is zero, return.                                         
!                                                                       
      thetam=thetas(4,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value, then check its range to                 
!        determine which computation to use for subk1m.                 
!                                                                       
      etaval=eta(z,4,betasq)                                            
!                                                                       
!        initialize the grid size constants.                            
!                                                                       
      numgrd=8                                                          
      numgd1=19                                                         
      numgd2=30                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than                 
!        or equal to 10).                                               
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.le.10.0)) then                    
!                                                                       
!        compute the 'b' value first. interpolate to obtain             
!        the b value from available data.                               
!                                                                       
        bvalue=alin3d(etaval,thetam,etagd,thtgd1,b,numgd2,numgd1,ildaln)
!                                                                       
!         actual computation of the low eta m-shell, s subshell         
!         correction.                                                   
!                                                                       
        subk1m=alin(thetam,thtgd2,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetam,thtgd2,t,numgrd,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the m-shell, s-subshell correction for higher         
!        eta values.                                                    
!                                                                       
      if (etaval.gt.10.0) subk1m=alin(thetam,thtgd2,u,numgrd,ildaln)    
     & /etaval                                                          
!                                                                       
!       now compute the whole subshell correction from the              
!       per electron subshell correction previously computed.           
!                                                                       
      subk1m=shel(4,iz)*subk1m/(shel(4,iz)+shel(5,iz)+shel(6,iz))       
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subk2l (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the l-shell, p-subshell      
!                   correction using the khandelwal method. see the     
!                   main khandelwal l shell routine shelkl for          
!                   article references.                                 
!                                                                       
!        author :   routine by daniel pickens                           
!                   computer sciences corporation                       
!                   07 january 1984                                     
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to velocity sq
!                                                                       
!        outputs :  subk2l - the l-shell, p-subshell correction.        
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(29), thetgd(26), b(29,26), s(26), t(26), u(26), v(
     & 26)                                                              
      character*3 ildaln                                                
!                                                                       
      data etagd /0.000,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,
     & 0.060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800
     & ,1.000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000/          
!                                                                       
!        note : the top value of the theta grid has been changed        
!               from 0.660 to 0.75 inorder to be able to run all        
!               the elements. this was necessary because the grid       
!               supplied in the khandelwal article did not cover all    
!               the possible high theta values.                         
!                                                                       
      data thetgd /0.240,0.260,0.280,0.300,0.320,0.340,0.350,0.360,0.380
     & ,0.400,0.420,0.440,0.450,0.460,0.480,0.500,0.520,0.540,0.550,0.56
     & 0,0.580,0.600,0.620,0.640,0.650,0.750/                           
!                                                                       
      data s /15.3343,13.9389,12.7909,11.8343,11.0283,10.3424,10.0371,9.
     & 7537,9.2443,8.8005,8.4114,8.0683,7.9117,7.7641,7.4931,7.2506,7.03
     & 27,6.8362,6.7452,6.6584,6.4969,6.3498,6.2154,6.0923,6.0345,5.9792
     & /                                                                
!                                                                       
      data t /35.0669,33.4344,32.0073,30.7466,29.6226,28.6128,28.1449,27
     & .6991,26.8674,26.1061,25.4058,24.7587,24.4531,24.1583,23.5992,23.
     & 0771,22.5880,22.1285,21.9090,21.6958,21.2872,20.9006,20.5341,20.1
     & 859,20.0183,19.8546/                                             
!                                                                       
      data u /0.1215,0.5265,0.8411,1.0878,1.2828,1.4379,1.5032,1.5617,1.
     & 6608,1.7401,1.8036,1.8543,1.8756,1.8945,1.9262,1.9508,1.9696,1.98
     & 36,1.9890,1.9935,2.0001,2.0039,2.0053,2.0049,2.0040,2.0028/      
!                                                                       
      data w /4.0/                                                      
!                                                                       
      data x /4.3/                                                      
!                                                                       
!        the values for 'v' were obtained in part from:                 
!        hans bichsel, "the l-shell correction in stopping power",      
!        april 1967. for those values not available from bichsel,       
!        the numbers were obtained from a linear interpolation.         
!                                                                       
      data v /1.543,1.543,1.543,1.543,1.543,1.543,1.543,1.538,1.529,1.52
     & 0,1.515,1.509,1.506,1.505,1.502,1.500,1.499,1.499,1.498,1.498,1.4
     & 99,1.499,1.499,1.500,1.500,1.500/                                
!                                                                       
!        theta is 0.240.                                                
!                                                                       
      data (b(i,1),i=1,29) /0.00000000,.603950e-2,.142900e-1,.326030e-1,
     & .758610e-1,.131210e+0,.260440e+0,.424010e+0,.594360e+0,.772520e+0
     & ,.113940e+1,.150760e+1,.238760e+1,.318220e+1,.451930e+1,.558950e+
     & 1,.645830e+1,.721910e+1,.784400e+1,.839720e+1,.934640e+1,.101090e
     & +2,.107619e+2,.110546e+2,.115863e+2,.122775e+2,.140048e+2,.161752
     & e+2,.173420e+2/                                                  
!                                                                       
!        theta is 0.260.                                                
!                                                                       
      data (b(i,2),i=1,29) /0.00000000,.468140e-2,.115560e-1,.273700e-1,
     & .658840e-1,.116170e+0,.234960e+0,.388030e+0,.547980e+0,.715890e+0
     & ,.106270e+1,.141160e+1,.224620e+1,.299940e+1,.426310e+1,.527030e+
     & 1,.608400e+1,.679580e+1,.737670e+1,.789000e+1,.876900e+1,.947130e
     & +1,.100713e+2,.103399e+2,.108270e+2,.114590e+2,.130332e+2,.150024
     & e+2,.160330e+2/                                                  
!                                                                       
!        theta is 0.280.                                                
!                                                                       
      data (b(i,3),i=1,29) /0.00000000,.363020e-2,.935020e-2,.229990e-1,
     & .573040e-1,.103040e+0,.212440e+0,.356080e+0,.506720e+0,.665490e+0
     & ,.994620e+0,.132650e+1,.212170e+1,.283910e+1,.404040e+1,.499440e+
     & 1,.576180e+1,.643260e+1,.697690e+1,.745700e+1,.827780e+1,.893020e
     & +1,.948660e+1,.973520e+1,.101856e+2,.107688e+2,.122172e+2,.140213
     & e+2,.149404e+2/                                                  
!                                                                       
!        theta is 0.300.                                                
!                                                                       
      data (b(i,4),i=1,29) /0.00000000,.281630e-2,.756750e-2,.193360e-1,
     & .498980e-1,.915390e-1,.192440e+0,.327510e+0,.469730e+0,.620280e+0
     & ,.933550e+0,.125030e+1,.201080e+1,.269710e+1,.384450e+1,.475300e+
     & 1,.548110e+1,.611730e+1,.663060e+1,.708270e+1,.785460e+1,.846520e
     & +1,.898510e+1,.921810e+1,.963670e+1,.101793e+2,.115229e+2,.131898
     & e+2,.140164e+2/                                                  
!                                                                       
!        theta is 0.320.                                                
!                                                                       
      data (b(i,5),i=1,29) /0.00000000,.218580e-2,.612570e-2,.162630e-1,
     & .434830e-1,.814130e-1,.174510e+0,.301800e+0,.436350e+0,.579430e+0
     & ,.878360e+0,.118160e+1,.191120e+1,.257010e+1,.367060e+1,.453980e+
     & 1,.523410e+1,.584060e+1,.632750e+1,.675580e+1,.748610e+1,.806120e
     & +1,.855020e+1,.876810e+1,.916180e+1,.967010e+1,.109254e+2,.124771
     & e+2,.132260e+2/                                                  
!                                                                       
!        theta is 0.340.                                                
!                                                                       
      data (b(i,6),i=1,29) /0.00000000,.169740e-2,.495920e-2,.136810e-1,
     & .379140e-1,.724720e-1,.158440e+0,.278550e+0,.406070e+0,.542300e+0
     & ,.828180e+0,.111920e+1,.182100e+1,.245560e+1,.351480e+1,.434960e+
     & 1,.501460e+1,.559540e+1,.605960e+1,.646740e+1,.716210e+1,.770680e
     & +1,.816940e+1,.837530e+1,.874690e+1,.922600e+1,.104062e+2,.118601
     & e+2,.125432e+2/                                                  
!                                                                       
!        theta is 0.350.                                                
!                                                                       
      data (b(i,7),i=1,29) /0.00000000,.149610e-2,.446230e-2,.125480e-1,
     & .354080e-1,.683940e-1,.151010e+0,.267740e+0,.391950e+0,.524970e+0
     & ,.804740e+0,.109000e+1,.177900e+1,.240240e+1,.344270e+1,.426200e+
     & 1,.491370e+1,.548300e+1,.593690e+1,.633550e+1,.701420e+1,.754540e
     & +1,.799670e+1,.819670e+1,.855850e+1,.902450e+1,.101714e+2,.115818
     & e+2,.122357e+2/                                                  
!                                                                       
!        theta is 0.360.                                                
!                                                                       
      data (b(i,8),i=1,29) /0.00000000,.131900e-2,.401580e-2,.115090e-1,
     & .330700e-1,.645550e-1,.150300e+0,.257430e+0,.378460e+0,.508390e+0
     & ,.782300e+0,.106210e+1,.173890e+1,.235160e+1,.337410e+1,.417880e+
     & 1,.481800e+1,.537650e+1,.582080e+1,.621090e+1,.687470e+1,.739330e
     & +1,.783310e+1,.802860e+1,.838130e+1,.883520e+1,.995110e+1,.113211
     & e+2,.119480e+2/                                                  
!                                                                       
!        theta is 0.380.                                                
!                                                                       
      data (b(i,9),i=1,29) /0.00000000,.102580e-2,.325150e-2,.968160e-2,
     & .288510e-1,.575310e-1,.137210e+0,.238180e+0,.353180e+0,.477270e+0
     & ,.740120e+0,.100960e+1,.166360e+1,.225670e+1,.324630e+1,.402420e+
     & 1,.464080e+1,.517960e+1,.560660e+1,.598110e+1,.661790e+1,.711370e
     & +1,.753380e+1,.772030e+1,.805650e+1,.848860e+1,.954880e+1,.108466
     & e+2,.114250e+2/                                                  
!                                                                       
!        theta is 0.400.                                                
!                                                                       
      data (b(i,10),i=1,29) /0.00000000,.798580e-3,.263350e-2,.814420e-2
     & ,.251730e-1,.512880e-1,.125350e+0,.220580e+0,.329950e+0,.448610e+
     & 0,.701190e+0,.961190e+0,.159420e+1,.216940e+1,.312950e+1,.388350e
     & +1,.447990e+1,.500130e+1,.541290e+1,.577380e+1,.638700e+1,.686280
     & e+1,.726550e+1,.744420e+1,.776600e+1,.817910e+1,.919080e+1,.10425
     & 9e+2,.109622e+2/                                                 
!                                                                       
!        theta is 0.420.                                                
!                                                                       
      data (b(i,11),i=1,29) /0.00000000,.622440e-3,.213350e-2,.685040e-2
     & ,.219640e-1,.457330e-1,.114580e+0,.204450e+0,.308550e+0,.422120e+
     & 0,.665120e+0,.916300e+0,.153000e+1,.208890e+1,.302220e+1,.375460e
     & +1,.433300e+1,.483900e+1,.523700e+1,.558570e+1,.617800e+1,.663610
     & e+1,.702370e+1,.719540e+1,.750450e+1,.790100e+1,.887020e+1,.10050
     & 4e+2,.105499e+2/                                                 
!                                                                       
!        theta is 0.440.                                                
!                                                                       
      data (b(i,12),i=1,29) /0.00000000,.485820e-3,.172920e-2,.576170e-2
     & ,.191630e-1,.407840e-1,.104780e+0,.189620e+0,.288770e+0,.397560e+
     & 0,.631590e+0,.874540e+0,.147030e+1,.201420e+1,.292310e+1,.363610e
     & +1,.419830e+1,.469040e+1,.507620e+1,.541410e+1,.598780e+1,.643030
     & e+1,.680430e+1,.697000e+1,.726790e+1,.764960e+1,.858140e+1,.97132
     & 0e+1,.101805e+2/                                                 
!                                                                       
!        theta is 0.450.                                                
!                                                                       
      data (b(i,13),i=1,29) /0.00000000,.429450e-3,.155700e-2,.528390e-2
     & ,.178980e-1,.385140e-1,.100210e+0,.182650e+0,.279440e+0,.385940e+
     & 0,.615690e+0,.854720e+0,.144210e+1,.197880e+1,.287620e+1,.358030e
     & +1,.413500e+1,.462060e+1,.500090e+1,.533380e+1,.589890e+1,.633430
     & e+1,.670210e+1,.686500e+1,.715780e+1,.753280e+1,.844750e+1,.95572
     & 0e+1,.100099e+2/                                                 
!                                                                       
!        theta is 0.460.                                                
!                                                                       
      data (b(i,14),i=1,29) /0.00000000,.379770e-3,.140210e-2,.484570e-2
     & ,.167170e-1,.363710e-1,.958520e-1,.175960e+0,.270450e+0,.374730e+
     & 0,.600320e+0,.835560e+0,.141470e+1,.194460e+1,.283120e+1,.352660e
     & +1,.407410e+1,.455370e+1,.492860e+1,.525680e+1,.581380e+1,.624240
     & e+1,.660440e+1,.676470e+1,.705260e+1,.742130e+1,.831990e+1,.94090
     & 0e+1,.984770e+1/                                                 
!                                                                       
!        theta is 0.480.                                                
!                                                                       
      data (b(i,15),i=1,29) /0.00000000,.297380e-3,.113750e-2,.407580e-2
     & ,.145810e-1,.324350e-1,.877050e-1,.163360e+0,.253440e+0,.353460e+
     & 0,.571090e+0,.799070e+0,.136260e+1,.187970e+1,.274570e+1,.342490e
     & +1,.395910e+1,.442740e+1,.479250e+1,.511190e+1,.565400e+1,.607010
     & e+1,.642140e+1,.657680e+1,.685580e+1,.721290e+1,.808190e+1,.91330
     & 0e+1,.954640e+1/                                                 
!                                                                       
!        theta is 0.500.                                                
!                                                                       
      data (b(i,16),i=1,29) /0.00000000,.233300e-3,.923550e-3,.342750e-2
     & ,.127160e-1,.289220e-1,.802640e-1,.151720e+0,.237620e+0,.333610e+
     & 0,.543680e+0,.764810e+0,.131370e+1,.181880e+1,.266580e+1,.333020e
     & +1,.385230e+1,.431030e+1,.466640e+1,.497800e+1,.550660e+1,.591140
     & e+1,.625300e+1,.640410e+1,.667520e+1,.702180e+1,.786440e+1,.88816
     & 0e+1,.927240e+1/                                                 
!                                                                       
!        theta is 0.520.                                                
!                                                                       
      data (b(i,17),i=1,29) /0.00000000,.183390e-3,.750420e-3,.288290e-2
     & ,.110870e-1,.257860e-1,.734610e-1,.140940e+0,.222890e+0,.315030e+
     & 0,.517930e+0,.732580e+0,.126770e+1,.176150e+1,.259090e+1,.324170e
     & +1,.375270e+1,.420130e+1,.454930e+1,.485370e+1,.537010e+1,.576480
     & e+1,.609760e+1,.624470e+1,.650870e+1,.684580e+1,.766470e+1,.86515
     & 0e+1,.902210e+1/                                                 
!                                                                       
!        theta is 0.540.                                                
!                                                                       
      data (b(i,18),i=1,29) /0.00000000,.144470e-3,.610320e-3,.242520e-2
     & ,.966520e-2,.229890e-1,.672370e-1,.130960e+0,.209240e+0,.297630e+
     & 0,.493710e+0,.702180e+0,.122430e+1,.170760e+1,.252050e+1,.315870e
     & +1,.365950e+1,.409950e+1,.444010e+1,.473800e+1,.524320e+1,.562870
     & e+1,.595540e+1,.609720e+1,.635460e+1,.668330e+1,.748070e+1,.84402
     & 0e+1,.879270e+1/                                                 
!                                                                       
!        theta is 0.550.                                                
!                                                                       
      data (b(i,19),i=1,29) /0.00000000,.128340e-3,.550610e-3,.222450e-2
     & ,.902360e-2,.217020e-1,.643260e-1,.126250e+0,.202610e+0,.289340e+
     & 0,.482120e+0,.687620e+0,.120350e+1,.168170e+1,.248690e+1,.311920e
     & +1,.361510e+1,.405110e+1,.438820e+1,.468300e+1,.518310e+1,.556420
     & e+1,.588550e+1,.602740e+1,.628180e+1,.660660e+1,.739410e+1,.83409
     & 0e+1,.868500e+1/                                                 
!                                                                       
!        theta is 0.560.                                                
!                                                                       
      data (b(i,20),i=1,29) /0.00000000,.114070e-3,.496880e-3,.204050e-2
     & ,.842420e-2,.204870e-1,.615400e-1,.121710e+0,.196300e+0,.281300e+
     & 0,.470860e+0,.673460e+0,.118320e+1,.165660e+1,.245420e+1,.308070e
     & +1,.357210e+1,.400420e+1,.433800e+1,.462980e+1,.512500e+1,.550200
     & e+1,.581980e+1,.596010e+1,.621160e+1,.653270e+1,.731070e+1,.82454
     & 0e+1,.858160e+1/                                                 
!                                                                       
!        theta is 0.580.                                                
!                                                                       
      data (b(i,21),i=1,29) /0.00000000,.902790e-4,.404980e-3,.171740e-2
     & ,.734140e-2,.182560e-1,.564230e-1,.113130e+0,.184300e+0,.265960e+
     & 0,.449280e+0,.646270e+0,.114430e+1,.160830e+1,.239150e+1,.300720e
     & +1,.348980e+1,.391460e+1,.424210e+1,.452850e+1,.501440e+1,.538370
     & e+1,.569500e+1,.583230e+1,.607850e+1,.639250e+1,.715290e+1,.80653
     & 0e+1,.838660e+1/                                                 
!                                                                       
!        theta is 0.600.                                                
!                                                                       
      data (b(i,22),i=1,29) /0.00000000,.716250e-4,.330490e-3,.144590e-2
     & ,.639680e-2,.162640e-1,.515430e-1,.105160e+0,.173060e+0,.251530e+
     & 0,.428880e+0,.620490e+0,.110730e+1,.156240e+1,.233220e+1,.293770e
     & +1,.341220e+1,.383030e+1,.415200e+1,.443330e+1,.491060e+1,.527290
     & e+1,.557820e+1,.571280e+1,.595410e+1,.626180e+1,.700620e+1,.78982
     & 0e+1,.820610e+1/                                                 
!                                                                       
!        theta is 0.620.                                                
!                                                                       
      data (b(i,23),i=1,29) /0.00000000,.569690e-4,.270060e-3,.121780e-2
     & ,.557310e-2,.144860e-1,.471630e-1,.977470e-1,.162530e+0,.237940e+
     & 0,.409550e+0,.596010e+0,.107210e+1,.151880e+1,.227580e+1,.287190e
     & +1,.333890e+1,.375060e+1,.406700e+1,.434370e+1,.481310e+1,.516890
     & e+1,.546870e+1,.560090e+1,.583770e+1,.613950e+1,.686920e+1,.77428
     & 0e+1,.803830e+1/                                                 
!                                                                       
!        theta is 0.640.                                                
!                                                                       
      data (b(i,24),i=1,29) /0.00000000,.454300e-4,.220990e-3,.102620e-2
     & ,.485510e-2,.129000e-1,.431490e-1,.908600e-1,.152660e+0,.225120e+
     & 0,.391220e+0,.572730e+0,.103860e+1,.147730e+1,.222230e+1,.280940e
     & +1,.326930e+1,.367530e+1,.398670e+1,.425900e+1,.472120e+1,.507110
     & e+1,.536580e+1,.549570e+1,.572840e+1,.602480e+1,.674110e+1,.75977
     & 0e+1,.788210e+1/                                                 
!                                                                       
!        theta is 0.650.                                                
!                                                                       
      data (b(i,25),i=1,29) /0.00000000,.406090e-4,.200010e-3,.942230e-3
     & ,.453140e-2,.121720e-1,.412700e-1,.875990e-1,.147950e+0,.218990e+
     & 0,.382410e+0,.561510e+0,.102240e+1,.145720e+1,.219640e+1,.277930e
     & +1,.323590e+1,.363910e+1,.394820e+1,.421850e+1,.467720e+1,.502420
     & e+1,.531660e+1,.544540e+1,.567620e+1,.597010e+1,.668010e+1,.75288
     & 0e+1,.780790e+1/                                                 
!                                                                       
!        theta is 0.750.                                                
!                                                                       
      data (b(i,26),i=1,29) /0.00000000,.363240e-4,.181100e-3,.865240e-3
     & ,.422930e-2,.114850e-1,.394710e-1,.844540e-1,.143390e+0,.213040e+
     & 0,.373820e+0,.550560e+0,.100660e+1,.143760e+1,.217120e+1,.275000e
     & +1,.320330e+1,.360380e+1,.391060e+1,.417900e+1,.463440e+1,.497870
     & e+1,.526880e+1,.539660e+1,.562550e+1,.591700e+1,.662100e+1,.74620
     & 0e+1,.773620e+1/                                                 
!                                                                       
      iz=nint(z)                                                        
      subk2l=0.0                                                        
!                                                                       
!        obtain the theta value and then check the theta, if            
!        it is zero, then return.                                       
!                                                                       
      thetal=thetas(3,iz)                                               
      if (thetal.le.0.0) return                                         
!                                                                       
!        compute the eta value then check its range to determine        
!        which computation to use for subk2l.                           
!                                                                       
      etaval=eta(z,3,betasq)                                            
!                                                                       
!        set the grid size constants.                                   
!                                                                       
      numgrd=26                                                         
      numgd2=29                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        note - the 3.0, 8.0, and 2.0 used in the evaluation of         
!        the shell correction were added by j. janni inorder            
!        to better understand the equation, and are not present         
!        in the article by khandelwal.                                  
!                                                                       
!        evaluate for the low eta values.                               
!                                                                       
      if (etaval.le.7.0) then                                           
!                                                                       
!        compute the 'b' value by interpolation since there is          
!        data available.                                                
!                                                                       
        bvalue=alin3d(etaval,thetal,etagd,thetgd,b,numgd2,numgrd,ildaln)
!                                                                       
!        actual computation of the l-shell, s-subshell for low eta.     
!                                                                       
        subk2l=alin(thetal,thetgd,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetal,thetgd,t,numgrd,ildaln)-3.951675*bvalue                 
      endif                                                             
!                                                                       
!        evaluate for the higher eta values.                            
!                                                                       
      if (etaval.gt.7.0) subk2l=alin(thetal,thetgd,u,numgrd,ildaln)     
     & /etaval+alin(thetal,thetgd,v,numgrd,ildaln)/(etaval**2)-w/(etaval
     & **3)+x/(etaval**4)                                               
!                                                                       
!        now normalize the correction.                                  
!                                                                       
      subk2l=shel(3,iz)*subk2l/(shel(2,iz)+shel(3,iz))                  
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subk2m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, p subshell      
!                   correction using the total shell physics discribed  
!                   in reference 137:                                   
!                                                                       
!                     g. khandelwal and e. merzbacher,                  
!                     "stopping power of m electrons,"                  
!                     physical review, vol 144, number 1 (1966)         
!                                                                       
!                   and the subshell method in the reference:           
!                                                                       
!                     g. khandelwal, "stopping power of m electrons     
!                     for heavy charged particles," unpublished         
!                     paper, 9 oct. 1982                                
!                                                                       
!                   and using data supplied in a letter from            
!                   g. khandelwal to joe janni dated 31 january, 1968.  
!                                                                       
!                   the s,t,u and v values were obtained from "bichsel" 
!                   because khandelwal did not compute them.            
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   30 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subk2m - the m-shell, p subshell correction as      
!                            computed using Khandelwal method           
!                            and data.                                  
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(30), thtgd1(19), b(30,19), thtgd2(7), s(7), t(7), 
     & u(7)                                                             
      character*3 ildaln                                                
!                                                                       
      data etagd /0.0,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,0.
     & 060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800,1
     & .000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000,10.000/     
      data thtgd1 /0.24,0.26,0.28,0.30,0.32,0.34,0.35,0.36,0.38,0.40,0.4
     & 2,0.44,0.45,0.46,0.48,0.50,0.52,0.54,0.55/                       
!                                                                       
!        theta is 0.24.                                                 
!                                                                       
      data (b(i,1),i=1,30) /0.0000,0.0233,0.0486,0.1022,0.2212,0.3639,0.
     & 6845,1.0225,1.3594,1.6868,2.3012,2.8565,4.0113,4.9087,6.2150,7.13
     & 27,7.8262,8.3731,8.8094,9.1668,9.8519,10.3536,10.7696,10.9536,11.
     & 2841,11.7080,12.7448,14.0217,14.8519,15.7259/                    
!                                                                       
!        theta is 0.26.                                                 
!                                                                       
      data (b(i,2),i=1,30) /0.0000,0.0195,0.0411,0.0881,0.1957,0.3272,0.
     & 6276,0.9478,1.2689,1.5823,2.1721,2.7067,3.8201,4.6857,5.9446,6.82
     & 69,7.4924,8.0159,8.4323,8.7723,9.4279,9.9054,10.3007,10.4754,10.7
     & 891,11.1910,12.1727,13.3797,14.1636,14.9886/                     
!                                                                       
!        theta is 0.28.                                                 
!                                                                       
      data (b(i,3),i=1,30) /0.0000,0.0166,0.0350,0.0763,0.1736,0.2950,0.
     & 5769,0.8808,1.1876,1.4881,2.0558,2.5716,3.6481,4.4855,5.7023,6.55
     & 36,7.1945,7.6975,8.0964,8.4212,9.0512,9.5075,9.8848,10.0515,10.35
     & 05,10.7333,11.6671,12.8135,13.5572,14.3396/                      
!                                                                       
!        theta is 0.30.                                                 
!                                                                       
      data (b(i,4),i=1,30) /0.0000,0.0144,0.0301,0.0663,0.1543,0.2665,0.
     & 5314,0.8204,1.1140,1.4027,1.9502,2.4490,3.4922,4.3043,5.4837,6.30
     & 74,6.9265,7.4115,7.7950,8.1063,8.7137,9.1515,9.5131,9.6727,9.9588
     & ,10.3248,11.2167,12.3099,13.0186,13.7637/                        
!                                                                       
!        theta is 0.32.                                                 
!                                                                       
      data (b(i,5),i=1,30) /0.0000,0.0126,0.0261,0.0579,0.1376,0.2413,0.
     & 4904,0.7656,1.0470,1.3249,1.8539,2.3372,3.3500,4.1393,5.2850,6.08
     & 42,6.6838,7.1528,7.5226,7.8220,8.4094,8.8307,9.1784,9.3317,9.6065
     & ,9.9578,10.8126,11.8590,12.5367,13.2491/                         
!                                                                       
!        theta is 0.34.                                                 
!                                                                       
      data (b(i,6),i=1,30) /0.0000,0.0112,0.0229,0.0509,0.1229,0.2188,0.
     & 4533,0.7157,0.9858,1.2536,1.7654,2.2345,3.2197,3.9881,5.1035,5.88
     & 05,6.4627,6.9174,7.2750,7.5638,8.1333,8.5400,8.8752,9.0230,9.2877
     & ,9.6258,10.4478,11.4527,12.1030,12.7862/                         
!                                                                       
!        theta is 0.35.                                                 
!                                                                       
      data (b(i,7),i=1,30) /0.0000,0.0106,0.0215,0.0478,0.1163,0.2085,0.
     & 4361,0.6923,0.9571,1.2202,1.7239,2.1862,3.1584,3.9172,5.0184,5.78
     & 52,6.3593,6.8074,7.1593,7.4432,8.0046,8.4045,8.7341,8.8793,9.1393
     & ,9.4714,10.2783,11.2642,11.9019,12.5718/                         
!                                                                       
!        theta is 0.36.                                                 
!                                                                       
      data (b(i,8),i=1,30) /0.0000,0.0101,0.0202,0.0449,0.1101,0.1988,0.
     & 4197,0.6700,0.9296,1.1881,1.6840,2.1398,3.0995,3.8490,7.9368,5.69
     & 38,6.2603,6.7020,7.0487,7.3279,7.8815,8.2750,8.5992,8.7420,8.9976
     & ,9.3240,10.1166,11.0845,11.7104,12.3677/                         
!                                                                       
!        theta is 0.38.                                                 
!                                                                       
      data (b(i,9),i=1,30) /0.0000,0.0092,0.0181,0.0398,0.0988,0.1809,0.
     & 3890,0.6281,0.8778,1.1275,1.6085,2.0521,2.9883,3.7204,4.7830,5.52
     & 18,6.0740,6.5041,6.8408,7.1114,7.6506,8.0324,8.3465,8.4849,8.7324
     & ,9.0482,9.8145,10.7491,11.3531,11.9872/                          
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (b(i,10),i=1,30) /0.0000,0.0084,0.0163,0.0356,0.0889,0.1648,0
     & .3611,0.5895,0.8299,1.0714,1.5385,1.9706,2.8850,3.6011,4.6405,5.3
     & 627,5.9020,6.3214,6.6491,6.9119,7.4380,7.8091,8.1143,8.2486,8.488
     & 8,8.7951,9.5376,10.4423,11.0266,11.6398/                         
!                                                                       
!        theta is 0.42.                                                 
!                                                                       
      data (b(i,11),i=1,30) /0.0000,0.0078,0.0149,0.0320,0.0803,0.1504,0
     & .3355,0.5539,0.7854,1.0192,1.4732,1.8947,2.7887,3.4899,4.5080,5.2
     & 149,5.7423,6.1521,6.4716,6.7273,7.2416,7.6030,7.8999,8.0305,8.264
     & 1,8.5618,9.2827,10.1604,10.7269,11.3212/                         
!                                                                       
!        theta is 0.44.                                                 
!                                                                       
      data (b(i,12),i=1,30) /0.0000,0.0072,0.0136,0.0289,0.0726,0.1375,0
     & .3120,0.5209,0.7441,0.9706,1.4122,1.8236,2.6986,3.3859,4.3843,5.0
     & 772,5.5938,5.9946,6.3066,6.5559,7.0593,7.4119,7.7013,7.8286,8.056
     & 1,8.3460,9.0474,9.9004,10.4507,11.0279/                          
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (b(i,13),i=1,30) /0.0000,0.0069,0.0131,0.0275,0.0691,0.1315,0
     & .3010,0.5053,0.7245,0.9474,1.3832,1.7897,2.6556,3.3364,4.3255,5.0
     & 118,5.5232,5.9199,6.2284,6.4746,6.9730,7.3214,7.6074,7.7331,7.957
     & 8,8.2440,8.9363,9.7779,10.3207,10.8898/                          
!                                                                       
!        theta is 0.46.                                                 
!                                                                       
      data (b(i,14),i=1,30) /0.0000,0.0067,0.0126,0.0263,0.0659,0.1259,0
     & .2904,0.4903,0.7056,0.9251,1.3550,1.7569,2.6140,3.2885,4.2686,4.9
     & 485,5.4550,5.8477,6.1528,6.3961,6.8896,7.2341,7.5148,7.6410,7.863
     & 0,8.1457,8.8292,9.6599,10.1955,10.7570/                          
!                                                                       
!        theta is 0.48.                                                 
!                                                                       
      data (b(i,15),i=1,30) /0.0000,0.0062,0.0117,0.0241,0.0600,0.1154,0
     & .2706,0.4619,0.6697,0.8825,1.3013,1.6942,2.5345,3.1968,4.1599,4.8
     & 279,5.3251,5.7102,6.0090,6.2468,6.7312,7.0683,7.3447,7.4661,7.683
     & 1,7.9591,8.6264,9.4365,9.9587,10.5059/                           
!                                                                       
!        theta is 0.50.                                                 
!                                                                       
      data (b(i,16),i=1,30) /0.0000,0.0058,0.0109,0.0222,0.0548,0.1060,0
     & .2523,0.4355,0.6360,0.8425,1.2508,1.6351,2.4595,3.1105,4.0577,4.7
     & 144,5.2031,5.5813,5.8742,6.1069,6.5829,6.9131,7.1838,7.3027,7.514
     & 9,7.7850,8.4373,9.2286,9.7384,10.2726/                           
!                                                                       
!        theta is 0.52.                                                 
!                                                                       
      data (b(i,17),i=1,30) /0.0000,0.0054,0.0103,0.0205,0.0502,0.0975,0
     & .2355,0.4108,0.6045,0.8049,1.2031,1.5793,2.3886,3.0289,3.9612,4.6
     & 075,5.0882,5.4599,5.7474,5.9755,6.4437,6.7676,7.0329,7.1495,7.357
     & 4,7.6219,8.2604,9.0345,9.5329,10.0551/                           
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (b(i,18),i=1,30) /0.0000,0.0050,0.0096,0.0191,0.0462,0.0898,0
     & .2199,0.3878,0.5749,0.7695,1.1580,1.5264,2.3215,2.9517,3.8700,4.5
     & 066,4.9798,5.3455,5.6280,5.8517,6.3127,6.6308,6.8912,7.0055,7.209
     & 5,7.4689,8.0946,8.8527,9.3407,9.8518/                            
!                                                                       
!        theta is 0.55.                                                 
!                                                                       
      data (b(i,19),i=1,30) /0.0000,0.0048,0.0093,0.0185,0.0443,0.0863,0
     & .2126,0.3769,0.5607,0.7526,1.1364,1.5010,2.2892,2.9146,3.8262,4.4
     & 582,4.9279,5.2907,5.5708,5.7925,6.2500,6.5654,6.8235,6.9368,7.138
     & 9,7.3958,8.0156,8.7661,9.2492,9.7551/                            
!                                                                       
!        remember, the theta grid below and the s,t,u and v             
!        values are from "bichsel".                                     
!                                                                       
      data thtgd2 /0.315,0.36,0.45,0.54,0.63,0.72,0.81/                 
!                                                                       
      data s /6.4289,5.8995,5.1587,4.6727,4.3349,4.0897,3.9058/         
!                                                                       
      data t /26.0020,24.0564,21.2825,19.3686,17.9452,16.8309,15.9256/  
!                                                                       
      data u /0.6524,0.6431,0.6457,0.6520,0.6546,0.6531,0.6484/         
!                                                                       
      data v /0.188/                                                    
!                                                                       
!     data thtgd2/ 0.35, 0.450, 0.55 /                                  
!                                                                       
!     data s/ 41.37, 24.29, 17.88 /                                     
!                                                                       
!     data t/ 129.8, 89.92, 72.28 /                                     
!                                                                       
!     data u/ 0.24, 0.39, 0.75 /                                        
!                                                                       
!        initialize the m-shell, p-subshell correction value to zero.   
!                                                                       
      iz=z                                                              
      subk2m=0.0                                                        
!                                                                       
!        obtain the theta value and then the value, if                  
!        theta is zero, return.                                         
!                                                                       
      thetam=thetas(5,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value, then check its range to                 
!        determine which computation to use for subk2m.                 
!                                                                       
      etaval=eta(z,5,betasq)                                            
!                                                                       
!        initialize the grid size constants.                            
!                                                                       
      numgrd=7                                                          
      numgd1=19                                                         
      numgd2=30                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than                 
!        or equal to 10).                                               
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.le.10.0)) then                    
!                                                                       
!        compute the 'b' value first. interpolate to obtain             
!        the b value from available data.                               
!                                                                       
        bvalue=alin3d(etaval,thetam,etagd,thtgd1,b,numgd2,numgd1,ildaln)
!                                                                       
!         actual computation of the low eta m-shell, p-subshell         
!         correction.                                                   
!                                                                       
        subk2m=alin(thetam,thtgd2,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetam,thtgd2,t,numgrd,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the m-shell, p-subshell correction for higher         
!        eta values.                                                    
!                                                                       
      if (etaval.gt.10.0) subk2m=alin(thetam,thtgd2,u,numgrd,ildaln)    
     & /etaval                                                          
!                                                                       
!        now compute the whole subshell correction from the             
!        per electron subshell correction previously computed.          
!                                                                       
      subk2m=shel(5,iz)*subk2m/(shel(4,iz)+shel(5,iz)+shel(6,iz))       
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subk3m (z,betasq)                                        
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose :  this function computes the m-shell, d subshell      
!                   correction using the total shell physics discribed  
!                   in reference 137:                                   
!                                                                       
!                     g. khandelwal and e. merzbacher,                  
!                     "stopping power of m electrons,"                  
!                     physical review, vol 144, number 1 (1966)         
!                                                                       
!                   and the subshell method in the reference:           
!                                                                       
!                     g. khandelwal, "stopping power of m electrons     
!                     for heavy charged particles," unpublished         
!                     paper, 9 oct. 1982                                
!                                                                       
!                   and using data supplied in a letter from            
!                   g. khandelwal to joe janni dated 31 january, 1968.  
!                                                                       
!                   the s,t,u and v values were obtained from "bichsel" 
!                   because khandelwal did not compute them.            
!                                                                       
!        author :   daniel pickens                                      
!                   computer sciences corporation                       
!                   30 june 1984                                        
!                                                                       
!        inputs :   z      - the atomic number of the element.          
!                   betasq - the converted kinetic energy to            
!                            velocity squared.                          
!                                                                       
!        outputs :  subk3m - the m-shell, d subshell correction as      
!                            computed using Khandelwal method           
!                            and data.                                  
!                                                                       
!        errors :   none.                                               
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      dimension etagd(30), thtgd1(19), b(30,19), thtgd2(6), s(6), t(6), 
     & u(6)                                                             
      character*3 ildaln                                                
!                                                                       
      data etagd /0.000,0.005,0.007,0.010,0.015,0.020,0.030,0.040,0.050,
     & 0.060,0.080,0.100,0.150,0.200,0.300,0.400,0.500,0.600,0.700,0.800
     & ,1.000,1.200,1.400,1.500,1.700,2.000,3.000,5.000,7.000,10.000/   
!                                                                       
      data thtgd1 /0.24,0.26,0.28,0.30,0.32,0.34,0.35,0.36,0.38,0.40,0.4
     & 2,0.44,0.45,0.46,0.48,0.50,0.52,0.54,0.55/                       
!                                                                       
!        theta is 0.24.                                                 
!                                                                       
      data (b(i,1),i=1,30) /0.0000,0.2675,0.5851,1.2397,2.6680,4.3646,9.
     & 1302,12.1289,16.0822,19.9289,27.1812,33.8175,48.0817,59.8157,78.3
     & 614,92.7594,104.5273,114.4781,123.0758,130.5564,143.6961,154.5096
     & ,163.7826,167.9998,175.6000,185.6007,210.8914,243.2560,264.7833,2
     & 87.7231/                                                         
!                                                                       
!        theta is 0.26.                                                 
!                                                                       
      data (b(i,2),i=1,30) /0.0000,0.2131,0.4794,1.0384,2.2734,3.7486,8.
     & 0213,10.4917,13.9020,17.2025,23.3773,28.9751,40.8555,50.4962,65.5
     & 434,77.1024,86.4903,94.3941,101.1968,107.0795,117.4711,125.9756,1
     & 33.2576,136.5738,142.5240,150.3577,170.1374,195.4080,212.2003,230
     & .0851/                                                           
!                                                                       
!        theta is 0.28.                                                 
!                                                                       
      data (b(i,3),i=1,30) /0.0000,0.1708,0.3958,0.8777,1.9577,3.2566,7.
     & 1414,9.2006,12.1918,15.0736,20.4284,25.2417,35.3364,43.4213,55.88
     & 47,65.3584,73.0033,79.4111,84.9038,89.6215,98.0131,104.8376,110.6
     & 720,113.3348,118.0870,124.3477,140.1314,160.2630,173.6253,187.850
     & 1/                                                               
!                                                                       
!        theta is 0.30.                                                 
!                                                                       
      data (b(i,4),i=1,30) /0.0000,0.1376,0.3288,0.7474,1.7005,2.8562,6.
     & 4293,8.1617,10.8227,13.3768,18.0947,22.3032,31.0332,37.9385,48.45
     & 58,56.3674,62.7103,68.0031,72.5208,76.3735,83.2791,88.8576,93.620
     & 6,95.7988,99.6640,104.7607,117.5894,133.9240,144.7533,156.2781/  
!                                                                       
!        theta is 0.32.                                                 
!                                                                       
      data (b(i,5),i=1,30) /0.0000,0.1113,0.2745,0.6403,1.4877,2.5250,5.
     & 8429,7.3109,9.7069,11.9998,16.2141,19.9480,27.6165,33.6117,42.637
     & 6,49.3586,54.7123,59.1597,62.9395,66.1375,71.9211,76.5606,80.5156
     & ,82.3288,85.5260,89.7467,100.3534,113.8360,122.7663,132.2611/    
!                                                                       
!        theta is 0.34.                                                 
!                                                                       
      data (b(i,6),i=1,30) /0.0000,0.0903,0.2301,0.5513,1.3093,2.2472,5.
     & 3527,6.6032,8.7831,10.8645,14.6741,18.0297,24.8595,30.1415,38.007
     & 0,43.8066,48.3973,52.1940,55.4068,58.1023,63.0259,66.9461,70.2826
     & ,71.8168,74.5040,78.0547,86.9654,98.2730,105.7543,113.7051/      
!                                                                       
!        theta is 0.35.                                                 
!                                                                       
      data (b(i,7),i=1,30) /0.0000,0.0814,0.2109,0.5123,1.2307,2.1246,5.
     & 1369,6.2926,8.3791,10.3694,14.0059,17.2007,23.6765,28.6594,36.040
     & 8,41.4577,45.7323,49.2599,52.2385,54.7265,59.2956,62.9195,66.0016
     & ,67.4208,69.8981,73.1735,81.3872,91.8016,98.6883,106.0050/       
!                                                                       
!        theta is 0.36.                                                 
!                                                                       
      data (b(i,8),i=1,30) /0.0000,0.0734,0.1935,0.4765,1.1582,2.0113,4.
     & 9376,6.0064,8.0076,9.9152,13.3948,16.4445,22.6024,27.3178,34.2679
     & ,39.3447,43.3389,46.6281,49.3993,51.7039,55.9593,59.3214,62.1787,
     & 63.4964,65.7884,68.8208,76.4196,86.0462,92.4087,99.1663/         
!                                                                       
!        theta is 0.38.                                                 
!                                                                       
      data (b(i,9),i=1,30) /0.0000,0.0597,0.1630,0.4132,1.0280,1.8087,4.
     & 5819,5.4971,7.3484,9.1112,12.3184,15.1176,20.7302,24.9900,31.2090
     & ,35.7119,39.2341,42.1226,44.5457,46.5425,50.2726,53.1964,55.6777,
     & 56.8257,58.8078,61.4342,68.0060,76.3179,81.8057,87.6313/         
!                                                                       
!        theta is 0.40.                                                 
!                                                                       
      data (b(i,10),i=1,30) /0.0000,0.0487,0.1376,0.3593,0.9170,1.6333,4
     & .2740,5.0576,6.7817,8.4227,11.4022,13.9938,19.1589,23.0480,28.676
     & 7,32.7189,35.8635,38.4322,40.5779,42.3299,45.6423,48.2182,50.4013
     & ,51.4148,53.1513,55.4562,61.2155,68.4881,73.2851,78.3746/        
!                                                                       
!        theta is 0.42.                                                 
!                                                                       
      data (b(i,11),i=1,30) /0.0000,0.0397,0.1164,0.3131,0.8199,1.4800,4
     & .0049,4.6747,6.2897,7.8268,10.6141,13.0319,17.8258,21.4102,26.557
     & 4,30.2260,33.0636,35.3765,37.2989,38.8541,41.8313,44.1284,46.0726
     & ,46.9785,48.5185,50.5663,55.6764,62.1196,66.3656,70.8681/        
!                                                                       
!        theta is 0.44.                                                 
!                                                                       
      data (b(i,12),i=1,30) /0.0000,0.0324,0.0985,0.2733,0.7349,1.3452,3
     & .7678,4.3382,5.8586,7.3064,9.9297,12.2004,16.6835,20.0152,24.7659
     & ,28.1288,30.7177,32.8209,34.5621,35.9577,38.6634,40.7350,42.4862,
     & 43.3052,44.6866,46.5270,51.1138,56.8891,60.6917,64.7220/         
!                                                                       
!        theta is 0.45.                                                 
!                                                                       
      data (b(i,13),i=1,30) /0.0000,0.0293,0.0907,0.2555,0.6963,1.2837,2
     & .6853,4.1847,5.6625,7.0702,9.6203,11.8259,16.1723,19.3936,23.9722
     & ,27.2031,29.6848,31.6979,33.3613,34.6883,37.2778,39.2528,40.9215,
     & 41.7033,43.0169,44.7687,49.1321,54.6225,58.2360,62.0650/         
!                                                                       
!        theta is 0.46.                                                 
!                                                                       
      data (b(i,14),i=1,30) /0.0000,0.0265,0.0834,0.2389,0.6601,1.2258,2
     & .5831,4.0401,5.4778,6.8480,9.3301,11.4754,15.6959,18.8160,23.2375
     & ,26.3481,28.7325,30.6638,32.2567,33.5217,36.0058,37.8935,39.4875,
     & 40.2357,41.4880,43.1598,47.3214,52.5545,55.9974,59.6448/         
!                                                                       
!        theta is 0.48.                                                 
!                                                                       
      data (b(i,15),i=1,30) /0.0000,0.0216,0.0707,0.2091,0.5939,1.1194,2
     & .3951,3.7741,5.1388,6.4412,8.8007,10.8379,14.8347,17.7764,21.9223
     & ,24.8233,27.0382,28.8274,30.2979,31.4553,33.7571,35.4937,36.9587,
     & 37.6489,38.7954,40.3289,44.1424,48.9321,52.0811,55.4158/         
!                                                                       
!        theta is 0.50.                                                 
!                                                                       
      data (b(i,16),i=1,30) /0.0000,0.0177,0.0600,0.1831,0.5352,1.0243,2
     & .2262,3.5352,4.8351,6.0775,8.3297,10.2733,14.0780,16.8680,20.7816
     & ,23.5069,25.5805,27.2514,28.6202,29.6883,31.8392,33.4508,34.8092,
     & 35.4514,36.5105,37.9300,41.4565,45.8812,48.7883,51.8657/         
!                                                                       
!        theta is 0.52.                                                 
!                                                                       
      data (b(i,17),i=1,30) /0.0000,0.0144,0.0508,0.1605,0.4829,0.9387,2
     & .0735,3.3194,4.5613,5.7503,7.9079,9.7696,13.4083,16.0685,19.7849,
     & 22.3619,24.3169,25.8887,27.1725,28.1661,30.1911,31.6986,32.9683,3
     & 3.5707,34.5572,35.8820,39.1704,43.2926,45.9994,48.8639/          
!                                                                       
!        theta is 0.54.                                                 
!                                                                       
      data (b(i,18),i=1,30) /0.0000,0.0118,0.0431,0.1407,0.4361,0.8615,1
     & .9349,3.1234,4.3130,5.4543,7.5278,9.3176,12.8117,15.3599,18.9079,
     & 21.3593,23.2139,24.7021,25.9144,26.8455,28.7648,30.1852,31.3807,3
     & 1.9497,32.8755,34.1212,37.2110,41.0810,43.6210,46.3082/          
!                                                                       
!        theta is 0.55.                                                 
!                                                                       
      data (b(i,19),i=1,30) /0.0000,0.0107,0.0397,0.1318,0.4146,0.8257,1
     & .8703,3.0320,4.1972,5.3165,7.3515,9.1084,12.5372,15.0352,18.5081,
     & 20.9037,22.7149,24.1654,25.3462,26.2498,28.1227,29.5048,30.6677,3
     & 1.2221,32.1214,33.3324,36.3352,40.0950,42.5621,45.1718/          
!                                                                       
!        remember, the theta grid below and the s,t,u and v             
!        values are from "bichsel".                                     
!                                                                       
      data thtgd2 /0.36,0.45,0.54,0.63,0.72,0.81/                       
!                                                                       
      data s /10.4696,8.3353,7.1929,6.5217,6.0999,5.8209/               
!                                                                       
      data t /45.6579,39.4198,35.2355,32.2033,29.8843,28.0388/          
!                                                                       
      data u /1.0397,1.1432,1.1312,1.0848,1.0310,0.9791/                
!                                                                       
      data v /0.138/                                                    
!                                                                       
!     data thtgd2/ 0.35, 0.450, 0.55 /                                  
!                                                                       
!     data s/ 41.37, 24.29, 17.88 /                                     
!                                                                       
!     data t/ 129.8, 89.92, 72.28 /                                     
!                                                                       
!     data u/ 0.24, 0.39, 0.75 /                                        
!                                                                       
!        initialize the m-shell, d-subshell correction value to zero.   
!                                                                       
      iz=z                                                              
      subk3m=0.0                                                        
!                                                                       
!        obtain the theta value and then check the value,               
!        if theta is zero, return.                                      
!                                                                       
      thetam=thetas(6,iz)                                               
      if (thetam.le.0.0) return                                         
!                                                                       
!        compute the eta value, then check its range to                 
!        determine which computation to use for subk3m.                 
!                                                                       
      etaval=eta(z,6,betasq)                                            
!                                                                       
!        initialize the grid size constants.                            
!                                                                       
      numgrd=6                                                          
      numgd1=19                                                         
      numgd2=30                                                         
!                                                                       
!        init old flag to specify new calculation each use              
!        of alin and alin3d.                                            
!                                                                       
      ildaln='new'                                                      
!                                                                       
!        evaluate for the low eta values (eta less than                 
!        or equal to 10).                                               
!                                                                       
      if ((etaval.ge.0.0).and.(etaval.le.10.0)) then                    
!                                                                       
!        compute the 'b' value first. interpolate to obtain             
!        the b value from available data.                               
!                                                                       
        bvalue=alin3d(etaval,thetam,etagd,thtgd1,b,numgd2,numgd1,ildaln)
!                                                                       
!         actual computation of the low eta m-shell, d-subshell         
!         correction.                                                   
!                                                                       
        subk3m=alin(thetam,thtgd2,s,numgrd,ildaln)*log(etaval)+alin     
     &  (thetam,thtgd2,t,numgrd,ildaln)-bvalue                          
!                                                                       
      endif                                                             
!                                                                       
!        evaluate the m-shell, d-subshell correction for higher         
!        eta values.                                                    
!                                                                       
      if (etaval.gt.10.0) subk3m=alin(thetam,thtgd2,u,numgrd,ildaln)    
     & /etaval                                                          
!                                                                       
!       now compute the whole subshell correction from the              
!       per electron subshell correction previously computed.           
!                                                                       
      subk3m=shel(6,iz)*subk3m/(shel(4,iz)+shel(5,iz)+shel(6,iz))       
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function subshl (z,beta,fudge,shel,shel2,shel3,eshel,esheln)      
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose : this routine computes the subshell correction values.
!                  beta is squared and compared against a set maximum   
!                  value. if the squared beta is greater than the maximu
!                  then return with the correction set to 0.0.          
!                  if the squared beta is less than the maximum,        
!                  then the actual subshl calculation is done. the physi
!                  in this routine is discribed in reference 133:       
!                                                                       
!                    h. bichsel, "higher shell corrections in stopping  
!                    power," univ of southern california linear         
!                    accelerator group technical report no. 3 (1961).   
!                                                                       
!        author :  daniel pickens                                       
!                  computer sciences corp.                              
!                  27 march 1983                                        
!                                                                       
!        inputs :  z      - the atomic number of the element.           
!                  beta   - the converted kinetic energy to velocity.   
!                  fudge  -                                             
!                  shel   - the number of elections in the              
!                           specific subshell.                          
!                  shel2  - the number of electrons in the l shell,     
!                           s subshell of the particular element.       
!                  shel3  - the number of electrons in the l shell,     
!                           p subshell of the particular element.       
!                  eshel  - the energy value of the specific            
!                           subshell electrons.                         
!                  esheln - the energy value of the l shell, p subshell 
!                           electrons for the particular element.       
!                                                                       
!        outputs : subshl - the calculated subshell correction value.   
!                                                                       
!        errors :  none.                                                
!                                                                       
!        init print flag to zero so that the call to sheljl             
!        does not write a comment line out saying :                     
!                                                                       
!          "l-shell - janni's total shell method used".                 
!                                                                       
      logical ptraut                                                    
!                                                                       
      iz=nint(z)                                                        
      ptraut=.false.                                                    
!                                                                       
!        initialize the routine output to 0.0 first.                    
!                                                                       
      subshl=0.0                                                        
!                                                                       
!        compute the ratio first, check for a zero in the denominator.  
!                                                                       
      ratio=0.0                                                         
      if (eshel.ne.0.0) ratio=esheln/eshel                              
!                                                                       
!         compute the scaled beta squared value that will be used       
!         throughout this routine.                                      
!                                                                       
      bsqscl=(beta*beta*ratio)/fudge                                    
!                                                                       
!        check for maximum scaled beta squared value, if greater than or
!        equal to this value, then return.                              
!                                                                       
      if (bsqscl.gt.0.99) return                                        
!                                                                       
!        calculate the correction value.                                
!                                                                       
      subshl=(shel/(shel2+shel3))*(1.0-beta*beta)*sheljl(z,bsqscl,cl1   
     & ,cl2,ptraut)/(1.0-bsqscl)                                        
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      function theta (iz,numshl,nprinc,nangle)                          
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        purpose : this routine calculates the theta                    
!                  value using the physics from:                        
!                                                                       
!                    e. mertzbacher and h. lewis, x-ray                 
!                    production by heavy charged particles,             
!                    in encyclopedia of physics (s. flugge, ed.),       
!                    vol. xxxiv, springer-verlag, berlin (1958).        
!                                                                       
!                  theta is calculated relativistically using           
!                  equations 4.19, 4.17, and 4.16 of the above          
!                  reference.                                           
!                                                                       
!        author :  joe janni and daniel pickens                         
!                  10 september 1983                                    
!                                                                       
!        inputs :  iz     - the atomic number.                          
!                  numshl - the shell number, values from 1 to 18.      
!                           (max_shell = 18 in block8.h)                
!                  nprinc - the principle quantum number.               
!                  nangle - the angular momentum quantum number.        
!                                                                       
!        outputs : theta  - the calculated theta value.                 
!                                                                       
!        errors :  none.                                                
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
!        calculate the alpha constant.                                  
!                                                                       
      z = iz                                                            
      prin = nprinc                                                     
      angl = nangle                                                     
      alpha=1.0/137.0                                                   
!                                                                       
!        actual theta calulation.                                       
!                                                                       
      theta=0.0                                                         
      if (eshel(numshl,iz).gt.0.0) theta=(prin/(z-slater(numshl         
     & ,iz)))**2*(eshel(numshl,iz))/eshel(1,1)-((z-slater(numshl,iz))   
     & *alpha/prin)**2*(prin/angl-(3.0/4.0))                            
!                                                                       
!        assume that minor effects of the relativistic correction       
!        in the theta calculation are not permitted to produce          
!        an erroneous slightly negative theta value.                    
!                                                                       
      if (theta.lt.0.0) theta=0.0                                       
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
      subroutine thetag                                                 
*
      implicit double precision (a-h,o-z)                               
      parameter (huge_float = 1.0d+37, tiny_float = 1.0d-37)            
      parameter (dp0=0.d0, dp1=1.d0, dp2=2.d0, dp3=3.d0, dp4=4.d0,      
     & dp5=5.d0, dp6=6.d0, dp10=10.d0, dp12=12.d0, dp24=24.d0,          
     & dp30=30.d0, dp41=41.d0, dp120=120.d0, dp130=130.d0,              
     & dp200=200.d0, dp650=650.d0, dp720=720.d0,                        
     & dp1p30=1.d30)                                                    
      parameter (dpth=dp1/dp3, dph=0.5d0, dp2th=dp2/dp3,                
     & dppi=3.1415926535898d0)                                          
      parameter (dp1m2=1.d-02, dp1m4=1.d-04, dp1m5=1.d-05,              
     & dp1m6=1.d-06, dp1m10=1.d-10, dp1m20=1.d-20)                      
      parameter (dp4m3=4.d-03, dp2m2=2.d-02, dp9m1=0.9d0, dp11m1=1.1d0, 
     & dp7095m6=7.095d-03,                                              
     & dp6906m2=69.06d0)                                                
      save                                                              
!                                                                       
!        this routine calls routine theta to get (compute) the          
!        theta values and then stores them in the common                
!        block8 for shell correction useage and for printing later.     
!                                                                       
!        routine by daniel pickens                                      
!        consultant - computer sciences corp.                           
!        10 september 1983                                              
!                                                                       
      parameter (max_shell=18, max_elem=103)                            
      common /block8/shel(max_shell,max_elem),eshel(max_shell,max_elem),
     & slater(max_shell,max_elem),thetas(max_shell,max_elem)            
      external atmdat                                                   
!                                                                       
!        determine the k shell theta values.                            
!                                                                       
      do 10 iz=1,max_elem                                               
      numshl=1                                                          
      nprinc=1                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the l shell theta values.                            
!                                                                       
      numshl=2                                                          
      nprinc=2                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=3                                                          
      nangle=2                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the m shell theta values.                            
!                                                                       
      numshl=4                                                          
      nprinc=3                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=5                                                          
      nangle=2                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=6                                                          
      nangle=3                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the n shell theta values.                            
!                                                                       
      numshl=7                                                          
      nprinc=4                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=8                                                          
      nangle=2                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=9                                                          
      nangle=3                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=10                                                         
      nangle=4                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the o shell theta values.                            
!                                                                       
      numshl=11                                                         
      nprinc=5                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=12                                                         
      nangle=2                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=13                                                         
      nangle=3                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=14                                                         
      nangle=4                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the p shell theta values.                            
!                                                                       
      numshl=15                                                         
      nprinc=6                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=16                                                         
      nangle=2                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
      numshl=17                                                         
      nangle=3                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
!        determine the q shell theta values.                            
!                                                                       
      numshl=max_shell                                                  
      nprinc=7                                                          
      nangle=1                                                          
      thetas(numshl,iz)=theta(iz,numshl,nprinc,nangle)                  
!                                                                       
   10 continue                                                          
!                                                                       
      return                                                            
      end                                                               
*
************************************************************************
*
       Subroutine star(k)
*      ------------------
       character c1*1
1      read(1,'(a1)',end=1000)c1
       if(c1.eq.'*'.or.c1.eq.'c'.or.c1.eq.'C'.or.c1.eq.'!') goto 1
       backspace 1
       return
1000   if(k.eq.0) return 
       Print *,' U N E X P E C T E D   E N D   O F   I N P U T '
       print *,'                        press any key...'
       pause
       stop
       end 
*
************************************************************************
*
      Subroutine STORE_IN(MK,T,Z,IDE)
*     -------------------------------
       COMMON/RECSTORE/TKIN(50003),ZZ(50003),NKO(50003),INDIC(50003),
     #                 NREC
*
      NREC=NREC+1      
               If(NREC.gt.50003) Then
               Print *,'Dimension of TKIN,ZZ.. is not sufficient !'
               Print *,'Check COMMON/RECSTORE/  in the code      !'
               call error('TKIN',50003)
               endif
      TKIN(NREC)=T
      ZZ(NREC)=Z
      NKO(NREC) =MK
      INDIC(NREC)=IDE
      RETURN
      END
*
************************************************************************
*
      Subroutine STORE_OUT(MK,T,Z,IDE)
*     --------------------------------
       COMMON/RECSTORE/TKIN(50003),ZZ(50003),NKO(50003),INDIC(50003),
     #                 NREC
*
      NREC=NREC-1
      If(NREC.le.0) Return      
      T =TKIN(NREC+1)
      Z =ZZ(NREC+1)
      MK=NKO(NREC+1)
      IDE=INDIC(NREC+1)
      RETURN
      END
*
************************************************************************
*  
       Function TDAM(IK,TkeV)
*      ------------------------
       parameter (maxc1=22)
       COMMON/NRT1/ANRT(MAXC1),BNRT(MAXC1),GNRT(MAXC1)
       TT=TkeV
*
       Tdam= TT/
     # (1.+ANRT(IK)*TT+BNRT(IK)*(TT**0.75)+GNRT(IK)*(TT**0.16666666666))     
       RETURN
       END
*
************************************************************************
*  
        Function TPKA(IK,MK,T0,Tmean)
*       -----------------------------
        parameter (maxc=21,maxc1=22)
        Common/Z2A2/ZT(MAXC),AT(MAXC),FR(MAXC),ED(MAXC),NK
        Common/PKA/ALPHA2(MAXC1,MAXC),E0(MAXC1,MAXC)
        Common/CUT1/rmaxpl,itot,icut
        itot=itot+1
*
        Emin=ED(MK)
        Tmax=ALPHA2(IK,MK)*T0
                             If(Tmax.le.Emin) then
                             TPKA=Emin+0.0001
                             return
                             endif
        EPS= T0/E0(IK,MK)
        COEFF=ALPHA2(IK,MK)*E0(IK,MK)/EPS
*
        Xmin= SQRT( Emin/COEFF )
c x(T)  X= SQRT( T0/COEFF )
*
* dx= (1/2) * (1/coeff)**0.5 / T**0.5
        RM=F(Xmin)/(Emin**1.5)      ! 3/2:  1 from x**2 and 0.5 from dx
*       
*
        rn=0.
ccc     Tmax=Amin1( 10.*Tmean,Tmax)
*
1000    TT=Emin+RANDOM(0)*(Tmax-Emin)
        XX= SQRT( TT/COEFF )
        rn=rn+1.
             if(rn.gt.rmaxpl) then
             icut=icut+1
             TPKA=Tmean !
ccc         Write(888,123)IK,MK,T0,Tmean,Tmax
123      Format(1x,60('-')/1x,' IK,MK,T0,Tmean,Tmax=',2i4,3g12.5)
             return
             endif
1900    continue
ccc     Write(888,*)TT, F(XX)/TT**1.5, RM
        If( RM*RANDOM(0)-F(XX)/(TT**1.5) )2000,2000,1000
*
2000    TPKA=TT
        If(TT.gt.T0)then
        Print *,' T0=',T0,'  Tplay=',TT,' ALPHA2=',ALPHA2
        endif 
* 
         Return
         End
*
************************************************************************
*
        Subroutine ZIEION(C80,Z,A)
        Character C80*80
c
c Ex:   C80=' Ion = Tungsten [74] , Mass = 183.951 amu'
c
        open(29,status='scratch')
c
        Do i=1,80
        i1=i
        If(C80(i:i).eq.'[') goto 1000
        enddo
        Print *,' Subr. ZIEION   Symbol "[" not found !'
        print *,'                           press any key...'
        pause
        stop
c
 1000   Do i=i1,80
        i2=i
        If(C80(i:i).eq.']') goto 1001
        enddo
        Print *,' Subr. ZIEION   Symbol "]" not found !'
        print *,'                           press any key...'
        pause
        stop
c
 1001   if((i2-i1).eq.2) then
        k=i1+1     
        write(29,'(a1)')C80(k:k)
                        endif
        if((i2-i1).eq.3) then
        k1=i1+1     
        k2=i1+2
        write(29,'(a2)')C80(k1:k2)
                        endif
        if((i2-i1).ne.2.and.(i2-i1).ne.3) then
        Print *,' Subr. ZIEION    Error:   i2-i1=',i2-i1
        print *,'                        press any key...'
        pause
        stop
                        endif                      
c
        Do i=i2,80
        j1=i
        If(C80(i:i).eq.'=') goto 2000
        enddo
        Print *,' Subr. ZIEION    Second symbol "=" not found !'
        print *,'                                press any key...'
        pause
        stop
c
 2000   Do i=j1,80
        j2=i
        If(C80(i:i).eq.'a') goto 2001
        enddo
        Print *,' Subr. ZIEION   "amu" not found !'
        print *,'                       press any key...'
        pause
        stop
c
 2001   k1=j1+1
        k2=j2-1 
        write(29,'(a12)')C80(k1:k2)
        rewind 29
c
        read(29,*)Z
        read(29,*)A
        close(29)
        Return                
        end
